// ****************************************************************************
//
// bt-GASel.mps 
//
// 2017.01.11   v1.0   First release
//
// Dynamic Lightbar menu for Groups/Areas selection, both Messages and Files
// customizable with optional config file that can be passed in the menu config
//
// Based on XQ-FMAG.ZIP by xqtr from Another Droid BBS :
//
//    - complete rewrite
//    - code optimization and clarification
//    - customization through external config file
//    - one single MPS for all 4 functions (Files/Messages Groups/Areas)
//    - default values if no custom config file provided
//    - display file for each function customizable through config file
//    - single procedure Draw_Bar instead of DrawON et DrawOFF
//    - uses of Case tests instead of nested/unnested if then else
//    - added support for Right/Left arrows (equiv of PgUp/PgDn)
//    - global code comment and clean up
//    - bugfix of Base/Group sorted/delete/added and displayed list order don't match
//      internal Unique IDs
//
//  Coming development in future releases :
//
//    - multi-column through config file also
//
// Redesigned & Rewritten for BackToTheRoots BBS by Fabian
//                     telnet : BackToTheRoots.it-awareness.ch:2323
//                              netmail on fsxNet : Fabian@21:2/106
//                                         email : fabian@lucchi.me
// ****************************************************************************

Uses CFG
Uses MGroup
Uses FGroup
Uses FBase
Uses MBase
Uses User

Type
  TGroupBase      = Record
                      iUniqueID    : LongInt;
                      sName        : String[30];
                      sACS         : String[30];
                      bHidden      : Boolean;
                    End;

Type
  TMessageBase    = Record
                      sName        : String[40];
                      sQWKName     : String[13];
                      sNewsName    : String[60];
                      sFilename    : String[40];
                      sPath        : String[80];
                      byUnused     : Byte;
                      byNetType    : Byte;
                      byReadType   : Byte;
                      byListType   : Byte;
                      sListACS     : String[30];
                      sReadACS     : String[30];
                      sPostACS     : String[30];
                      sNewsACS     : String[30];
                      sSysopACS    : String[30];
                      sSponsor     : String[30];
                      byColQuote   : Byte;
                      byColText    : Byte;
                      byColTear    : Byte;
                      byColOrigin  : Byte;
                      byColKludge  : Byte;
                      bNetAddr     : Byte;
                      sOrigin      : String[50];
                      byDefNScan   : Byte;
                      byDefQScan   : Byte;
                      wMaxMsgs     : Word;
                      wMaxAge      : Word;
                      sHeader      : String[20];
                      sRTemplate   : String[20];
                      sITemplate   : String[20];
                      wIndex       : Word;
                      liFlags      : LongInt;
                      liCreated    : LongInt;
                      sEchoTag     : String[40];
                      liQWKNetId   : LongInt;
                      wQWKConfId   : Word;
                      abReserved   : Array[1..29] Of Byte;
                    End;

Type
  TFileBase       = Record
                      wIndex       : Word;
                      sName        : String[40];
                      sFTPName     : String[60];
                      sFilename    : String[40];
                      sDispFile    : String[20];
                      sTemplate    : String[20];
                      sListACS     : String[30];
                      sFTPAcs      : String[30];
                      sDownloadACS : String[30];
                      sUploadACS   : String[30];
                      sHatchACS    : String[30];
                      sSysopACS    : String[30];
                      sPath        : String[80];
                      byDefScan    : Byte;
                      liFlags      : LongInt;
                      liCreated    : LongInt;
                      byNetAddr    : Byte;
                      sEchoTag     : String[30];
                    End;

Type
  TInternalzone   = Record
                      iUniqueID   : LongInt;
                      sName       : String[40];               // Keep the biggest (base=40, group=30)
                    End;

Const
  csiDefZone_Type                   =  1;                     // Default to File Groups
  csiDefPos_StartX                  = 21;                     // Left column of usable space to display list
  csiDefPos_StartY                  =  9;                     // Top row of usable space to display list
  csiDefPos_EndX                    = 39;                     // Right column of usble space to diplay list
  csiDefPos_EndY                    = 20;                     // Botton row of usable space to display list
  csiDefPos_SearchX                 = 20;                     // Column to display search string
  csiDefPos_SearchY                 = 24;                     // Row to display search string

  cssDefColors_Search_Prefix        = '|15';                  // MCI codes to send before displaying the search string
  cssDefColors_Bar_On_Prefix        = '|15|17';               // MCI codes to send before drawing an highlighted bar
  cssDefColors_Bar_On_Suffix        = '|16';                  // MCI codes to send after drawing an highlighted bar
  cssDefColors_Bar_Off_Prefix       = '|07';                  // MCI codes to send before drawing a dimmed bar

  cssDefDisplay_File                = 'GASel-fg';             // Default file to display as background
  cssDefHelp_File                   = 'GASelHlp';             // Default help file to display

  csiMax_Rows                       = 150;                    // Max number of groups/areas loaded in the list for display
  csiMax_Zones                      = 1000;                   // Max number of zones to load in memory

  cssParameters_ZoneType            = 'Zone_Type';            // Zone type (1=FG, 2=FA, 3=MG, 4=MA)
  cssParameters_TopLeftX            = 'Top_Left_X';           // Param name for left column of list
  cssParameters_TopLeftY            = 'Top_Left_Y';           // Param name for top row of list
  cssParameters_BottomRightX        = 'Bottom_Right_X';       // Param name for right colum of list
  cssParameters_BottomRightY        = 'Bottom_Right_Y';       // Param name for botton row of list
  cssParameters_DisplayFile         = 'Display_File';         // Param name for display file to use
  cssParameters_HelpFile            = 'Help_File';            // Param name for help file to be displayed
  cssParameters_SearchX             = 'Pos_Search_X';         // Param name for column of search string
  cssParameters_SearchY             = 'Pos_Search_Y';         // Param name for row of search string
  cssParameters_Search_Prefix       = 'Search_Color_Prefix';  // Param name for MCI before search string
  cssParameters_Bar_On_Prefix       = 'Bar_HighLight_Prefix'; // Param name for MCI before highlighted bar
  cssParameters_Bar_On_Suffix       = 'Bar_HighLight_Suffix'; // Param name for MCI after highlighted bar
  cssParameters_Bar_Off_Prefix      = 'Bar_Dimmed_Prefix';    // Param name for MCI before dimmed bar

  csiZone_Groups_File               = 1;
  csiZone_Bases_File                = 2;
  csiZone_Groups_Message            = 3;
  csiZone_Bases_Message             = 4;

  cssMenu_FG                        = 'FG';
  cssMenu_FA                        = 'FA';
  cssMenu_MG                        = 'MG';
  cssMenu_MA                        = 'MA';

  // We need to read directly mystic groups definition files to get internal UniqueID for each group. Because
  // group number or order list is not the same as internal UniqueID (if you sort groups, delete and then add
  // another one). The internal function FG doesn't use the "list index" displayed but the internal UniqueID.
  // Source code xq-fg from xqtr wasn't working on that point, it joined the group based on his list #, which is
  // not correct
  cssDAT_Groups_File                = 'groups_f.dat';         // Default file that contains File groups definitions
  cssDAT_Groups_Message             = 'groups_g.dat';         // Default file that contains Message groups definitions
  cssDAT_Bases_File                 = 'fbases.dat';           // Default file that contains File areas definitions
  cssDAT_Bases_Message              = 'mbases.dat';           // Default file that contains Message areas definitions

Var
  iZone_Type                : Integer = csiDefZone_Type;
  iPos_StartX               : Integer = csiDefPos_StartX;
  iPos_StartY               : Integer = csiDefPos_StartY;
  iPos_EndX                 : Integer = csiDefPos_EndX;
  iPos_EndY                 : Integer = csiDefPos_EndY;
  iPos_SearchX              : Integer = csiDefPos_SearchX;
  iPos_SearchY              : Integer = csiDefPos_SearchY;
  sColor_Search_Prefix      : String  = cssDefColors_Search_Prefix;
  sColor_Bar_On_Prefix      : String  = cssDefColors_Bar_On_Prefix;
  sColor_Bar_On_Suffix      : String  = cssDefColors_Bar_On_Suffix;
  sColor_Bar_Off_Prefix     : String  = cssDefColors_Bar_Off_Prefix;
  sDisplayFile              : String  = cssDefDisplay_File;
  sHelpFile                 : String  = cssDefHelp_File;

  iZonesAvailable           : Integer;
  arZones                   : Array[1..csiMax_Zones] Of TInternalZone;

  iTotalZones               : Integer;                           // How many zones are loaded in memory
  iTemp                     : Integer;
  asZones                   : Array[1..csiMax_Rows] Of String;   // List of zones (Groups or Areas)
  aiIndexes                 : Array[1..csiMax_Rows] Of LongInt;  // Indexes of each zone (Groups or Areas)
                                                                 // but we store the "UniqueID" from groups_?.dat
                                                                 // or the "Index" from ?bases.dat
  iTopPage                  : Integer;                           // # of zone displayed in first row of list
  iBarPos                   : Integer;                           // Where is the bar now
  bDone                     : Boolean;                           // Is a select or esc issued ?
  cChar                     : Char;
  cChar2                    : Char;
  sSearch                   : String;                            // Search string
  iSearch                   : Integer;                           // Position of corresponding zone
  iCount                    : Integer;
  iTableLength              : Integer;                           // Height of list (bottom row - top row)
  sDefaultMenu              : String;                            // Default Mystic menu to call if any problem

//
// We load any custom parameters if required
//
Procedure Load_Parameters;
Var
  tfInput  : File;
  sLine    : String;
  sParam   : String;

  Procedure LoadUniqueIDs;
  Var
    fZones     : File;
    recGroup   : TGroupBase;
    recFile    : TFileBase;
    recMessage : TMessageBase;
    sFileName  : String;
  Begin
    Case iZone_Type Of
      1 : sFilename := cssDAT_Groups_File;
      2 : sFilename := cssDAT_Bases_File;
      3 : sFileName := cssDAT_Groups_Message;
      4 : sFileName := cssDAT_Bases_Message;
    End; // case

    If Not(FileExist(CfgDataPath + sFileName)) Then Begin
      MenuCmd(sDefaultMenu, '');
      Halt;
    End; // If Not(FileExist...

    fAssign(fZones, CfgDataPath + sFilename, 66);
    fReset(fZones);

    iZonesAvailable := 0;
    Repeat
      Case iZone_Type Of
        csiZone_Groups_File,
        csiZone_Groups_Message : fRead(fZones, recGroup, SizeOf(recGroup));
        csiZone_Bases_File     : fRead(fZones, recFile, SizeOf(recFile));
        csiZone_Bases_Message  : fRead(fZones, recMessage, SizeOf(recMessage));
      End; // Case iZone_Type...

      iZonesAvailable := iZonesAvailable + 1;

      Case iZone_Type Of
        csiZone_Groups_File,
        csiZone_Groups_Message  : Begin
                                    arZones[iZonesAvailable].iUniqueID := recGroup.iUniqueID;
                                    arZones[iZonesAvailable].sName     := recGroup.sName;
                                  End;
        csiZone_Bases_File      : Begin
                                    arZones[iZonesAvailable].iUniqueID := recFile.wIndex;
                                    arZones[iZonesAvailable].sName     := recFile.sName;
                                  End;
        csiZone_Bases_Message   : Begin
                                    arZones[iZonesAvailable].iUniqueID := recMessage.wIndex;
                                    arZones[iZonesAvailable].sName     := recMessage.sName;
                                  End;
      End; // case iZone_Type ...
    Until fEOF(fZones);
    fClose(fZones);
  End; // Procedure GetGroupIDs


  //
  // We extract the value (string) for a given parameter name (as read from file)
  //
  Function ExtractParamValue(sString, sName : String) : String;
  Begin
    ExtractParamValue := StripB(Copy(sString, Pos('=', sString)+1, 255), ' ');
  End;

Begin
  //
  // If Parameters File Doesn't Exists, We Use Default Values Through
  // Default Init At Variables Declaration
  //
  If FileExist(CfgMpePath + ParamStr(1)) Then Begin
    // Open Parameters File For Customized Settings only if file does exist
    fAssign(tfInput, CfgMpePath + ParamStr(1), 66);
    fReset(tfInput);

    Repeat
      fReadLn(tfInput, sLine);

      // Do not process comments in that file
      If Copy(sLine, 1, 2)<>'//' Then Begin
        If Pos(cssParameters_ZoneType, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_ZoneType);
          iZone_Type := Str2Int(sParam);
        End
        Else If Pos(cssParameters_TopLeftX, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_TopLeftX);
          iPos_StartX := Str2Int(sParam);
        End
        Else If Pos(cssParameters_TopLeftY, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_TopLeftY);
          iPos_StartY := Str2Int(sParam);
        End
        Else If Pos(cssParameters_BottomRightX, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_BottomRightX);
          iPos_EndX := Str2Int(sParam);
        End
        Else If Pos(cssParameters_BottomRightY, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_BottomRightY);
          iPos_EndY := Str2Int(sParam);
        End
        Else If Pos(cssParameters_DisplayFile, sLine)>0 Then Begin
          sDisplayFile := ExtractParamValue(sLine, cssParameters_DisplayFile);
        End
        Else If Pos(cssParameters_SearchX, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_SearchX);
          iPos_SearchX := Str2Int(sParam);
        End
        Else If Pos(cssParameters_SearchY, sLine)>0 Then Begin
          sParam := ExtractParamValue(sLine, cssParameters_SearchY);
          iPos_SearchY := Str2Int(sParam);
        End
        Else If Pos(cssParameters_Search_Prefix, sLine)>0 Then Begin
          sColor_Search_Prefix := ExtractParamValue(sLine, cssParameters_Search_Prefix);
        End
        Else If Pos(cssParameters_Bar_On_Prefix, sLine)>0 Then Begin
          sColor_Bar_On_Prefix := ExtractParamValue(sLine, cssParameters_Bar_On_Prefix);
        End
        Else If Pos(cssParameters_Bar_On_Suffix, sLine)>0 Then Begin
          sColor_Bar_On_Suffix := ExtractParamValue(sLine, cssParameters_Bar_On_Suffix);
        End
        Else If Pos(cssParameters_Bar_Off_Prefix, sLine)>0 Then Begin
          sColor_Bar_Off_Prefix := ExtractParamValue(sLine, cssParameters_Bar_Off_Prefix);
        End
        Else If Pos(cssParameters_HelpFile, sLine)>0 Then Begin
          sHelpFile := ExtractParamValue(sLine, cssParameters_HelpFile);
        End;
      End; // If Copy(sLine, 1, 2)....
    Until fEOF(tfInput);

    fClose(tfInput);

    // Set default menu action if we need to fallback to Mystic (zone too big or no zone, or no ANSI)
    Case iZone_Type Of
      1 : sDefaultMenu := cssMenu_FG;
      2 : sDefaultMenu := cssMenu_FA;
      3 : sDefaultMenu := cssMenu_MG;
      4 : sDefaultMenu := cssMenu_MA;
    End; // Case
  End; // If Not(FileExist)...

  LoadUniqueIDs;  // Load Groups/Areas file/message names & UniqueIDs to fetch mystic commands (fg, fa, mg & ma)

End;

//
// Generic Draw Bar procedure
// >iPos = row of bar to draw
// >bOn  = is bar hightlighted
//
Procedure Draw_Bar(iPos : Integer; bOn : Boolean);
Begin
  GotoXY (iPos_StartX, iPos_StartY+iPos-iTopPage);
  Case bOn Of
    True  : Begin
              Write(sColor_Bar_On_Prefix+' ' + PadRT(StripMCI(asZones[iPos]), iPos_EndX-iPos_StartX, ' ') + sColor_Bar_On_Suffix);
            End;
    False : Begin
              Write(sColor_Bar_Off_Prefix+' ' + PadRT(asZones[iPos], iPos_EndX-iPos_StartX, ' '));
//              Write(StrRep(' ', (iPos_EndX+iPos_StartX+1) - WhereX));
            End;
  End; // Case bOn ....
End;

//
// Redraw full page
//
Procedure DrawFullPage;
Var
  iLocalPos : Integer;
Begin
  iLocalPos := iBarPos;
  For iTemp := 0 to (iPos_EndY - iPos_StartY) Do Begin 
    iBarPos := iTopPage + iTemp;
    Draw_Bar(iBarPos, False);
  End; // For iTemp := 0 To ...
  iBarPos   := iLocalPos;
  Draw_Bar(iBarPos, True);
End; // Procedure DrawFullPage

//
// Search a given group by its name to retrieve the corresponding iUniqueID
//
Function GetUniqueID(sName : String) : Integer;
Var
  iLoop : Integer;
Begin
  For iLoop := 1 To iZonesAvailable Do Begin
    If arZones[iLoop].sName=sName Then Begin
      GetUniqueID := arZones[iLoop].iUniqueID;
      Break; // Exit immediately
    End; // If arZones[iLoop]
  End; // For iLoop
End;

//
// Load zones when Groups File has been selected
//
Procedure LoadGroupsFileFromZones;
Var
  iLocal : Integer = 1;
Begin
  While GetFGroup(iLocal) And (iTotalZones < csiMax_Rows) Do Begin
    If Acs(FGroupACS) Then Begin
      iTotalZones            := iTotalZones + 1;
      asZones[iTotalZones]   := FGroupName;

      // Instead of storing the record # sequentially, we
      // search the group in the groups array to get its iUniqueID
      // that we must use when calling FG to select another group
      aiIndexes[iTotalZones] := GetUniqueID(FGroupName);
    End; // If Acs(FGroupACS)...
    iLocal := iLocal + 1;    
  End; // While GetFGroup(iLocal)...
End; // Procedure LoadGroupsFileFromZones

//
// Load zones when Groups Message has been selected
//
Procedure LoadGroupsMessageFromZones;
Var
  iLocal : Integer = 1;
Begin
  While GetMGroup(iLocal) And (iTotalZones < csiMax_Rows) Do Begin
    If Acs(MGroupACS) Then Begin
      iTotalZones            := iTotalZones + 1;
      asZones[iTotalZones]   := MGroupName;

      // Instead of storing the record # sequentially, we
      // search the group in the groups array to get its iUniqueID
      // that we must use when calling FG to select another group
      aiIndexes[iTotalZones] := GetUniqueID(MGroupName);
    End; // If Acs(MGroupACS)...
    iLocal := iLocal + 1;    
  End; // While GetMGroup(iLocal)...
End; // Procedure LoadGroupsMessageFromZones

//
// Load zones when Bases File has been selected
//
Procedure LoadBasesFileFromZones;
Var
  iLocal : Integer = 1;
Begin
  While GetFBase(iLocal) And (iTotalZones < csiMax_Rows) Do Begin
    If Acs(FBaseACS) Then Begin
      iTotalZones            := iTotalZones + 1;
      asZones[iTotalZones]   := FBaseName;

      // Instead of storing the record # sequentially, we
      // search the group in the groups array to get its iUniqueID
      // that we must use when calling FG to select another group
      aiIndexes[iTotalZones] := GetUniqueID(FBaseName);
    End; // If Acs(FBaseACS)...
    iLocal := iLocal + 1;    
  End; // While GetFBase(iLocal)...
End; // Procedure LoadBasesFileFromZones

//
// Load zones when Bases Messages has been selected
//
Procedure LoadBasesMessageFromZones;
Var
  iLocal : Integer = 1;
Begin
  While GetMBase(iLocal) And (iTotalZones < csiMax_Rows) Do Begin
    If Acs(MBaseACS) Then Begin
      iTotalZones            := iTotalZones + 1;
      asZones[iTotalZones]   := MBaseName;

      // Instead of storing the record # sequentially, we
      // search the group in the groups array to get its iUniqueID
      // that we must use when calling FG to select another group
      aiIndexes[iTotalZones] := GetUniqueID(MBaseName);
    End; // If Acs(FMBaseACS)...
    iLocal := iLocal + 1;    
  End; // While GetMBase(iLocal)...
End; // Procedure LoadBasesMessageFromZones

//
// **************************************************************
// ***                Start of main program                   ***
// **************************************************************
//
Begin
  // If no ANSI capabilities, use default Mystic function and exit immediately
  If Graphics = 0 Then Begin
    MenuCmd (sDefaultMenu, '');
    Halt;
  End;

  // Load Customized Parameters
  Load_Parameters;

  iTotalZones  := 0;
  iTemp        := 1;

  sSearch      := '';
  iSearch      := 0;

  iTableLength := iPos_EndY-iPos_StartY;

  Case iZone_Type Of
    csiZone_Groups_File        : LoadGroupsFileFromZones;
    csiZone_Groups_Message     : LoadGroupsMessageFromZones;
    csiZone_Bases_File         : LoadBasesFileFromZones;
    csiZone_Bases_Message      : LoadBasesMessageFromZones;
  End; // case iZone_Type...

  // If no zones defined, show default prompt and exit
  If iTotalZones = 0 Then begin
    WriteLn (GetPrompt(37));
    Halt;
  End; // If iTotalZones = 0

  // If zones count = max allowed zones, use appropriate builtin function and exit
  If iTotalZones = csiMax_Rows Then Begin
    MenuCmd(sDefaultMenu, '');
    Halt;
  End; // If iTotalZones = ...

  // Show list template
  DispFile (sDisplayFile);

  iTopPage  := 1;
  iBarPos   := 1;
  bDone     := False;

  // Initial First Page Draw
  DrawFullPage;

  Repeat
    cChar := ' ';

    If iTopPage+iTableLength < iTotalZones Then Begin
      cChar2 := Chr(245);
    End; // If (iTopPage + iTableLength)...

    cChar := ReadKey;

    If IsArrow Then Begin
      Case cChar Of
        Chr(71)     : Begin
                  	    // key HOME
                        iSearch  := 1;
                        iTopPage := 1;
                        iBarPos  := 1;
    	                  DrawFullPage;
                      End; // Chr(71)
    
        Chr(79)     : Begin
                        // key END
                        iSearch := 1;
    		                If iTotalZones > iTableLength+1 Then Begin
    			                iTopPage := iTotalZones - iTableLength;
    			                iBarPos  := iTotalZones;
    		                End
                        Else Begin
    			                iBarPos  := iTotalZones;
    		                End; // If iTotalZones > iTableLength...
    		                DrawFullPage;
                      End; // Chr(79)
    
        Chr(72)     : Begin
                        // key UP
                        iSearch := 1;
                        If iBarPos > iTopPage Then Begin
                          Draw_Bar(iBarPos, False);
                          iBarPos := iBarPos - 1;
                          Draw_Bar(iBarPos, True);
                        End
                        Else If iTopPage > 1 Then Begin
                          iTopPage := iTopPage - 1;
                          iBarPos  := iTopPage;
                          DrawFullPage;
                        End; // If iBarPos > iTopPage...
                      End; // Chr(27)
    
        Chr(73),
        Chr(75)     : Begin
                        // key PageUp Or Left
                        iSearch := 1;
                        If iTopPage-iPos_EndY-iPos_StartY+1 > 0 Then Begin
                          iTopPage := iTopPage - iTableLength + 1;
                          iBarPos  := iBarPos  - iTableLength + 1;
                          DrawFullPage;
                        End
                        Else Begin
                          iTopPage := 1;
                          iBarPos  := 1;
                          DrawFullPage;
                        End; // If iTopPage-csiPos...
                      End; // Chr(73)
    
        Chr(80)     : Begin
                        // key DOWN
                        iSearch := 1;
                        If iBarPos < iTotalZones Then Begin
                          If iBarPos < iTopPage+iTableLength Then Begin
                            Draw_Bar(iBarPos, False);
                            iBarPos := iBarPos + 1;
                            Draw_Bar(iBarPos, True);
                          End
                          Else If iBarPos < iTotalZones Then Begin
                            iTopPage := iTopPage + 1;
                            iBarPos  := iBarPos  + 1;
                            DrawFullPage;
                          End; // If iBarPos < iTopPage...
                        End; // If iBarPos < iTotalZones...
                      End; // Chr(80)
    
        Chr(81),
        Chr(77)     : Begin
                        // key PageDown Or Right
                        iSearch := 1;
                        If iTotalZones > iTableLength+1 Then Begin
                          If iTopPage+iTableLength+1 < iTotalZones-iTableLength+1 Then Begin
                            iTopPage := iTopPage + iTableLength + 1;
                            iBarPos  := iBarPos  + iTableLength + 1;
                            DrawFullPage;
                          End
                          Else Begin
                            iTopPage := iTotalZones - iTableLength;
                            iBarPos  := iTotalZones;
                            DrawFullPage;
                          End; // If iTopPage+iTableLength...
                        End
                        Else Begin
                          Draw_Bar(iBarPos, False);
                          iBarPos := iTotalZones;
                          Draw_Bar(iBarPos, True);
                        End; // If iTotalZones > iTableLength...
                      End; // Chr(81) 
      End; // Case
      cChar := #0; // Reset input to prevent unhandled behaviour
    End
    Else If cChar >= Chr(32) And cChar <= Chr(128) Then Begin
      // Key is AlphaNum
      sSearch := sSearch+Upper(cChar);
      GotoXY (iPos_SearchX, iPos_SearchY);
      Write (sColor_Search_Prefix+Upper(sSearch)); 
      For iCount := 1 To csiMax_Rows Do Begin
        If Pos(sSearch, Upper(asZones[iCount]))>0 Then Begin
          iTopPage := iCount;
          iBarPos  := iCount;
          iSearch  := iCount;
          DrawFullPage;
          Break;
        End; // If Pos(sSearch, Upper(asZones[iCount]))>0...
      End; // For iCount := 1 To csiMax_Rows... 
    End // If cChar >= Chr(32)...
    Else Begin
      Case cChar Of
            Chr(26)       : Begin
                              // Help, CTRL-Z ?
                              DispFile (CfgTextPath + sHelpFile);
                              cChar := ReadKey;
                              DispFile (sDisplayFile);
                              DrawFullPage;
                            End; // Chr(26)
            Chr(13),
            Chr(27)       : Begin
                              // Key is ENTER or ESC
                              bDone := True;
                            End; // Chr(13)
            Chr(8)        : Begin
                            	// Key is ???
                              Delete (sSearch, Length(sSearch), 1);
          	                  GotoXY (iPos_SearchX, iPos_SearchY);
          	                  Write (sColor_Search_Prefix+Upper(sSearch)+' ');

          	                  For iCount := 1 to csiMax_Rows Do Begin
          		                  If Pos(sSearch, Upper(asZones[iCount]))>0 Then Begin
          			                  iTopPage := iCount;
                                  iBarPos  := iCount;
                                  iSearch  := iCount;
                                  DrawFullPage;
          		                  End; // If Pos(sSearch)...
          	                   End; // For iCount := 1 To csiMax_Rows...
                            End; // Chr(8)
            Chr(1)        : Begin
                              // Search because the search string has changed ?
                              For iCount := (iSearch+1) To csiMax_Rows Do Begin
          		                  If Pos(sSearch, Upper(asZones[iCount]))>0 Then Begin
          			                  iTopPage := iCount;
                                  iBarPos  := iCount;
                                  iSearch  := iCount;
                                  DrawFullPage;
                                  Break;
          		                  End; // If Pos(sSearch)...
        	                    End; // For iCount := ...	
                            End; // Chr(1)
            Chr(25)       : Begin
                              // Clear/Reset search string
                              GotoXY(iPos_SearchX, iPos_SearchY);
        	                    Write (StrRep(' ', Length(sSearch)));
        	                    sSearch := '';
        	                    iSearch := 0;
                            End; // Chr(25)
      End; // Case cChar Of...
    End; // If IsArrow
  Until bDone; // Repeat

  GotoXY (1, 23);

  // ENTER key
  If cChar = Chr(13) Then Begin
      MenuCmd (sDefaultMenu, Int2Str(aiIndexes[iBarPos]));
  End;

End.
