# ---------------------------------------------------------------------------
# BULLETIN.MPS: Bulletin Menu Script for Mystic BBS v1.07+
# ---------------------------------------------------------------------------
# This MPE program creates a simple bulletin menu.  The following parameters
# must be passed when running this script:
#
# BULLETIN [menu name] [base bulletin name] [check]
#
# The first option [menu name] passes the name of the bulletin menu to
# display.  For example, if the text "BULLETIN" is passed, the script will
# display the display file "BULLETIN.XXX" as the menu.
#
# The second option [base bulletin name] is the base bulletin name for each
# actual bulletin.  This can be no longer than 6 characters in length.  For
# example, if "BULLET" was passed as the base bulletin name, when the user
# types in "1" and hits enter, the script will display BULLET1.XXX
#
# The next command line is optional.  If you supply the option "CHECK", the
# script will check for updated bulletins since the user's last call, then
# prompt them to read the bulletins if there are new bulletins available.
# This is handy to put as an FIRSTCMD command during the login somewhere,
# as the default Mystic BBS installation does.
#
# Feel free to make any modifications to this code that you want.  The only
# request I have is that if you want to distribute it, you must follow these
# guidelines:
#
#   1. Get my approval *FIRST*
#   2. Release the source code
#   3. Give me FULL credit for the original work
#   4. List ALL changes you've made to the original program
#
# You can contact me at mysticbbs@geocities.com
# ---------------------------------------------------------------------------

Uses CFG
Uses DIR
Uses USER

Var CheckNew Boolean
Var MenuName String
Var Prefix   String
Var Done     Boolean
Var InStr    String
Var NewNum   Byte
Var NewStr   String

Procedure Scan_New_Bulletins
Begin
  NewStr := ''
  NewNum := 0
  FindFirst (PreFix + '*.*', AnyFile)
  While DosError = 0
    If DirTime > UserLast And Upper(Copy(DirName, 1, Pos('.', DirName) - 1)) <> 'BULLETIN' Then
      InStr := Copy(DirName, 7, Pos('.', DirName) - 7) + ' '
      If Pos(InStr, NewStr) = 0 Then
        NewStr := NewStr + InStr
        NewNum := NewNum + 1
      EndIf
    EndIf
    FindNext
  WEnd
  FindClose
Pend

Begin
  If ParamCount < 2 Then
    WriteLn ('|CRERROR (BULLETIN.MPS): Invalid command line')
    Halt
  EndIf

  GetCFG
  GetThisUser

  MenuName := CfgTextPath + ParamStr(1)
  Prefix   := CfgTextPath + ParamStr(2)
  CheckNew := False
  Done     := False

  If ParamCount > 2 Then
    If Upper(ParamStr(3)) = 'CHECK' Then
      CheckNew := True
    EndIf
  EndIf

  Scan_New_Bulletins

  If NewNum = 0 Then
    NewStr := 'None'
  EndIf

  If CheckNew Then
    If NewNum = 0 Then
      WriteLn ('|CL|01[|10|01] |09There are no new bulletins.')
      Halt
    Else
      If Not InputYN('|CL|01[|10|01] |09New bulletins: |15' + Int2Str(NewNum) + '|09  Read them now? ') Then
        Halt
      EndIf
    EndIf
  EndIf

  DispFile (MenuName)

  Repeat
    WriteLn ('|CR|09New Bulletins    |08-> |07' + NewStr)
    Write   ('|09Command (?/List) |08-> |07')

    InStr := Input(4, 4, 12, '')
    If InStr = '?' Then
      DispFile (MenuName)
    ElseIf InStr = 'Q'
      Done := True
    ElseIf InStr = '' Then
      DispFile (MenuName)
    Else
      DispFile (PreFix + InStr)
      If IsNoFile Then
        WriteLn ('|CRERROR: Bulletin not found.')
      EndIf
    EndIf
  Until Done
End
