#Imports
import os
from configparser import ConfigParser
import mystic_bbs as bbs

#Classes
'''Local actual CWD and find the settings file'''
class Config(ConfigParser):

    
    def __init__(self):
        super().__init__()
        self.errorfree = False 
        self.cfgpath = str()
        self.cfgname = str()
        for root, dirs, files in os.walk(os.getcwd()):
            for name in files:
                if name == 'ANSiTV.ini':
                    self.cfgpath = os.path.abspath(os.path.join(root))+'/'
                    self.cfgname = os.path.abspath(os.path.join(root, name))
                    self.errorfree = True

        if self.errorfree:
            self.read(self.cfgname)

        #grab user for load and save
        self.User = bbs.getuser(0)["handle"]
    
    def ArtDir(self):
        return self['main']['artdir']
    
    def LstTotal(self):
        return int(self['main']['lsttotal'])
    
    def Fixed(self):
        return self['main']['fixed']

    def VData(self):
        return self['main']['vdata']

    def Prompts(self):
        return self['main']['prompts']

    def Bgrnd(self):
        return self['main']['bgrnd']

    def BaudRt(self):
        return int(self['main']['baud'])


class Selector:
    '''Class for selecting, unselecting and passing on a final list.'''
    BaudRate = 9600
    SelectedFiles = list()


    def __init__(self, filename : str):
        self.name=filename
        self.selected = False
        for i,item in enumerate(Selector.SelectedFiles):
            if item.name == self.name:
                self.selected = True
                Selector.SelectedFiles[i] = self
    
    def __str__(self):
        return self.name

    def SelectToggle(self):
        self.selected=not self.selected
        if self.selected:
            Selector.SelectedFiles.append(self)
        else:
            if self in Selector.SelectedFiles:
                Selector.SelectedFiles.remove(self)

    def Selected(self):
        return self.selected
    
    def GetRate(cfg : Config):
        running = True
        while running:
            lintmp = str()
            lintmp += cfg.Bgrnd()
            lintmp += cfg.Fixed()
            lintmp += 'Enter Baud Rate: '
            lintmp += cfg.VData()
            bbs.write(lintmp)
            Selector.BaudRate = bbs.getstr(10, 6, 6, str(Selector.BaudRate))
            Selector.BaudRate = int(Selector.BaudRate)
            if Selector.BaudRate in (0, 300, 1200, 2400, 4800, 9600, 14400, 28800, 33600, 57600, 115200):
                running = False                
            else:             
                bbs.writeln('|CR|20|15 Must be a valid Baud rate: |PA|16|CL')
                bbs.showfile(cfg.cfgpath+'main.ans', 0, False, False, False)
    
    def Save(cfg : Config):
        filename = cfg.cfgpath+'userdata/'+cfg.User+'.sav'
        CRLF = str(chr(13)) + str(chr(10))
        filesout = [s.name + CRLF for s in Selector.SelectedFiles]
        fout = open(filename, 'w')
        fout.write(str(Selector.BaudRate)+CRLF)
        fout.writelines(filesout)
        fout.close()

    def Load(cfg : Config):
        filename = cfg.cfgpath+'userdata/'+cfg.User+'.sav'
        if os.path.exists(filename):
            CRLF = str(chr(13)) + str(chr(10))
            fin = open(filename, 'r')
            lines = fin.readlines()
            fin.close()
            lines = [s.rstrip() for s in lines]
            Selector.BaudRate = int(lines[0])
            Selector.SelectedFiles = [Selector(s) for s in lines[1:]]
        else:
            Selector.BaudRate = cfg.BaudRt()
    
    def TempLoad(tempuser, cfg : Config):
        filename = cfg.cfgpath+'userdata/'+tempuser
        if os.path.exists(filename):
            CRLF = str(chr(13)) + str(chr(10))
            fin = open(filename, 'r')
            lines = fin.readlines()
            fin.close()
            lines = [s.rstrip() for s in lines]
            Selector.BaudRate = int(lines[0])
            Selector.SelectedFiles = [Selector(s) for s in lines[1:]]
                


#definitions

def Listing(cfg : Config):
    ansilist = os.listdir(cfg.ArtDir())
    ansilist = [Selector(s) for s in ansilist]
    totalfiles = len(ansilist)
    PageTl = totalfiles // cfg.LstTotal()
    Rmn = totalfiles % cfg.LstTotal()
    running = True
    Pg = int(0)
    while running:
        CurrentPage = ansilist[Pg*cfg.LstTotal():Pg*cfg.LstTotal()+cfg.LstTotal()]
        ch = ' '    
        while not (ch in 'QSCPV'):
            bbs.writeln('|CL')
            bbs.showfile(cfg.cfgpath+'hdr.ans', 0, False, False, False)
            for j,Item in enumerate(CurrentPage):
                slcted = ' '
                indx=(Pg*cfg.LstTotal()+j)
                if Item.Selected():
                    slcted = '|20|14*|10|16'
                lineTmp = str()
                lineTmp += slcted
                lineTmp += cfg.VData()
                lineTmp += str(j)
                lineTmp += cfg.Fixed()
                lineTmp += ' File: '
                lineTmp += cfg.VData()
                lineTmp += str(Item)
                bbs.writeln(str(lineTmp))
            if Pg + 1 == PageTl and 0 == Rmn:
                ch = bbs.onekey('0123456789QSPV', False)
            elif Pg == 0:
                ch = bbs.onekey('0123456789QSCV', False)
            else:
                ch = bbs.onekey('0123456789QSCPV', False)
            if ch in '0123456789':
                tch = int(ch)
                indx=Pg*cfg.LstTotal()+tch
                ansilist[indx].SelectToggle()
            if ch == 'Q':
                running = False
                return ch
            if ch == 'S':
                running = False
                Selector.Save(cfg)
                return ansilist
            if ch == 'C':
                Pg = Pg + 1
            if ch == 'P' and Pg > 0:
                Pg = Pg - 1
            if ch == 'V':
                bbs.write('Which one?')
                ch2 = bbs.onekey('0123456789', False)
                tch = int(ch2)
                indx=Pg*cfg.LstTotal()+tch
                ftemp = ansilist[indx]
                bbs.showfile(cfg.ArtDir()+str(ftemp), Selector.BaudRate, False, False, False)
                bbs.writeln('|PA')

                

        if Rmn > 0 and Pg + 1 == PageTl:
            CurrentPage = ansilist[totalfiles-Rmn:]
            ch = ' '
            while not (ch in 'QSP'):
                bbs.writeln('|CL')
                bbs.showfile(cfg.cfgpath+'hdr.ans', 0, False, False, False)
                for j,Item in enumerate(CurrentPage):
                    slcted = ' '
                    indx=(totalfiles-Rmn+j)
                    if Item.Selected():
                        slcted = '|20|14*|10|16'
                    lineTmp = str()
                    lineTmp += slcted
                    lineTmp += cfg.VData()
                    lineTmp += str(j)
                    lineTmp += cfg.Fixed()
                    lineTmp += ' File: '
                    lineTmp += cfg.VData()
                    lineTmp += str(Item)
                    bbs.writeln(str(lineTmp))
                ch = bbs.onekey('0123456789QSPV', False)
                if ch in '0123456789':
                    tch = int(ch)
                    indx=totalfiles-Rmn+tch
                    ansilist[indx].SelectToggle()
                if ch == 'Q':
                    return ch
                if ch == 'S':
                    Selector.Save(cfg)
                    return ansilist
                if ch == 'P':
                    Pg = Pg - 1
                if ch == 'V':
                    bbs.write('Which one?')
                    ch2 = bbs.onekey('0123456789', False)
                    tch = int(ch2)
                    indx=Pg*cfg.LstTotal()+tch
                    ftemp = ansilist[indx]
                    bbs.showfile(cfg.ArtDir()+str(ftemp), Selector.BaudRate, False, False, False)
                    bbs.writeln('|PA')

def OtherPlay(cfg : Config):
    running = True
    usrdir = cfg.cfgpath+'userdata/'
    usrlst = os.listdir(usrdir)
    totalfiles = len(usrlst)
    PageTl = totalfiles // cfg.LstTotal()
    Rmn = totalfiles % cfg.LstTotal()
    running = True
    Pg = int(0)
    while running:
        CurrentPage = usrlst[Pg*cfg.LstTotal():Pg*cfg.LstTotal()+cfg.LstTotal()]
        ch = ' '    
        while not (ch in 'QCP'):
            bbs.writeln('|CL')
            bbs.showfile(cfg.cfgpath+'uhdr.ans', 0, False, False, False)
            for j,Item in enumerate(CurrentPage):
                indx=(Pg*cfg.LstTotal()+j)
                lineTmp = str()
                lineTmp += cfg.VData()
                lineTmp += str(j)
                lineTmp += cfg.Fixed()
                lineTmp += ' User: '
                lineTmp += cfg.VData()
                lineTmp += str(Item)
                bbs.writeln(str(lineTmp))
            if Pg + 1 == PageTl and 0 == Rmn:
                ch = bbs.onekey('0123456789QP', False)
            elif Pg == 0:
                ch = bbs.onekey('0123456789QC', False)
            else:
                ch = bbs.onekey('0123456789QCP', False)
            if ch in '0123456789':
                tch = int(ch)
                indx=Pg*cfg.LstTotal()+tch
                userfile = usrlst[indx]
#insert load and play code
                Selector.TempLoad(userfile, cfg)
                if len(Selector.SelectedFiles) > 0:
                    for item in Selector.SelectedFiles:
                        playfile=str(item)
                        bbs.showfile(cfg.ArtDir()+playfile, Selector.BaudRate, False, False, False)
                    linetmp = str()
                    linetmp += cfg.Bgrnd()
                    linetmp += cfg.Fixed()
                    linetmp += '-=The End=-'
                    linetmp += '|16|15'
                    bbs.writeln(linetmp)
                    bbs.writeln('|PA')
                else:
                    bbs.writeln('|CL|20|15USER HAS NO FILES SELECTED|PA')
                Selector.Load(cfg)
            if ch == 'Q':
                running = False
                return ch
            if ch == 'C':
                Pg = Pg + 1
            if ch == 'P' and Pg > 0:
                Pg = Pg - 1

        if Rmn > 0 and Pg + 1 == PageTl:
            CurrentPage = usrlst[totalfiles-Rmn:]
            ch = ' '
            while not (ch in 'QP'):
                bbs.writeln('|CL')
                bbs.showfile(cfg.cfgpath+'uhdr.ans', 0, False, False, False)
                for j,Item in enumerate(CurrentPage):
                    indx=(totalfiles-Rmn+j)
                    lineTmp = str()
                    lineTmp += cfg.VData()
                    lineTmp += str(j)
                    lineTmp += cfg.Fixed()
                    lineTmp += ' User: '
                    lineTmp += cfg.VData()
                    lineTmp += str(Item)
                    bbs.writeln(str(lineTmp))
                ch = bbs.onekey('0123456789QP', False)
                if ch in '0123456789':
                    tch = int(ch)
                indx=Pg*cfg.LstTotal()+tch
                userfile = usrlst[indx]
#insert load and play code
                Selector.TempLoad(userfile, cfg)
                if len(Selector.SelectedFiles) > 0:
                    for item in Selector.SelectedFiles:
                        playfile=str(item)
                        bbs.showfile(cfg.ArtDir()+playfile, Selector.BaudRate, False, False, False)
                    linetmp = str()
                    linetmp += cfg.Bgrnd()
                    linetmp += cfg.Fixed()
                    linetmp += '-=The End=-'
                    linetmp += '|16|15'
                    bbs.writeln(linetmp)
                    bbs.writeln('|PA')
                else:
                    bbs.writeln('|CL|20|15USER HAS NO FILES SELECTED|PA')
                Selector.Load(cfg)
                if ch == 'Q':
                    return ch
                if ch == 'P':
                    Pg = Pg - 1

    

# Main
cfg = Config()
if cfg.errorfree:
    Selector.Load(cfg)
    bbs.showfile(cfg.cfgpath+'splash.ans', 0, False, False, False)
    running = True
    while running:
        bbs.showfile(cfg.cfgpath+'main.ans', 0, False, False, False)
        linetmp = str()
        linetmp += cfg.Fixed()
        linetmp += 'Baud set to: '
        linetmp += cfg.VData()
        linetmp += str(Selector.BaudRate)
        linetmp += cfg.Fixed()
        linetmp += ' User: '
        linetmp += cfg.VData()
        linetmp += '|UH'
        bbs.writeln(linetmp)
        ch = bbs.onekey('SBPQV', False)
        if ch == 'S':
            Listing(cfg)
        if ch == 'Q':
            running = False
        if ch == 'B':
            Selector.GetRate(cfg)
            Selector.Save(cfg)
        if ch == 'P':
            if len(Selector.SelectedFiles) > 0:
                for item in Selector.SelectedFiles:
                    playfile=str(item)
                    bbs.showfile(cfg.ArtDir()+playfile, Selector.BaudRate, False, False, False)
                linetmp = str()
                linetmp += cfg.Bgrnd()
                linetmp += cfg.Fixed()
                linetmp += '-=The End=-'
                linetmp += '|16|15'
                bbs.writeln(linetmp)
                bbs.writeln('|PA')

            else:
                bbs.writeln('|CL|20|15NO FILES SELECTED|PA')
        if ch == 'V':
            OtherPlay(cfg)
else:
    bbs.writeln('settings.ini missing or invalid')