// Simple Snake, for Mystic BBS... by xqtr

// Ansi copied and altered from SixteenColors
// Used some piece of code, from the Blackjack game, of Mystic BBS
// All credits to the authors and original creators.


Uses 
User;

Const 
  F_Save  = 'snake.ply';
  
  Version     = '0.1';

  wall = '@';
  

  tput = 1;
  tclr = 2;
  tsav = 3;

Type 
  PlayerRec = Record
    UserID : LongInt;
    Name   : String[30];
    Score   : LongInt;
    TopScore: LongInt;
    LastOn : LongInt;
  End;

Type 
  TopTenRec = Record
    User : String[35];
    score : LongInt;
    topscore : integer;
    Date : LongInt;
  End;


Var  
  ch: char;
  DataPath      : String;
  Player        : PlayerRec;
  PlayerNumber  : LongInt = -1;
  Player_Score  : integer;
  t_option : array[1..3] Of byte;
  
  i,j,len,bombx,bomby,l,dir,dirnew:byte;
	body:array[1..255,1..2] of byte;
	d:integer;
	k:char;
	score:integer;
	timedelay:boolean;
	td:byte;
	
Procedure SavePlayer;

Var 
  F : File;
Begin
  fAssign (F, DataPath + F_Save, 66);
  fReset  (F);
  If player.score>player.topscore Then player.topscore := player.score;
  If PlayerNumber <> -1 Then
    fSeek (F, SizeOf(Player) * (PlayerNumber - 1));
  Else
    fSeek (F, fSize(F));

  fWriteRec (F, Player);
  fClose    (F);
End;

Procedure ExecuteTopTen;

Var 
  TopList   : Array[1..10] Of TopTenRec;
  Count1    : Byte;
  Count2    : Byte;
  Count3    : Byte;
  F         : File;
  OnePerson : PlayerRec;
Begin
  Write ('|16|CL|10Sorting top scores...');

  For Count1 := 1 To 10 Do
    Begin
      TopList[Count1].User := 'None';
      TopList[Count1].Score := 0;
      TopList[Count1].Date := 0;
      TopList[Count1].topscore := 0;
    End;

  fAssign (F, DataPath + F_Save, 66);
  fReset  (F);

  If IoResult = 0 Then
    While Not fEof(F) Do
      Begin
        fReadRec (F, OnePerson);

        For Count2 := 1 To 10 Do
          If TopList[Count2].topscore <= OnePerson.topscore Then
            Begin
              For Count3 := 10 Downto Count2 + 1 Do
                TopList[Count3] := TopList[Count3 - 1]

                                   TopList[Count2].score := OnePerson.score;
              TopList[Count2].User := OnePerson.Name;
              TopList[Count2].Date := OnePerson.LastOn;
              TopList[Count2].topscore := OnePerson.topscore;

              Break;
            End;
      End;

  ClrScr;

  GotoXY (28, 3);
  Write  ('|07Simple Snake - Top 10 ');

  GotoXY (5, 6);
  Write  ('##  User                              Date                      Score');

  GotoXY (5, 7);
  Write  ('|02' + strRep(#196, 68) + '|10');

  For Count1 := 1 To 10 Do
    Begin
      GotoXY (5, 7 + Count1);
      Write  (PadLT(Int2Str(Count1), 2, ' '));

      GotoXY (9, 7 + Count1);
      Write  (TopList[Count1].User);

      GotoXY (42, 7 + Count1);
      Write  (DateStr(TopList[Count1].Date, 1));

      GotoXY (53, 7 + Count1);
      Write  (PadLT(strComma(TopList[Count1].topscore), 20, ' '));

    End;

  GotoXY (5, 18);
  Write  ('|02' + strRep(#196, 68));

  GotoXY (26, 20);
  Write  ('|02Press |08[|15ENTER|08] |02to continue|PN');
End;
	

procedure drawbox(x,y,width,height:integer;title:string);
var i1,i2:integer;
begin
	for i2:=1 to height do
	begin
		gotoxy(x,y+i2-1);
		for i1:=1 to width do
		begin
			if (i1 > 1) and (i1 < width) and (i2 > 1) and (i2 < height) then
				write(' ')
			else
				write('#')
		end;
	end;
	if (title <> '') then
	begin
		i1 := y+((height-1)/2);
		i2 := x+(width/2-length(title)/2);
		gotoxy(i2,i1);
		write(title);
	end;
end;	

procedure drawsnake;
var tmp:integer;
begin
	for tmp:=1 to len do
	begin
		gotoxy(body[tmp,1], body[tmp,2]);
		if (tmp = 1) then write('O')
		else write('X');
	end;
end;

function collision:boolean;
var tmp:integer;
begin
	collision := false;
	for tmp:=1 to len do
	begin
		if (body[tmp,1] < 2) or (body[tmp,1] >= 80) then
		begin
			collision:=true;
			break;
		end;
		if (body[tmp,2] < 4) or (body[tmp,2] >= 24) then
		begin
			collision:=true;
			break;
		end;
	end;
end;

procedure death;
begin
	//textcolor(lightblue);
	textcolor(9)
	drawbox(1,11,80,3,'');
	gotoxy(37,12);
	//textcolor(lightred);
	textcolor(12)
	write('GAME OVER!');
	textcolor(7);
	gotoxy(1,25);
	pause
	SavePlayer;
	ExecuteTopTen;
	halt
end;

procedure extend(x,y:integer);
begin
	score:=score + len
	len:=len+1
	body[len,1] := x;
	body[len,2] := y;
	gotoxy(x,y);
	write('X');
	gotoxy(2,2);
	textcolor(14+18*16);
	write(' Score: '+int2str(score));
	player.score:=score
	textcolor(10);
end;

function snake_contains(x,y:integer):boolean;
var tmp:integer;
begin
	snake_contains := false;
	for tmp:=1 to len do
	begin
		if (body[tmp,1] = x) and (body[tmp,2] = y) then snake_contains := true;
	end;
end;

procedure generate_new;
var x,y:integer;
begin
	repeat
		x := random(78)+1;
		y := random(19)+4;
	until not snake_contains(x,y);
	bombx := x;
	bomby := y;
	gotoxy(x,y);
	textcolor(14+18*16);
	write(chr(244));
	textcolor(6+18*16);
end;

procedure movesnake;
var x,y,wasx,wasy,tmp:integer;
	died:boolean;
begin
	case dir of
		1: begin x :=  1; y := 0; end;
		2: begin x :=  0; y := 1; end;
		3: begin x := -1; y := 0; end;
		4: begin x :=  0; y :=-1; end;
	end;
	gotoxy(body[1,1], body[1,2]); write('X');
	gotoxy(body[len,1], body[len,2]); write(' ');
	wasx:=body[len,1];
	wasy:=body[len,2];
	died := false;
	if (snake_contains(body[1,1] + x, body[1,2] + y)) then
		died := true;
	for tmp:=2 to len do
	begin
		body[len-tmp+2,1] := body[len-tmp+1,1];
		body[len-tmp+2,2] := body[len-tmp+1,2];
	end;
	body[1,1] := body[1,1] + x;
	body[1,2] := body[1,2] + y;
	gotoxy(body[1,1], body[1,2]); write('O');
	if (died) then death;
	if (snake_contains(bombx,bomby)) then
	begin
		extend(wasx,wasy);
		generate_new;
		d:=200
		timedelay:=true
	end;
	
	if timedelay=true then td:=td+1
	if td > 20 then begin
	  d:=100
	  timedelay:=false
	  td:=0
	end
	if (collision) then death;
end;

Procedure LoadPlayer;

Var 
  F : File;
  T : PlayerRec;
Begin
  GetThisUser;

  PlayerNumber  := -1;

  Player.UserID := UserIndex;
  Player.Score   := 0;

  fAssign (F, DataPath + F_Save, 66);
  fReset  (F);

  If IoResult <> 0 Then fReWrite(F);

  While Not fEof(F) Do
    Begin
      fReadRec (F, T);

      If T.UserID = UserIndex Then
        Begin
          Player       := T;
          PlayerNumber := fPos(F) / SizeOf(Player);
          Break;
        End;
    End;

  fClose (F);

  Player.LastOn := DateTime;
  Player.Name   := UserAlias;
  player.score := 0;
End;




Begin
  ClrScr;
  timedelay:=false;
  td:=0;
  If Graphics = 0 Then
    Begin
      WriteLn ('Sorry, this game requires ANSI graphics.|CR|PA');
      Halt;
    End;

  DataPath := JustPath(ProgName);

  If Upper(ParamStr(1)) = 'TOP10' Then
    Begin
      ExecuteTopTen;
      Halt;
    End;
  Randomize;

  LoadPlayer;

  DispFile (DataPath + 'snake');
  GotoXY (25, 24);
  Write('|16|10Simple Snake v' + Version + '   Code: |15xqtr');
  gotoxy(1,25)
  pause  
  clrscr;
	
	len:=1; d:=150; l:=64; score:=0;
	dir:=1; //{1=east,2=south;3=west,4=north}
	for i:=1 to 255 do
		for j:=1 to 2 do
			body[i,j] := 0;
	body[1,1] := 2;
	body[1,2] := 12;
	textcolor(15+18*16);
	drawbox(1,1,80,24,'');
	drawbox(1,1,80,3,'Move with Arrows, Exit with ESC ');
	textcolor(14+18*16);
	generate_new;
	drawsnake;
	gotoxy(2,2);

  repeat
		delay(d);
		if (keypressed) then
		begin
			k:=readkey;
				 If IsArrow Then begin
					if k=chr(77) then dirnew := 1;
					if k=chr(80) then dirnew := 2;
					if k=chr(75) then dirnew := 3;
					if k=chr(72) then dirnew := 4;
				
			
				if (dir = 1) and (dirnew <> 3) then dir := dirnew;
				if (dir = 2) and (dirnew <> 4) then dir := dirnew;
				if (dir = 3) and (dirnew <> 1) then dir := dirnew;
				if (dir = 4) and (dirnew <> 2) then dir := dirnew;
			end else if k = chr(27) then death;
			bufflush
		end;
		movesnake;
		gotoxy(2,2);
	until false;
	
	textcolor(7);
	gotoxy(1,25);
    
End.
