//
// Paging Module v1.1 (linux)
// 
// Includes options for
// - Text Messages
// - Audio Playback
// - Sysop availability status message
//
// 
// DEVELOPED / SUPPORT
//
// CLUTCH BBS
// Telnett: Clutch BBS
// Sysop: niter3
// URL: http://clutch.darktech.org
// Developer: n3! (nite3)
//
//
// NOTES / TO-DO:
//
// - Update the email procedure and change "sysop_name" to the name of the sysop.
// - Update the variable "tz" to reflect your timezone region
// - Review and update "cl_paging.sh" (If using the text option)
//
//   AUDIO OPTION:
//
// - Install the "mpg123" package.
// - Setup your sudoers files under /etc/sudoers (Haven't found a way to pass the audio group over mis 
//   or ddtelnetd. **You may not need to do this, so you can modify the command below and remove "sudo")
//
//   Here is an example of your sudoers file. This will allow elevated permissions without a password
//   prompt.
//
//   bbs ALL=(ALL) NOPASSWD: /usr/bin/mpg123
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING VIA TEXT MESSAGE
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging text
// 
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING VIA AUDIO (requires the "mpg123" package.)
//
// To use audio paging, set the menu command as follows
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging audio
//
// ------------------------------------------------------------------------------------------------
//
// ENABLE PAGING FOR ALL OPTIONS (Text & audio)
//
//	command: (GX) Execute MPL program
//	Data: cl_paging all
//
// ------------------------------------------------------------------------------------------------
//
// SYSOP STATUS MESSAGE
//
// To get a status of the sysop availability, add the following menu item.
// 
//	command: (GX) Execute MPL program
//	Data: cl_paging status
// 


Uses USER
Uses CFG

Begin

Var MyFile : file;
Var Str : string;
Var time : string;         
Var temp_time : string;
Var cstart : string
Var cend : string
Var avail : string
Var tz : string

tz := 'est' // *** Update to your timezone region ***
cstart := int2str(cfgchatstart)
cend := int2str(cfgchatend)

temp_time := timestr(datetime,false);    
time := temp_time;                   


	 If cfgchatend = 00 or cfgchatend = 0 then cfgchatend :=24
		delete(temp_time,3,1); 
		time := copy(temp_time,1,2);


GetThisUser
const prompt = '|[Y10|08:|15|19'
avail := '|[Y11|[X40|16|08availability: |03' + cstart + '-' + cend + '|08 ' + tz +''


//------------------------------------------------------------------------------------------------------------
// Sysop IN status

procedure sysopINstatus
begin
CLRSCR

writeln('|07The sysop is currently |20|15 IN |16|07 OUT')
writeln('|CR|PA')

end


// ------------------------------------------------------------------------------------------------------------
// Sysop OUT status

procedure sysopOUTstatus
begin
CLRSCR

writeln('|07The sysop is currently  IN |20|15 OUT |16')
writeln('|CR|PA')

end

// -----------------------------------------------------------------------------------------------------------
// Email procedure  --------- UPDATE BELOW TO REFLECT YOUR SYSOP NAME

procedure email
begin

If inputny('|07Send |19|15|SN|16|07 a message? :'); Then
menucmd('MW','/To:sysop_name /SUBJ:Page_Attempt'); // Update to reflect Sysop Name

end

// -----------------------------------------------------------------------------------------------------------
// Sysop IN all - Audio and Text

procedure sysopINall
begin

CLRSCR
writeln('|DFcl_paging.ans')
writeln('|[Y08|[X72|16|08v1.1')
writeln('|[Y10|[X01|19|$D76 ')
writeln('|[Y10|[X77|16|08: ')
writeln('|08|16|$D50-|[X10reason?|$D60--')
writeln('' + avail + '')


write(prompt)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
		fclose(MyFile)
	
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		menucmd('DD','/bin/sh -c "sudo mpg123 -q ' + CFGSYSPATH + 'scripts/axelf.mp3 &"')
		
		writeln('|[Y10|[X03|19|$D73 ')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|07|[Y13Please give the sysop a few minutes to respond.|CR')
		email()

end


// -----------------------------------------------------------------------------------------------------------
// Sysop IN Audio

procedure sysopINaudio
begin

CLRSCR
writeln('|DFcl_paging.ans')
writeln('|[Y08|[X72|16|08v1.1')
writeln('|[Y10|[X01|19|$D76 ')
writeln('|[Y10|[X77|16|08: ')
writeln('|08|16|$D50-|[X10reason?|$D60--')
writeln('' + avail + '')

write(prompt)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		menucmd('DD','/bin/sh -c "sudo mpg123 -q ' + CFGSYSPATH + 'scripts/axelf.mp3 &"')
		
		writeln('|[Y10|[X03|19|$D73 ')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|07|[Y13Please give the sysop a few minutes to respond.|CR')
		email()
end


// ------------------------------------------------------------------------------------------------------------------------
// Sysop IN text

procedure sysopINtext
begin


CLRSCR
writeln('|DFcl_paging.ans')
writeln('|[Y08|[X72|16|08v1.1')
writeln('|[Y10|[X01|19|$D76 ')
writeln('|[Y10|[X77|16|08: ')
writeln('|08|16|$D50-|[X10reason?|$D60--')
writeln('' + avail + '')

write(prompt)
Str := Input (73, 73, 1, '')

	If Str = '' Then
		exit

	Else If Str <> '' Then 

		fAssign (MyFile, '/tmp/cl_temp.txt', 66);
		frewrite(MyFile)
		fwriteln(MyFile, UserAlias);
		fwriteln(MyFile, Str);
		fclose(MyFile)
			
		menucmd('DD',CFGSYSPATH + '/scripts/cl_paging.sh')
		
		writeln('|[Y10|[X03|19|$D73 ')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|08:|15|[Y10|19|11 paging |[X10/|DE|[X10\|DE')
		writeln('|16|07|[Y13Please give the sysop a few minutes to respond.|CR')
		email()
end


// -----------------------------------------------------------------------------------------------------------------------
// Sysop OUT

procedure sysopOUT
begin

CLRSCR
writeln('|DFcl_paging.ans')
writeln('|[Y08|[X72|16|08v1.1')
writeln('|[Y10|[X01|$D76 ')
writeln('|[Y10|[X77|16|08: ')
writeln('|08|16|$D50-|[X10reason?|$D60--')
writeln('' + avail + '')

writeln('|[Y10|[X01|08|16:|15 |SN |07is currently not available.  |PA')

email()
	
end


// ------------------------------------------------------------------------------------------------------------------------
// Starts Sysop In text

Procedure sysop_text
Begin

	If (str2int(time) >= cfgchatstart) and (str2int(time) <= cfgchatend) then
		sysopINtext
	Else
		sysopOUT

End


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN audio

procedure sysop_audio
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cfgchatend) then
		sysopINaudio
        Else
		sysopOUT

end


//------------------------------------------------------------------------------------------------------------
// Starts Sysop IN all

procedure sysop_all
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cfgchatend) then
		sysopINall
        Else
		sysopOUT

end


// ------------------------------------------------------------------------------------------------------------
// Starts status message

procedure sysop_status
begin

If (str2int(time) >= cfgchatstart) and (str2int(time) <= cfgchatend) then
		sysopINstatus
        Else
		sysopOUTstatus

end


// ------------------------------------------------------------------------------------------------------------
// ERROR MESSAGE

procedure error
begin

CLRSCR
writeln('|12ERROR!|CR|CR|07Please configure the following options.|CR|CRText - Text Message|CRAudio - Audio Playback|CRStatus - Sysop Status Message|CRALL - Text Messsage & Audio playback')
writeln('|CR|PA')
end


//------------------------------------------------------------------------------------------------------------
// ::: Main Program :::

Case Upper(ParamStr(1)) of
	'STATUS' : sysop_status;
	'TEXT' : sysop_text;
	'AUDIO' : sysop_audio;
	'ALL' : sysop_all;
	
Else
	error

End

End
