/*

	01/09/2018
	This is the Mystic doorgame DoubleUp! by Darryl Perry, aka Gryphon
	of Cyberia BBS (cyberia.darktech.org) 

	DoubleUp! is a sliding block puzzle game patterned after the popular
	video game, 2048, by Gabriele Cirulli.

	DoubleUp! is witten for Mystic BBS using the MPL scripting language.
	This program requires Mystic BBS v1.12a38 or later to run.

	Place the doubleup.mps script in your scripts directory, and compile it.

	Create a Mystic menu of type 'GX' with the data field of 'doubleup'.

	Version 2.1 : 01/27/2018 : o Fixed issue where scores weren't being updated
                              if the player lost the round, but had bested
                              his previous high score.

	Version 2.0 : 01/27/2018 : Double-Up! is now InterBBS-capable.

   Version 1.3 : 05/01/2016 : Changes in Mystic v1.12 variable assigning caused 
                              the game to abort with a RTE 216.  Made changes
                              to be compliant with the new reality.
   Version 1.2 : 01/06/2016 : changed player listing to Top Ten Players
                              Revamped the artwork.
	Version 1.1 : 03/05/2015 : Fixed player listing display 
	Version 1.0 : 06/27/2014 : First release
	

*/

Uses Cfg
Uses User

Const Prog = 'Double-Up! v2.0 by Darryl Perry 2014-2018'
Const CryptKey = 'o_8LpaIhD9V[K+zc*7W^!)yb<4C6EngwMF]BRN=YrlG@ij#f}ZtO1?~QHX2kv/:s\5{30.d,U$A&P>%mSeT-u;(qJx'

Const SX	= 18 
Const SY	= 2

Const NN = 1
Const EE = 2
Const SS = 3
Const WW = 4

Type	PlyrRec = Record
	Idx			: Integer
	Rank			: Integer
	Name		  	: String[40]
	FromBBS		: String[40]
	GameScore	: LongInt
	GameMoves	: Integer
	GameHiMark  : Integer	
	BestScore	: LongInt
	BestMoves	: Integer
	BestHiMark  : Integer	
	GamesPlayed : Integer
End


Var Grid		: Array [1..4,1..4] of Integer
Var Dirg		: Array [1..4,1..4] Of Integer
Var DirX		: Array [1..4] of Integer
Var DirY			: Array [1..4] of Integer
Var Field	  	: LongInt
Var ScoreBox  	: LongInt
Var BestBox		: LongInt
Var MenuBox		: LongInt
Var BeatBox		: LongInt
Var Colors	 	: Array [1..16] Of Integer
Var Plyr			: PlyrRec
Var Highest		: PlyrRec
Var GameOver  	: Boolean = False
Var PlyrCnt		: Integer = 0
Var PlyrFile  	: String
Var ScorAns		: String
Var IBBS_Out	: String
Var IBBS_Base	: String
Var IBBS_Infile_Prefix	: String
Var IBBS_Infile_Postfix	: String
Var IBBS_Email_From		: String
Var IBBS_Email_Subject	: String
Var IBBS_Address			: String
Var IBBS_FromBBS			: String
Var IBBS_Flag				: String
Var Do_IBBS		: Boolean
Var ThisBBS		: String = StripB(StripMCI(MCI2Str('BN')),' ')


Function Decrypt(S:String):String
Var Ret	: String
Var J,V,I: Integer = Pos(S[1],CryptKey)
Begin
	Ret:=''
	For J:=2 To Length(S) Do Begin
		V:=Pos(S[J],CryptKey)-I
		If V < 1 Then
			V:=V+Length(CryptKey)
		If V > Length(CryptKey) Then
			V:=V-Length(CryptKey)
		Ret:=Ret+CryptKey[V]
	End
	Ret:=Replace(Ret,'_',' ')
	Decrypt:=WordGet(1,Ret,'$')
End

Function Encrypt(S:String):String
Var Ret	: String
Var K		: Integer 
Var V,J	: Integer
Var I		: Integer = Random(Length(CryptKey))+1
Begin

	S:=S+'$'
	S:=Replace(S,' ','_')
	K:=Length(S)
	Ret:=CryptKey[I]
	For J:=1 To K Do Begin
		V:=Pos(S[J],CryptKey)+I
		If V > Length(CryptKey) Then
			V:=V-Length(CryptKey)
		Ret:=Ret+CryptKey[V]
	End	
	While Length(Ret) < 78 Do Begin
		Ret:=Ret+CryptKey[Random(Length(CryptKey))+1]
	End
	Encrypt:=Ret
End

Procedure SavePlyr (PL:Integer)
Var Fptr	: File
Begin
	fAssign(Fptr,PlyrFile,66)
	fReset(Fptr)
	If IOResult <> 0 Then Begin
		fReWrite(Fptr)
		Plyr.Idx:=1
	End Else
		fSeek(Fptr,(PL-1)*SizeOf(Plyr))
	fWriteRec(Fptr,Plyr)
	fClose(Fptr)
End

Function ReadPlyr (PlyrNo : Integer): Boolean
Var X	 : Integer
Var Ret  : Boolean = False
Var Fptr : File
Begin
	fAssign(Fptr,PlyrFile,66)
	fReset(Fptr)
	If IoResult = 0 Then Begin
		fSeek(Fptr,(PlyrNo-1)*SizeOf(Plyr))
		If Not fEof(Fptr) Then Begin
			fReadRec(Fptr,Plyr)
			Ret:=True
		End
		fClose(Fptr)
	End
	ReadPlyr:=Ret
End

Procedure Do_IBBS_Out
Var Y,X	: Integer
Var S,R	: String
Begin
	If FileExist(IBBS_Out) Then FileErase(IBBS_Out)
	R:=''

	AppendText(IBBS_Out,'[----------------------------------- START -----------------------------------]')

	R:=StripMCI(Plyr.Name)+'^'+StripMCI(Plyr.FromBBS)+'^'
	R:=R+Int2Str(Plyr.BestScore)+'^'
	R:=R+Int2Str(Plyr.BestMoves)+'^'
	R:=R+Int2Str(Plyr.BestHiMark)+'^'
	R:=R+Int2Str(Plyr.GamesPlayed)+'^'
	S:=Encrypt(R)
	AppendText(IBBS_Out,S)
	AppendText(IBBS_Out,'[-----------------------------------  END  -----------------------------------]')
	MenuCmd('MX',IBBS_Out+';'+IBBS_Base+';'+IBBS_Email_From+';'+IBBS_Email_From+';'+StripMCI(MCI2Str('BN')))
	If FileExist(IBBS_Out) Then FileErase(IBBS_Out)
End


Procedure Check4Best
Begin
	If Plyr.GameScore>Plyr.BestScore Then Begin
		Plyr.BestScore:=Plyr.GameScore
		Plyr.BestMoves:=Plyr.GameMoves
		Plyr.BestHiMark:=Plyr.GameHiMark
		SavePlyr(Plyr.Idx)
		Do_IBBS_Out
	End
End

Function Exp(N:Integer):Integer
Var Ret	: Integer = 1
Begin
	While N > 0 Do Begin
		N:=N-1
		Ret:=Ret*2
	End
	Exp:=Ret
End

Procedure SortList
Var T1,P1,P2	: PlyrRec
Var F1,F2	: File
Var A,X,Y,Z	: Integer
Begin
	SavePlyr(Plyr.Idx)
	T1:=Plyr
	For A:=1 To PlyrCnt Do Begin
	For X:=1 To PlyrCnt Do Begin
		ReadPlyr(X)
		P1:=Plyr
		For Y:=X To PlyrCnt Do Begin
			ReadPlyr(Y)
			P2:=Plyr
			If P1.Idx <> P2.Idx Then Begin
				If P1.BestScore < P2.BestScore Then Begin
					Z:=P1.Idx
					P1.Idx:=P2.Idx
					P2.Idx:=Z
					Plyr:=P1
					SavePlyr(Plyr.Idx)
					Plyr:=P2
					SavePlyr(Plyr.Idx)
				End
			End
		End
	End
	End
	Plyr:=T1
	ReadPlyr(Plyr.Idx)
End

Procedure ListTopTen
Var Box  : LongInt
Var I,X  : Integer
Var S    : String
Var TPlyr	: PlyrRec
Begin

	SortList
	
   SavePlyr(Plyr.Idx)
	TPlyr:=Plyr

   ClassCreate(Box,'box')
   BoxOptions (Box,5,False,46,46,15,15,False,0)
   BoxHeader  (Box,1,(16*4)+15,' Top Ten Players ')
   BoxOpen    (Box,4,SY+4,77,22)

   WriteXY(06,SY+6,(16*2)+15,'Player')
   WriteXY(30,SY+6,(16*2)+05,'From BBS')
   WriteXY(62,SY+6,(16*2)+10,'Score')
   WriteXY(69,SY+6,(16*2)+04,'Highest')
   WriteXY(06,SY+7,(16*2)+14,PadCt(#254,70,#254))

	For X:=1 To 10 Do Begin
		If ReadPlyr(X) Then Begin
			WriteXY(06,SY+7+X,(16*2)+15,Plyr.Name)
			WriteXY(30,SY+7+X,(16*2)+05,Plyr.FromBBS)
         WriteXY(59,SY+7+X,(16*2)+10,PadLt(StrComma(Plyr.BestScore),8,' '))
         WriteXY(70,SY+7+X,Colors[Plyr.BestHiMark+1],PadCt(#219,6,#219))

         S:='|19|00'+PadCt(Int2Str(Exp(Plyr.BestHiMark)),4,' ')
         GoToXy(71,SY+7+X); Write(S)
		End
	End
	
   ReadKey
   BoxClose(Box)
   ClassFree(Box)
	Plyr:=TPlyr
	ReadPlyr(Plyr.Idx)
	
End

Procedure DrawChip(X,Y,C:Integer)
Begin
	WriteXY(X-1,Y-1,Colors[C+1],' '+PadRt(#220,6,#220)+' ')
	WriteXY(X-1,Y  ,16,PadRt(#219,8,#219))
	WriteXY(X  ,Y  ,Colors[C+1],PadRt(#219,6,#219))
	WriteXY(X+1,Y  ,16*7,PadCT(Int2Str(Exp(C)),4,' '))
	WriteXY(X-1,Y+1,Colors[C+1],' '+PadRt(#223,6,#223)+' ')
End

Procedure GetHighest
Var X	: Integer = 1
Var MeMe: PlyrRec 
Var S	: String
Begin

	MeMe:=Plyr
	Highest.BestScore:=0
	While ReadPlyr(X) Do Begin
		If Plyr .BestScore > Highest.BestScore Then
			Highest:=Plyr
		X:=X+1
	End
	WriteXY(4,14,95,Copy(Highest.Name,1,16))
	WriteXY(4,15,95,Copy(Highest.FromBBS,1,16))
	WriteXY(12,16,94,PadLt(StrComma(Highest.BestScore),8,' '))
	WriteXY(12,17,94,PadLt(StrComma(Highest.BestMoves),8,' '))
	DrawChip(14,19,Highest.BestHiMark)


	Plyr:=MeMe
End

Function FindPlyr(PlyrName,BBS: String) : Integer
Var X,Ret	: Integer = 0
Var Found	: Boolean = False
Begin
	X:=1
	While ReadPlyr(X) And Not Found Do Begin
		If Upper(Plyr.Name)=Upper(PlyrName) And Upper(Plyr.FromBBS)=Upper(BBS) Then Begin
			Ret:=X
			Found:=True
		End
		X:=X+1
	End
	FindPlyr:=Ret
End

Procedure DrawSpot(X,Y:Byte)
Var S	: String
Var C	: Integer
Begin
	C:=Grid[X,Y]+1
	S:=PadCt(Int2Str(Exp(C-1)),4,' ')
	WriteXY(SX+(X*8),SY+(Y*4)-1,Colors[C],PadCt(#219,6,#219))
	WriteXY(SX+(X*8),SY+(Y*4)  ,Colors[C],PadCt(#219,6,#219))
	WriteXY(SX+(X*8),SY+(Y*4)+1,Colors[C],PadCt(#219,6,#219))
	If Exp(C-1) > 1 Then
		WriteXY(SX+(X*8)+1,SY+(Y*4),(16*7),S)
End

Procedure DrawGrid
Var D,C	: Integer
Var X,Y	: Byte
Var T,S	: String
Begin
	For X:=1 To 4 Do Begin
		For Y:=1 To 4 Do Begin
			DrawSpot(X,Y)
		End
	End
End

Procedure AddRandom
Var C,X,Y  : Byte
Var Done	: Boolean = False
Begin
	C:=0
	Repeat
		X:=Random(4)+1
		Y:=Random(4)+1
		If Grid[X,Y]=0 Then Begin 
			Grid[X,Y]:=1
			Done:=True
		End
		C:=C+1
	Until Done Or C > 100
End

Procedure DrawField
Begin
	ClassCreate (Field, 'box');
	ClassCreate(ScoreBox,'box')
	ClassCreate(BestBox,'box')
	ClassCreate(MenuBox,'box')
	ClassCreate(BeatBox,'box')

	BoxHeader	(ScoreBox,1,78,' This Game ')
	BoxHeader	(BestBox ,1,31,' Best Game ')
	BoxHeader	(Field	,1,31,' Double-Up! ')
	BoxHeader	(MenuBox ,1,31,' Menu ')
	BoxHeader	(BeatBox ,1,31,' One To Beat ')

	BoxOptions(Field	,6,True, 127, 120, 127,  56, False,0);
	BoxOptions(ScoreBox,6,True,  27,  24, 127,  56, False,0);
	BoxOptions(BeatBox ,6,True,  91,  88, 127,  56, False,0);
	BoxOptions(BestBox ,6,True,  75,  72, 127,  56, False,0);
	BoxOptions(MenuBox ,6,True, 107, 104, 127,  56, False,0);


	BoxOpen (ScoreBox,	 2, SY+1,  SX+3, SY+9)
	BoxOpen (BeatBox ,	 2, SY+11, SX+3, SY+19)
	BoxOpen (Field	, SX+5, SY+1, SX+40, SY+19)
	BoxOpen (BestBox ,SX+42, SY+1,	 79, SY+9)
	BoxOpen (MenuBox ,SX+42, SY+11,	79, SY+19)

	GoToXy(1,1)
	Write('|16|11 |19|15 '+PadCt(Prog,76,' ')+' |16')

	WriteXY(4,4 ,30,PadRt(Plyr.Name,17,' '))
	WriteXY(4,5 ,30,'Score  :')
	WriteXY(4,6 ,30,'Moves  :')
	WriteXY(4,9 ,30,'Highest:')
	WriteXY(SX+44,4,78,PadRt(Plyr.Name,17,' '))
	WriteXY(SX+44,5,78,'Score  :')
	WriteXY(SX+44,6,78,'Moves  :')
	WriteXY(SX+44,9,78,'Highest:')

	WriteXY(4,16,94,'Score  :')
	WriteXY(4,17,94,'Moves  :')
	WriteXY(4,19,94,'Highest:')

	WriteXY(SX+45,15,110,#16+','+#17+','+#30+','+#31+' = Move')
	WriteXY(SX+45,16,110,'Q, ESC = QUIT ')
	WriteXY(SX+45,17,110,'L = Leaders   ')
	WriteXY(SX+45,18,110,'? = Help      ')
End

Procedure DeInit
Begin
	BoxClose(Field)
	BoxClose(ScoreBox)
	BoxClose(BestBox)
	BoxClose(MenuBox)
	BoxClose(BeatBox)
	ClassFree(Field)
	ClassFree(ScoreBox)
	ClassFree(BestBox)
	ClassFree(MenuBox)
	ClassFree(BeatBox)
	SavePlyr(Plyr.Idx)
End

Procedure ResetPlayer
Begin
	Plyr.GameMoves:=0
	Plyr.GameHiMark:=1
	Plyr.GameScore:=1
	Plyr.GamesPlayed:=Plyr.GamesPlayed+1
	SavePlyr(Plyr.Idx)
End

Procedure ResetGame
Var X,Y	: Byte
Begin
	For X:=1 To 4 Do Begin
		For Y:=1 To 4 Do Begin
			Grid[X,Y]:=0
		End
	End
	AddRandom
	AddRandom
	GameOver:=False
End

Procedure AddPlayer(UA,FB:String;BM,BS,BHM,GP:Integer)
Begin
	PlyrCnt:=PlyrCnt+1
	Plyr.Idx:=PlyrCnt
	Plyr.Name:=StripMCI(UA)
	Plyr.BestMoves:=BM
	Plyr.BestScore:=BS
	Plyr.BestHiMark:=BHM
	Plyr.GamesPlayed:=GP
	Plyr.FromBBS:=StripMCI(FB)
	SavePlyr(Plyr.Idx)
End

Procedure MakeScoreFile
Var Q,S	: String
Var L,X	: Integer
Begin
	SortList
	If FileExist(ScorAns) Then FileErase(ScorAns)

	S:='|16|11|CL|CR |19|15 '+PadCt(Prog,76,' ')+' |16'
	AppendText(ScorAns,S)
	AppendText(ScorAns,'')
	S:='|11 '+PadRt('Player',20,' ')
	S:=S+PadRt('BBS',20,' ')
	S:=S+PadLt('Score',15,' ')
	S:=S+PadLt('Highest',23,' ')
	AppendText(ScorAns,S)
	S:='|10 '+PadCt(#254,78,#254)
	AppendText(ScorAns,S)
	X:=1
	While ReadPlyr(X) Do Begin
		S:='|13 '+PadRt(Plyr.Name,20,' ')
		S:=S+'|05'+PadRt(Plyr.FromBBS,20,' ') 
		S:=S+'|09'+PadLt(StrComma(Plyr.BestScore),15,' ') 
		S:=S+'               |'+PadLt(Int2Str(Colors[Plyr.BestHiMark+1]),2,'0')+#219+#219
		S:=S+'|23|00'+PadCt(Int2Str(Exp(Plyr.BestHiMark)),4,' ')
		S:=S+'|'+PadLt(Int2Str(Colors[Plyr.BestHiMark+1]),2,'0')+#219+#219+'|16'
		AppendText(ScorAns,S)
		X:=X+1
	End
	S:='|10 '+PadCt(#254,78,#254)
	AppendText(ScorAns,S)
End

Procedure DeleteBBS(BS:String)
Var InFptr,OutFptr: File 
Var InFile,OutFile: String = PlyrFile
Var TPlyr	: PlyrRec
Var X	: Integer = 0
Begin
	OutFile:=PlyrFile+'.tmp'
	fAssign(InFptr,InFile,66)
	fReset(InFptr)
	If IoResult = 0 Then Begin
		fAssign(OutFptr,OutFile,66)
		fReWrite(OutFptr)
		While Not fEof(InFptr) Do Begin
			fReadRec(InFptr,TPlyr)
			If TPlyr.FromBBS <> BS Then Begin
				TPlyr.Idx:=X+1
				fWriteRec(OutFptr,TPlyr)
				X:=X+1
			End
		End
		fClose(OutFptr)
	End
	fClose(InFptr)
	If FileExist(Outfile) Then Begin
		If FileExist(InFile) Then Begin
			fileErase(InFile)
			FileCopy(OutFile,InFile)
			FileErase(OutFile)
		End
	End	
End

Procedure Do_IBBS_Input
Var Fptr	: File
Var Thisfile,Q,S,P,B	: String
Var Ok2Read	: Boolean = False
Var TPlyr	: PlyrRec
Var BestMoves,BestHiMark,GP,X			: Integer
Var BestScore		: LongInt
Begin
	If Not Do_IBBS Then Exit
	TPlyr:=Plyr

	FindFirst(JustPath(Progname)+IBBS_Infile_Prefix+'*'+IBBS_Infile_Postfix,66)
	While DOSERROR = 0 Do Begin
		ThisFile:=JustPath(ProgName)+DirName
		fAssign(Fptr,ThisFile,66)
		fReset(Fptr)
		If IoResult = 0 Then Begin
			While Not fEof(Fptr) Do Begin
				fReadLn(Fptr,S)
				If Pos('-  END  -',S) > 0 Then Ok2Read:=False
				If Ok2Read Then Begin
					Q:=Decrypt(S)
					P:=WordGet(1,Q,'^')
					B:=StripB(WordGet(2,Q,'^'),' ')
					BestScore:=Str2Int(WordGet(3,Q,'^'))
					BestMoves:=Str2Int(WordGet(4,Q,'^'))
					BestHiMark:=Str2Int(WordGet(5,Q,'^'))
					GP:=Str2Int(WordGet(6,Q,'^'))

					If Replace(Upper(StripB(B,' ')),' ','_') <> Upper(ThisBBS) Then Begin
	
						X:=FindPlyr(P,B)
						If X < 1 Then
							AddPlayer(P,B,BestMoves,BestScore,BestHiMark,GP)
						Else Begin
							If ReadPlyr(X) Then Begin
								Plyr.Name:=StripMCI(P)
								Plyr.FromBBS:=StripMCI(B)
								Plyr.BestScore:=BestScore
								Plyr.BestMoves:=BestMoves
								Plyr.BestHiMark:=BestHiMark
								Plyr.GamesPlayed:=GP
								SavePlyr(Plyr.Idx)
							End	
						End
					End
				End
			
				If Pos('- START -',S) > 0 Then Ok2Read:=True
			End
			fClose(Fptr)
			FileErase(ThisFile)
		End
		FindNext
	End 
	FindClose
	Plyr:=TPlyr
	ReadPlyr(Plyr.Idx)
End

Procedure ReadIBBSIni
Var fptr	: File
Var Key,Val,S	: String
Begin
	Do_IBBS:=False
	If FileExist(JustPath(ProgName)+'ibbs.mpy') Then Begin
		If FileExist(JustPath(ProgName)+'ibbs.ini') Then Begin
			Do_IBBS:=True
		End
	End

	If Do_IBBS Then Begin
		fAssign(Fptr,JustPath(ProgName)+'ibbs.ini',66)
		fReset(Fptr)
		If IoRESULT = 0 Then Begin
			While Not fEof(Fptr) Do Begin
				fReadLn(Fptr,S)
				If Pos('=',S) > 0 Then Begin
					Key:=StripB(WordGet(1,S,'='),' ')
					Val:=StripB(WordGet(2,S,'='),' ')
					Case Upper(Key) Of
						'DATA_BASE': IBBS_Base:=Val
						'PREFIX'	: IBBS_Infile_Prefix:=Val
						'POSTFIX': IBBS_Infile_Postfix:=Val
						'FROM'	: IBBS_Email_From:=Val
						'SUBJECT': IBBS_Email_Subject:=Val
						'ADDRESS': IBBS_Address:=Val
						'FLAG'	: If Val <> '1' Then Do_IBBS:=False
					End
				End
			End
			fClose(Fptr)
		End
		If Do_IBBS Then Begin
			MenuCmd('GY',JustPath(ProgName)+'ibbs.mpy')
			Do_IBBS_Input
		End
	End 
End

Procedure Init
Var X,C	: Integer=0
Begin

	DirX[NN]:=0;	DirY[NN]:=-1
	DirX[EE]:=1;	DirY[EE]:=0
	DirX[SS]:=0;	DirY[SS]:=1
	DirX[WW]:=-1;	DirY[WW]:=0

	Colors[1]:=7
	Colors[2]:=1
	Colors[3]:=2
	Colors[4]:=3
	Colors[5]:=4
	Colors[6]:=5
	Colors[7]:=6
	Colors[8]:=9
	Colors[9]:=+10
	Colors[10]:=11
	Colors[11]:=12
	Colors[13]:=13
	Colors[14]:=14
	Colors[15]:=10

	ScorAns:=JustPath(ProgName)+'duscore.asc'
	If ParamCount > 0 Then Begin
		ScorAns:=ParamStr(1)
	End

	PlyrFile:=JustPath(ProgName)+'dblup.ply'
	IBBS_Out:=JustPath(ProgName)+'ibbs.out'
	
	MenuCmd('NA','Playing Double-Up!')

	PlyrCnt:=0
	While ReadPlyr(PlyrCnt+1) Do PlyrCnt:=PlyrCnt+1

	GetThisUser
	X:=FindPlyr(UserAlias,ThisBBS)

	If X < 1 Then 
		AddPlayer(UserAlias,MCI2Str('BN'),0,0,0,0)
	Else	
		ReadPlyr(X)

	ReadIBBSIni

	DrawField
	GetHighest
	ResetGame
	ResetPlayer
End

Procedure GoWest
Var Z,X,Y	: Byte
Begin
	For Y:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For X:=1 To 3 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X+1,Y]
					Grid[X+1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X+1,Y)
				End
			End
		End
	End
	For Y:=1 To 4 Do Begin
		For X:=1 To 3 Do Begin
			If Grid[X,Y]>0 Then Begin
				If Grid[X,Y]=Grid[X+1,Y] Then Begin
					Grid[X,Y]:=Grid[X,Y]+1
					If Grid[X,Y] > Plyr.GameHiMark Then
						Plyr.GameHiMark:=Grid[X,Y]
					Plyr.GameScore:=Plyr.GameScore+Exp(Grid[X,Y])
					Grid[X+1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X+1,Y)
				End
			End
		End
	End
	For Y:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For X:=1 To 3 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X+1,Y]
					Grid[X+1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X+1,Y)
				End
			End
		End
	End
End

Procedure GoEast
Var Z,X,Y	: Byte
Begin
	For Y:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For X:=4 Down To 2 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X-1,Y]
					Grid[X-1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X-1,Y)
				End
			End
		End
	End
	For Y:=1 To 4 Do Begin
		For X:=4 Down To 2 Do Begin
			If Grid[X,Y]>0 Then Begin
				If Grid[X,Y]=Grid[X-1,Y] Then Begin
					Grid[X,Y]:=Grid[X,Y]+1
					If Grid[X,Y] > Plyr.GameHiMark Then
						Plyr.GameHiMark:=Grid[X,Y]
					Plyr.GameScore:=Plyr.GameScore+Exp(Grid[X,Y])
					Grid[X-1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X-1,Y)
				End
			End
		End
	End
	For Y:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For X:=4 Down To 2 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X-1,Y]
					Grid[X-1,Y]:=0
					DrawSpot(X,Y)
					DrawSpot(X-1,Y)
				End
			End
		End
	End
End

Procedure GoNorth
Var Z,X,Y	: Byte
Begin
	For X:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For Y:=1 To 3 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X,Y+1]
					Grid[X,Y+1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y+1)
				End
			End
		End
	End
	For X:=1 To 4 Do Begin
		For Y:=1 To 3 Do Begin
			If Grid[X,Y]>0 Then Begin
				If Grid[X,Y]=Grid[X,Y+1] Then Begin
					Grid[X,Y]:=Grid[X,Y]+1
					If Grid[X,Y] > Plyr.GameHiMark Then
						Plyr.GameHiMark:=Grid[X,Y]
					Plyr.GameScore:=Plyr.GameScore+Exp(Grid[X,Y])
					Grid[X,Y+1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y+1)
				End
			End
		End
	End
	For X:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For Y:=1 To 3 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X,Y+1]
					Grid[X,Y+1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y+1)
				End
			End
		End
	End
End

Procedure GoSouth
Var Z,X,Y	: Byte
Begin
	For X:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For Y:=4 Down To 2 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X,Y-1]
					Grid[X,Y-1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y-1)
				End
			End
		End
	End
	For X:=1 To 4 Do Begin
		For Y:=4 Down To 2 Do Begin
			If Grid[X,Y]>0 Then Begin
				If Grid[X,Y]=Grid[X,Y-1] Then Begin
					Grid[X,Y]:=Grid[X,Y]+1
					If Grid[X,Y] > Plyr.GameHiMark Then
						Plyr.GameHiMark:=Grid[X,Y]
					Plyr.GameScore:=Plyr.GameScore+Exp(Grid[X,Y])
					Grid[X,Y-1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y-1)
				End
			End
		End
	End
	For X:=1 To 4 Do Begin
		For Z:=1 To 4 Do Begin
			For Y:=4 Down To 2 Do Begin
				If Grid[X,Y] = 0 Then Begin
					Grid[X,Y]:=Grid[X,Y-1]
					Grid[X,Y-1]:=0
					DrawSpot(X,Y)
					DrawSpot(X,Y-1)
				End
			End
		End
	End
End

Function CountEmpty:Integer
Var Ret	: Integer = 0
Var X,Y	: Byte
Begin
	For X:=1 To 4 Do Begin
		For Y:=1 To 4 Do Begin
			If Grid[X,Y]=0 Then Ret:=Ret+1
		End
	End
	CountEmpty:=Ret
End

Function CountMoves:Integer
Var Ret	: Integer = 0
Var X,Y	: Integer
Begin
	For X:=1 To 3 Do 
		For Y:=1 To 4 Do 
			If Grid[X,Y]=Grid[X+1,Y] Then Ret:=Ret+1

	For Y:=1 To 3 Do
		For X:=1 To 4 Do
			If Grid[X,Y]=Grid[X,Y+1] Then Ret:=Ret+1
	CountMoves:=Ret
End

Procedure Move(DD:Byte)
Var X,Y	: Byte
Var Changed: Boolean = False
Begin

	Changed:=False
	For Y:=1 To 4 Do 
		For X:=1 To 4 Do 
			Dirg[X,Y]:=Grid[X,Y]

	Case DD Of
		NN: GoNorth
		SS: GoSouth
		EE: GoEast
		WW: GoWest
	End

	For Y:=1 To 4 Do 
		For X:=1 To 4 Do 
			If Grid[X,Y]<>Dirg[X,Y] Then Changed:=True

	If CountEmpty < 1 And CountMoves < 1 Then GameOver:=True
	If Not GameOver Then Begin
		If Changed Then Begin
			Plyr.GameMoves:=Plyr.GameMoves+1
			AddRandom
		End
	End Else Begin
		Check4Best
	End
End

Procedure UpdateScoreBoard
Var S	: String
Begin
	WriteXY(12,5 ,30,PadLt(StrComma(Plyr.GameScore),8,' '))
	WriteXY(12,6 ,30,PadLt(StrComma(Plyr.GameMoves),8,' '))
	DrawChip(14,9,Plyr.GameHiMark)
	WriteXY(SX+53,5,78,PadLt(StrComma(Plyr.BestScore),7,' '))
	WriteXY(SX+53,6,78,PadLt(StrComma(Plyr.BestMoves),7,' '))
	DrawChip(SX+54,9,Plyr.BestHiMark)
End

Function KeepPlaying:Boolean
Var KPBox	: LongInt
Var Ret	  : Boolean = False
Begin
	Check4Best
	ClassCreate (KPBox, 'box');
	BoxHeader (KPBox, 0,31,'Game Over!');	  
	BoxOpen	(KPBox,32, 6, 48, 11);

	WriteXY(35, 8,(16*7),'Play Again?')	
	WriteXY(35,10,(16*7),'  (Y/N): ')	
	Ret:=False
	If OneKey('YN',False) = 'Y' Then 
		Ret:=True

	BoxClose(KPBox)
	ClassFree(KPBox)
	
	KeepPlaying:=Ret
End

Procedure Help
Var X	: Integer
Var Box	: LongInt
Var S	: String
VAr Sav	: PlyrRec
Begin

	Sav:=Plyr
	ClassCreate (Box, 'box');
	BoxOptions  (Box,5,False,78,78,15,15,False,0)
	BoxHeader	(Box,1,(16*1)+15,' How To Play ' )
	BoxOpen (Box, 14, SY+3, 66, 20)

	WriteXY(16, 7,78,'Double-Up! is played on a simple gray 4x4		 ')
	WriteXY(16, 8,78,'grid with tiles of varying colors that slide	 ')
	WriteXY(16, 9,78,'when moved using the four arrow keys.			  ')
	WriteXY(16,10,78,'																')
	WriteXY(16,11,78,'The tiles slide as far as possible in the chosen')
	WriteXY(16,12,78,'direction until they are stopped by either		')
	WriteXY(16,13,78,'another tile or the edge of the grid.  If two	')
	WriteXY(16,14,78,'tiles of the same number collide while moving,  ')
	WriteXY(16,15,78,'they will "double-Up" and merge into a tile with')
	WriteXY(16,16,78,'the combined value.  The resulting tile cannot  ')
	WriteXY(16,17,78,'merge with another tile again in the same move. ')
	WriteXY(16,18,78,'Every turn, a new tile will randomly appear in  ')
	WriteXY(16,19,78,'an empty spot with a value of 2.					 ')
	ReadKey
	BoxClose(Box)
	ClassFree(Box)	
	Plyr:=Sav
End

Procedure Q2BBS
Begin
	Check4Best
	ClrScr
	MakeScoreFile
	DispFile(ScorANS)
	Pause
	WriteLn('|16|14|CL|CR|CRReturning to |BN|CR|CR')
	Pause
	Halt
End

Procedure Main
Var Ch	: Char
Var Done	: Boolean = False
Begin
	While Not Done Do Begin
		If GameOver Then Begin
			If KeepPlaying Then Begin
				ResetGame	
				ResetPlayer
				GetHighest
			End Else
				Q2BBS
		End

		UpdateScoreBoard
		DrawGrid
		Ch:=ReadKey
		If IsArrow Then Begin
			Case Ch Of
				#72: Move(NN)
				#75: Move(WW)
				#77: Move(EE)
				#80: Move(SS)
			End
		End Else Begin
			Ch:=Upper(CH)
			Case Ch Of
				'Q': Done:=True
				#27: Done:=True
				'8': Move(NN)
				'4': Move(WW)
				'6': Move(EE)
				'2': Move(SS)
				'L': ListTopTen
				'A': If ACS('s255') Then Do_IBBS_Input
				'?': Help
			End
		End
	End
End

Begin
	ClrScr
	Init
	Main
	DeInit
	Q2BBS
End
