// ==========================================================================
//   File: G-RUMORS.MPS
//   Desc: Rumors engine for Mystic BBS v2.0
// Author: g00r00
// ==========================================================================
//
// INSTALLATION:
//
//   1) Copy G-RUMORS.MPS into its own directory or your scripts path and
//      compile it with MPLC or MIDE
//
//   2) For each menu you want to display rumors on, you must edit with the
//      MCFG -> Menu Editor and add the following menu command:
//
//         HotKey: EVERY
//        Command: GX (Execute MPL)
//           Data: g-rumors show
//
//      Note that if you have it in a path other than the scripts path, then
//      you will have to specify that in the Data field above.  For example
//      <path>g-rumors show
//
//   3) When g-rumors show is ran, it generates a rumor and stores it into
//      the &A MCI code.  Therefore, you will need to edit your menu prompt
//      and add |&A into it where you want it to display the rumor.
//
//   4) There are options in addition to the SHOW command in which you can
//      use to add other functionality to your BBS.  They are:
//
//        ADD : Allows adding of a rumor to the rumor database.  The database
//              keeps the 50 more currently added rumors.
//
//      EXAMPLE:
//
//         Hotkey: A
//        Command: GX (Execute MPL)
//           Data: rumors add
//
// CUSTOMIZATION:
//
//   If you wish to customize the prompts used in the Rumors, you can do
//   so by changing the PromptAdd and PromptSave values set below.
//
// LICENSE:
//
//   You are not permitted to modify this program and release it.  You are
//   not permitted to take any code and use it in another program which you
//   release without permission from g00r00.  You may make modifications to
//   this program for your own personal use.  If you feel you've made the
//   program better, contact me and I may include it in a future release. As
//   long as people abide to these rules, I will continue to release mods
//   and source code.
//
// HISTORY:
//
//   - 12/20/02: Version 1 released
// ==========================================================================

{$syntax iplc}

const
  PromptAdd  = "|CR|15E|07n|08ter |07y|08our |07r|08umor|CR:|07"
  PromptSave = "|CR|15S|07a|08ve |07t|08his |07r|08umor? |XX"

proc rumoradd {
  @ string str
  @ string(50) data
  @ byte datasize, count
  @ file f

  write(promptadd)
  str = getstr(78, 78, 1, "")

  if str == "" exit
  if !getyn(promptsave, true) exit

  fassign(f, justpath(progname) + "rumors.dat", 2)
  freset(f)
  if ioresult <> 0 frewrite(f)

  while !feof(f) && datasize < 50 {
    datasize = datasize + 1
    freadln(f, data(datasize))
  }

  fclose(f)

  if datasize == 50 {
    for count = 1 to 49
      data(count) = data(count+1)
  } else
    datasize = datasize + 1

  data(datasize) = str

  frewrite(f)
  for count = 1 to datasize
    fwriteln(f, data(count))
  fclose(f)
}

proc rumorshow {
  @ string(50) data
  @ byte datasize, count
  @ file f

  fassign (f, justpath(progname) + "rumors.dat", 2)
  freset (f)

  if ioresult <> 0 exit

  while !feof(f) && datasize < 50 {
    datasize = datasize + 1
    freadln(f, data(datasize))
  }

  count    = random(datasize) + 1
  datasize = 0

  freset(f)
  while datasize <> count {
    datasize = datasize + 1
    freadln(f, data(datasize))
  }

  fclose(f)

  setpromptinfo("A", data(datasize))
}

{
  @ string options

  options = strupper(progparams)

  if pos("ADD",  options) > 0
    rumoradd()
  else
  if pos("SHOW", options) > 0
    rumorshow()
  else
    writeln("RUMORS: Invalid option: press a key|PN")
}

