#!/usr/bin/python
import requests
import sys
import cmd2 as cmd
import os
import csv
import json
import tabulate
import pandas as pd
from prettytable import PrettyTable
from subprocess import Popen, PIPE
import wikipedia
import textwrap
import codecs
from termcolor import colored
from colorama import Fore, Back, Style
import re
import unicodedata
from itertools import repeat

bbs_path = "/u01/bbs/text/wiki"
bbs_name = "Infoline BBS"
prog_version = "0.4"
keyword = "wiki"
section_010_begin = "--||"
section_010_end = "||--\n"
section_020_begin = "--++"
section_020_end = "++--\n"
section_010_text = Fore.CYAN
section_020_text = Fore.CYAN
section_010_ansi_color = 'green'
section_010_text_color = 'green'
section_020_ansi_color = 'cyan'
section_020_text_color = 'cyan'

def rep(s,n):
  ''.join(list(repeat(s,n)))

def prettyKeyword(keyword, color, bright):
  ret = ""
  if bright == 1:
    return (Style.BRIGHT + colored(keyword.upper(),color)  + " " )
  if bright == 2:
    return (Style.NORMAL + colored(keyword.upper(),color) + " " )
  if bright == 3:
    return (Style.DIM + colored(keyword.upper(),color) + " " )
  return (ret)

    #\e[0;0H \
def getWikiPage(keyword):
  # "\033[2J" \ # CLEARS THE SCR 
  # "\0330H" \  # Puts cursor topl
  article_banner = "" \
    + "\n\n" \
    + "\033[2J" \
    + "\n"

  for i in range(1,4):
    for j in range(1,5):
      article_banner = article_banner \
      + prettyKeyword(keyword,'cyan',j % 3) 
    article_banner = article_banner + colored(" @@@ SOURCE: WIKIPEDIA\n",'white')

  res = wikipedia.page(keyword.lower())
  keyword = keyword.lower().replace(" ","_")
  file = codecs.open(bbs_path + "/" + keyword + '.txt','arw+','utf-8')
  file.truncate()
  file.write(article_banner)
  file.write("" + "\n")
  file.write(" + ");
  p1 = re.compile('(===)(.*)(===)',re.MULTILINE)
  p2 = re.compile('(==)(.*)(==)',re.MULTILINE)
  bfsep=res.content
  bfres=bfsep
  afres = unicodedata.normalize('NFKD', bfres ).encode('ascii','ignore')
  afres = p1.sub(Style.DIM + colored(section_010_begin,section_010_ansi_color) + Style.BRIGHT + colored(r"\2",section_010_text_color) + Style.DIM + colored(section_010_end,section_010_ansi_color) + section_010_text ,bfres)
  afres = p2.sub(Style.DIM + colored(section_020_begin,section_020_ansi_color) + Style.BRIGHT + colored(r"\2",section_020_text_color) + Style.DIM + colored(section_020_end,section_020_ansi_color) + section_020_text,afres)
  for i in textwrap.wrap(afres,48,break_long_words=False,replace_whitespace=False, drop_whitespace=False,initial_indent=Style.BRIGHT + colored("+++ ",'red')):
    outline = "%s"  % i
    file.write(outline)
  file.write("" + "\n")
  file.write(colored(""+"=".ljust(77,"-")+"=",'grey'))
  file.close()

#def text_postprocessing(keyword):
#  var origfile
#  res = wikipedia.page(keyword.lower())
#  keyword = keyword.lower().replace(" ","_")
#  file = codecs.open(bbs_path + "/" + keyword + '.tmp','arw+','utf-8')
#  while not _is_eof(f): ## how to check that end is reached?
#    origfile += f.readline()
#  file = codecs.open(bbs_path + "/" + keyword + '.txt','arw+','utf-8')

def noway():
    print "->" # red

class cli(cmd.Cmd):

  prompt = '-> '
  intro = "\nUse:\nwiki <keyword>\nthen unjk space to scroll\nq - quit\n"

  def do_shell(self, line):
    noway()

  def do_pause(self, line):
    noway()

  def do_edit(self, line):
    noway()

  def do_shortcuts(self, line):
    noway()

  def do_set(self, line):
    noway()

  def do_run(self, line):
    noway()

  def do_py(self, line):
    noway()

  def do_load(self, line):
    noway()

  def do__relative_load(self, line):
    noway()

  def do_version(self, line):
    noway()

  def do_help(self, line):
    noway()

  def do_wiki(self,line):
    resp = getWikiPage(line) 
    line = line.lower().replace(" ","_")
    os.system('ansi ' + bbs_path + "/" + line + '.txt')

if __name__ == '__main__':
  cli().cmdloop()
