(*
   RCS Scrollz Announcements
   
   Copyright 2020 Black Panther(RCS) <dan@castlerockbbs.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
     
2020-10-11  Black Panther(RCS)  <dan@castlerockbbs.com>

*)

Uses CFG

Const
  PROG_NAME = 'Scrollz Announcements'
  PROG_VER_MAJ = '0'
  PROG_VER_MIN = '7'
  PROG_VER_TYP = 'beta'
  
Var
  DelTime  :Integer=150
  Banner   :String[90]
  Banners  :Array[1..11] of String[90]
  colortext:String[4]='3'
  colorcaps:String[4]='9'
  count    :Byte=1
  x        :Byte=10
  y        :Byte=8
  z        :Byte=0
  v        :Byte=1
  t        :Byte=1
  oldt     :Byte=1
  oldt2    :Byte=1
  endx     :Byte=70
  msglen   :Byte
  fldlen   :Byte
  temp     :String
  temp1    :String
  ch       :Char
  done     :Boolean=false
  ininame  :String
  
procedure init(ini:string)
Var
  config     : FILE
  s          : String
  s1         : String
  s2         : String
Begin
  fAssign(config,CfgMpePath+ini,66)
  fReset(config)
  If IOResult = 0 Then
  Begin
    While Not fEOF(config) do
      Begin
		fReadLn(config,s)
		if s[0]<>';' then
		  Begin
    		s1:=WordGet(1,s,'=')
	    	s2:=WordGet(2,s,'=')
		    Case s1 of
			    'line'      : y:=Str2Int(s2)
    			'start'     : x:=Str2Int(s2)
	    		'end'       : endx:=Str2Int(s2)
		    	'colortext' : colortext:=s2
			    'colorcaps' : colorcaps:=s2
    			'speed'     : DelTime:=Str2Int(s2)
	    		'count'     : count:=Str2Int(s2)
		    	'banner1'   : Banners[1]:=s2
			    'banner2'   : Banners[2]:=s2
    			'banner3'   : Banners[3]:=s2
	    		'banner4'   : Banners[4]:=s2
		    	'banner5'   : Banners[5]:=s2
			    'banner6'   : Banners[6]:=s2
			    'banner7'   : Banners[7]:=s2
		    	'banner8'   : Banners[8]:=s2
	    		'banner9'   : Banners[9]:=s2
    			'banner10'  : Banners[10]:=s2
	      End
	  End
	End
    fClose(config)
  End Else Writeln('Unable to open config file')
  Banners[count+1]:='Welcome to the new Scrollz Announcements for Mystic v'+PROG_VER_MAJ+'.'+PROG_VER_MIN+' '+PROG_VER_TYP
  if x>4 then writexy(x-4,y,Str2Int(colorcaps),'-=[')
  if endx<76 then writexy(endx+1,y,Str2Int(colorcaps),']=-')
End

procedure endmpl
Begin
  ch:=readkey
  //gotoxy(12,23)
  StuffKey(ch)
  //gotoxy(12,23)
  Halt
End

Begin
  if ParamCount < 1 Then
    Begin
      WriteLn('|CRError: No INI file indicated')
      SysopLog('Scrollz was not passed the INI file name')
      halt
    End
  ininame:=ParamStr(1)
  init(ininame)
  //clrscr
  fldlen:=endx-x
  if length(colortext)=1 then insert('0',colortext,1)
  if colortext[0]<>'|' then insert('|',colortext,1)
  Repeat
    if keypressed then 
    Begin
      //ch:=readkey
      //done:=true
      endmpl
    End
    repeat
      t:=Random(count+1)+1
    until t<>oldt or t<>oldt2
    if Banners[t]='' or t>count then Banner:=Banners[count+1]
    if Banners[t]<>'' then Banner:=Banners[t]
    Banner:=StripMCI(Banner)+'   '
    msglen:=Length(Banner)
    if msglen>79 then
      Begin
        delete(Banner,79,msglen-79)
      End
    z:=0
    v:=1
    Repeat
      if keypressed then
      Begin
        //ch:=readkey
        //done:=true
        endmpl
      End
      z:=0
      gotoxy(x,y)
      temp1:=Copy(Strippipe(Banner),1,v)
      temp:=PadLT(temp1,fldlen-z,' ')
      write(colortext+temp)
      z:=z+1
      v:=v+1
      gotoxy(12,23)
      delay(DelTime)
    Until v=msglen or v=fldlen
    z:=1
    Repeat
      if keypressed then
      Begin
        //ch:=readkey
        //done:=true
        endmpl
      End
      temp:=''
      gotoxy(x,y)
      if msglen<fldlen then
        temp:=PadLT(Banner,fldlen-z,' ')
      Else
      Begin
        temp:=Copy(Banner,z,fldlen)
        z:=z+1
      End
      write(temp)
      z:=z+1
      gotoxy(12,23)
      delay(DelTime)
    Until (z>fldlen-msglen)
    z:=0
    v:=2
    Repeat
      if keypressed then
      Begin
		//ch:=readkey
        //done:=true
        endmpl
      End
      gotoxy(x,y)
      temp1:=Copy(Banner,v,msglen)
      temp:=PadRt(temp1,fldlen,' ')
      write(temp)
      v:=v+1
      gotoxy(12,23)
      delay(DelTime)
    Until v=msglen+2
    if count>4 then oldt2:=oldt
    oldt:=t
  Until done
  //gotoxy(1,24)
  //StuffKey(ch)
  //StuffKey(ch)
  //writeln(ch)
  endmpl
End
