Uses CFG
Uses User

Const
  PROG_NAME = 'RCS Who''s Online'
  PROG_VER_MAJ = '0'
  PROG_VER_MIN = '5'

Type
  UserRecord = Record
    Active     :Boolean
    Name       :String[30]
    Action     :String[40]
    Location   :String[30]
    Gender     :Char
    Age        :Byte
    Baud       :String[6]
    Invisible  :Boolean
    Available  :Boolean
    InChat     :Boolean
    Room       :Byte
    Paged      :Boolean
    ServType   :Byte
    ServerSlot :Integer
    ClienSlot  :Integer
    Updated    :LongInt
    ProcessID  :LongInt
  End;

Var
  maxnodes   :Byte
  loop       :Byte
  Fptr       :File
  Listnodes  :UserRecord
  Path       :String[50]
  syslevel   :Byte=200

Function FindMaxNodes():Byte
Begin
  maxnodes := CFGTNNODES
End

Procedure Read(node:Byte):Boolean
Begin
  Read:=False
  Path:=CfgDataPath+'chat'+Int2Str(node)+'.dat'
  if fileExist(Path) then
  Begin
    fAssign(Fptr,Path,66)
    fReset(Fptr)
    If IOResult = 0 then 
    Begin
      fReadRec(Fptr,Listnodes)
      fClose(Fptr)
      if (not(Listnodes.Active) or not(Listnodes.Available) or (Listnodes.Invisible)) then
      Begin
        if Usersec<=syslevel then
          Begin
            Listnodes.Name:='|08Waiting for caller...'
            Listnodes.Action:=''
          End
      End
      Read:=True
    End
    If IOResult <> 0 then
    Begin
      Listnodes.Name:='Waiting for caller'
      Listnodes.Action:=''
      Read:=False
    End
  End
End

Procedure ListPrint
Var
  x :Byte
  y :Byte
Begin
  x:=14
  y:=8
  gotoxy(x,y)
  For loop:=1 to maxnodes do
  Begin
    If Read(loop)=True then
    Begin
      if (not(Listnodes.Active) or not(Listnodes.Available) or (Listnodes.Invisible)) then
      Begin
        if UserSec<=syslevel then
          Begin
            Listnodes.Name:='|09Waiting for caller...'
            Listnodes.Action:=''
          End
      End
    End
    If Read(loop)=False then
    Begin
      Listnodes.Name:='|08Waiting for caller...'
      Listnodes.Action:=''
    End
    write('|07|[X14'+int2str(loop)+'  |11|[X18'+Listnodes.Name+'           |[X41'+Listnodes.Action)
    if Listnodes.Invisible and Listnodes.Name<>'|08Waiting for caller...' and UserSec>=syslevel then write('  |12|[X65*Invisible*')
    //else writeln('')
    gotoxy(x,y+loop)
  End
End

Procedure Header
Begin
  gotoxy(1,1)
  writeln('|09|$D78.')
  writeln('|09                                Who is Online')
  writeln('|09|$D78.')
End

Procedure Footer
Begin
  gotoxy(1,19)
  writeln('|09|$D78-')
  writeln('|09|[X02Black Panther(RCS) Castle Rock BBS|[X56'+PROG_NAME+' v'+PROG_VER_MAJ+'.'+PROG_VER_MIN)
  writeln('|09|$D78-')
End

Begin
  getThisUser
  ClrScr
  FindMaxNodes()
  //Header
  dispfile('rcswho')
  ListPrint
  Footer
  ReadKey
End.
