{
 $Id$
}
 {*****************************************************************************
 *
 * Purpose ...............: all Basic processing and control
 *                          as well as validating .tic files
 *
 *
 *       180896 - Added procedure costs
 * vbc - 120208 - in .tic files ignore commands FDN & FULLNAME
 * vbc - 290208 - Fix for TimeDiff allow for sec, mins < 10: at end of source
 *                changed error opening to crlf at end
 * vbc - 040208 - log msgs setup for SR.Name to xticname
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}


Unit FM_basic;

   { ratjetoe van routines, wordt geoverlayed }

{$V-,X+,O+}

Interface

Uses Dos, Crt,
     Crc32, Crosslib, Compsys,
     S_String, F_File, S_Screen, M_Window, F_Fast,
     Fm_Struct, Fm_Log, Fm_Hex, Fm_Exec, Fm_Dup, Fm_List;

TYPE
  String3    = String[3];

VAR
  CO            : CompressorType;


function  flowstring (flow : flowtype; lastmonth : byte; which : byte) : string;
Function  AttribStr (Attr : msgAttribSet) : String;
Procedure MatchAKA (VAR Match : NodeType; ToNode : NodeType);
Function  NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
Procedure PopDir; { f & s }
Function  GetBbsAreaNaam(recnummer:word) : String; { f & s }
Function  TimeDiff (Up, Dn : LongInt) : String;
Function  ReleaseOK (UN : LongInt) : Boolean;
Function  UniqueName (EXT : String3) : String;
Function  ZoneString (DT : DateTime; DOW : Word) : String;
Function  FileCRC (VAR F : File) : LongInt;
Function  FileMatch (Name, Mask : String) : Boolean;
Function  LongDate : LongInt;
Function  udir (S : string) : string;
Function  MSGID (AKA : NodeType) : String;
Procedure Error (Err : Byte; S : String);
procedure GetArea (X : Word);
Procedure Strip_Buffer (VAR info:infotype);
Function  ExceptionMatch ( name:string; kind:exceptiontype; fromarea:string ) : Boolean;
Function  Lees_bericht (compare:longint; ToFileMgr: Boolean; MsgNummer: String{; Var Ms : Bericht}) : Boolean;
Function  checkepath(str:string;endslace:boolean):string;
Function  ErrStr (B : Word) : String; { f & s }
Function  DaTi (Pdate : LongInt) : String;
Function  NotAKA (N : NodeType) : Boolean;
Procedure DoBatchFile;
Procedure Update_History(currcrc:longint);
Function  UnpackTPbundle (FN : String) : Boolean;
Function  GetQuote : string;
Procedure Trim_History;
Procedure WriteToTmpFile(filename,line:string);
Function  LastDir(s:string):string;   {haalt huidige dir van s af}
{$F+} Procedure Dosshell; {$F-}
Procedure Copy_to_bad_dir_or_delete_tick ( name:String );
Function ReadTick(sr:searchrec) : Boolean;
Function checkdiskspace:boolean;
Procedure Lang_test;
Procedure WriteImportLog;
function GetInfoDate(filepath:string) : longint;
Procedure DoAnnouncement;
Procedure Test_File;
Function DetectArchive : Archivertype;


Implementation

Function DetectArchive : Archivertype;
Var Tmp : String;
Begin
  If DetectCompressor(info.filepath+info.filespec,CO) then   { Find the compressor used }
    Begin
      Tmp := CO^.WhichType;
      If Tmp = 'ARC' then detectarchive := ARC else
      If Tmp = 'PAK' then detectarchive := PAK else
      If Tmp = 'ARJ' then detectarchive := ARJ else
      If Tmp = 'DWC' then detectarchive := DWC else
      If Tmp = 'HYP' then detectarchive := HYP else
      If Tmp = 'LHA' then detectarchive := LZH else
      If Tmp = 'ZIP2' then detectarchive := ZIP else
      If Tmp = 'ZIP1' then detectarchive := ZIP else
      If Tmp = 'RAR' then detectarchive := RAR else
      If Tmp = 'SQZ' then detectarchive := SQZ else
      If Tmp = 'ZOO' then detectarchive := ZOO else
      detectarchive := All;
     End Else
      detectarchive := All;
End;


Procedure Test_File;
VAR
  CMDLINE : string;
  errorexec : word;
Begin
  CmdLine := ' '+info.filepath+info.filespec;
{  If not SETUP.Showvirus then CmdLine := CmdLine + ' > NUL'; }
  ErrorExec := 0;
  Notify(4,'(testing) ');
  ErrorExec := fmExec (setup.testfile, CmdLine, setup.swapmethode, $3200,
    false, setup.showswapping);
  If ErrorExec > 0 then
    Begin
      If ErrorExec > 255
        then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
           Begin
             notifycr (2,'');
             NotifyCr (2,'Test program reports error '+StrHex(ErrorExec,4));
             filestatus := BADCRC;
           End;
    End;
End;




Procedure DoAnnouncement;
Var
  I     : Word;
  first : boolean;
Begin
  first := true;
  If FileStatus = OK then
    Begin
      If AREA.Grp <> 0 then
        Begin
          Assign (ANF, SystemPath + 'ANNOUNCE.FM');
          {$I-} Reset (ANF); {$I+}
          If IOresult <> 0 then
            Rewrite (ANF) else Seek (ANF, FileSize(ANF));

          For i := 1 to 255 do
            Begin
              If area.msgid[i] then
                Begin

                  Reset(Mf);
                  MESSAGE.messagenr := 0;
                  While (not EOF(MF)) and (MESSAGE.messagenr <> i) do
                    Read (MF, MESSAGE);
                  If (MESSAGE.messagenr = i) and   {msg slot niet leeg}
                     (strip('B',' ',message.messagename) <> '') then
                    Begin

                      if first then
                        begin
                          Notify (4,'(announce) ');
                          first := false;
                        end;
                      FillChar (ANN, SizeOf(ANN), 0);
                      ann.Name         := INFO.FileSpec;
                      ann.Magic        := INFO.Magic;
                      ann.Replaces     := INFO.Replaces;
                      ann.area         := INFO.TAG;
                      ann.Grp          := Area.grp;
                      ann.Msg          := I;
                      ann.Desc         := INFO.Description;
                      move(info.longdesc,ann.ldesc,sizeof(ann.ldesc));
                      ann.lcount       := info.longcount;
                      ann.CRCstr       := StrHex (CurrCRC,0);
                      ann.Arrived      := 0;
                      ann.Date         := INFO.Date;
                      ann.Size         := INFO.Size;
                      ann.Origin       := INFO.Origin;
                      ann.From         := INFO.From;
                      ann.expo         := history.forwards;
                      Move (INFO.Path, ann.path, SizeOf(info.Path));
                      ann.cpath        := info.cpath;
                      Write (ANF, ANN);
                    End;
                End;
            End; {for i = .. }
          Close (ANF);
        End; { if announce }
    End; { if filestatus = ok }
End;


function GetInfoDate(filepath:string): longint;
Var Tmp : File;
Begin
  getinfodate := 0;
  Assign (TMP, FilePath + INFO.FileSpec);
  {$I-} Reset (TMP,1); {$I+}
  if IOresult = 0 then
    begin      { get the filedate }
      GetFTime (TMP, INFO.Date);
      UnpackTime (INFO.Date, DT);
      INFO.Date := GetUnixDate (DT);
      Move (DT, Today, SizeOf(DT));
      INFO.Size := FileSize (TMP);
      getinfodate := FileCRC(TMP);
    end;
End;



Procedure WriteImportLog;
Var T : text;
    tmp : string;
Begin
  assign(t,systempath+'IMPORT.XYZ');
  {$I-} reset(t); {$I+}
  If ioresult <> 0 then
    begin
      {$I-} rewrite(t); {$I+}
      if ioresult <> 0 then exit;
    end else
    begin
      {$I-} append(t); {$I+}
      if ioresult <> 0 then exit;
    end;

  tmp := '';
  tmp := 'Imported '+info.filespec+' from '+node2str(info.from)+
     ' in '+info.tag+' ('+area.directory+')';

  writeln(t,tmp);
  close(t);
End;




Procedure Lang_test;
var
  t : text;
  x, errorexec : word;
  cmdline : string;
Begin
 assign(t,'FILE_ID.DIZ');
 rewrite(t);

 if info.longcount <> 0 then
   begin
     for x := 1 to info.longcount do
       write(t,info.longdesc[x]);
   end else
   begin
     writeln(t,info.description);
   end;

  close(t);

  CmdLine := CmdLine + ' > NUL';
  ErrorExec := 0;
  Notify(4,'(checking desc) ');
  ErrorExec := fmExec (setup.testlang, '', setup.swapmethode, $3200,
    false, setup.showswapping);

  If ErrorExec > 0 then
    Begin
      If ErrorExec > 255
        then NotifyCR (2,ExecError(ErrorExec)+' ('+StrHex(ErrorExec,4)+')') else
           Begin
             notifycr (2,'');
             NotifyCr (2,'Language test program reports error '+StrHex(ErrorExec,4));
             filestatus := BADLANG;
           End;

    End;
End;




Function checkdiskspace:boolean;
var
  tel : longint;
begin
  tel := diskfree(0);
  tel := tel div 1024;
  If (tel < setup.space) and (setup.space <> 0) then
    Begin
      Writeln('Not enough disk space available! ('+int_to_str(setup.space)+' Kb required)');
      checkdiskspace := false;
    End Else checkdiskspace := true;
end;

Function ReadTick(sr:searchrec) : Boolean;
Var
  TIC        : Text;
  Tstr       : String;
  pLine      : String;
  pWord      : String[25];
  valid      : boolean;
  valcode    : integer;
  { for counting }
  i : integer;
  wrapdescbak : boolean;
  correct : boolean;
Begin
  correct := true;

  wrapdescbak := setup.wrapdesc;
  Assign (TIC, SETUP.InboundPath+SR.Name);
  xticname := SR.Name;                               { vbc 040208 - for log msgs see fm_proc }
  {$I-} Reset (TIC); {$I+}
  if IOresult = 0 then
    begin
      FillChar (Info, SizeOf(INFO), 0);
      FillChar (Info.longdesc,sizeof(info.longdesc),#0);
      INFO.Status := [];

      While not EOF(TIC) do
        begin
          ReadLn (TIC, pLine);
          if pLine <> '' then
            begin
              PWord := Upper(ExtractWords(1,1,Pline));
              If Pword = 'FILE' then
                begin
                  Info.filespec := Upper(ExtractWords(2,1,Pline));
                end else
              If Pword = 'AREADESC' then
                begin
                  Info.areadesc := extractwords(2,wordcnt(pline)-1,pline);
                end else
              If pword = 'SIZE' then {} else
              If pword = 'DATE' then {} else
{vbc120208}   If pword = 'FULLNAME' then {} else
{vbc120208}   If pword = 'FDN'  then {} else
              If Pword = 'AREA' then
                begin
                  Info.tag := first(20,upper(extractwords(2,wordcnt(pline)-1,pLine)));
                  info.tag := replace(' ','_',info.tag);
                end else
              If Pword = 'LDESC' then
                begin
                  TStr := extractwords(2,wordcnt(pline)-1,pLine)+' ';
                  tstr := strip('A',#13,Tstr);
                  tstr := strip('A',#0,Tstr);
                  if strip('A',' ',tstr) <> '' then
                    begin
                      if length(tstr) > 50 then setup.wrapdesc := true;
                      if (length(tstr) < 50) and not setup.wrapdesc then
                        begin
                          tstr := first(length(tstr)-1,tstr);
                        end;
                      For I := 1 to Length(Tstr) do
                        begin
                          If not (tstr[i] in [#0,#10]) then
                            begin
                              If (not setup.extendeddiz) or
                                (setup.extendeddiz and (tstr[i] in [#32..#127])) then
                                Begin
                                  inc(info.longcount);
                                  INFO.LongDesc[info.longcount] := Tstr[i];
                                end;
                            end;
                        end;
                    end;
                end else
              If pword = 'DESC' then
                begin
                  info.description := strip('B',' ',last(length(pline)-length(extractwords(1,1,pline)),pline));
                end else
              If Pword = 'CRC' then
                begin
                  INFO.CRCstr := extractwords(2,1,pLine);
                  While Length(INFO.CRCstr) < 8 do INFO.CRCstr := '0' + INFO.CRCstr;
                end else
              If Pos('REPL',Pword) <> 0 then
                begin
                  INFO.Replaces := upper(extractwords(2,1,pLine));
                  if info.replaces = '*.*' then
                    begin
                      notifycr(2,'Illegal wildcard use in replace verb (''*.*'')');
                       info.replaces := '';
                    end;
                end else
              If Pword = 'COST' then
                begin
                  INFO.TOTALCOST := str_to_real(extractwords(2,1,pline));
                end else
              If Pos('PATH',Pword) <> 0 then
                begin
                  if INFO.cPath < MAXPATH then
                    begin
                      pword := extractwords(2,1,pLine);
                      Inc(INFO.cPath);
                      Str2Node (pWord, INFO.Path[INFO.cPath], SETUP.Address[1], Valid);
                      pword := extractwords(3,1,pLine);
                      Val(pWord, INFO.PathUnix[INFO.cPath], ValCode);
                      If ValCode <> 0 then INFO.PathUnix[INFO.cPath] := 0;
                      pword := extractwords(4,1,pline);
                      INFO.PathStamp[INFO.cPath] := Copy(pLine, Pos(pWord, pLine), Length(pLine)-Pos(pWord, pLine)+1);
                    end;
                end else
              If Pos('SEEN',Pword) <> 0 then
                begin
                  Delete (pLine, 1, Pos(' ',pLine));
                  repeat
                    if INFO.cSeen < MAXSEENBY then
                      begin
                        Pword := extractwords(1,1,pLine);
                        Inc(INFO.cSeen);
                        if INFO.cSeen = 1
                          then Str2Node (pWord, INFO.SeenByLst[INFO.cSeen], SETUP.Address[1], Valid)
                            else Str2Node (pWord, INFO.SeenByLst[INFO.cSeen], INFO.SeenByLst[INFO.cSeen-1], Valid);
                      end else
                      begin
                        Move (INFO.SeenByLst[2], INFO.SeenByLst[1], SizeOf(NodeType)*MAXSEENBY-SizeOf(NodeType));
                        PWord := Extractwords(1,1,pLine);
                        Str2Node (pWord, INFO.SeenByLst[INFO.cSeen], INFO.SeenByLst[INFO.cSeen-1], Valid);
                      end;
                    if Pos(' ', pLine) > 0
                      then Delete (pLine, 1, Pos(' ',pLine))
                        else pLine := '';
                  until pLine = '';
               end else
             If pos('ORIG',Pword) <> 0 then
               begin
                 pword := extractwords(2,1,pLine);
                 Str2Node (pWord, INFO.Origin, SETUP.Address[1], Valid);
               end else
             If pword = 'FROM' then
               begin
                 pword := extractwords(2,1,pLine);
                 Str2Node (pWord, INFO.From, SETUP.Address[1], Valid);
               end else
             If pos('RELEAS',pword) <> 0 then
               begin
                 pword := extractwords(2,1,pLine);
                 Val(pWord, INFO.Release, ValCode);
                 if ValCode <> 0 then INFO.Release := 0;
               end else
             If pos('PW',pword) <> 0 then
               begin
                 INFO.Password := extractwords(2,1,pLine);
               end else
             If pos('LOG',pword) <> 0 then
               begin
                 info.logstring := extractwords(2,wordcnt(pline)-1,pline);
               end else
             If pword = 'MAGIC' then
               begin
                 pword := extractwords(2,1,pline);
                 info.magic := pword;
               end else
             If pword = 'AUTHOR' then
               begin
                 info.author := extractwords(2,wordcnt(pline)-1,pline);
               end else
             If pword = 'ENCRYPTED' then
               begin
                 info.encrypted := extractwords(2,2,pline);
               end else
             If pword = 'GARBLED' then
               begin
                 info.garbled := extractwords(2,2,pline);
               end else
             if pword = 'REPORT' then
               begin
                 str2node(extractwords(2,1,pline),info.report,setup.address[1],valid);
               end else
             if (pword = 'RTRCPT') or (pword = 'RECEIPTREQUEST') {fsc-0087} then
               begin
                 info.rtrcpttrue := true;
                 for i := 1 to wordcnt(pline)-1 do
                   str2node(extractwords(1+i,1,pline),info.rtrcpt[i],setup.address[1],valid);
               end else
             if pword = 'SOURCE' then
               begin
                 str2node(extractwords(2,1,pline),info.source,setup.address[1],valid);
               end else
             if pword = 'TOPO' then
               begin
                 info.topotrue := true;
                 if wordcnt(pline) > 1 then str2node(extractwords(2,1,pline),info.topo,setup.address[1],valid);
               end else
             if (pword = 'TO') or (pword = 'DESTINATION') then
               begin
                 {}
               end else
               begin
                 if pword <> 'CREATED' then
                   notifycr(2,'Unknown command '+upper(pword)+' in tic file ?!');
               end;
           end; {pline <> ''}
        end; {while not eof(tic)}
      close(tic);
      if info.longcount > 0 then strip_buffer(info);

      if info.filespec = '' then correct := false;
      if info.tag = '' then correct := false;

      if not correct then notifycr(2,'Incorrect tic file '+sr.name);

    end else
    begin
      Notifycr(2,'Error opening '+SR.Name);
      correct := false;
    end;


   if correct then
     begin
       { als description leeg is, maar longdesc niet: }
       if (info.description = '') and (info.longcount > 0) and (info.longcount < 80) then
         begin
           for i := 1 to info.longcount do
             info.description := info.longdesc[i];
         end;
       setup.wrapdesc := wrapdescbak;

       i := 1;
       while not nodeeq(info.seenbylst[i],info.from) and (i <= info.cseen) do inc(i);
       if i > info.cseen then
         begin
           notifycr(12,'');
           notifycr(2,'Sending node '+node2str(info.from)+' not in seenby line, corrected!');
           if info.cseen < maxseenby then
             begin
               inc(info.cseen);
               move(info.from,INFO.SeenByLst[INFO.cSeen],sizeof(nodetype));
             end else
             begin
               Move (INFO.SeenByLst[2], INFO.SeenByLst[1], SizeOf(NodeType)*MAXSEENBY-SizeOf(NodeType));
               move(info.from,info.seenbylst[info.cseen],sizeof(nodetype));
             end;
         end;   {  if info.from not in seenbye then add info.from to seenbye }
     end;

  readtick := correct;
End;




Procedure Copy_to_bad_dir_or_delete_tick ( name:String );
Var
  Tstr : String;
  Tmp  : Text;
Begin
  If (FileStatus <> OK) and not (local in info.status) then
    begin
      Inc (tBad);
      { move files to badfile dir }
      if (SETUP.BadFilePath <> '') then
        begin

          if not ((setup.ignunknown = 1) and (filestatus = unknown)) and
             not ((setup.ignunknown = 2) and (filestatus = unknown)) and
             not ((setup.ignbadcrc = 1) and (filestatus = baddescr)) and
             not ((setup.ignbadcrc = 2) and (filestatus = baddescr)) and
             (filestatus <> notfound) then
               begin     { move file to badfile dir}
                 if Copy_File (SETUP.InboundPath, info.filespec, INFO.FileSpec, SETUP.BadFilePath, False) then
                   begin
                     If not delete_file(setup.inboundpath+info.filespec) then
                       NotifyCr(2,'Cannot delete '+setup.inboundpath+info.filespec);
                   end;
               end;

          if ((setup.ignunknown = 2) and (filestatus = unknown)) or
             ((setup.ignbadcrc = 2) and (filestatus = baddescr)) then
            begin     { delete file }
              If not delete_file(setup.inboundpath+info.filespec) then
                NotifyCr(2,'Cannot delete '+setup.inboundpath+info.filespec) else
                  Notifycr(4,'File '+info.filespec+' deleted');
            end;


          { OK, BADCRC, BADPATH, ILLEGAL, UNKNOWN, DUPLICATE, NOTFOUND
            BADDESCR, NOACTION, NOACCESS, VIRUSFOUND, BADLANG   }

          Tstr := file_split(3,name);
          If last(1,Tstr) <> '.' then Tstr := Tstr + '.';

          Case Filestatus of
           BadCrc     : Begin
                          Tstr := Tstr + 'CRC';
                          if setup.noti_bad then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' had an incorrect crc value, moved to bad dir');
                        End;
           BadPath    : Begin
                          Tstr := Tstr + 'PTH';
                          if setup.noti_other then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+'''s path in area is incorrect, moved to bad dir');
                        End;
           Illegal    : Begin
                          Tstr := Tstr + 'ILL';
                          if setup.noti_ill then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' was sent by an illegal uplink, moved to bad dir');
                        End;
           Badlang    : Begin
                          Tstr := Tstr + 'LNG';
                          if setup.noti_lang then
                            Writetotmpfile(systempath+'fmsystmp.#$',
                              info.filespec+' contains bad language, moved to bad dir');
                        End;
           Unknown    : Begin
                          Tstr := Tstr + 'UNK';
                          if setup.noti_unk then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' was received in an unknown area ('+info.tag+'), moved to bad dir');
                        End;
           Duplicate  : Begin
                          Tstr := Tstr + 'DUP';
                          if setup.noti_other then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' is a duplicate, moved to bad dir');
                        End;
           Notfound   : Begin
                          Tstr := Tstr + 'NTF';
                          if setup.noti_other then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' was not found in inbound dir, tick file moved to bad dir');
                        End;
           BadDescr   : Tstr := Tstr + 'DES';
           NoAction   : Tstr := Tstr + 'ACT';
           NoAccess   : Tstr := Tstr + 'ACC';
           VirusFound : Begin
                          Tstr := Tstr + 'VIR';
                          if setup.noti_virus then
                            WriteToTmpFile(systempath+'fmsystmp.#$',
                              info.filespec+' contains a virus, moved to bad dir!');
                        End;
          End;

          if not ((setup.ignunknown = 1) and (filestatus = unknown)) and
             not ((setup.ignunknown = 2) and (filestatus = unknown)) and
             not ((setup.ignbadcrc = 1) and (filestatus = baddescr)) and
             not ((setup.ignbadcrc = 2) and (filestatus = baddescr)) then
            begin     { move tic file to badfile dir}
              If Copy_File (SETUP.InboundPath, Name, Tstr, SETUP.BadFilePath, False) then
                begin
                  If not Delete_File(SETUP.InboundPath+name) then
                    NotifyCr (2,'Error removing .TIC file');
                end;
            end;

          if ((setup.ignunknown = 2) and (filestatus = unknown)) or
             ((setup.ignbadcrc = 2) and (filestatus = baddescr)) then
            begin     { delete file }
              If not Delete_File(SETUP.InboundPath+name) then
                NotifyCr (2,'Error removing .TIC file');
            end;

        end;
    end else
    begin
      if not (local in info.status) then
        begin
          If not delete_file(SETUP.InboundPath+name) then
            NotifyCr (2,'Error removing processed TIC');
          If name <> info.filespec then
            If not Delete_File(setup.inboundPath+info.filespec) then
              NotifyCr (2,'Error removing processed file');
        end else
        begin
          if (filestatus = ok) and info.hatmove then
            if not delete_file(info.filepath+info.filespec) then
              notifycr(2,'Error removing processed file');
        end;
    end;
End;



{$F+} Procedure DosShell; {$F-}
Var
  Dirstr : String;
  res    : word;
Begin
  GetDir(0,Dirstr);
  Savescreen;
  Textcolor(7);
  Textbackground(0);
  Clrscr;
  cursor_on;

  res := fmExec(getenv('COMSPEC'),' ', setup.SwapMethode, $ffff, false, setup.showswapping);

  cursor_off;
  ChDir(Dirstr);
  Restorescreen;
End;





Function LastDir(s:string):string;   {haalt huidige dir van s af}
Begin
  if length(s) > 0 then
    begin
      if pos('\',s) <> 0 then
        begin
          repeat
            s := first(length(s)-1,s);
          until (last(1,s) = '\') or (length(s) = 0);
          if last(1,s) = '\' then s := udir(s);
        end;
    end;
  lastdir := s;
End;

Procedure WriteToTmpFile(filename,line:string);
Var
  T : Text;
Begin
  Assign(t,filename);
  {$I-} reset(t); {$I+}
  If ioresult <> 0 then rewrite(t);
  append(t);
  writeln(t,line);
  close(t);
End;


Procedure Trim_History;
Var
  Size, Recs, MaxS, MaxRecs, ToMuch : Longint;
  HFBak : File;
  Al    : Array[1..100] of HistoryType;
  Count : Word;
Begin
  Size := File_Size(systempath+'HISTORY.FM');
  Recs := Size div sizeof(historytype);

  MaxS    := Setup.historykb;
  MaxS    := MaxS * 1024;
  MaxRecs := MaxS div sizeof(historytype);

  If MaxRecs < Recs then
    Begin
      ToMuch := Recs - MaxRecs;

      Reset(Hf,1);
      Seek(Hf, ToMuch*Sizeof(historytype));

      Assign(HFBak,systempath+'HISTORY.BAK');
      Rewrite(HfBak,1);

      Repeat
        BlockRead(Hf,Al,Sizeof(Al),Count);
        If Count > 0 then BlockWrite(HfBak,Al,Count);
      Until Count = 0;

      Close(Hf);
      Close(HfBak);
      Erase(Hf);
      Rename(HfBak,Systempath+'HISTORY.FM');

      Reset(Hf);
      Close(Hf);
    End;
End;




Function GetQuote : string;
VAR
  Size   : LongInt;
  I      : Byte;
  Quote  : string;
  T1     : File;
  CH     : Char;
  Min    : Byte;
  Loop   : Byte;
begin
  Quote := '';

  if SETUP.QuoteFile <> '' then
    begin
      Assign (T1, SETUP.QuoteFile);
      {$I-} Reset (T1,1);
      if IOresult = 0 then
        begin

          CH := #13;
          if FileSize(T1) > 255
            then Min := 250
              else Min := FileSize(T1);

          Loop := 0;
          repeat
            Size := Random(FileSize(T1)-Min);
            Seek (T1, Size);
            Inc (Loop);
            repeat
              BlockRead(T1, CH, 1)
            until (EOF(T1)) or (CH = #13);
          until (Loop > 50) or ((CH = #13) and (FilePos(T1) < (FileSize(T1)-Min)));

          if Loop > 50 then Seek (T1, 0);
          BlockRead (T1, Quote[1], 255);
          if Quote[1] = #10 then Move (Quote[2], Quote[1], 254);
          I := 1;
          While Quote[I] <> #13 do Inc(I);
          Quote[0] := Char(I-1);
          Close (T1);
        end; {$I+}
      if ioresult <> 0 then {};
    end;

    if Quote = '' then
      begin
        case Random(9)+1 of
         1 : Quote := 'You can''t beat the feeling....';
         2 : Quote := '(c) 1991-2008 by FileMgr '+VERSION+'...';
         3 : Quote := 'FileMgr, fixes it all...';
         4 : Quote := 'Use FileMgr, the best in fileprocessing!';
         5 : Quote := 'You can''t beat the real thing...';
         6 : Quote := 'FileMgr, the ultimate fileprocessor!';
         7 : Quote := 'Another announcement, created with FileMgr!';
         8 : Quote := 'FileMgr, a revolution in fileprocessing...';
         9 : Quote := 'Another happy FileMgr tagline...';
        end; {case}
      end;

  GetQuote := Quote;
End;



Function  UnpackTPbundle (FN : String) : Boolean;
TYPE
  Buffer = Array[1..4000] of byte;

  TPhdr  = record
    Dummy   : LongInt;
    FrNode,
    ToNode  : NodeType;
    Dummy2  : Array[1..8] of byte;
  end;

VAR
  T, F : File;
  B    : ^Buffer;
  S    : LongInt;
  BS   : Word;
  CNT  : LongInt;
  HDR  : TPhdr;
  Name : Array[1..13] of Char;
  Fname: String[13];

begin
  Notify (7,'Unpacking '+FN+' (TickPack bundle)');

  Assign (F, SETUP.InboundPath + FN);
  {$I-} Reset (F, 1); {$I+}
  if IOresult = 0
  then begin
    S := FileSize(F);

    if MaxAvail <= SizeOf(B^)
    then BS := MaxAvail
    else BS := SizeOf(B^);
    GetMem (B, BS);

    BlockRead (F, HDR, SizeOf(HDR));
    NotifyCR (7,' from '+Node2Str(HDR.FrNode));

    repeat
      BlockRead (F, HDR.Dummy2, 5);
      BlockRead (F, S, SizeOf(S));
      BlockRead (F, Name, SizeOf(Name));

{     StrPeek (FName, Name, 12); }
      fname := '';
      cnt := 1;
      while name[cnt] <> #0 do
        begin
          fname := fname + name[cnt];
          inc(cnt);
        end;

      Assign (T, SETUP.Inboundpath+FName);
      Rewrite (t,1);

      CNT := S;
      repeat
        if S > BS
        then begin
          BlockRead  (F, B^, BS);
          BlockWrite (T, B^, BS);
          S := S - BS;
        end
        else begin
          BlockRead  (F, B^, S);
          BlockWrite (T, B^, S);
          S := 0;
        end
      until S=0;
      If setup.showunpack then NotifyCR(8,FName);
      Close (T);
    until EOF(F);

    Close (F);
    FreeMem (B, BS);
    UnpackTPbundle := True;
  end
  else begin
    NotifyCR (7,' Error opening bundle');
    UnpackTPbundle := False;
  end;
end;


Procedure Update_History(currcrc:longint);
var
  tmp : string;
Begin
  { update history file }
  HISTORY.Name     := INFO.FileSpec;
  HISTORY.GROUP    := area.grp;
  tmp := info.tag;
  if length(tmp) > 15 then tmp := first(15,tmp);
  HISTORY.TAG      := tmp;
  HISTORY.Size     := INFO.Size;
  HISTORY.CRC_32   := CurrCRC;
  HISTORY.DT       := LongDate;
  Add_To_History(history);
End;



Procedure DoBatchFile;
Var
  infol      : announcelinktype;
  batchtmp   : string;
  valcode    : integer;
  batchparam : string;            { batchfile parameters }
Begin
  if AREA.BatchFile <> '' then
    begin

(*
      if pos('.FTB',area.batchfile) > 0 then
        begin               { process FileMgrToBatch }
          if readnewtpl (tpl, tplsize, fexpand('.\'+area.batchfile)) then
            begin
              createmsgtxtbuffer (txtptr);
              fillchar (infol, sizeof(infol), 0);

              infol.name       := info.filespec;
              infol.replaces   := info.replaces;
              infol.area       := info.tag;
              infol.desc       := info.description;
              infol.magic      := info.magic;
              infol.crc        := valhex(info.crcstr, cnverr);
              infol.date       := info.date;
              infol.size       := info.size;
              infol.origin     := info.origin;
              infol.from       := info.from;
              infol.grp        := area.grpid;
              infol.expo       := area.exportnr;

              writetpl2 (txtptr, tpl, tplsize, infol, area.AKA, todays, '');
              batchtmp := area.batchfile;
              strrepli (batchtmp, '.FTB', '.BAT',1,1,12);

              assign (tmp, batchtmp);
              rewrite (tmp, 1);
              blockwrite (tmp, txtptr^, msgtxtindex);
              close (tmp);
            end else
            begin
              writeln ('Error reading ftb');
              batchtmp := '';
            end;
        end else *)
          batchtmp := area.batchfile;

      NotifyCR(5,'');
      batchparam := INFO.FileSpec+' '+checkepath(AREA.Directory,true)+' '+AREA.TAG;

      if batchtmp <> '' then
        begin
          ValCode := fmexec (batchtmp, batchparam, setup.swapmethode, $ffff, false, setup.showswapping);

          case ValCode of
           $00..$FF : NotifyCR (2,AREA.BatchFile+' returns errorlevel '+int_to_str(ValCode));
           else NotifyCR (2,ExecError(ValCode) + ' ('+StrHex(ValCode,4)+')');
          end;
        end;
    end;
End;


Function NotAKA (N : NodeType) : Boolean;
VAR
  I : Byte;
begin
  I := 1;
  While (I<=11) and (not NodeEQ(SETUP.Address[I], N)) do Inc(I);
  if I > 11
    then NotAKA := True else NotAKA := false;
end;


Function DaTi (Pdate : LongInt) : String;
Const
  Months : Array[1..12] of String[3] = ('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
Var
  DT : DateTime;
  date,time : string;
Begin
  UnPackTime (Pdate, DT);

  if dt.hour < 10 then time := '0'+int_to_str(dt.hour) else time := int_to_str(dt.hour);
  if dt.min < 10 then time := time + ':0'+int_to_str(dt.min) else time := time +':'+ int_to_str(dt.min);
  if dt.sec < 10 then time := time + '.0'+int_to_str(dt.sec) else time := time +':'+ int_to_str(dt.sec);

  if dt.day < 10 then date := '0'+int_to_str(dt.day) else date := int_to_str(dt.day);
  date := date + ' '+months[dt.month];
  date := date +' '+int_to_str(dt.year);

  dati := date+'  '+time;
End;


Function ErrStr (B : Word) : String;
begin
  case B of
    1 : ErrStr := 'Invalid function number';
    2 : ErrStr := 'File not found';
    3 : ErrStr := 'Path not found';
    4 : ErrStr := 'Too many open files';
    5 : ErrStr := 'File access denied';
    6 : ErrStr := 'Invalid file handle';
   12 : ErrStr := 'Invalid file access code';
   15 : ErrStr := 'Invalid drive number';
   16 : ErrStr := 'Cannot remove current directory';
   17 : ErrStr := 'Cannot rename across drives';
  100 : ErrStr := 'Disk read error';
  101 : ErrStr := 'Disk write error';
  102 : ErrStr := 'File not assigned';
  103 : ErrStr := 'File not open';
  104 : ErrStr := 'File not open for input';
  105 : ErrStr := 'File not open for output';
  106 : ErrStr := 'Invalid numeric format';
  150 : ErrStr := 'Disk is write-protected';
  151 : ErrStr := 'Bad drive request struct length';
  152 : ErrStr := 'Drive not ready';
  154 : ErrStr := 'CRC error in data';
  156 : ErrStr := 'Disk seek error';
  157 : ErrStr := 'Unknown media type';
  158 : ErrStr := 'Sector Not Found';
  159 : ErrStr := 'Printer out of paper';
  160 : ErrStr := 'Device write fault';
  161 : ErrStr := 'Device read fault';
  162 : ErrStr := 'Sharing violation (hardware failure)';
  200 : ErrStr := 'Division by zero';
  201 : ErrStr := 'Range check error';
  202 : ErrStr := 'Stack overflow error';
  203 : ErrStr := 'Heap overflow error';
  204 : ErrStr := 'Invalid pointer operation';
  205 : ErrStr := 'Floating point overflow';
  206 : ErrStr := 'Floating point underflow';
  207 : ErrStr := 'Invalid floating point operation';
  208 : ErrStr := 'Overlay manager not installed';
  209 : ErrStr := 'Overlay file read error';
  210 : ErrStr := 'Object not initialized';
  211 : ErrStr := 'Call to abstract method';
  212 : ErrStr := 'Stream registration error';
  213 : ErrStr := 'Collection index out of range';
  214 : ErrStr := 'Collection overflow error';
  else  ErrStr := 'Unknown error';
  end; {case}
end;


Function GetBbsAreaNaam(recnummer:word) : String;
Var
  Found    : Boolean;
  Tel, Max : Word;
Begin
  If Exist(systempath+'filearea.fm') then
    Begin
      Assign (bf, systempath+'filearea.fm');
      Reset (bf,1);
      Max   := (Filesize(bF) div sizeof(bbsarea)) -2;
      If Recnummer-1 <= Max then
        Begin
          Dec(Recnummer);
          Seek(bF, (Recnummer * SizeOf(Bbsarea)) + sizeof(Bbsarea) + 20);
          BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
          GetBbsAreaNaam := BbsArea.name;
        End Else
          GetBbsAreaNaam := '';
      Close(bf);
   End Else
    GetBbsAreaNaam := '';
End;


Procedure PopDir;
begin
  InOutRes := 0;
  {$I-} ChDir (DirStack); {$I+}
  if IOresult > 0 then WriteLn ('Unable to return to '+DirStack);
end;


Function AttribStr (Attr : msgAttribSet) : String;
VAR
  S : String;
begin
  S := '';
  if Privat        in Attr then S := S + 'Private ';
  if CrashMail     in Attr then S := S + 'Crash ';
  if HoldMail      in Attr then S := S + 'Hold ';
  if DirectMail    in Attr then S := S + 'Direct ';
  if FileRequest   in Attr then S := S + 'FilReq ';
  if Fattach       in Attr then S := S + 'File ';
  if FileUpdateReq in Attr then S := S + 'UpdReq ';
  AttribStr := Copy(S,1,Length(S)-1);
end;



Procedure MatchAKA (VAR Match : NodeType; ToNode : NodeType);
VAR
  I : Byte;
begin
  if Match.Zone = 0 then
    begin
      I := 0;
      repeat
        Inc(I);
      until (I>15)
      or ((SETUP.ZoneToAKA[I].Zone > 0) and
        (((SETUP.ZoneToAKA[I].Zone = ToNode.Zone) and (SETUP.ZoneToAKA[I].Net = ToNode.Net))
      or ((SETUP.ZoneToAKA[I].Zone = ToNode.Zone) and (SETUP.ZoneToAKA[I].Net = 0))));

      if I > 15 then
        begin
          I := 0;
          repeat
            Inc(I);
          until (I>15)
          or ((SETUP.Address[I].Zone > 0) and (SETUP.Address[I].Zone = ToNode.Zone));

          if I > 15
            then Match := SETUP.Address[1]
              else Match := SETUP.Address[I];
        end else
          Match := SETUP.Address[SETUP.ZoneToAKA[I].AKA];
  end;
end;


Function dayofweek (Day,Month,Year : Integer) : byte;
Var A,B       : Integer;
    Year_Corr : Real;
    julian    : longint;
Begin
  B := 0;
  If Month <= 2 Then
    Begin
      Dec (Year);
      Inc (Month,12);
    End;
  If (Year * 10000.0 + Month * 100.0 + Day >= 15821015.0) Then
    Begin
      A := Year Div 100;
      B := 2 - A + A Div 4;
    End;
  If Year > 0 Then Year_Corr := 0.0 Else Year_Corr := 0.75;

  Julian := longint(Trunc((365.25 * Year - Year_Corr)) +
                    Trunc((30.6001 * (Month+1) + Day + 1720994 + B)));
  DayOfWeek := Integer ((julian+2) Mod 7);
End;




Function NextDate (D : LongInt; IV : FrequencyType; Day : Byte) : LongInt;
CONST
  DS  = 60*60*24; { nr of sec's in day }
VAR
  DT  : DateTime;
  DOW : Word;
  New : Boolean;
begin
  FillChar (DT, Sizeof(DT), 0);

  { if today is allowed, from FMSETUP }

  if D = 0 then
    begin
      new := True;
      GetDate (DT.Year, DT.Month, DT.Day, DOW);
      D := GetUnixDate(DT) - DS;
      if DOW > 0 then Dec(DOW) else DOW := 6;
    end else
    begin
      New := False;
      getdosdate (d, dt);
      dow := dayofweek (dt.day, dt.month, dt.year);
    end;

  case IV of
  Dayly    : begin
               {Inc(d);}
               GetDate (DT.Year, DT.Month, DT.Day, DOW);
               D := GetUnixDate(DT) + DS;
             end;
  Weekly   : begin
               dec(day);
               if dow = day then inc(d,ds*7) else
                 while dow <> day do
                   begin
                     inc(d,ds);
                     if dow < 6 then inc(dow) else dow := 0;
                   end;
             end;
  Weekly2  : begin
               if not New then
                 begin
                   Inc (D, DS*8);  { next week }
                   if DOW < 6 then Inc (DOW) else DOW := 0;
                 end;
               repeat
                 Inc (D, DS);
                 if DOW < 6 then Inc (DOW) else DOW := 0;
               until DOW = Day;
             end;
  Monthly  : repeat
               Inc(D, DS);
               GetDOSdate (D, DT);
             until Day = DT.Day;
  Monthly2 : begin
               if not New then Inc (D, DS*31);  { next month }
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
  Monthly3 : begin
               if not New then Inc (D, DS*62);
               repeat
                 Inc(D, DS);
                 GetDOSdate (D, DT);
               until Day = DT.Day;
             end;
  end; {case}

  NextDate := D;
end;



function flowstring (flow : flowtype; lastmonth : byte; which : byte) : string;
var   { 0 = nodereport, 1 = areareport, 2 = fmsetup }
  dummy    : byte;
  months   : byte;
  avbytes,
  avfiles  : longint;
begin
  months  := 0;
  avbytes := 0;
  avfiles := 0;

  for dummy := 1 to 12
  do begin
    if flow[dummy].bytes >= 0
    then begin
      avbytes := avbytes + flow[dummy].bytes;
      inc (months);
    end;
    if flow[dummy].files >= 0 then avfiles := avfiles + flow[dummy].files;
  end;
  if months > 0 then
    begin
      avbytes  := round((avbytes/months)/1024);
      avfiles  := round(avfiles/months);
      case which of
       0 : begin
             if (avbytes / 1024) > 10 then
               begin
                 avbytes := round(avbytes/1024);
                 flowstring := ' '+int_to_str(avbytes) + 'Mb in ' + int_to_str(avfiles) + ' files.';
               end else
                 flowstring := ' '+int_to_str(avbytes) + 'Kb in ' + int_to_str(avfiles) + ' files.';
           end;
       1 : begin
             if (avbytes / 1024) > 10 then
               begin
                 avbytes := round(avbytes/1024);
                 flowstring := ' (' + int_to_str(avbytes) + 'Mb in ' + int_to_str(avfiles) + ' files)';
               end else
                 flowstring := ' (' + int_to_str(avbytes) + 'Kb in ' + int_to_str(avfiles) + ' files)';
           end;
       2 : begin
             flowstring := int_to_str(avbytes)+' '+int_to_str(avfiles)+' '+int_to_str(months);
           end;
      end;
    end else
    begin
      case which of
       0 : flowstring := ' nothing';
       1 : flowstring := ' (no flow)';
       2 : flowstring := '';
      end;
    end;
end;



function checkepath(str:string;endslace:boolean):string;
var
  tmp,g,s1,s2 : string;
begin
  if pos('%',str) > 0 then
    begin
      tmp := last(length(str)-pos('%',str),str);
      if pos('%',str) > 1 then s1 := first(pos('%',str)-1,str) else s1 := '';
      if pos('%',tmp) > 0 then
        begin
          s2 := last(length(tmp)-pos('%',tmp),tmp);
          tmp := first(pos('%',tmp)-1,tmp);
          if length(tmp) > 0 then
            begin
              g := getenv(tmp);
              if g = '' then
                begin
                  notifycr(2,'Environment variable '+tmp+' (%'+tmp+'%) not found!');
                  halt;
                end else
                begin
                  str := s1 + g + s2;
                  if endslace then
                    begin
                      if (last(1,str) <> '\') and (length(str) > 2) then str := str + '\';
                    end;
                end;
            end;
        end;
    end;
  checkepath := str;
end;



Function Lees_bericht (compare:longint; ToFileMgr: Boolean; MsgNummer: String{; Var Ms : Bericht}) : Boolean;
type
  Bericht = record   { netmail msg, om snel uit te kunnen lezen }
    _From,
    _To          : Array[1..36] of Char;
    _Subj        : Array[1..72] of char;
    _Date        : Array[1..20] of char;
    TimesRead,           { Number of time msg has been read       }
    DestNode,            { Destination node of message            }
    OrigNode,            { Origin node of message                 }
    Cost,                { In lowest unit of originator's currency}
    OrigNet,             { Origin net of message                  }
    DestNet      : Word; { Destination node of message            }
    SentTime,
    RcvdTime     : LongInt;
    ReplyTo      : word; { Message number to which this replies   }
    Attribs      : msgAttribSet; { See below                      }
    unreply      : integer;
  End;
var
  ms : bericht;
  i         : word;
  F1        : File;
  Buffer    : Array [0..250] of char;
  Ciclo     : Byte;
  Dt        : datetime;
  FileDate  : longint;
  X, Count  : Word;
  Tmp, Tmp1 : String;
  Bol       : Boolean;
  Filebak   : Byte;
  bakpoint : word;
begin
  filebak := filemode;
  filemode := 64;
  Assign (f1,MsgNummer);
  {$I-} reset(f1,1); {$I+}
  If ioresult <> 0 then
    Begin
      Writeln('Cannot open '+msgnummer);
      Lees_Bericht := false;
      filemode := filebak;
      Exit;
    End;
  filemode := filebak;

  GetfTime (f1, FileDate);
  UnpackTime (FileDate, DT);
  FileDate := GetUnixDate(DT);

  FillChar (ms,SizeOf(ms),chr(0));
  {$I-} BlockRead (f1,ms,sizeof(ms)); {$I+}
  If IoResult <> 0 Then
    Begin
      Writeln('Cannot read '+msgnummer);
      Lees_Bericht := false;
      Exit;
    End;

  if pos(#0,ms._from) <> 0 then fromname := first(36,first(pos(#0,ms._from)-1,ms._from)) else fromname := first(36,ms._from);
{  StrAsc (Fromname, ms._from, 36); }
  if pos(#0,ms._to) <> 0 then toname := first(36,first(pos(#0,ms._to)-1,ms._to)) else toname := first(36,ms._to);
{  StrAsc (Toname, ms._To, 36);}
  if pos(#0,ms._subj) <> 0 then subject := first(72,first(pos(#0,ms._subj)-1,ms._subj)) else subject := first(72,ms._subj);
{  StrAsc (Subject, ms._Subj, 72); }

  If toFilemgr then
    Begin
      I := 1;
      While (I <= 15) and
            ((setup.Alias[I,Length(setup.Alias[I])] <> '*') and
            (upper(toname) <> upper(setup.Alias[I]))) or
            ((setup.Alias[I,Length(setup.Alias[I])] = '*') and
            (Pos(Copy(upper(setup.Alias[I]),1,Length(setup.Alias[I])-1), upper(toname)) <> 1))
         do Inc(I);
      If (I > 15) and (upper(toname) <> 'FILEMGR') then
        Begin
          toname := '';
          fromname := '';
          lees_bericht := true;
          Close(f1);
          exit;
        End;
    End;

  If (Rcvd in ms.Attribs) then               { save time }
    Begin
      toname := '';
      fromname := '';
      lees_bericht := true;
      Close(f1);
      exit;
    End;

  With FromNode do
    begin
      Zone  := 0;
      Net   := ms.OrigNet;
      Node  := ms.OrigNode;
      Point := 0;
    end;
  With ToNode do
    begin
      Zone  := 0;
      Net   := ms.DestNet;
      Node  := ms.DestNode;
      Point := 0;
    end;

  Fillchar(buffer,sizeof(buffer),0);
  Blockread(f1,buffer,sizeof(buffer),count);
  Close(f1);

  If count > 0 then
    begin

      tmp := ''; {zoeken naar kludges}
      x := 0;
      repeat
        inc(x);
        if length(tmp) > 49 then
          begin
            tmp := last(49,tmp);
            tmp := tmp + buffer[x];
          end else
            tmp := tmp + buffer[x];

        tmp := replace(#13,' ',tmp);

        If (pos('MSGID:',tmp) = 1) and (wordcnt(tmp) > 2) then
          begin
            Tmp1 := extractwords(2,1,tmp);
            tmp1 := replace(':',' ',tmp1);
            tmp1 := extractwords(1,1,tmp1);
            fromnode.zone := str_to_int(tmp1);
          end;
        If (pos('INTL ',tmp) = 1) and (wordcnt(tmp) > 3) then
          begin
            bakpoint := fromnode.point;
            Tmp1 := extractwords(2,1,tmp);
            Str2node(tmp1,tonode,setup.address[1],bol);
            Tmp1 := extractwords(3,1,tmp);
            Str2node(tmp1,fromnode,setup.address[1],bol);
            fromnode.point := bakpoint;
          end;
        If (pos('FMPT ',tmp) = 1) and (wordcnt(tmp) > 2) then
          begin
            Tmp1 := extractwords(2,1,tmp);
            Fromnode.point := str_to_int(tmp1);
          end;
        If (pos('TOPT ',tmp) = 1) and (wordcnt(tmp) > 2) then
          begin
            Tmp1 := extractwords(2,1,tmp);
            Tonode.point := str_to_int(tmp1);
          end;

      until x = count;
    end;

  if ToNode.Zone = 0 then
    begin { is there any zone information present? }
      if FromNode.Zone = 0 then
        begin
          x := 0;
          repeat
            Inc (x);
          until (x > 21) or (SETUP.Address[x].Net = FromNode.Net);
          if x > 11 then FromNode.Zone := SETUP.Address[1].Zone
            else FromNode.Zone := SETUP.Address[x].Zone;
        end;
      ToNode.Zone := FromNode.Zone;
    end;

  { if from FileMgr AND too old, then dispose }
  if compare <> 0 then
    begin
      if (SETUP.Days2Keep > 0) and (pos('FILEMGR',upper(fromname)) <> 0) and (FileDate < Compare) then
        Begin
          {$I-} Erase (f1); {$I+}
          writelogcr(2,msgnummer+' to '+node2str(tonode)+' is too old, deleted!');
          toname := '';
          fromname := '';
          Lees_Bericht := False;
        End;
    end;

  If tofilemgr then
    begin
      I := 1;
      While (i <= 21) and (not NodeEQ(SETUP.Address[I], toNode)) do Inc(I);
      If i > 21 then
        Begin
          toname := '';
          fromname := '';
          lees_bericht := true;
          exit;
        End;
    End;
  Lees_bericht := true;
End;


Function ExceptionMatch ( name:string; kind:exceptiontype; fromarea:string ) : Boolean;
var match : boolean;
Begin
  Assign(exfile,systempath+'filemask.fm');
  {$I-} reset(exfile); {$I+}
  if ioresult <> 0 then
    begin
      exceptionmatch := false;
      exit;
    end;
  match := false;
  while not match and not eof(exfile) do
    begin
      read(exfile,ex);
      if (ex.kind = kind) and filematch(name,ex.mask) then
        begin
          if (fromarea = '') or (ex.fromarea = '') then match := true else
              match := upper(ex.fromarea) = upper(fromarea);
        end;

      if match then
        begin
          if (kind = ex_nodepath) and not nodeeq(ex.fromnode,node.address) then
            match := false;
        end;

    end;
  close(exfile);
  exceptionmatch := match;
End;


Procedure Strip_Buffer (VAR info:infotype);
Var
  k    : array[0..2048] of char;
  p    : array[1..2048] of char;
  x, y : integer;
Begin
  if not setup.wrapdesc then exit;

  for x := 1 to 2048 do p[x] := info.longdesc[x];
  fillchar(k,sizeof(k),#0);
  x := 1; y := 1;                            {verwijderen van meerdere spaties}
  k[0] := ' ';
  repeat
    while ((p[x] = ' ') and (k[y-1] = ' ')) and (x < 2048) do inc(x);
    k[y] := p[x];
    inc(x);
    inc(y);
  until x > 2048;
  for x := 1 to 2048 do info.longdesc[x] := k[x];

  x := 1;
  while (info.longdesc[x] <> #0) and (x <= 2048) do inc(x);

  while (info.longdesc[x-1] = ' ') or (info.longdesc[x-1] = #13) do
    begin
      info.longdesc[x-1] := #0;
      dec(x);
    end;

  info.longcount := x;
End;

procedure GetArea (X : Word);
begin
  Seek (AF, AFXt^[X].AreaRec);
  BlockRead (AF, AREA, SizeOf(AREA));
  Fillchar(sfxt^,sizeof(sfxt^),0);
  BlockRead (AF, sfxt^, (AREA.ExportNr*SizeOf(ExportType)));
end;



Procedure Error (Err : Byte; S : String);
begin
  NotifyCR (1,S);
  Halt(Ord(ERR)+1);
end;


Function MSGID (AKA : NodeType) : String;
VAR
  S     : String[8];
  Dummy : Word;
  T       : DateTime;
begin
  if setup.namecount = 0
  then With T do begin
    GetTime (Hour, Min, Sec, Dummy);
    GetDate (Year, Month, Day, Dummy);
    setup.namecount := GetUnixDate(T);
  end
  else Inc (setup.namecount);

  S     := lower(StrHex(setup.namecount,8));
  MSGID := #1+'MSGID: '+Node2Str(AKA)+' '+S;
end;


Function udir (S : string) : string;
Begin
  if length(S) > 0 then
    begin
      if last(1,s) = '\'
        then uDir := first(length(s)-1,s)
          else uDir := S;
    end else
      uDir := '';
End;


Function FileMatch (Name, Mask : String) : Boolean;
TYPE
  WildCard = (NONE, ALL, ONE, ALP, NUM);
CONST
  WildChar = '*?@#';
VAR
  Matches : Boolean;
  MName,
  FName   : String[8];
  MExt,
  FExt    : String[3];
  CF      : WildCard;
  WF      : Boolean;
  FI, MI  : Byte;
begin
  Matches := True;

  { split mask/filename into name/ext parts }

  Name := upper(name);
  Name := Replace('.',' ',name);
  fname := extractwords(1,1,name);
  fext := extractwords(2,1,name);

  mask := upper(mask);
  mask := replace('.',' ',mask);
  mname := extractwords(1,1,mask);
  mext := extractwords(2,1,mask);

  { check ext first }

  if (Mext <> '*') and (Mext <> Fext) then
    begin
      CF := NONE;
      WF := False;
      FI := 0; MI := 0;

      While (Matches or WF) and (FI < Length(Fext)) do
        begin
          Inc (FI);
          Inc (MI);

          CF := WildCard(Pos(Mext[MI], WildChar));
          if CF = ALL then
            begin
              if MI = Length(Mext)            { if '*' is last part of mask }
                then FI := Length(Fext) else  { > then force exit, all OK   }
                  begin                       { > if there's more to match  }
                    FI      := Length(Fext) - (Length(Mext) - MI);
                    Matches := False;
                    WF      := True;                    { no immediate exit }
                  end;
            end else
            begin                                  { match single character }
              case CF of
                ONE  : Matches := True;
                NUM  : Matches := fext[fi] in ['0'..'9'] {IsDigit(Fext[FI])};
                ALP  : Matches := fext[fi] in ['a'..'z','A'..'Z']   { IsAlpha(Fext[FI])};
                NONE : Matches := (Mext[MI] = Fext[FI]);
              end; {case}
            end;
        end;
      if (MI < Length(Mext)) then Matches := False;
    end;

  { now check name }

  if length(mname) > length(fname) then
    begin
      wf := true;
      repeat
        if last(1,mname) = '?' then
          mname := first(length(mname)-1,mname) else
            wf := false;
      until (length(mname) = length(fname)) or not wf;
    end;

  if Matches then
    begin
      if (Mname <> '*') and (Mname <> Fname) then
        begin
          CF := NONE;
          WF := False;
          FI := 0; MI := 0;

          While (Matches or WF) and (FI < Length(Fname)) do
            begin
              Inc (FI);
              Inc (MI);

              CF := WildCard(Pos(Mname[MI], WildChar));
              if CF = ALL then
                begin
                  if MI = Length(Mname)            { if '*' is last part of mask }
                    then FI := Length(Fname) else  { > then force exit, all OK   }
                      begin                       { > if there's more to match  }
                        FI      := Length(Fname) - (Length(Mname) - MI);
                        Matches := False;
                        WF      := True;              { no immediate exit }
                      end;
                end else
                begin                        { match single character }
                  case CF of
                    ONE  : Matches := True;
                    NUM  : Matches := fname[fi] in ['0'..'9'] {IsDigit(Fname[FI])};
                    ALP  : Matches := fname[fi] in ['a'..'z','A'..'Z'] {IsAlpha(Fname[FI])};
                    NONE : Matches := (Mname[MI] = Fname[FI]);
                  end; {case}
                end;
            end;
          if (MI < Length(Mname)) then
            begin
              Matches := False;
            end;
        end;
    end;

  FileMatch := Matches;
End;


Function LongDate : LongInt;
Var HS,DOW : Word;
    DT     : DateTime;
    Tmp    : LongInt;
Begin
  With DT do
    begin
      GetDate (Year,Month,Day,DOW);
      GetTime (Hour,Min,Sec,HS);
    end;
  PackTime (DT, Tmp);
  LongDate := Tmp;
End;


Function FileCRC (VAR F : File) : LongInt;
Type
  Buffer   = Array[1..4000] of Byte;
Var
  L, C     : LongInt;
  RAM,
  RD       : Word;
  B        : ^Buffer;
  Tel      : Word;
Begin
  if SizeOf(B^) <= MaxAvail
    then RAM := SizeOf(B^)
      else RAM := MaxAvail;
  if RAM = 0 then
    begin
      WriteLn ('not enough memory for CRC check !');
      Halt(1);
    end else
    begin
      Reset (F,1);
      GetMem (B, RAM);
      C := $FFFFFFFF;
      Repeat
        BlockRead (F, B^[1], RAM, RD);
        For Tel := 1 to Rd do
          C := UpdateCRC32(B^[0+Tel],c);
      until EOF(F) or (RD < RAM);
      FreeMem (B, RAM);
      Close (F);
      FileCRC := NOT(C);
    end;
End;


Function UniqueName (EXT : String3) : String;
var
  T : DateTime;
  Dummy : Word;
  S     : String[10];
Begin
  if setup.namecount = 0
  then With T do begin
    GetTime (Hour, Min, Sec, Dummy);
    GetDate (Year, Month, Day, Dummy);
    setup.namecount := GetUnixDate(T);
  end
  else Inc(setup.namecount);
  S := StrHex(setup.namecount, 8);
  Delete (S,1,2);
  UniqueName := S+'.'+EXT;
End;


Function ZoneString (DT : DateTime; DOW : Word) : String;
VAR
  S : String;
  L : LongInt;
begin
{  With DT
  do begin }
    L := GetUnixDate(DT);
    L := L + Integer(SETUP.TimeZone*60*60);      { add nr of seconds }
    GetDOSdate(L, DT);

    S := Days[DOW] + '&' + Months[dt.Month] + '&'
         +expand(int_to_str(dt.Day),2)+'&'
         +expand(int_to_str(dt.Hour),2)+':'
         +expand(int_to_str(dt.Min),2)+':'
         +expand(int_to_str(dt.Sec),2)+'&'
         +int_to_str(dt.Year)+'&UTC';

    s := replace(' ','0',s); {ChrRepl(S,' ','0',1,255);} { Replace all spaces with zero's }
    s := replace('&',' ',s); {ChrRepl(S,'&',' ',1,255);} { Replace all &'s with spaces }
    ZoneString := S;
{  end; }
End;


Function ReleaseOK (UN : LongInt) : Boolean;
var
  DT : DateTime;
  DD : Word;
begin
  ReleaseOK := True;
  if UN = 0
  then begin
    FillChar (DT, SizeOf(DT), 0);
    With DT do GetDate (Year, Hour, Min, DD);
    if (GetUnixDate(DT) MOD 3600) < (UN MOD 3600)
    then ReleaseOK := False;
  end;
end;


Function TimeDiff (Up, Dn : LongInt) : String;
VAR
  DIF : DateTime;
  S   : String[8];     { vbc 2902008 }
begin
  GetDOSdate (Dn, DIF);
  GetDOSdate (Up, DIF);
  GetDOSdate (662688000+(Dn-Up), DIF);

  if (DIF.Hour > 0) and (DIF.Hour < 10) then
    S := '0'+ int_to_str(DIF.Hour) + ':' else
  if DIF.Hour > 0 then
    s := int_to_str(DIF.Hour) + ':' else
    S := '';
  if DIF.Min < 10 then
     S := S + '0'+int_to_str(DIF.Min) + ':' else
     S := S + int_to_str(DIF.Min) + ':';
   if DIF.Sec < 10 then
     S := S + '0'+int_to_str(DIF.Sec) else
     S := S +int_to_str(DIF.Sec);

{vbc 290208 - rem'd 2 fix fault for Active Log Line
    + expand(int_to_str(DIF.Sec),2);

  if S[1] = ' ' then delete (S,1,1);
  s:= replace(' ','0',s); {ChrRepl (S, ' ', '0', 1, 255);
}
  TimeDiff := S;
end;




end.

