{
 $Id$
}
{*****************************************************************************
 *
 * Process :  File Hatching
 *
 * vbc - 150208 - editdate changed from 1900 to 2000 y2k
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes / Others        FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Unit Fm_Hatch;

{$O+}

Interface

Uses
  Crt, Dos,
  F_Fast, S_Screen, M_Window, S_String, F_File, Crosslib, Fil_Spec,
  Fm_Struct, Fm_Basic, Fm_Init, Fm_Proc, Fm_Log, Fm_List, Fm_Exec, Nw_Msg;

{--------------------------------------------------------------------------}

Procedure Hatch;

{--------------------------------------------------------------------------}

Implementation

{$F+} procedure dummy; {$F-}
begin
end;

Procedure browsetag (window:byte; var afxinx : word);
var
  x   : word;
  tmp : string;
begin
  if (afxinx > areaidx) or (afxinx = 0) then afxinx := 1;

  create_list;
  for x := 1 to areaidx do
    add_to_list(expand(int_to_str(x),4)+expand(afxt^[x].tag,25)+' '+int_to_str(afxt^[x].grp));

  with mwin[window] do
   begin
     x1 := 28;
     x2 := 3;
     y1 := 64;
     y2 := 21;
     st := ' Select Area ';
   end;

  Writeat(1,16,1,0, #195 + Replicate(78,#196) + #180);
  Writeat(1,22,1,0, #195 + Replicate(78,#196) + #180);

  create_window(window);

  tmp := Show_List (Window,true,true,2,afxinx);

  if tmp <> '' then
    begin
      tmp := extractwords(2,1,tmp);
      x := 1;
      while (afxt^[x].tag <> tmp) and (x <= areaidx) do inc(x);
      if x > areaidx then x := 0;
    end else x := 0;

  afxinx := x;
  remove_list;
  remove_window(window);

  Writeat(1,16,11,0, #195 + Replicate(78,#196) + #180);
  Writeat(1,22,11,0, #195 + Replicate(78,#196) + #180);
end;



Procedure Browse_Aka (window:byte; VAR AKA : Byte);
Var
  x   : byte;
  tmp : string;
Begin
  create_list;
  for x := 1 to 21 do
    begin
      if setup.address[x].zone <> 0 then
        add_to_list(node2str(setup.address[x]));
    end;

  if list_amount > 1 then
    begin
      with mwin[window] do
       begin
         x1 := 30;
         x2 := 12-(list_amount div 2);
         y1 := 50;
         y2 := 12+(list_amount div 2);
         st := ' Select Aka ';
       end;

      Writeat(1,16,1,0, #195 + Replicate(78,#196) + #180);
      Writeat(1,22,1,0, #195 + Replicate(78,#196) + #180);
      create_window(window);

      tmp := Show_List (Window,false,false,0,aka);

      if tmp <> '' then
        begin
          x := 1;
          while (node2str(setup.address[x]) <> tmp) and (x <= 21) do inc(x);
          if x > 21 then aka := 0 else aka := x;
        end;

      remove_window(window);
      Writeat(1,16,11,0, #195 + Replicate(78,#196) + #180);
      Writeat(1,22,11,0, #195 + Replicate(78,#196) + #180);
    end else
    begin
      Askwindow('Currently there are no aka''s',
                'defined. Use the ''Addresses'' option',
                'to define your address',[#13,#27,#32]);
    end;
  remove_list;
End;


Function Browse_File (window:byte; f,p : string) : string;
Var
  Sr  : searchrec;
  Tmp : string;
  bak : string;
Begin
  bak := p+f;

  If file_split(1,f) = '' then
    Begin
      If last(1,p) <> '\' then p := p + '\';
      F := p + f;
    End Else
    Begin
      p := file_split(1,f);
      if last(1,p) <> '\' then p := p + '\';
    End;

  Create_list;

  Findfirst (f, $0, sr);
  While (doserror = 0) do
    Begin
      Add_to_list(expand(sr.name,12)+' '+allign(int_to_str(sr.size),7));
      Findnext(sr);
    End;

  If list_amount > 0 then
    Begin
      With mwin[window] do
        Begin
          x1 := 57;
          x2 := 1;
          y1 := 80;
          y2 := 24;
          st := ' Select file ';
        End;
      Writeat(1,16,1,0, #195 + Replicate(78,#196) + #180);
      Writeat(1,22,1,0, #195 + Replicate(78,#196) + #180);
      Create_window(window);
      Tmp := Show_List (Window,true,true,1,1);
      Browse_file := p+extractwords(1,1,tmp);
      Remove_window(window);
      Writeat(1,16,11,0, #195 + Replicate(78,#196) + #180);
      Writeat(1,22,11,0, #195 + Replicate(78,#196) + #180);
    End else
    Begin
      Askwindow ('No matching files', 'found.', 'Press [Enter] to continue', [#13,#32,#27]);
      Browse_file := bak;
    End;
  Remove_list;
End;


Procedure EditDate (X,Y,A : Byte; VAR D : LongInt);
VAR
  DT        : DateTime;
  S         : String;
  Day,
  Month,
  Year      : String[2];
  ValidDate : Boolean;
Begin
  FillChar (DT, SizeOf(DT), 0);
  S         := DateString(D);
  ValidDate := True;
  Repeat
    Read_String(x,y,8,8,s,c_date);

    s := replace('/','-',s);
    s := replace('.','-',s);

    day := first(pos('-',s)-1,s);
    s := last(length(s)-pos('-',s), s);

    month := first(pos('-',s)-1,s);
    s := last(length(s)-pos('-',s), s);

    year := s;

    if (length(day) > 0) and (length(month) > 0) and (length(year) > 0) then
      begin
        dt.day := str_to_int(day);
        dt.month := str_to_int(month);
        dt.year := str_to_int(year);
        if dt.day < 10 then
          s := '0'+int_to_Str(dt.day) else
            s := int_to_str(dt.day);
        if dt.month < 10 then
          s := s + '-0'+int_to_Str(dt.month) else
            s := s + '-'+ int_to_str(dt.month);
        s := s + '-'+ int_to_str(dt.year);
        ValidDate := True;
      end else validdate := false;
  until ValidDate;
  Writeat(X,Y,A,0,S);
  DT.Year := DT.Year + 2000;      { chg for y2k as its 2008 not 1900 }
  D := GetUnixDate(DT);
end;


Procedure WriteColor(line,normal,highc,backc:byte;str:string);
Var
  X,Y : integer;
  bol : boolean;
Begin
  writeat(1,line,7,0,replicate(80,' '));
  Y := 1; X := 0; bol := false;
  While y <= length(str) do
    Begin
      if str[y] <> '^' then
        begin
          inc(x);
          if bol then writeat(x,line,highc,backc,str[y]) else
            writeat(x,line,normal,backc,str[y]);
        end else bol := not bol;
      inc(y);
    End;
End;



Procedure Hatch;

  Procedure HatchError (S : String);
  Begin
    NotifyCR (2,S);
    WriteLn;
    ParameterHelp;
  End;

Var
  I, Index   : Byte;            { INX to determine editfield                }
  HatchAKA   : Byte;            { TMP byte to hold active hatch address     }
  HatchFile  : PathStr;         { TMP string to hold the complete filespec  }
  HatchTMP   : PathStr;         { TMP string to hold old contents           }
  TagTMP     : String[15];      { TMP string to hold old contents of TAG    }
  X,Y        : Byte;            { TMP to hold screen attributes and cursor  }
  SR         : SearchRec;       { SearchRec, to find the file to hatch      }
  DT         : DateTime;        { TMP to calc unixdate                      }
  Hatches    : Boolean;
  TmpStr     : String;
  TmpEdit    : String;
  Ch         : char;
  Stop       : boolean;

  TotFiles   : Word;
  TotKb      : LongInt;
  TotAll     : LongInt;
  TotQue     : Byte;


  Procedure RemoveWin;
  Begin
    Remove_Window(1);
    Restorescreen;
    GotoXy(x,y);
    Cursor_On;
  End;

  Function NodesAll : Longint;
  Var Tmp : LongInt;
      x : integer;
  Begin
    Tmp := 0;
    I := 0;
    While I < area.exportnr do {harddiskruimte uitrekenen}
      Begin
        inc(i);
        X := 1;
        While (x <= Nodeidx) and
          (NOT NodeEQ(sfxt^[i].a, NFXt^[X].Address)) do Inc(X);
        If x <= Nodeidx then
          Begin {ok, node gevonden}
            seek (nf, nfxt^[x].noderec);
            blockread (nf, node,sizeof(node));
            {if packfile then bij total optellen}
            if packfile in node.defstatus then
              inc(tmp, file_size(hatchfile) div 1024 );
          End;
      End;
    inc(tmp, file_size(hatchfile) div 1024 );
    nodesall := tmp;
  End;

  Procedure WriteInQue(Str:String);
  Var HStr : String[80];
      X,Y  : Byte;
  Begin
    Inc(TotQue);
    If TotQue = 6 then
      Begin
        For Y := 17 to 20 do  {opschuiven}
          Begin
            Hstr := '';
            For X := 3 to 79 do
              Hstr := Hstr + getscreenchar(x,y+1);
            Writeat(3,y,3,0,Hstr);
          End;
        TotQue := 5;
      End;
    Writeat(3,16+Totque,3,0,str);
  End;

  Procedure ShowInQueue( FileNr : Word; Kb : Longint );
  Begin
    Writeat(3,23,3,0,Expand('In Queue: '+int_to_str(TotFiles+FileNr)
      +' files, '+int_to_str(TotKb+Kb)+' Kb. (Totally all nodes: '
      +int_to_str(TotAll+Nodesall)+' Kb)',77));
  End;

  Procedure Write_Selection(sel:byte);
  Begin
    Writeat(3,3 ,7,0, ' Area (TAG)  ');
    Writeat(3,4 ,7,0, ' Filename    ');
    Writeat(3,5 ,7,0, ' Replaces    ');
    Writeat(3,6 ,7,0, ' Magic name  ');
    Writeat(3,7 ,7,0, ' Hatch date  ');
    Writeat(3,8 ,7,0, ' Release     ');
    Writeat(3,9 ,7,0, ' Active AKA  ');
    Writeat(3,10,7,0, ' Description ');

    Writeat(62,3,7,0,' Ignore dups ');
    Writeat(62,4,7,0,' Move file   ');
    Writeat(62,5,7,0,' Virus Scan  ');
    Writeat(62,6,7,0,' Import diz  ');
    Writeat(62,7,7,0,' Re-archive  ');

    Case sel of
      1 : Writeat(3,3 ,1,7, ' Area (TAG)  ');
      2 : Writeat(3,4 ,1,7, ' Filename    ');
      3 : Writeat(3,5 ,1,7, ' Replaces    ');
      4 : Writeat(3,6 ,1,7, ' Magic name  ');
      5 : Writeat(3,7 ,1,7, ' Hatch date  ');
      6 : Writeat(3,8 ,1,7, ' Release     ');
      7 : Writeat(3,9 ,1,7, ' Active AKA  ');
      8 : Writeat(3,10,1,7, ' Description ');

      9 : Writeat(62,3,1,7,' Ignore dups ');
     10 : Writeat(62,4,1,7,' Move file   ');
     11 : Writeat(62,5,1,7,' Virus Scan  ');
     12 : Writeat(62,6,1,7,' Import diz  ');
     13 : Writeat(62,7,1,7,' Re-archive  ');
    End;
  End;

  Procedure Write_Settings;
  Begin
    Writeat(17,3,3,0,expand(info.tag,15));
    Writeat(17,4,3,0,expand(hatchfile,42));
    Writeat(17,5,3,0,expand(info.replaces,12));
    Writeat(17,6,3,0,expand(info.magic,12));
    Writeat(17,7,3,0,DateString(info.Forwar));
    Writeat(17,8,3,0,DateString(info.release));
    if hatchaka <> 0 then
      Writeat(17,9,3,0,expand(Node2Str(SETUP.Address[hatchAKA]),23)) else
        Writeat(17,9,3,0,expand('Aka matching',23));
    writeat(17,10,3,0,expand(first(62,info.description),62));

    if info.hatdups then writeat(76,3,3,0,'Y') else writeat(76,3,3,0,'N');
    if info.hatmove then writeat(76,4,3,0,'Y') else writeat(76,4,3,0,'N');
    if info.hatviru then writeat(76,5,3,0,'Y') else writeat(76,5,3,0,'N');
    if info.hatimpo then writeat(76,6,3,0,'Y') else writeat(76,6,3,0,'N');
    if info.hatrear then writeat(76,7,3,0,'Y') else writeat(76,7,3,0,'N');
  End;

  Procedure Function_F1;
  Var
    dummy : word;
  Begin
    If (HatchFile <> '') and (info.description <> '') and (info.tag <> '') then
      Begin
        { fill INFO fields correctly }
        info.Status      := [Local];
        info.FilePath    := file_Split(1,hatchfile);
        info.FileSpec    := file_split(2,hatchfile);
        info.Size        := 0;
        info.CRCstr      := '';
        if HatchAKA > 0 then info.Origin := SETUP.Address[HatchAKA];
        info.From        := info.Origin;
        info.cSeen       := 1;
        info.SeenbyLst[1]:= info.Origin;

        { create hatch entry }
        Assign (PF, SystemPath + 'PROCESS.FM');
        {$I-} Reset (PF); {$I+}
        if IOresult <> 0 then Rewrite (PF);
        Seek (PF, FileSize(PF));
        Write (PF, INFO);
        Close (PF);

        Hatches := True;

        { total gegevens voor in queue }
        inc(totfiles);
        inc(totkb, (file_size(hatchfile) div 1024) );
        ShowInQueue(0,0);
        inc(totall,nodesall);

        writeinque(expand(info.filespec,12)+'  '+expand(info.tag,20)+' '+expand(info.description,42));

        FillChar (INFO, SizeOf(INFO), 0); {alles weer leeg voor een evt volgende file}
        FillChar (HatchFile, SizeOf(HatchFile), 0);
        FillChar (HatchTMP, SizeOf(HatchTMP), 0);
        FillChar (TagTMP, SizeOf(TagTMP), 0);

        FillChar (DT, SizeOf(DT), 0); {datum en release weer vullen}
        With DT do GetDate(Year, Month, Day, Dummy);
        INFO.Release := GetUnixDate(DT);
        INFO.Forwar := INFO.Release;

        writeat(17,10,3,0,replicate(62,' '));
        writeat(4,11,3,0,replicate(75,' '));
        writeat(4,12,3,0,replicate(75,' '));
        writeat(4,13,3,0,replicate(75,' '));
        writeat(4,14,3,0,replicate(75,' '));
        writeat(4,15,3,0,replicate(75,' '));

        Writeat(33,3,3,0,expand(' ',27));

        HatchAKA  := 1;
        Index     := 1;
        pardesc := '';

      End else
      Begin
        If (hatchfile <> '') and (info.description = '') then
          Begin
            askwindow ('You must specify a','description for this file.','Press [Enter] to continue',[#13]);
            index   := 7;
            stop := false;
          End Else
        If hatchfile = '' then
          Begin
            askwindow('You must specify','a filename to hatch.','Press [Enter] to continue',[#13]);
            index := 2;
            stop := false;
          End Else
        If info.tag = '' then
          Begin
            askwindow('You must specify','an area to hatch in.','Press [Enter] to continue',[#13]);
            index := 1;
            stop := false;
          End;
      End;
  End;

  Procedure Function_File;
  var
    x : integer;
    dummy : integer;
    t : string;
  Begin
    HatchTMP := HatchFile;
    Repeat
      hatchfile := pardesc;
      t := hatchfile;
      Read_String(17,4,42,62,t,c_all);
      hatchfile := t;
      Writeat(17,4,3,0,expand(upper(hatchfile),42));
      Hatchfile := browse_file(2,hatchfile, area.directory);
      if not exist(hatchfile) then hatchfile := area.directory +'*.*';
      pardesc := hatchfile;
    Until (hatchfile <> '') or (hatchfile = hatchtmp);

    If hatchfile <> hatchtmp then
      Begin
        hatchfile := fsearch(hatchfile,area.directory+';.\');
        If hatchfile = '' then
          Begin
            HatchFile := HatchTMP;
          End else
          Begin
            HatchTMP := file_split(1,HatchFile);
            HatchFile := FExpand(Hatchfile);

            i := setup.filebase; {file omschrijving zoeken}
            If i = 1 then
              Begin
                If (area.areanr = 0) or not exist('filearea.fm') then
                  i := 0 else
                    Begin
                      Assign (bf,systempath+'filearea.fm');
                      Reset (bf,1);
                      Seek(bF, 20);
                      BlockRead(bF,Bbsarea,Sizeof(Bbsarea));
                      TmpStr := Bbsarea.path;
                      Close(bf);
                      GetBbsAreaNaam(area.areanr);
                    End;
              End;
            If i = 0 then
              Begin
                tmpstr := file_split(1,hatchfile);
                if last(1,tmpstr) <> '\' then
                  tmpstr := tmpstr + '\FILES.BBS' else
                    tmpstr := tmpstr + 'FILES.BBS';
              End;
            tmpedit := file_split(2,hatchfile);
            If Find_File(tmpedit,i,tmpstr,bbsarea) then
              Begin
                info.description := '';
                x := 0;
                For dummy := 1 to desc_length do
                  Begin     { strip ext ascii en #13 uit korte omschr }
                    if (desc_buffer[dummy] in [#13,#32..#63,#65..#126,#128..#168]) and
                       (length(info.description) < 250) and
                       (((desc_buffer[dummy] = #32) and (last(1,info.description) <> #32)) or (desc_buffer[dummy] <> #32)) then
                      begin
                        if desc_buffer[dummy] = #13 then
                          info.description := info.description + ' ' else
                            info.description := info.description + desc_buffer[dummy];
                      end;

                    if desc_buffer[dummy] <> #10 then
                      begin
                        inc(x);
                        info.longdesc[x] := desc_buffer[dummy];
                      end;
                  End;
                info.description := strip('B',' ',info.description);
                info.longcount := x;
                if info.longcount > 0 then strip_buffer(info);
              End Else
              Begin
                Tmpstr := '[Description missing, inform Sysop]';
                info.description := tmpstr;
                info.longcount := 0;
              End;
            writeat(17,10,3,0,expand(first(62,info.description),62));
          End; {hatchfile <> ''}
        ShowInQueue(1, (file_size(hatchfile) div 1024));
      End; {hatchfile <> hatchtmp}
  End;


  Procedure enterlongdesc;
  var
    x, res : word;
    t      : text;
  Begin
    if setup.exteditor <> '' then
      begin

        delete_file(systempath+'FM_LDESC.TMP');
        if info.longcount > 0 then
          begin
            assign(t,systempath+'FM_LDESC.TMP');
            {$I-} rewrite(t); {$I+}
            if ioresult = 0 then
              begin
                for x := 1 to info.longcount do
                  begin
                    ch := info.longdesc[x];
                    if ch <> #10 then write(t,ch);
                    if ch = #13 then write(t,#10);

                  end;
                close(t);
              end;
          end;

        savescreen;
        cursor_on;
        res := fmExec(setup.exteditor,systempath+'FM_LDESC.TMP', setup.SwapMethode, $3200, false, false);
        restorescreen;
        cursor_off;

        assign(t,systempath+'FM_LDESC.TMP');
        {$I-} reset(t); {$I+}
        if ioresult = 0 then
          begin
            info.longcount := 0;
            while not eof(t) do
              begin
                read(t,ch);
                if ch <> #10 then
                  begin
                    inc(info.longcount);
                    info.longdesc[info.longcount] := ch;
                  end;
              end;
            close(t);
            erase(t);
            if info.longcount > 0 then strip_buffer(info);
          end else
          begin
            info.longcount := 0;
          end;
      end;
  end;

  {...}


Begin
  ctrlZhook := DosShell;

  WriteLogCR (6, 'HATCH');

  FillChar (INFO,  SizeOf(INFO),  0);
  Fillchar (info.longdesc, sizeof(info.longdesc),#0);
  FillChar (Hatchfile, sizeof(hatchfile), 0);
  FillChar (HatchTMP, SizeOf(HatchTMP), 0);
  FillChar (TagTMP, SizeOf(TagTMP), 0);

  Hatches      := False;
  HatchFile    := '';

  FillChar (DT, SizeOf(DT), 0);
  With DT do GetDate(Year, Month, Day, totfiles);
  INFO.Release := GetUnixDate(DT);
  INFO.Forwar := INFO.Release;

  totfiles := 0;
  totkb := 0;
  totall := 0;
  totque := 0;

  If NOT BatchHatch then
    Begin
      X := WhereX;
      Y := WhereY;

      Savescreen;
      Clrscr;
      Cursor_Off;

      With mwin[1] do
        Begin
          x1 := 1;
          x2 := 1;
          y1 := 80;
          y2 := 24;
          st := ' Hatch Manager ';
        End;
      Create_Window(1);
      Writeat(1,16,11,0, #195+replicate(78,#196)+#180);
      Writeat(1,22,11,0, #195+replicate(78,#196)+#180);

      ShowInQueue(0,0);

      Stop      := false;
      Index     := 1;
      HatchAKA  := 1;

      Repeat
        WriteColor(25,7,15,0,' ^F1^-Hatch  ^F2^-Edit long description              ^F9^-Discard  ^F10^-Hatch & Exit');
        Writeat(3,16,11,0,'filename');
        Writeat(17,16,11,0,'area');
        Writeat(38,16,11,0,'description');

        Write_Selection(index);
        Write_Settings;

        Ch := Readkey;
        Case Ch of
          #0  : Begin
                  Ch := Readkey;
                  Case Ch of
                    #59 : {f1}  function_f1;
                    #60 : {f2}  enterlongdesc;
                    #67 : {f9}  stop := true;
                    #68 : Begin {f10}
                            stop := true;
                            function_f1;
                          End;
                    #72 : Begin {up}
                            Dec(index); If index = 0 then index := 13;
                          End;
                    #80 : Begin {down}
                            Inc(index); If index = 14 then index := 1;
                          End;
                    #71, {home}
                    #73 : {pgup} Index := 1;
                    #79, {end}
                    #81 : {pgdn} Index := 13;
                  End;
                End;
          #26 : DosShell;
          #13 : Begin
                  Case index of
                    1 : Begin
                          TmpEdit := info.tag;
                          Read_String(17,3,15,15,tmpedit,c_all);
                          If (tmpedit = info.tag) or (tmpedit = '') then
                            begin
                              Writeat(17,3,3,0,expand(info.tag,15));
                              browsetag (2,afxinx);
                              if afxinx <> 0 then
                                tmpedit := AfXt^[Afxinx].Tag;
                            end;

                          if tmpedit <> info.tag then
                            begin
                              tmpedit := upper(tmpedit);
                              AFXinx := 1;
                              While (AFXinx <= Areaidx) and (AFXt^[AFXinx].TAG <> tmpedit) do Inc(AFXinx);
                              if AFXinx <= Areaidx then
                                begin
                                  GetArea (AFXinx);
                                  info.tag := afxt^[afxinx].tag;

                                  if dupcheck in area.status then info.hatdups := true else info.hatdups := false;
                                  if virus in area.status then info.hatviru := true else info.hatviru := false;
                                  if importdiz in area.status then info.hatimpo := true else info.hatimpo := false;
                                  if convert in area.rearchive then info.hatrear := true else info.hatrear := false;

                                end else AskWindow(tmpedit,' not found.','Press [Enter] to continue',[#32,#27,#13]);
                            end;

                          Writeat(17,3,3,0,expand(info.tag,15));
                          Writeat(33,3,3,0,expand(AREA.Name,27));
                        End;
                    2 : Function_File;
                    3 : Begin
                          TmpEdit := info.replaces;
                          Read_String(17,5,12,12,tmpedit,c_file);
                          info.replaces := upper(TmpEdit);
                        End;
                    4 : Begin
                          TmpEdit := info.magic;
                          Read_String(17,6,12,12,tmpedit,c_file);
                          Info.magic := upper(TmpEdit);
                        End;
                    5 : Begin
                          EditDate (17,7,3, info.Forwar);
                          if info.release < info.forwar then info.release := info.forwar;
                        End;
                    6 : Begin
                          Repeat
                            if info.Release < info.Forwar then info.Release := info.Forwar;
                            EditDate (17,8,3, info.Release);
                          Until info.Release >= info.Forwar;
                        End;
                    7 : Browse_Aka(2,hatchaka);
                    8 : begin
                          tmpedit := info.description;
                          read_String(17,10,62,250,tmpedit,c_all);
                          info.description := tmpedit;
                        end;
                    9 : info.hatdups := not info.hatdups;
                   10 : info.hatmove := not info.hatmove;
                   11 : info.hatviru := not info.hatviru;
                   12 : info.hatimpo := not info.hatimpo;
                   13 : info.hatrear := not info.hatrear;
                  End;
                End;
        End; {case}
      Until Stop;
      CtrlZHook := Dummy;

    End Else {batch hatch}
    Begin

      If (parTAG <> '') and (parFile <> '') and (parDesc <> '') then
        Begin
          { check TAG }
          AFXinx := 1;
          partag := upper(partag);
          While (AFXinx <= Areaidx) and (AFXt^[AFXinx].TAG <> parTAG) do Inc(AFXinx);
          If AFXinx > Areaidx then HatchError ('Area '+parTAG+' not found.');
          Getarea (afxinx);
          INFO.TAG := parTAG;

          if Pos('\', parFile) = 0 then
            begin
              HatchFile := Fsearch(parFile, AREA.Directory+';.\');
              if HatchFile = '' then HatchError ('File '+parFile+' not found.');
              Hatchfile := File_split(1,hatchfile);
            end else
            begin
              FindFirst (parFile, $0, SR);
              if DOSerror > 0 then HatchError ('File '+parFile+' not found.');
              while doserror = 0 do findnext(sr);
              parfile := file_split(1,parfile)+sr.name;
              hatchfile := '';
             end;
           if (hatchfile <> '') and (last(1,hatchfile) <> '\') then hatchfile := hatchfile + '\';
           INFO.FilePath  := file_split(1,hatchfile+parFile);
           INFO.FileSpec  := file_split(2,parfile);

           info.Replaces := parRepl;
           info.Description := parDesc;

{           FillChar (DT, SizeOf(DT), 0);
           With DT do GetDate(Year, Month, Day, totfiles);
           INFO.Release := GetUnixDate(DT);
           INFO.Forwar := INFO.Release; }

           if ParNOP
             then INFO.Status := [Local, FileProcessed]
               else INFO.Status := [Local];

           Info.Magic        := parMagic;
           Info.Size         := 0;
           Info.CRCstr       := '';
           if area.aka <> 0 then
             Info.Origin       := SETUP.Address[AREA.AKA] else
               info.origin := setup.address[1];
           Info.From         := info.Origin;
           Info.cSeen        := 1;
           Info.SeenbyLst[1] := info.Origin;

           { create hatch entry }

           Assign (PF, SystemPath + 'PROCESS.FM');
           {$I-} Reset (PF); {$I+}
           if IOresult <> 0 then Rewrite (PF);
           Seek (PF, FileSize(PF));
           Write (PF, INFO);
           Close (PF);

           Hatches := True;
        End Else
        Begin
          NotifyCR(2,'Insufficient information to process HATCH.');
          WriteLn;
          ParameterHelp;
        End;
    End;

  { if hatches are made, process them }
  If Hatches then
    Begin
      if exist(systempath+'import.xyz') then delete_file(systempath+'import.xyz');

      Assign (PF, SystemPath + 'PROCESS.FM');
      {$I-} Reset (PF); {$I+}
      If IOresult = 0 then
        Begin

          Assign(Pfnew,systempath+'PROCESS.NEW');
          {$I-} reset(pfnew); {$I+}
          If ioresult <> 0 then rewrite(pfnew);
          Seek(pfnew,filesize(pfnew));

          If batchhatch or (askwindow(int_to_str(filesize(pf))+' files in queue.','Hatch files now?',
          '(Y/N)',['y','Y','n','N']) in ['Y','y']) then
            Begin
              If not batchhatch then removewin;
              While not EOF(PF) do
                Begin
                  Read (PF, INFO);
                  If Date_Past (datestring(info.forwar)) then
                    begin
                      ProcessFile;

                      if info.hatmove and (filestatus = ok) and (upper(info.filepath) <> upper(area.directory)) then
                        if not delete_file(info.filepath+info.filespec) then
                          notifycr(2,'Error removing processed file');

                    end Else Write(pfnew,info);
                End;
            End Else
            Begin
              If not batchhatch then removewin;
              While not EOF(PF) do
                Begin
                  Read (PF, INFO);
                  Write(pfnew,info);
                End;
            End;
          Close (PF);
          Erase (Pf);
          Close (Pfnew);
          Rename(pfnew,systempath+'PROCESS.FM');
          If file_size(systempath+'PROCESS.FM') = 0 then delete_file(systempath+'PROCESS.FM');

        End Else NotifyCR (2,'Error opening PROCESS.FM');

        If exist(systempath+'FMSYSTMP.#$') then sendsysopmsg('Areas created');
    End Else
    Begin
      If not batchhatch then removewin;
    End;
End;


End.
