{
 $Id$
}
Unit MkMsgPkt;       {fido pkt2+ unit}

{$O+}


 {*****************************************************************************
 *
 * Purpose:  Fido pkt2+ support
 *
 *****************************************************************************
 * Copyright (C) 1991-2008
 *
 * Vincent Coen / Ron Huiskes               FIDO:   2:250/1
 * Applewood
 * Epping Road
 * Roydon, Essex, CM19 5DA
 * United Kingdom
 *
 * This file is part of FileMgr.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FileMgr is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with FileMgr; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *****************************************************************************}

Interface

Uses MKGlobT, MKMsgAbs, MKFile, MKFFile, MKString,
     Dos, S_String, F_File, Fm_Struct;


Type TMsgType = Record
  MsgFile     : FFileObj;      { packet file }
  MsgBakFile  : FFileObj;      { tmp msg file }
  MsgText,
  MsgBak      : Longint;
  MsgOpen     : Boolean;       { packet open }
  NetMailPath : String[128];
  Orig,
  Dest        : AddrType;
  End;


Type PktMsgObj = Object (AbsMsgObj)
  FM: ^tMsgType;
  Constructor Init;                           {Initialize FidoMsgOut}
  Destructor Done; Virtual;                   {Done FidoMsgOut}
  Procedure SetMsgPath(St: String); Virtual;  {Set pkt path}
  Procedure DoString(Str: String); Virtual;   {Add string to message text}
  Procedure PutByte(B: Byte; Position: LongInt); Virtual;
  Procedure DoChar(Ch: Char); Virtual;        {Add character to message text}
  Procedure DoStringLn(Str: String); Virtual; {Add string and newline to msg text}
  Function  WriteMsg: Word; Virtual;
  Procedure SetFrom(Name: String); Virtual; {Set message from}
  Procedure SetTo(Name: String); Virtual; {Set message to}
  Procedure SetSubj(Str: String); Virtual; {Set message subject}
  Procedure SetDest(Var Addr: AddrType); Virtual;
  Procedure SetOrig(Var Addr: AddrType); Virtual;
  Procedure SetDate(St:String); Virtual;
  Procedure SetTime(st:string); Virtual;
  Procedure SetPriv(bol:boolean); Virtual;
  Procedure SetCrash(bol:boolean); Virtual;
  Procedure SetFattach(bol:boolean); Virtual;
  Procedure SetHold(bol:boolean); Virtual;
  Procedure StartNewMsg; Virtual;
  Function  OpenMsgBase: Word; Virtual;
  Function  CloseMsgBase: Word; Virtual;
  End;

Type PktHdrType = Record
  OrigNode   : Word;
  DestNode   : Word;
  Year       : Word;
  Month      : Word;
  Day        : Word;
  Hour       : Word;
  Min        : Word;
  Sec        : Word;
  Baud       : Word;
  PktVers1   : Byte;
  PktVers2   : Byte;
  OrigNet    : Word;
  DestNet    : Word;
  ProdCode   : Byte;
  Revision   : Byte;
  Pwd        : Array[1..8] of Char;
  QOrigZone  : Word;
  QDestZone  : Word;
  AuxNet     : Word;
  CWVal      : Word;
  ProdCodeHi : Byte;
  RevMinor   : Byte;
  CW         : Word;
  OrigZone   : Word;
  DestZone   : Word;
  OrigPoint  : Word;
  DestPoint  : Word;
  ProdInfo   : LongInt;
 End;

Type PktMsgHdrType = Record
  PTypeMaj : Byte; {always 2}
  PTypeMin : Byte; {always 0}
  OrigNode : Word;
  DestNode : Word;
  OrigNet  : Word;
  DestNet  : Word;
  Attr     : Word;
  Cost     : Word;
  DateTime : Array[1..20] of char;             {Null Terminated 20 chars total}
    {MsgTo Null Terminated}
    {MsgFrom Null Terminated}
    {MsgSubj Null Terminated}
    {MsgText Null Terminated}
 End;

Type PktMsgPtr = ^PktMsgObj;

Implementation

Const
     { Masks for use with message attribute flags }
      Attr_Private: word =  1;
      Attr_Crash:   word =  2;
      Attr_Read:    word =  4;
      Attr_Sent:    word =  8;
      Attr_File:    word = 16;      { Attach}
      Attr_FWD:     word = 32;      { in Transit }
      Attr_Orphan:  word = 64;      { Unknown dest }
      Attr_Kill:    word = 128;
      Attr_Local:   word = 256;
      Attr_Hold:    word = 512;
      Attr_FRQ:     word = 2048;    { File Request}
      Attr_RRQ:     word = 4096;    { Reciept Req }
      Attr_CPT:     word = 8192;    { is Reciept  }
      Attr_ARQ:     word = 16384;   { Audit Req   }
      Attr_URQ:     word = 32768;   { Update Req  }

Var
  ph : PktHdrType;
  pm : PktMsgHdrType;

Constructor PktMsgObj.Init;
Begin
  New(FM);
  If FM = Nil Then
    Begin
      Fail;
      Exit;
    End;
  FM^.NetMailPath := '';
  FM^.MsgFile.Init(2000);
  FM^.MsgBakFile.Init(4000);
  FM^.MsgOpen := False;
  FM^.Dest.Zone := 0;
  FM^.Orig.Zone := 0;
  FM^.MsgText := 0;
  FM^.MsgBak := 0;
End;

Destructor PktMsgObj.Done;
Begin
  Dispose(FM);
End;

Procedure PktMsgObj.SetMsgPath(St: String);
Begin
  FM^.NetMailPath := copy(st,1,110);
End;

Procedure PktMsgObj.PutByte(B: Byte; Position: LongInt);
Begin
  If FM^.MsgbakFile.SeekFile(Position) Then
    If FM^.MsgbakFile.BlkWrite(B, SizeOf(Byte)) Then;
End;

Procedure PktMsgObj.DoString(Str: String);
Var
  i: Word;
Begin
  i := 1;
  While i <= Length(Str) Do
    Begin
      DoChar(Str[i]);
      Inc(i);
    End;
End;

Procedure PktMsgObj.SetTime(st:string);
var
  tmp : string;
  x : word;
Begin
  tmp := st;    { '01 Jan 86  02:34:56' }
  for x := 1 to length(tmp) do pm.datetime[11+x] := tmp[x];
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;

  ph.Hour := str_to_int(first(2,st));
  ph.Min  := str_to_int(last(2,first(5,st)));
  ph.Sec  := str_to_int(last(2,st));
  If FM^.MsgFile.SeekFile(0) Then
    If FM^.MsgFile.BlkWrite(ph, SizeOf(ph)) Then;
End;


Procedure PktMsgObj.Setdate(st:string);
Var
  tmp : string;
  x   : word;
Begin
  tmp := last(2,first(5,st));     {  '01 Jan 86  02:34:56'  }
  tmp := tmp + ' ';
  tmp := tmp + months[str_to_int( first(2,st)  )];
  tmp := tmp + ' ';
  tmp := tmp + last(2,st);
  tmp := tmp + '  ';
  for x := 1 to length(tmp) do pm.datetime[x] := tmp[x];
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;

  ph.Year  := 1900+str_to_int(last(2,st));
  ph.Month := str_to_int(first(2,st));
  ph.Day   := str_to_int(last(2,first(5,st)));
  If FM^.MsgFile.SeekFile(0) Then
    If FM^.MsgFile.BlkWrite(ph, SizeOf(ph)) Then;
End;

Procedure PktMsgObj.SetPriv(bol:boolean);
Begin
  If bol then
    pm.attr := pm.attr + Attr_Private else
      pm.attr := pm.attr - Attr_Private;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;
End;

Procedure PktMsgObj.SetCrash(bol:boolean);
Begin
  If bol then
    pm.attr := pm.attr + Attr_Crash else
      pm.attr := pm.attr - Attr_Crash;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;
End;

Procedure PktMsgObj.SetHold(bol:boolean);
Begin
  If bol then
    pm.attr := pm.attr + Attr_Hold else
      pm.attr := pm.attr - Attr_Hold;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;
End;

Procedure PktMsgObj.SetFattach(bol:boolean);
Begin
  If bol then
    pm.attr := pm.attr + Attr_File else
      pm.attr := pm.attr - Attr_File;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;
End;


Procedure PktMsgObj.DoChar(Ch: Char);
Begin
  PutByte(Ord(Ch), FM^.MsgBak);
  Inc(FM^.MsgBak);
End;

Procedure PktMsgObj.DoStringLn(Str: String);
Begin
  DoString(Str+#13);
End;

Function  PktMsgObj.WriteMsg: Word;
Var B   : Array[1..1000] of char;
    Tel : Word;
    Tmp : String;
Begin
  DoChar(#0);
  { wegschrijven 1 x #0 voor eind van msg }

  {copieren van msgbakfile aan msgfile}
  If FM^.MsgFile.SeekFile(FM^.MsgText) then; {seek naar einde van pkt}
  If FM^.MsgBakFile.SeekFile(0) then;  {seek naar begin van msg}

  Repeat
    If FM^.MsgBakFile.BlkRead(B,Sizeof(b),tel) then;
    If FM^.MsgFile.BlkWrite(b, tel) Then;
    Inc(FM^.MsgText,tel);
  Until Tel = 0;

  If FM^.MsgbakFile.CloseFile Then {};

  {deleten msgbakfile}
  Tmp := first(length(FM^.NetMailPath)-1,fm^.netmailpath)+'P';
  If Exist(tmp) then
    if Delete_file(tmp) then;

  FM^.MsgbakFile.Done;

  WriteMsg := IoResult;
End;


Procedure PktMsgObj.StartNewMsg;
Var
  tmp : string;
  x : byte;
Begin
  FM^.MsgBak := 0;
  Tmp := first(length(FM^.NetMailPath)-1,fm^.netmailpath)+'P';
  If Length(Tmp) > 0 Then
    Begin
      If FM^.MsgbakFile.OpenFile(Tmp, fmReadWrite + fmDenyNone) Then
        Begin
          fillchar(pm,sizeof(pm),' ');
          pm.PTypeMaj := 2;
          pm.PTypeMin := 0;
          pm.attr := 0;

          pm.datetime[20] := #0;

          { message header aanmaken }
          If FM^.MsgbakFile.BlkWrite(pm, SizeOf(pm)) Then;
          Inc(FM^.MsgBak,sizeof(pm));
        End;
    End;
End;

Procedure PktMsgObj.SetFrom(Name: String); {Set msg from}
Begin
  DoString(name+#0);
End;

Procedure PktMsgObj.SetTo(Name: String); {Set msg to}
Begin
  DoString(name+#0);
End;

Procedure PktMsgObj.SetSubj(Str: String); {Set msg subject}
Begin
  DoString(str+#0);
End;

Procedure PktMsgObj.SetDest(Var Addr: AddrType);
Var
  TmpChr: Char;
Begin
  FM^.Dest := Addr;

  {header}
  ph.orignode  := addr.node;
  ph.orignet   := addr.net;
  ph.origZone  := addr.zone;
  ph.origPoint := addr.point;
  ph.QorigZone := addr.zone;

  If FM^.MsgFile.SeekFile(0) Then
    If FM^.MsgFile.BlkWrite(ph, SizeOf(ph)) Then;

  {msg header}
  pm.destNode := addr.node;
  pm.destNet  := addr.net;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;

  If Addr.Point <> 0 Then DoStringLn(#1+'TOPT '+Long2Str(Addr.Point));
  If ((FM^.Orig.Zone <> 0)) Then DoStringLn(#1+'INTL '+AddrStr(FM^.Dest)+' '+AddrStr(FM^.Orig));
End;

Procedure PktMsgObj.SetOrig(Var Addr: AddrType);
Begin
  FM^.Orig := Addr;

  {header}
  ph.destnet   := addr.net;
  ph.destnode  := addr.node;
  ph.destZone  := addr.zone;
  ph.destPoint := addr.point;
  ph.QdestZone := addr.zone;

  If FM^.MsgFile.SeekFile(0) Then
    If FM^.MsgFile.BlkWrite(ph, SizeOf(ph)) Then;

  {msg header}
  pm.origNode := addr.node;
  pm.origNet  := addr.net;
  If FM^.MsgBakFile.SeekFile(0) Then
    If Fm^.MsgBakFile.BlkWrite(pm,sizeof(pm)) Then;

  If Addr.Point <> 0 Then DoStringLn(#1+'FMPT '+Long2Str(Addr.Point));
  If ((FM^.Dest.Zone <> 0)) Then DoStringLn(#1+'INTL '+AddrStr(FM^.Dest)+' '+AddrStr(FM^.Orig));
End;

Function PktMsgObj.OpenMsgBase: Word;
var
  Tmp : string;
Begin
  { file aanmaken en openen }
  If FM^.MsgOpen Then
    Begin
      If FM^.MsgFile.CloseFile Then
        OpenMsgBase := 1;
    End;
  Tmp := FM^.NetMailPath;
  If Length(Tmp) > 0 Then
    Begin
      If FM^.MsgFile.OpenFile(Tmp, fmReadWrite + fmDenyNone) Then
        Begin
          OpenMsgBase := 0;
          FM^.Msgopen := true;

          { packet header creeren }
          fillchar(ph,sizeof(ph),#0);
          ph.PktVers1   := 2;
          ph.PktVers2   := 0;
          ph.ProdCode   := 15;
          ph.ProdCodeHi := 0;
          ph.Revision   := 1;
          ph.RevMinor   := 0;

          PH.CW         := 1;         { extended pkt-2+ ftsc-0039 ofzoiets }
          PH.CWVal      := lo(1) * 256 + hi(1);

          If FM^.MsgFile.BlkWrite(ph, SizeOf(ph)) Then;
          inc(fm^.MsgText,sizeof(ph));
        End Else
          OpenMsgBase := 1;
    End Else
      OpenMsgBase := 1;
End;

Function PktMsgObj.CloseMsgBase: Word;
Var
  B : Char;
Begin
  B := #0;
  If FM^.MsgFile.SeekFile(FM^.MsgText) then;
  If FM^.MsgFile.BlkWrite(b, sizeof(b)) Then;
  Inc(FM^.MsgText);

  If FM^.MsgFile.SeekFile(FM^.MsgText) then;
  If FM^.MsgFile.BlkWrite(b, sizeof(b)) Then;
  Inc(FM^.MsgText);
  { wegschrijven 2 x #0 voor eind van packet }

  { packet afsluiten }
  If FM^.MsgFile.CloseFile Then {};
  FM^.MsgFile.Done;
  CloseMsgBase := 0;
End;


End.


