PAGE  80,132
TITLE CHRDELR  Delete Trailing Chars Routine, Ver 6.20

; CHRDELR.ASM - ChrDelR
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine operates on a string to delete all trailing occurrences of a
; given character.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  ChrDelR

S            EQU     DWORD PTR SS:[bx+6]
Char         EQU     BYTE  PTR SS:[bx+4]

; ChrDelR - Deletes Right (or trailing) characters.
; procedure ChrDelR (S: string; Find: char);

ChrDelR      PROC FAR
       mov   bx,sp            ; Set up stack base
; -- Get string length --
       les   di,S             ; Point to dest string
       xor   cx,cx            ; Set CX=0
       add   cl,es:[di]       ; Get and evaluate length
       jz    Exit             ; Quit if null string
; -- Scan for trailing chars --
       mov   si,di            ; Save DI
       add   di,cx            ; Point to end of string
       inc   cx               ; Account for first scan
       std                    ; Set DF to decrement
       mov   al,Char          ; Get Char to delete
       repe  scasb            ; Find char that's not equal
; -- Trim off trailing chars --
       xchg  ax,cx            ; Get count in AL
       mov   di,si            ; Restore pointer to S[0]
       stosb                  ; Set new count
Exit:  ret   6                ; Clear all parameters
ChrDelR      ENDP

CODE   ENDS

       END
