PAGE  80,132
TITLE STRMOV  String Move Procedure, Ver 6.20

; STRMOV.ASM - StrMov
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine is equivalent to a string assignment:
;    String1 := String2;
; but it is up to 70% faster.  Use when speed is essential.
; As in all move-type procedures, make sure your destination is large enough.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrMov
        EXTRN   RepMovsB: NEAR

Dest         EQU     DWORD PTR SS:[bx+8]
S            EQU     DWORD PTR SS:[bx+4]

; StrMov - Moves source string to destination.
; procedure StrMov (VAR Dest: string; S: string);

StrMov       PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
; -- Check S length --
       lds   si,S             ; Point to source string
       xor   ax,ax            ; Set AX=0
       mov   al,[si]          ; Get length
       mov   cx,ax            ; Set counter
; -- Get Dest --
       inc   cx               ; Include length byte
       les   di,Dest          ; At Dest[0]
       cld                    ; Set DF to increment
       call  RepMovsB         ; Do fast move of bytes
       mov   ds,dx            ; Restore Pascal's DS
       ret   8                ; Clear all parameters

StrMov       ENDP

CODE   ENDS

       END
