PAGE  80,132
TITLE STRPEEK  String Peek and Poke Routines, Ver 6.20

; STRPEEK.ASM - StrPeek, StrPoke
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrPeek, StrPoke
        EXTRN   RepMovsB: NEAR

; StrPeek - Takes an array in memory at Source and converts it to a
; string at S.  Dest[0] cannot overlap Source.  This allows arrays to be
; handled as strings.
; procedure StrPeek (VAR Dest: string; VAR Source; Count: byte);

Dest         EQU     DWORD PTR SS:[bx+10]
Source       EQU     DWORD PTR SS:[bx+6]
Count        EQU     BYTE  PTR SS:[bx+4]

StrPeek      PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       les   di,Dest          ; Point to dest Pascal string
       lds   si,Source        ; Point to array source
       cld                    ; Set DF to increment
       mov   al,Count         ; Get length in AL
       stosb                  ; Set length
       xchg  ax,cx            ; Save length in CX
       xor   ch,ch            ; Zero extend CL
       call  RepMovsB         ; Do fast move of bytes
       mov   ds,dx            ; Restore Pascal's DS
       ret   10               ; Clear all parameters
StrPeek      ENDP


; StrPoke - Pokes the characters of S as an array into memory
; NOT including the length byte.  This allows strings to be handled as
; arrays.  Dest[0] cannot overlap S.
; procedure StrPoke (VAR Dest; S: string);

Dest         EQU     DWORD PTR SS:[bx+8]
S            EQU     DWORD PTR SS:[bx+4]

StrPoke      PROC FAR
       mov   bx,sp            ; Set up stack base
       mov   dx,ds            ; Save Pascal's DS
       lds   si,S             ; Point to source Pascal string
       les   di,Dest          ; Point to array dest
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       xchg  ax,cx            ; Save length in CX
       xor   ch,ch            ; Zero extend CL
       call  RepMovsB         ; Do fast move of bytes
       mov   ds,dx            ; Restore Pascal's DS
       ret   8                ; Clear all parameters
StrPoke      ENDP

CODE   ENDS

       END
