PAGE  80,132
TITLE STRPOSX  String Position of Find from Index Routine, Ver 6.20

; STRPOSX.ASM - StrPosX
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; This routine finds the position of Find from the given indeX.


CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrPosX

S            EQU     DWORD PTR [bp+12]
Find         EQU     DWORD PTR [bp+8]
indeX        EQU     BYTE  PTR [bp+6]

; StrPosX - Position of Find from string indeX.
; function StrPosX (S,Find: string; indeX: byte): byte;

; AH: 0         AL: First char
; BX: scratch
; CH: ?         CL: Compare length
; DH: 0         DL: Find[0]-1
; BP: Max chars to scan

StrPosX      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       push  ds               ; Save Pascal's DS
       lds   si,Find          ; Point to Find string
; -- Test Find length --
       xor   ax,ax            ; Set AX=0
       cld                    ; Set DF to increment
       lodsb                  ; Get Find length
       mov   dx,ax            ; Save in DX
       dec   dx               ; Find[0]-1
       js    Exit3            ; Exit if Find='' (DX=-1)
; -- Get Maximum chars to scan --
       les   di,S             ; Point to dest string
       mov   al,es:[di]       ; Get S length
       sub   ax,dx            ; Positions remaining in AL
       jbe   Exit1            ; Exit if Find[0]-1>=S[0]
       mov   cx,ax            ; Save in CX
; -- Shift over to Index --
       mov   al,indeX         ; Get Position and test
       mov   bp,cx            ; Save max chars to scan
       cmp   ah,al            ; indeX=0?
       sbb   al,-1            ;   yes, increment
       inc   cx               ; 1-based
       sub   cx,ax            ; Chars to scan
       jbe   Exit1            ; None to search
       add   di,ax            ; First char to scan
       lodsb                  ; Get first find char
       jmp   SHORT L1         ; Start scan
; -- Scan for Find --
       EVEN                   ; Align for speed
L0:    mov   bx,cx            ; Save count remaining
       mov   cx,dx            ; Set Find scan length
       repe  cmpsb            ; Strings equal?
       je    Exit2            ;   yes, and exit
; -- Readjust for no match found --
       xchg  cx,bx            ;   (Swap counts)
       sub   bx,dx            ; Number of chars compared (neg)
       add   di,bx            ; Reset DI
       add   si,bx            ; Reset SI (ZF=0) Assumes string doesn't
                              ;   wrap around 64k segment
L1:    repne scasb            ; Try to find first match  (Pass if CX=0)
       je    L0               ; First char found         (ZF=1)
; -- Report results --
Exit1: mov   bx,bp            ; Set BX=BP to get result 0
Exit2: mov   ax,bp            ; Get original count in AL
       sub   ax,bx            ; Subtract chars to scan
Exit3: pop   ds               ; Restore Pascal's DS
       pop   bp               ; Restore Pascal's BP
       ret   10               ; Return to call
StrPosX      ENDP

CODE   ENDS

       END
