PAGE  80,132
TITLE STRROLL  String Roll Routine, Ver 6.20

; STRROLL.ASM - StrRoll
;  Copyright (c) 1989-1991 James H. LeMay, All rights reserved.
; Operates on a string by rolling characters.

CODE    SEGMENT WORD PUBLIC
        ASSUME  CS:CODE
        PUBLIC  StrRoll
        EXTRN   RepMovsB:    NEAR
        EXTRN   RepMovsBRev: NEAR

; StrRoll - Operates on a string by rolling the characters left or right.
; procedure StrRoll (VAR S: string; Count: integer);

S            EQU     DWORD PTR [bp+8]
Count        EQU     WORD  PTR [bp+6]
Temp         EQU     WORD  PTR [bp-0FFh]

; AH: Temp     AL: Length-Roll
; BX: Saved offset
; CX: reps
; DX: SS

StrRoll      PROC FAR
       push  bp               ; Save Pascal's BP
       mov   bp,sp            ; Set up stack base
       sub   sp,0FFh          ; Allow for Temp string
       push  ds               ; Save Pascal's DS
; -- Evaluate string length --
       xor   ax,ax            ; Set AX=0
       lds   si,S             ; At S[0]
       cld                    ; Set DF to increment
       lodsb                  ; Get length
       mov   cx,ax            ; Save in CX
       jcxz  Exit             ; Quit if null (=1?)
; -- Evaluate roll count --
       mov   ax,Count         ; Get Count to roll
       test  ax,ax            ; Count negative?
       js    NegR             ;  yes, do negative roll

; --------------------------------------------------------------------
;    Do positive roll
; --------------------------------------------------------------------
       call  ChkRoll          ; Check type of roll
       ja    N1               ; Easier to do negative roll
; -- Place Temp string in stack --
P1:    mov   ah,cl            ; Save Temp count
       mov   bx,di            ; Save offset in BX
       call  RepMovsB         ; Do fast move of bytes
; -- Move intra-string length --
       les   di,S             ; At S[0]
       inc   di               ; At S[1]
       mov   cl,al            ; Get Length-Roll
       call  RepMovsB         ; Do fast move of bytes
; -- Restore Temp string
       mov   ds,dx            ; DS=SS
       mov   si,bx            ; At Temp[0]
       mov   cl,ah            ; Get Temp length
       call  RepMovsB         ; Do fast move of bytes
; -- Exit routine --
Exit:  pop   ds               ; Restore Pascal's DS
       mov   sp,bp            ; Clear local variable
       pop   bp               ; Restore Pascal's BP
       ret   6                ; Clear all parameters

; --------------------------------------------------------------------
;    Do negative roll
; --------------------------------------------------------------------
NegR:  neg   ax               ;  no, set positive
       call  ChkRoll          ; Check type of roll
       jae   P1               ; Easier to do positive roll
; -- Place Temp string in stack --
N1:    add   si,ax            ; Jump to Temp source in S
       mov   bx,si            ; Save offset in BX
       mov   ah,cl            ; Save Temp count
       call  RepMovsB         ; Do fast move of bytes
; -- Move intra-string length --
       mov   di,si            ; At S[L+1]
       dec   di               ; At S[L]
       mov   si,ds            ; Place DS into ...
       mov   es,si            ;   ... ES
       mov   si,bx            ; At S[of Temp+1]
       dec   si               ; At S[of Temp]
       mov   cl,al            ; Length-Roll
       std                    ; Set DF to decrement
       call  RepMovsBRev      ; Do fast move of bytes
; -- Restore Temp string
       mov   ds,dx            ; DS=SS
       lea   si,Temp          ; At Temp[0]
       mov   cl,ah            ; Get Temp length
       add   si,cx            ; At Temp[L+1]
       dec   si               ; At Temp[L]
       call  RepMovsBRev      ; Do fast move of bytes
       jmp   SHORT Exit       ;
StrRoll      ENDP

; --------------------------------------------------------------------
;    Check type of roll
; --------------------------------------------------------------------
ChkRoll      PROC NEAR
       cmp   ax,cx            ; Compare count and length
       jl    C1               ; Evaluate roll
       div   cl               ; Get remainder
       mov   al,ah            ; Place in AL
       mov   ah,ch            ; Zero-extend AL
; -- Evaluate roll --
C1:    cmp   al,ah            ; Roll=0?
       jz    Exit2            ;   yes, exit
       sub   cx,ax            ; CX=Length-Roll
       cmp   ax,cx            ; Roll>Length-Roll?
       ja    C2               ;   yes, reverse roll
       xchg  ax,cx            ; Place roll count in CX
; -- Place Temporary string in stack --
C2:    mov   dx,ss            ; Place SS into ...
       mov   es,dx            ;   ... ES
       lea   di,Temp          ; At Temp[0]
       ret                    ; Return to call
Exit2: pop   es               ; Drop call's return
       jmp   SHORT Exit       ;
ChkRoll      ENDP



CODE   ENDS

       END
