/****************************************************************/
/*           Reset the position of the SETUP.EXE windows        */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      21 September 2000                         */
/*      Last revised: 8 June 2004                               */
/*                                                              */
/*  Usage:                                                      */
/*         resetpos                                             */
/*                                                              */
/*      You can use this when one or more of the windows        */
/*      belonging to SETUP.EXE has moved off-screen.  This      */
/*      script will move the windows to the bottom left of      */
/*      screen.  You can then run SETUP.EXE and move the        */
/*      windows to where you really need them.                  */
/*                                                              */
/*  Installation:                                               */
/*         Put this file in the directory containing SETUP.INI  */
/*         (This is normally the FtpServer main directory)      */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

/* Switch our working directory to the program directory */

PARSE SOURCE rubbish rubbish SrcDir
j = LASTPOS('\', SrcDir)
IF j > 0 THEN SrcDir = LEFT(SrcDir, j-1)
WrkDir = DIRECTORY()
CALL DIRECTORY SrcDir

Nul = D2C(0)
Null8 = Nul||Nul||Nul||Nul||Nul||Nul||Nul||Nul

CALL SysIni 'SETUP.INI', 'WindowPos', 'ALL:', stem
DO j = 1 TO stem.0
    CALL SysIni 'SETUP.INI', 'WindowPos', stem.j, Null8
END

SAY "The window positions have been reset"
SAY "You may now run SETUP.EXE"
CALL DIRECTORY WrkDir
EXIT 0

