#include "includes.h"



#define MIN(a,b)    ((a) < (b) ? (a) : (b))



void BlockDirCopy (PVOLUME pVolume, FLAT flatDest, FLAT flatSrc, ULONG cbLen)
{
  LONG      lDelta;
  FLAT      flatSrcEnd;
  POPENFILE pCurOpenfile;
  PCURDIR   pCurCurdir;
  PSEARCH   pCurSearch;

  if (cbLen == 0)
    return;

  VMCopy (flatDest, flatSrc, cbLen);

  flatSrcEnd = flatSrc + cbLen;
  lDelta = flatDest - flatSrc;

  pCurOpenfile = pVolume->pFirstOpenfile;
  while (pCurOpenfile != 0)
  {
    if (pCurOpenfile->flatEntry >= flatSrc  &&  pCurOpenfile->flatEntry < flatSrcEnd)
      pCurOpenfile->flatEntry += lDelta;
    pCurOpenfile = pCurOpenfile->pNextOpenfile;
  }

  pCurCurdir = pVolume->pFirstCurdir;
  while (pCurCurdir != 0)
  {
    if (pCurCurdir->flatBlkDir >= flatSrc  &&  pCurCurdir->flatBlkDir < flatSrcEnd)
      pCurCurdir->flatBlkDir += lDelta;
    pCurCurdir = pCurCurdir->pNextCurdir;
  }

  pCurSearch = pVolume->pFirstSearch;
  while (pCurSearch != 0)
  {
    if (pCurSearch->flatBlkDir >= flatSrc  &&  pCurSearch->flatBlkDir < flatSrcEnd)
      pCurSearch->flatBlkDir += lDelta;
    if (pCurSearch->flatEntry >= flatSrc  &&  pCurSearch->flatEntry < flatSrcEnd)
      pCurSearch->flatEntry += lDelta;
    pCurSearch = pCurSearch->pNextSearch;
  }
}




int BlockAlloc (PBLOCK pBlk, ULONG cbSize)
{
  FLAT flat;

  flat = 0;
  if (cbSize != 0)
  {
    flat = VMAlloc (ROUNDUP (cbSize));
    if (flat == 0)
      return ERROR_DISK_FULL;
  }
  pBlk->flatAddr = flat;
  pBlk->cbSize = cbSize;
  return NO_ERROR;
}




int BlockFree (PBLOCK pBlk)
{
  if (pBlk->cbSize != 0)
    VMFree (pBlk->flatAddr);
  pBlk->flatAddr = 0;
  pBlk->cbSize = 0;
  return NO_ERROR;
}




int BlockRealloc (PBLOCK pBlk, ULONG cbNewSize)
{
  if (pBlk->cbSize == 0)
    return BlockAlloc (pBlk, cbNewSize);

  if (cbNewSize == 0)
    return BlockFree (pBlk);

  if (ROUNDUP(cbNewSize) != ROUNDUP(pBlk->cbSize))
  {
    FLAT flatNew;

    flatNew = VMAlloc (ROUNDUP (cbNewSize));
    if (flatNew == 0)
      return ERROR_DISK_FULL;
    VMCopy (flatNew, pBlk->flatAddr, MIN (pBlk->cbSize, cbNewSize));
    VMFree (pBlk->flatAddr);
    pBlk->flatAddr = flatNew;
  }

  pBlk->cbSize = cbNewSize;
  return NO_ERROR;
}




int BlockReallocDir (PVOLUME pVolume, PBLOCK pBlk, ULONG cbNewSize)
{

#ifdef DEBUG
  if (pBlk->cbSize < DIR_DOTSSIZE  ||  cbNewSize < DIR_DOTSSIZE)
  {
    debugging = TRUE;
    DEBUG_PRINTF2 ("\r\n!!! BlockReallocDir oldsize=%lu newsize=%lu\r\n",
		   pBlk->cbSize, cbNewSize);
    INT3;
  }
#endif

  if (ROUNDUP(cbNewSize) != ROUNDUP(pBlk->cbSize))
  {
    FLAT flatNew;

    flatNew = VMAlloc (ROUNDUP (cbNewSize));
    if (flatNew == 0)
      return ERROR_DISK_FULL;
    BlockDirCopy (pVolume, flatNew, pBlk->flatAddr, MIN (pBlk->cbSize, cbNewSize));
    VMFree (pBlk->flatAddr);
    pBlk->flatAddr = flatNew;
  }

  pBlk->cbSize = cbNewSize;
  return NO_ERROR;
}




int BlockMakeEmptyDir (PBLOCK pBlk)
{
  DIRENTRY Entry;
  ULONG    datiNow;

  if (BlockAlloc (pBlk, DIR_DOTSSIZE))
    return ERROR_DISK_FULL;

  datiNow = UtilGetDateTime();

  Entry.fDOSattr = DOSATTR_DIRECTORY;
  Entry.blkFile.flatAddr = 0;
  Entry.blkFile.cbSize = 0;
  Entry.blkEA.flatAddr = 0;
  Entry.blkEA.cbSize = 0;
  Entry.datiCreate = datiNow;
  Entry.datiAccess = datiNow;
  Entry.datiWrite  = datiNow;

  /* make "." entry */
  Entry.cbName = 1;
  Entry.achName[0] = '.';
  VMWrite (pBlk->flatAddr, &Entry, sizeof(Entry)-sizeof(Entry.achName)+1);

  /* make ".." entry */
  Entry.cbName = 2;
  Entry.achName[1] = '.';
  VMWrite (pBlk->flatAddr + sizeof(Entry)-sizeof(Entry.achName)+1, &Entry,
	   sizeof(Entry)-sizeof(Entry.achName)+2);

  return NO_ERROR;
}
