#include "includes.h"



#pragma argsused

APIRET EXPENTRY FS_RMDIR (
    struct cdfsi *pcdfsi,
    struct cdfsd *pcdfsd,
    PSZ		pName,
    USHORT	iCurDirEnd )
{
  int      rc;
  PVOLUME  pVolume;
  DIRENTRY Entry;
  FLAT     flatEntry;
  FLAT     flatBlkDir;
  struct vpfsi *pvpfsi;
  struct vpfsd *pvpfsd;
  PSEARCH  pSearch;

  UtilEnterRamfs();
  DEBUG_PRINTF1 ("FS_RMDIR  pName='%s'", pName);

  FSH_GETVOLPARM (pcdfsi->cdi_hVPB, &pvpfsi, &pvpfsd);
  pVolume = pvpfsd->pVolume;
  flatBlkDir = pVolume->flatBlkRootDir;
  pName += 3;
  if (iCurDirEnd != 0xFFFF)
  {
    flatBlkDir = pcdfsd->pCurdir->flatBlkDir;
    pName += iCurDirEnd-3;
  }

  switch (UtilLocate (&flatBlkDir, &flatEntry, &Entry, pName))
  {
    case LOC_NOPATH:
    case LOC_NOENTRY:
	   rc = ERROR_PATH_NOT_FOUND;
	   break;


    case LOC_FILEENTRY:
	   rc = ERROR_CURRENT_DIRECTORY;
	   break;


    case LOC_DIRENTRY:
#ifdef DEBUG
	   if (Entry.blkFile.cbSize < DIR_DOTSSIZE)
	   {
	     debugging = TRUE;
	     DEBUG_PRINTF1 ("\r\n!!! FS_RMDIR cbSize=%lu\r\n", Entry.blkFile.cbSize);
	     INT3;
	   }
#endif

	   /* the dir should only contain . and .. */
	   if (Entry.blkFile.cbSize != DIR_DOTSSIZE)
	   {
	     rc = ERROR_CURRENT_DIRECTORY;
	     break;
	   }

	   /* terminate any searches in progress in the dir */
	   pSearch = pVolume->pFirstSearch;
	   while (pSearch != 0)
	   {
	     if (pSearch->flatBlkDir == flatEntry+FIELDOFFSET(DIRENTRY,blkFile))
	       pSearch->flatEntry = SEARCH_END;
	     pSearch = pSearch->pNextSearch;
	   }

	   BlockFree (&Entry.blkFile);
	   BlockFree (&Entry.blkEA);
	   UtilDeleteEntry (pVolume, flatBlkDir, &Entry, flatEntry);
	   rc = NO_ERROR;
	   break;
  }

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
