.* Copyright (c) 1995 Florian Groe-Coosmann, RCS section at the eof
.* Use &rbl. for a required blank ( ), &colon. for a colon (:)
:userdoc.
:docprof.
:ctrldef.
:ctrl ctrlid=CtrlID1 controls='ESC SEARCH PRINT INDEX CONTENTS BACK FORWARD'
coverpage.
:ectrldef.
.******************************************************************************
:h1 res=10100 name=ID_CRON.Der Cron Dmon (bersicht)
:i1 global.Cron Dmon
:p.Der Cron Dmon stammt eigentlich aus der Unix-Welt. Dieses Programm ist
eine Portierung auf OS/2, wobei Unix-spezifische Eigenschaften weggelassen
und OS/2-spezifische hinzugefgt wurden, ohne da eine prinzipielle nderung
der Funktionsweise oder Aufrufmglichkeiten zugelassen werden mute.

:p.Cron ist ein PM-Programm und im Unix-Sinn kein Dmon, obwohl crond auch
als Dmon ber die Kommandozeile :hp1. detach crond :ehp1.
gestartet werden kann. Leider hat er dann nicht seine volle Funktionalitt
unter OS/2, da aus dem Hintergrund keine Vordergrundprogramme gestartet werden
knnen. Die Benutzung ist dann auf eigene Gefahr.

:p.Der Cron Dmon hat keine Aufrufparameter. Alle
:link refid=IDD_NOTEBOOK reftype=hd.Einstellungen:elink.
erfolgen ber die Oberflche. Fehlerhafte Eintrge (z.B. bei einem Pfadwechsel)
werden auf Voreinstellungen gesetzt, so da ein Programmstart immer mglich
sein sollte.

:p.Wie unter Unix besteht die Mglichkeit, Cron-Eintrge ber das
Hilfsprogramm :hp2.crontab:ehp2. zu manipulieren. Da OS/2 ein
Single-User-Betriebssystem ist, entfallen die Optionen :hp2.-r:ehp2. und
:hp2.-l:ehp2. der Unix-Version. Stattdessen werden die einzelnen Befehle
direkt angegeben. Fr eine vollstndige Liste der Aufrufvariationen rufe man
am besten :hp2.crontab:ehp2. ohne Parameter auf. Alle wichtigen Parameter
findet man auch in der
:link reftype=hd refid=XMP_SYNTAX.Syntaxbeschreibung:elink. und bei den
:link reftype=hd refid=XMP_XMP.Beispielen:elink..

:h4.:hp2.Was leistet der Cron Dmon?:ehp2.
:p.Der Cron Dmon kann zu gewissen Zeiten Programme starten. Dabei ist eine
Auswahl der Minuten, Stunden, Monatstage, Monate und Wochentage mglich.
Zu den angegebenen Zeiten wird das Programm dann gestartet. Alle Kombinationen
der Zeiten sind dabei mglich, so da man einen repektablen Umfang von
chronologischen Aufgaben durch das System erledigen lassen kann, ohne da man
ein :link refid=Wecker reftype=fn.Weckerprogramm:elink. benutzen mu.
:fn id=Wecker.Als Wecker eignet sich der Cron Dmon selbstverstndlich
auch!:efn.

:p.Cron leitet alle Ausgaben der aufgerufenen Programme in eine Ausgabedatei.
Damit lassen sich dann im Nachhinein Fehler in den Programmen analysieren.
Der Unix-Dmon schickt diese Ausgaben (pro Programmstart) dem entsprechenden
Benutzer mit der Post zu. Diese Vorgehensweise ist aber unter OS/2 recht
ungeschickt, da es weder mehrere Benutzer, noch ein Postsystem gibt. Die
jeweilige Ausgabedatei enthlt deshalb alle ntigen Informationen ber Cron,
Programmstarts, sowie deren Ausgaben.

:p.Um auch auf unregelmig gewarteten Maschinen nicht als Speicherfresser zu
fungieren, wurde ein Mechanismus eingebaut, der es ermglicht, den
Ausgabeumfang zu begrenzen. Dabei werden mehrere Ausgabedateien verwendet,
zwischen denen nach dem Erreichen einer gewissen Gre oder auf Benutzerwunsch
durch den entsprechenden
:link refid=IDME_NEXTFILE reftype=hd.Meneintrag:elink.
gewechselt wird.

:p.Der Cron Dmon bernimmt weiterhin alle Aufgaben des Unix-Befehls
:hp2.at:ehp2.. Dieser Befehl startet ebenfalls ein Programm zu einer gewissen
Zeit, jedoch wird die Programmausfhrung nie wiederholt. Um ein weiteres
Kommunikationsprogramm zu sparen, wurde das Schlsselwort :hp2.Once:ehp2.
eingefhrt.

:p.Weiterhin beherrscht der Dmon spezifische Funktionen, die es
erlauben, beim Start und beim Ende des Cron Dmons Programme zu starten, da
OS/2-Maschinen naturgem selten lnger als ein paar Stunden arbeiten.
Programme, die eigentlich in der Nacht arbeiten sollen, knnen so nachgefahren
werden. (Datensicherung und -auffrischung, Aufrumarbeiten, etc.)

:p.Der Cron Dmon kann auch ber das Netzwerk bedient werden. Dies geschieht
durch das Programm :hp2.crontab:ehp2.. Untersttzte Netzwerkvarianten sind
:link refid=LAN_NETWORK reftype=hd.LAN/Netware:elink. und
:link refid=IDD_TCP reftype=hd.TCP/IP:elink..
.******************************************************************************
:h1.Farben und Schriftart
:i1.Farben
:i1.Schriftart
:p.Man kann die Farben und die Schriftart des Anzeigefensters verndern.
Dazu ffnet man in dem Ordner :hp2.Systemkonfiguration:ehp2. die Farb- oder
Schriftartpalette und zieht das gewnschte Element auf das Fenster.
:p.Bei den Farben kann man mit der zweiten Maustaste die Hintergrundfarbe
ndern. Hlt man dabei die [Strg]-Taste fest, ndert sich die Vordergrundfarbe.
:p.Die Werte werden gespeichert und bei einem erneuten Programmstart
bernommen.
.******************************************************************************
:h1 res=10101 name=IDME_NEXTFILE.Nchste Ausgabedatei
:i1.Nchste Ausgabedatei
:p.ber den Meneintrag :hp2.Nchste Ausgabedatei:ehp2. kann man die aktuelle
Ausgabedatei schlieen und zur nchsten berwechseln. Diese wird vorher
gelscht, falls sie schon existiert.

:p.Wird die maximale
:link refid=IDDE_OUTPUT_COUNT reftype=hd.Dateianzahl:elink.
erreicht, wird mit der Datei der Nummer 0 fortgefahren.

:p.Die aktuelle Ausgabedatei wird im Hauptfenster angezeigt.

:p.Der Meneintrag ist nicht anwhlbar, falls die
:link refid=IDDE_OUTPUT_IGNORE_OUTPUT reftype=hd.Ausgabe ignoriert:elink. wird.

:p.Dieser Menpunkt kann ntzlich sein, um die aktuelle Ausgabedatei anzusehen
oder zu bearbeiten, da der Dmon die aktuelle Ausgabedatei permanent im Zugriff
hat. Das Lesen dieser Datei ist zwar zu jedem Zeitpunkt erlaubt (TYPE
funktioniert), aber viele Editoren kommen damit nicht zurecht.
.******************************************************************************
:h1 hide res=10105 name=IDME_HELPKEYS.Hilfe zur Tastatur
:p.Es gibt keine spezifischen "Hotkeys" in diesem Programm. Die allgemeinen
:link reftype=hd database='wphelp.hlp' refid=193.Tastenzuordnungen:elink.
kann man sich z.B. ber den :hp2.Hauptindex:ehp2. im
:hp2.Informationsordner:ehp2. auf der Oberflche anzeigen lassen.
.******************************************************************************
:h1 res=10200 name=IDD_NOTEBOOK.Einstellungen
:i1.Einstellungen
:p.Durch das Auswhlen des Meneintrags :hp2.Einstellungen:ehp2. ffnet man das
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink..
Dort werden alle benutzerdefinierbaren Setzungen fr das Programm
eingegeben.
.*=============================================================================
:h2 res=10201 name=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen
:i1.Notizbuch
:p.Es gibt zur Zeit fnf verschiedene Notizbuchseiten, die wie gewohnt
bedient werden knnen. Selbstverstndlich kann auch zu jedem Seiteneintrag
die Hilfe kontextsensitiv angefordert werden.
Die fnf Seiten beschreiben
:ul.
:li.die allgemeine :link
 reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink.
:li.die einzelnen :link
 reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink.
:li.das Daten fr die :link
 reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. in eine Datei
:li.die Mglichkeiten fr den :link
 reftype=hd refid=IDD_TCP.TCP/IP-Zugriff:elink. von anderen Rechnern
:li.:link reftype=hd refid=IDD_GENERAL.allgemeine Einstellungen:elink., wie
z.B. die Sprache
:eul.
.*=============================================================================
:h2 res=10300 name=IDD_CRON_FILE.Crontabs-Bearbeitung
:i1.Crontabs-Bearbeitung
:p.Diese Seite aus dem :link
reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink.
erlaubt es, die Abarbeitung der Crontabs-Eintrge und deren Datei anzugeben.

:p.Durch das Auswhlen der :link
reftype=hd refid=IDDE_CRON_ATSTARTUP.CronStart-Abarbeitung:elink. fhrt der
Dmon alle Crontabs-Eintrge beim Dmonstart aus, deren Startzeit mit
:hp2.CronStart:ehp2. angegeben wurde. Ist die Abarbeitung nicht ausgewhlt,
werden die Eintrge ignoriert.

:p.Durch das Auswhlen der :link
reftype=hd refid=IDDE_CRON_ATEXIT.CronStop-Abarbeitung:elink. fhrt der
Dmon alle Crontabs-Eintrge beim Ende des Dmon aus, deren Startzeit mit
:hp2.CronStop:ehp2. angegeben wurde. Ist die Abarbeitung nicht ausgewhlt,
werden die Eintrge ignoriert.

:p.Der Dateiname und Pfad der Crontabs-Datei wird ebenfalls angezeigt; zur
:link reftype=hd refid=IDDE_CRON_FILENAMECHANGE.nderung:elink.
mu aber eine Schaltflche benutzt werden.
.*-----------------------------------------------------------------------------
:h3 res=10301 name=IDDE_CRON_ATSTARTUP.CronStart-Abarbeitung
:i1.CronStart-Abarbeitung
:p.Der Dmon beherrscht im Unterschied zur Unixversion auch die
Programmausfhrung beim Start des Dmon. Whrend in einem (greren)
Unixsystem diese Option unsinnig ist, ist sie unter OS/2 eine willkommene
Bereicherung der Mglichkeiten, da regelmig zu startende Programme
nachgezogen werden knnen. (Selbstverstndlich kann man auch die
Standardmglichkeiten von Startup.CMD oder den Systemstart-Ordner nutzen.)
Es ist auch eine Benutzerabrechnung im Verbund mit
:link reftype=hd refid=IDDE_CRON_ATEXIT.CronStop-Abarbeitung:elink. mglich,
sofern das Programm (als Referenz) im Systemstart-Ordner plaziert wurde oder
anderweitig beim Hochfahren des OS/2 gestartet wird.

:p.Weitere Hinweise fr die Gestaltung der Crontabs-Eintrge findet man in der
:link reftype=hd refid=XMP_SYNTAX.Syntaxbeschreibung:elink. und bei den
:link reftype=hd refid=XMP_XMP.Beispielen:elink..

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink..
.*-----------------------------------------------------------------------------
:h3 res=10302 name=IDDE_CRON_ATEXIT.CronStop-Abarbeitung
:i1.CronStop-Abarbeitung
:p.Der Dmon beherrscht im Unterschied zur Unixversion auch die
Programmausfhrung beim Ende des Dmon. Diese Mglichkeit ist mit Bedacht
zu benutzen, da der Dmon sich kurz nach der Aufforderung zum Beenden wirklich
beendet. Es empfiehlt sich, die Programme mittels dem OS/2-Befehl
:hp2.start:ehp2. aufzurufen, da der Dmon nur eine kurze Verzgerung akzeptiert
(ca. 1 Sekunde), um dann zu sterben.
In dieser Zeit lassen sich jedoch noch sinnvolle Arbeiten fr den
Systemabschlu starten, die man hufiger mal vergit. Dazu knnen sowohl
Benutzerabrechnungen als auch externe, kompliziertere Programmbeendigungen
z.B. im Netzwerk zhlen.

:p.Weitere Hinweise fr die Gestaltung der Crontabs-Eintrge findet man in der
:link reftype=hd refid=XMP_SYNTAX.Syntaxbeschreibung:elink. und bei den
:link reftype=hd refid=XMP_XMP.Beispielen:elink..

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink..
.*-----------------------------------------------------------------------------
:h3 res=10303 name=IDDE_CRON_FILENAME.Dateiname
:i1.Dateiname (Crontabs)
:p.Der Dateiname fr die Crontabs-Datei lt sich nur durch das Anwhlen der
Schaltflche
:link reftype=hd refid=IDDE_CRON_FILENAMECHANGE.Dateiname ndern:elink.
verndern. Es wird der aktuelle Pfad und Dateiname der Crontabs-Datei
angezeigt. Nach dem ersten Aufruf des Programms wird standardgem die
Datei :hp2.Crontabs:ehp2. aus dem gleichen Verzeichnis gewhlt, wo auch der
Cron Dmon steht. Treten dabei Fehler auf (Schreibschutz, Verzeichnis namens
:hp2.Crontabs:ehp2. existiert, etc.), so wird die Datei :hp2.nul:ehp2. gewhlt.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink..
.*-----------------------------------------------------------------------------
:h3 res=10304 name=IDDE_CRON_FILENAMECHANGE.Dateiname ndern
:i1.ndern des Dateinamens (Crontabs)
:p.Mit dieser Schaltflche lt sich der Dateiname und der Pfad der
Crontabs-Datei verndern. Dabei wird ein Standardfenster des Systems geffnet,
das auch von anderen Programmen genutzt wird, um Dateien einzulesen.

:p.Falls die angegebene Datei noch nicht existiert, so wird sie angelegt.
Es mu ein normaler Dateiname angegeben werden. Die einzige Ausnahme ist die
Datei :hp2.nul:ehp2., die als "Notdatei" fr Fehler fungiert. Falls die
Datei bereits existiert, so wird nach der Besttigung der Inhalt berprft.
Dabei mu fr jede Zeile die
:link reftype=hd refid=XMP_SYNTAX.Syntax:elink. eingehalten werden. Nur nach
dem erfolgreichen Einlesen der Datei wird die ursprngliche Datei geschlossen
und die neue verwendet.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink..
.*=============================================================================
:h2 res=10310 name=IDD_CRONTABS.Crontabs-Eintrge
:i1.Crontabs-Eintrge
:i1.Eintrge
:p.Diese Seite aus dem :link
reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink.
erlaubt es, die einzelnen Eintrge aus der Crontabs-Datei zu verndern und
anzusehen.

:p.Durch das Auswhlen von :link
reftype=hd refid=IDDE_CRONTABS_ADD.Hinzufgen:elink. wird der im
Feld :link
reftype=hd refid=IDDE_CRONTABS_ENTRY.Neuer Befehl:elink. eingesetzte Befehl
an die bestehende Datei angehngt und zur gegebenen Zeit ausgefhrt. Der Befehl
mu die
:link reftype=hd refid=XMP_SYNTAX.Syntax:elink. eingehalten.

:p.Das Auswhlen von :link
reftype=hd refid=IDDE_CRONTABS_CHANGE.ndern:elink. entspricht einem Lschen
und gleichzeitigem Hinzufgen des zu bearbeitenden Eintrags.

:p.Durch das Auswhlen von :link
reftype=hd refid=IDDE_CRONTABS_ABORT.Abbruch:elink. wird ein Bearbeitungswunsch
eines Eintrags widerrufen.

:p.Durch das Auswhlen von :link
reftype=hd refid=IDDE_CRONTABS_DELETE.Lschen:elink. werden alle
markierten Elemente der :link
reftype=hd refid=IDDE_CRONTABS_LIST.Eintragsliste:elink. gelscht.

:p.Durch das Auswhlen von :link
reftype=hd refid=IDDE_CRONTABS_EDIT.Bearbeiten:elink. wird das markierte
Element der :link reftype=hd refid=IDDE_CRONTABS_LIST.Eintragsliste:elink.
in das Editierfeld kopiert. Nach erfolgter Bearbeitung kann man durch das
Drcken von :link
reftype=hd refid=IDDE_CRONTABS_CHANGE.ndern:elink. das Element ersetzen.

:p.Alle Druckknpfe sind nur dann ausfhrbar, wenn eine gltige Operation
damit mglich ist.
.*-----------------------------------------------------------------------------
:h3 res=10311 name=IDDE_CRONTABS_LIST.Eintragsliste
:i1.Eintragsliste
:p.In dieser Liste sind alle vorhandenen Eintrge der Crontabs-Datei
aufgefhrt. Man kann einzelne Elemente mit der linken Maustaste oder der
Leertaste auswhlen und die dann ber die Schaltflche :link
reftype=hd refid=IDDE_CRONTABS_DELETE.Lschen:elink. entfernen.
:hp2.Vorsicht, es gibt keine Funktion zum Zurcknehmen des Lschvorgangs.:ehp2.

:p.Alternativ kann man auch einen Eintrag :link
reftype=hd refid=IDDE_CRONTABS_EDIT.bearbeiten:elink..

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10312 name=IDDE_CRONTABS_ENTRY.Crontabs-Eintrag
:i1.Crontabs-Eintrag (Neu)
:p.In diesem Feld kann ein neuer Crontabs-Befehl eingesetzt werden. Er mu die
:link reftype=hd refid=XMP_SYNTAX.Syntax:elink.konventionen einhalten. Nach dem
Editieren drckt man die Schaltflche :link
reftype=hd refid=IDDE_CRONTABS_ADD.Hinzufgen:elink., um den Eintrag
in die Crontabs-Datei zu bertragen. Treten keine Fehler auf, wird das Feld
gelscht und der Eintrag an das Ende der :link
reftype=hd refid=IDDE_CRONTABS_LIST.Eintragsliste:elink. gesetzt. Bei einem
Fehler verbleibt die Eingabe im Feld und es wird eine Fehlermeldung angezeigt.

:p.Wurde das Eintragsfeld durch das :link
reftype=hd refid=IDDE_CRONTABS_EDIT.Bearbeiten:elink. eines vorhandenen
Eintrags gefllt, kann man den alten Eintrag mit :link
reftype=hd refid=IDDE_CRONTABS_CHANGE.ndern:elink. ersetzen oder mit :link
reftype=hd refid=IDDE_CRONTABS_ABORT.Abbruch:elink. den nderungswunsch
zurckweisen.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10313 name=IDDE_CRONTABS_ADD.Eintrag hinzufgen
:i1.Crontabs-Eintrag hinzufgen
:p.Durch das Benutzen dieser Schaltflche wird der im Feld :link
reftype=hd refid=IDDE_CRONTABS_ENTRY.Neuer Befehl:elink. eingegebene Eintrag
berprft und gegebenenfalls in die Liste der vorhandenen Eintrge bernommen.

:p.Der Eintrag mu die
:link reftype=hd refid=XMP_SYNTAX.Syntax:elink.konventionen einhalten.
Bei einem Fehler verbleibt die Eingabe im Feld und es wird eine Fehlermeldung
angezeigt.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10316 name=IDDE_CRONTABS_CHANGE.Eintrag ndern
:i1.Crontabs-Eintrag ndern
:p.Durch das Benutzen dieser Schaltflche wird der im Feld :link
reftype=hd refid=IDDE_CRONTABS_ENTRY.Neuer Befehl:elink. eingegebene Eintrag
berprft und gegebenenfalls in die Liste der vorhandenen Eintrge bernommen.
Er ersetzt dabei den Eintrag, aus dem der Inhalt des Eintragsfeld entstanden
ist.

:p.Der Eintrag mu die
:link reftype=hd refid=XMP_SYNTAX.Syntax:elink.konventionen einhalten.
Bei einem Fehler verbleibt die Eingabe im Feld und es wird eine Fehlermeldung
angezeigt.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10317 name=IDDE_CRONTABS_ABORT.Eintragsbearbeitung abbrechen
:i1.Crontabs-Eintragsnderung abbrechen
:p.Durch das Benutzen dieser Schaltflche wird die Bearbeitung eines
existierenden Eintrags abgebrochen. Das Eintragsfeld wird dabei gelscht.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10314 name=IDDE_CRONTABS_DELETE.Eintrge lschen
:i1.Crontabs-Eintrge lschen
:p.Alle markierten Eintrge aus der
:link reftype=hd refid=IDDE_CRONTABS_LIST.Eintragsliste:elink. werden
unwiderruflich gelscht.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*-----------------------------------------------------------------------------
:h3 res=10315 name=IDDE_CRONTABS_EDIT.Eintrag bearbeiten
:i1.Crontabs-Eintrag bearbeiten
:p.Der markierte Eintrag aus der
:link reftype=hd refid=IDDE_CRONTABS_LIST.Eintragsliste:elink. wird zur
Vernderung in das Feld :link
reftype=hd refid=IDDE_CRONTABS_ENTRY.Neuer Befehl:elink. kopiert. Der Eintrag
verbleibt aus Sicherheitsgrnden in der Liste und wird durch das Drcken
von :link
reftype=hd refid=IDDE_CRONTABS_CHANGE.ndern:elink. ersetzt. Mit :link
reftype=hd refid=IDDE_CRONTABS_ABORT.Abbruch:elink. kann man den
nderungswunsch zurckweisen.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink..
.*=============================================================================
:h2 res=10400 name=IDD_OUTPUT.Ausgabe
:i1.Ausgabe
:p.Diese Seite aus dem :link
reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink.
erlaubt es, den Ausgabepfad und die Eigenschaften der Ausgabe vom Dmon und
den aufgerufenen Programmen festzulegen.

:p.Durch das Auswhlen von :link
reftype=hd refid=IDDE_OUTPUT_COUNT.Anzahl der Ausgabedateien:elink. und :link
reftype=hd refid=IDDE_OUTPUT_THRES.Dateigre-Schwellenwert:elink. legt man
den maximal benutzten Plattenplatz fest.

:p.Der Pfad der Ausgabedateien wird ebenfalls angezeigt; zur
:link reftype=hd refid=IDDE_OUTPUT_PATHCHANGE.Pfadnderung:elink.
mu aber eine Schaltflche benutzt werden.

:p.Es besteht die Mglichkeit, alle :link
reftype=hd refid=IDDE_OUTPUT_IGNORE_OUTPUT.Ausgaben zu ignorieren:elink..

:p.Die Unixversion von Cron schickt jedem Benutzer zu jedem Auftrag dessen
Ausgabe und den Programmstatus per Post zu. Da OS/2 weder ein standardisiertes
Postsystem, noch Multiuserfhigkeit besitzt, schien es geschickter, alle
Ausgaben und Meldungen in eine Datei zu lenken. Bei unregelmiger Wartung
wrde aber nach und nach die Plattenkapazitt berschritten. Deshalb wird
immer dann auf eine neue Datei gewechselt, wenn der Schwellenwert berschritten
wurde. Alle Ausgabedateien haben den Dateinamen :hp2.Cron000?.out:ehp2..
Dabei durchluft das Fragezeichen alle Ziffern von 0 bis zur gegebenen Anzahl
der Ausgabedateien.

:p.Die aktuelle Ausgabedatei ist im permanenten Zugriff, sofern die Ausgabe
nicht komplett ignoriert wird. Nicht alle Programme kommen mit diesem Zugriff
zurecht, um die Datei anzuzeigen. (Der Befehl TYPE funktioniert aber.)
.br
Deshalb kann man im Men die :link
reftype=hd refid=IDME_NEXTFILE.nchste Ausgabedatei:elink. auswhlen, um die
aktuelle Ausgabedatei freizugeben. Diese kann dann editiert oder angesehen
werden.
.*-----------------------------------------------------------------------------
:h3 res=10401 name=IDDE_OUTPUT_THRES.Schwellenwert
:i1.Schwellenwert
:p.Die aktuelle Ausgabedatei wird nach dem Erreichen des Schwellenwertes
gewechselt. Es knnen nur vorgewhlte Schwellenwerte benutzt werden.

:p.Der Zusammenhang mit den anderen Werten ist in der Hilfe zur
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. beschrieben.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10402 name=IDDE_OUTPUT_COUNT.Dateianzahl
:i1.Ausgabe-Dateianzahl
:p.Die Ausgabedateien durchlaufen die Namen :hp2.Cron000?.out:ehp2., wobei das
Fragezeichen die Werte von 0 bis zur Anzahl annimmt.

:p.Der Zusammenhang mit den anderen Werten ist in der Hilfe zur
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. beschrieben.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10403 name=IDDE_OUTPUT_PATH.Pfad
:i1.Ausgabepfad
:p.Dieses Feld zeigt den Pfad fr die Ausgabedateien. Der voreingestellte Wert
ist der Pfad, von dem der Dmon gestartet wurde, also nicht das jeweils
aktuelle Verzeichnis.

:p.Zur nderung mu die Schaltflche
:link reftype=hd refid=IDDE_OUTPUT_PATHCHANGE.Pfad ndern:elink. benutzt
werden. Dann wird die zugehrige
:link reftype=hd refid=IDD_OUTPUT_PATH.Auswahlbox:elink. geffnet.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10404 name=IDDE_OUTPUT_PATHCHANGE.Pfad ndern
:i1.Ausgabepfad ndern (Schaltflche)
:p.Mit dieser Schaltflche ffnet sich eine
:link reftype=hd refid=IDD_OUTPUT_PATH.Auswahlbox:elink., mit der der Pfad
fr die Ausgabedateien verndert werden kann. Nach einer erfolgreichen
Vernderung wird der Pfad im
:link reftype=hd refid=IDDE_OUTPUT_PATH.Anzeigefeld:elink. aufgefrischt.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10405 name=IDDE_OUTPUT_IGNORE_OUTPUT.Ausgabe ignorieren
:i1.Ausgabe ignorieren
:p.Es ist mglich, alle Ausgaben sowohl des Dmons, als auch der aufgerufenen
Programme zu ignorieren, sie werden dann nicht in eine Datei geschrieben.

:p.Diese Einstellung ist die Voreinstellung beim ersten Programmstart. Es wird
empfohlen, die Einstellungen auf dieser Seite den lokalen Bedrfnissen
anzupassen und die Ausgabe dann freizugeben, um Fehler bei den Programmen zu
erkennen.

:p.Falls diese Auswahl gesetzt ist, ist die Wahl der :link
reftype=hd refid=IDME_NEXTFILE.nchsten Ausgabedatei:elink. im Hauptmen nicht
mglich.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink..
.*-----------------------------------------------------------------------------
:h3 toc=4 res=10410 name=IDD_OUTPUT_PATH.Ausgabepfad ndern
:i1.Ausgabepfad ndern (Dialog)
:p.Dieses Dialogfenster ffnet sich durch das Bedienen der Schaltflche zum
:link reftype=hd refid=IDDE_OUTPUT_PATHCHANGE.Pfad ndern:elink..

:p.Der aktuelle Pfad der Ausgabedateien wird im :link
reftype=hd refid=IDDE_OUTPUT_PATH_ENTRY.Ausgabepfad-Eingabefeld:elink.
angezeigt. Bei jedem doppelten Mausklick in die :link
reftype=hd refid=IDDE_OUTPUT_PATH_LIST.Ausgabepfad-Liste:elink. wird der
entstehende Pfad neu angezeigt.

:p.Selbstverstndlich kann man den neuen Pfad auch per Hand eingeben.

:p.Diese Dialogbox wird von der Seite
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink.
aufgerufen.
.*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:h4 res=10411 name=IDDE_OUTPUT_PATH_ENTRY.Ausgabepfad-Eingabefeld
:i1.Ausgabepfad-Eingabefeld
:p.Das Eingabefeld fr die Ausgabe wird entweder durch eine Benutzereingabe
oder durch das Bedienen der
:link reftype=hd refid=IDDE_OUTPUT_PATH_LIST.Ausgabepfad-Liste:elink.
verndert. Initial wird der Wert auf den aktuellen Ausgabepfad gesetzt.

:p.Nach dem Drcken der Besttigungstaste wird berprft, ob der Pfad
tauglich ist. Dazu mu er existieren und die Mglichkeit bestehen, zehn
Dateien der Form :hp2.Cron000?.out:ehp2. zu erzeugen oder zu verndern.
Das Fragezeichen durchluft dabei alle Dezimalziffern.
.br
Bei einem Fehler wird ein Mitteilungsfenster geffnet und auf den Umstand
hingewiesen. Man mu dann einen anderen Pfad whlen, abbrechen oder mit
einem anderen Programm den Fehler beheben (z.B. den Pfad anlegen).

:p.Dieser Eintrag befindet sich in der Dialogbox zur
:link reftype=hd refid=IDD_OUTPUT_PATH.nderung des Pfades:elink., die von
der Seite
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink.
aufgerufen wird.
.*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
:h4 res=10412 name=IDDE_OUTPUT_PATH_LIST.Ausgabepfad-Liste
:i1.Ausgabepfad-Liste
:p.Mit der Liste fr Ausgabepfade hat man eine komfortable Mglichkeit,
den aktuellen Ausgabepfad zu verndern.

:p.In der Liste sind die Laufwerksbuchstaben (ohne Floppies) und alle
Unterverzeichnisse des aktuellen Pfades vertreten. Durch ein doppeltes Klicken
der linken Maustaste auf eine dieser Komponenten wird sie ausgewhlt und an
den aktuellen Pfad angehngt, bzw. der aktuelle Pfad ersetzt.

:p.Das
:link reftype=hd refid=IDDE_OUTPUT_PATH_LIST.Ausgabepfad-Eingabefeld:elink.
pat seinen Wert automatisch an. Durch das Bedienen der Eingabetaste wird die
aktuelle Auswahl bernommen und der Wert des Eingabefeldes getestet.

:p.Dieser Eintrag befindet sich in der Dialogbox zur
:link reftype=hd refid=IDD_OUTPUT_PATH.nderung des Pfades:elink., die von
der Seite
:link reftype=hd refid=IDD_OUTPUT.Ausgabe:elink. im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink.
aufgerufen wird.
.*=============================================================================
:h2 toc=3 res=10500 name=IDD_TCP.TCP/IP
:i1.TCP/IP
:p.Diese Seite aus dem :link
reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink.
erlaubt es, die Mglichkeiten einer Bedienung durch TCP/IP-vernetzte
Fremdmaschinen festzulegen.

TCP/IP kennt keinen eigenen Zugriffsschutz. Es ist dem System nicht mglich,
einzelne Kommunikationen zu verbieten. Um nicht eine riesige Sicherheitslcke
aufzutun, erlaubt der Cron Dmon nur die Kommunikation mit bestimmten
Partnerrechnern ber TCP/IP. Die Namen der Partnerrechner stehen in einer
Datei, pro Rechner eine Zeile. Jeder Rechnername darf in der Nummernnotation
(z.B. 128.176.248.76) oder in der allgemeinen Namenskonvention (z.B.
Sauron@uni-muenster.de) angegeben werden.

:p.Der Dateiname und Pfad der Erlaubnisdatei wird in einem Feld angezeigt; zur
:link reftype=hd refid=IDDE_TCP_FILENAMECHANGE.nderung:elink.
mu aber eine Schaltflche benutzt werden.

:p.Erst durch das Auswhlen von :link
reftype=hd refid=IDDE_TCP_ALLOWACCESS.Zugriff erlauben:elink. wird ein
prinzipieller Zugriff von Fremdrechnern mglich.
.br
Falls auf dem aktuellen Rechner kein TCP/IP installiert ist, ist diese
Schaltflche nicht anwhlbar.

:p.Die Bearbeitung der Crontabs-Datei aus der Ferne erfolgt durch das
Hilfsprogramm :hp2.crontab:ehp2..

:p.Die Portnummer des Cron Dmons ist 64020.
.*-----------------------------------------------------------------------------
:h3 res=10501 name=IDDE_TCP_FILENAME.Dateiname
:i1.Dateiname (TCP/IP-Zugriffserlaubnisse)
:p.Der Dateiname fr die TCP/IP-Zugriffserlaubnisse lt sich nur durch das
Anwhlen der Schaltflche
:link reftype=hd refid=IDDE_TCP_FILENAMECHANGE.Dateiname ndern:elink.
verndern. Es wird der aktuelle Pfad und Dateiname der Erlaubnisdatei-Datei
angezeigt. Nach dem ersten Aufruf des Programms wird standardgem die
Datei :hp2.nul:ehp2. benutzt.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_TCP.TCP/IP-Zugriffe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10502 name=IDDE_TCP_FILENAMECHANGE.Dateiname ndern
:i1.ndern des Dateinamens (TCP/IP-Zugriffserlaubnisse)
:p.Mit dieser Schaltflche lt sich der Dateiname und der Pfad der
TCP/IP-Zugriffserlaubnis-Datei verndern. Dabei wird ein Standardfenster des
Systems geffnet, das auch von anderen Programmen genutzt wird, um Dateien
einzulesen.

:p.Falls die angegebene Datei noch nicht existiert, so wird sie angelegt.
Es mu ein normaler Dateiname angegeben werden. Die einzige Ausnahme ist die
Datei :hp2.nul:ehp2., die als "Notdatei" fr Fehler fungiert. Falls die
Datei bereits existiert, so wird nach der Besttigung der Inhalt berprft.
Dabei mu in jeder Zeile ein Rechnername in IP-Notation stehen. Leerzeilen und
Zeilen, die mit einem Doppelkreuz (:hp2.#:ehp2.) oder Semikolon (:hp2.;:ehp2.)
beginnen, werden als Kommentarzeilen angesehen und ignoriert.
Nur nach dem erfolgreichen Einlesen der Datei wird die ursprngliche Datei
geschlossen und die neue verwendet.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_TCP.TCP/IP-Zugriffe:elink..
.*-----------------------------------------------------------------------------
:h3 res=10503 name=IDDE_TCP_ALLOWACCESS.Zugriff erlauben
:i1.TCP/IP-Zugriff erlauben
:i1.Zugriff erlauben (TCP/IP)
:p.Diese Schaltflche regelt den allgemeinen TCP/IP-Zugang von Fremdrechner.
Ungeachtet der :link
reftype=hd refid=IDDE_TCP_FILENAME.Zugriffserlaubnisdatei:elink., die die
Fremdrechner auflistet, steht hier ein Mittel zur Verfgung, um generell den
Zugriff zu verbieten.

:p.Diese Schaltflche ist nicht anwhlbar, wenn der Rechner nicht mit TCP/IP
ausgestattet ist.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_TCP.TCP/IP-Zugriffe:elink..
.*=============================================================================
:h2 res=10600 name=IDD_GENERAL.Allgemeine Einstellungen
:i1.Allgemeine Einstellungen
:p.Diese Seite aus dem :link
reftype=hd refid=IDDE_NOTEBOOK_PAGES.Notizbuch mit den Einstellungen:elink.
erlaubt es, allgemeine Einstellungen des Programms zu verndern.

Zur Zeit wird auf dieser Seite nur die bevorzugte Sprache ausgewhlt.
Standardgem steht diese beim ersten Programmstart auf "English", sofern
nicht die Umgebungsvariable :hp2.LANG:ehp2. auf etwas anderes verweist.
Untersttzte :hp2.LANG:ehp2.-Werte sind&colon.
:dl compact tsize=15.
:dthd.:hp5.LANG-Wert:ehp5.
:ddhd.:hp5.Sprache:ehp5.
:dt.USA
:dd.English
:dt.UK
:dd.English
:dt.GERM
:dd.Deutsch
:dt.FRAN
:dd.Franais
:edl.
:p.Gendert werden die Sprache durch das Bedienen der :link
reftype=hd refid=IDDE_GENERAL_LANGUAGE.Sprachauswahlliste:elink..
.*-----------------------------------------------------------------------------
:h3 res=10601 name=IDDE_GENERAL_LANGUAGE.Bevorzugte Sprache
:i1.Sprache
:p.Die bevorzugte Sprache lt sich durch das Bedienen dieser Liste auswhlen.
:link refid=NeueSprachen reftype=fn.Es steht nur eine begrenzte Auswahl zur
Verfgung.:elink.

:p.Standardgem steht die Sprache beim ersten Programmstart auf "English",
sofern nicht die Umgebungsvariable :hp2.LANG:ehp2. auf etwas anderes verweist.
In der Hilfe zu den
:link reftype=hd refid=IDD_GENERAL.allgemeinen Einstellungen:elink. stehen dazu
weitere Informationen.


Mgliche Sprachen sind zur Zeit&colon.
:ul.
:li.Deutsch
:li.Englisch
:li.Franzsisch
:eul.

:p.Eine nderung wird erst nach einem Neustart des Programms wirksam.

:p.Dieser Eintrag befindet sich im
:link reftype=hd refid=IDDE_NOTEBOOK_PAGES.Einstellungsnotizbuch:elink. auf der
Seite fr die
:link reftype=hd refid=IDD_GENERAL.allgemeinen Einstellungen:elink..
:fn id=NeueSprachen.Das mag sich ndern, falls ein paar Leute diesem Kram
bersetzen!:efn.
.******************************************************************************
:h1 name=XMP_GENERAL.Beispiele und Syntax von Crontabs-Eintrgen
:p.In diesem Kapitel wird die :link reftype=hd refid=XMP_SYNTAX.Syntax:elink.
der Crontabs-Eintrge beschrieben und die Benutzung anhand von
:link reftype=hd refid=XMP_XMP.Beispielen:elink. demonstriert.

:p.Im Gegensatz zur Syntax des Programms :hp2.crontabs:ehp2. und zu mglichen
Eingaben von :link
reftype=hd refid=IDD_CRONTABS.Crontabs-Eintrge:elink. innerhalb dieses
Programms drfen in der Datei auch Kommentare auftauchen.

:p.Kommentarzeilen sind leere Zeilen oder Zeilen, die in der ersten Spalte ein
Semikolon (:hp2.;:ehp2.) oder Doppelkreuz (:hp2.#:ehp2.) stehen haben.
.*=============================================================================
:h2 name=XMP_SYNTAX.Syntax der Crontabs-Eintrgen
:i1.Syntax der Crontabs-Eintrgen
:p.Die Syntax von Crontabs-Eintrgen ist recht einfach. Jeder Eintrag mu in
einer Zeile stehen. Es wird nicht zwischen Gro- und Kleinschreibung
unterschieden. Jede Zeile hat die Form
:xmp.[Flaggen] Zeiten Kommando:exmp.
:p.Die :hp2.Flaggen:ehp2. sind optional. Mgliche Flaggen sind zur Zeit&colon.
:dl compact.
:dthd.:hp5.Flagge:ehp5.
:ddhd.:hp5.Bedeutung:ehp5.
:dt.:hp2.Once:ehp2.
:dd.Das Kommando wird zur gegebenen Zeit einmal ausgefhrt und danach aus der
Kommandoliste gelscht.
:edl.

:p.Die :hp2.Zeiten:ehp2. haben in der Regel fnf Eintrge, die :hp2.alle:ehp2.
zutreffen mssen, damit das Kommando ausgefhrt wird&colon.
:ol.
:li.:hp2.Minuten:ehp2.
:p.Diese :link refid=Zahlenangabe reftype=fn.Zahlenangabe:elink.
beschreibt die Minute innerhalb der Stunde, in der das
Kommando gestartet werden soll. Mgliche Werte liegen zwischen 0 und 59.
:li.:hp2.Stunden:ehp2.
:lp.Diese :link refid=Zahlenangabe reftype=fn.Zahlenangabe:elink.
beschreibt die Stunde, zu der das
Kommando gestartet werden soll. Mgliche Werte liegen zwischen 0 und 23.
:li.:hp2.Monatstag:ehp2.
:lp.Diese :link refid=Zahlenangabe reftype=fn.Zahlenangabe:elink.
beschreibt den Monatstag, an dem das
Kommando gestartet werden soll. Mgliche Werte liegen zwischen 1 und 31, wobei
das Maximum nicht vom jeweiligen Monat abhngt. Im Februar werden also
Kommandos mit dem Monatstag 31 nicht ausgefhrt, obwohl die Angabe legal ist.
:li.:hp2.Monat:ehp2.
:lp.Diese :link refid=Zahlenangabe reftype=fn.Zahlenangabe:elink.
beschreibt den Monat, in dem das
Kommando gestartet werden soll. Mgliche Werte liegen zwischen 1 und 12.
:li.:hp2.Wochentag:ehp2.
:lp.Diese :link refid=Zahlenangabe reftype=fn.Zahlenangabe:elink.
beschreibt den Wochentag, an dem das
Kommando gestartet werden soll. Mgliche Werte liegen zwischen 0 und 6. Der
Wert 0 beschreibt den Sonntag.
:eol.

:p.Es gibt noch drei Spezialzeiten, die jeweils alle 5 Angaben ersetzen&colon.
:dl compact tsize=15.
:dthd.:hp5.Sonderzeit:ehp5.
:ddhd.:hp5.Bedeutung:ehp5.
:dt.:hp2.Cronstart:ehp2.
:dd.Das Kommando wird beim Start des Dmon ausgefhrt, sofern die Freigabe in
der :link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink. erfolgt
ist.
:dt.:hp2.Cronstop:ehp2.
:dd.Das Kommando wird beim Beenden des Dmon ausgefhrt, sofern die Freigabe in
der :link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink. erfolgt
ist.
.br
:hp1.VORSICHT&colon. Es verbleibt nur eine sehr kurze Verzgerungsfrist,
bevor der Dmon sich dann beendet. Im Falle eines Systemabschlusses kann die
verbliebene Zeit bis zum Booten ggf. nicht ausreichen, um komplizierte
Befehlsfolgen auszufhren. Eventuell wird in spteren Versionen eine
benutzerdefinierbare maximale Verzgerungszeit angeboten, dazu sollten aber
Bedarfswnsche geuert werden.:ehp1.
:dt.:hp2.Daily:ehp2.
:dd.Das Kommando wird einmal tglich bei der ersten Mglichkeit ausgefhrt.
Man beachte, da das Kommando :hp2.nicht:ehp2. beim Hinzufgen zur Liste
ausgefhrt wird, sondern erst ab dem nchsten Tag gestartet wird, falls der
Dmon am aktuellen Tag bereits gelaufen hat oder luft.
:edl.

:p.Als :hp2.Kommando:ehp2. ist jedes beliebige OS/2-Kommando erlaubt. Zur Zeit
gibt es noch keine genauere Spezifizierung des Programmtyps (das ndert sich!),
so da man bei DOS-Programmen am besten den OS/2-Befehl :hp2.start:ehp2. zur
Hilfe nimmt. Die Standardausgaben des Programms werden in einer temporren
Datei gesammelt und beim Beenden des Programms in die :link
reftype=hd refid=IDD_OUTPUT.Ausgabe:elink.datei kopiert. Da bei der Benutzung
von :hp2.start:ehp2. ein weiterer, unabhngiger Proze gestartet wird, der
sich der Kontrolle des Dmons entzieht, sollte die Ausgabe der Programme
gelscht oder umgelenkt werden. Dazu gibt man am Ende der Zeile
:xmp. >Datei 2>&amp.1:exmp.
:p.an. Als Dateiname kann man die Datei :hp2.nul:ehp2. angeben, um die Ausgabe
zu ignorieren. Da PM-Programme normalerweise keine Ausgabe haben, sollte dies
bei solchen Programmen immer angegeben werden.

:p.Die temporren Dateien werden im gleichen Unterverzeichnis erzeugt, wo auch
das Programm des Cron Dmon steht. Es empfiehlt sich, "Leichen" durch die
beiden Crontabs-Befehle
:xmp.
Cronstart del ?&colon.\Pfad\*.tmp >nul 2>&amp.1
0 3 * * 0 del ?&colon.\Pfad\*.tmp >nul 2>&amp.1
:exmp.
:p.regelmig zu entfernen. Das Fragezeichen und Pfad sollten durch die
entsprechenden Werte ersetzt werden.

:fn id=Zahlenangabe.Eine Zahlenangabe ist eine durch Kommata getrennte Liste
von Zahlen oder Zahlintervallen, die das Ereignis treffen mssen.
Ein Stern (:hp2.*:ehp2.) bedeutet&colon.
jede mgliche Zahl. Beispiele&colon.
:xmp.1,2,5:exmp.
:p.oder
:xmp.8-12,14-18:exmp.
:p.oder
:xmp.*:exmp.:efn.
.*=============================================================================
:h2 name=XMP_XMP.Beispiele fr Crontabs-Eintrge
:i1.Beispiele
:p.Es gibt eine Vielzahl von Einsatzmglichkeiten des Cron Dmon, von denen
einige anhand von Beispielen vorgestellt werden sollen. Dabei werden als
Kommandos auch Programmnamen benutzt, die garantiert nicht auf jedem System
verfgbar sind, aber durch ihre sprechenden Namen den Einsatz aufzeigen.

:ul.
:li.:font facename=Courier size=18x10.* * * * * echo Eine Minute ist um.:font
facename=default size=0x0.
:p.Jede Minute in jeder Stunde an jedem beliebigen Tag wird die Zeile
:hp2.Eine Minute ist um.:ehp2. ausgegeben. Diese Ausgabe des Kommandos echo
wird in die :link
reftype=hd refid=IDD_OUTPUT.Ausgabe:elink.datei des Cron Dmons kopiert.
:li.:font facename=Courier size=18x10.0 * * * * echo Eine Stunde ist um. >nul 2>&amp.1:font
facename=default size=0x0.
:p.Zu jeder vollen Stunde an jedem beliebigen Tag wird die Zeile
:hp2.Eine Stunde ist um.:ehp2. ausgegeben. Da die Ausgabe aber verworfen wird,
ist dieser Befehl unsinnig (echo ist ja nur fr Ausgaben zustndig). Immerhin
erscheint noch in der Ausgabedatei des Dmons die Mitteilung, da das Programm
gestartet wurde, sofern die Ausgabefunktionen prinzipiell benutzt werden.
:li.:font facename=Courier size=18x10.0,30 * * * * DeliverMail:font
facename=default size=0x0.
:p.Zu jeder vollen und halben Stunde wird das Programm DeliverMail gestartet.
Alle Ausgaben des Programms erscheinen auch in der Ausgabedatei des Dmons.
:li.:font facename=Courier size=18x10.0,30 * * * * start PMDeliverMail >nul 2>&amp.1:font
facename=default size=0x0.
:p.Zu jeder vollen und halben Stunde wird das Programm PMDeliverMail in einer
separaten Sitzung gestartet (ntig bei PM-Programmen!). Alle Ausgaben werden
verworfen.
:li.:font facename=Courier size=18x10.0 3 * * 0 MyBackup /weekly:font
facename=default size=0x0.
:p.An jedem Sonntag um drei Uhr morgens wird das Programm MyBackup mit dem
Parameter /weekly gestartet.
:li.:font facename=Courier size=18x10.0 3 1 * * MyBackup /monthly:font
facename=default size=0x0.
:p.An jedem 1. eines Monats um drei Uhr morgens wird das Programm MyBackup mit
dem Parameter /monthly gestartet.
:li.:font facename=Courier size=18x10.Once 0 3 1 4 * time 4&colon.0&colon.0:font
facename=default size=0x0.
:p.Am 1. April um 3 Uhr morgens wird einmalig die Zeit um eine Stunde
vorgestellt.
:li.:font facename=Courier size=18x10.Once * * * * * setboot /b >nul 2>&amp.1:font
facename=default size=0x0.
:p.Die Maschine wird einmalig (wichtig!) zum nchstmglichen Zeitpunkt neu
gestartet. Alle Ausgaben des Programms werden ignoriert. Vorsicht bei einer
Nachahmung, :hp2.setboot /b:ehp2. entspricht einem Drcken von Alt-Strg-Entf.
Dieser Befehl kann z.B. ntzlich sein, um einem Stromausfall zuvorzukommen.
(Na gut, das wei man nicht immer vorher, aber wenn der/die Kollege/in gerade
an Kabeln von ungeschtzten Stromkreisen rumfummelt, kann dies noch die letzte
Rettung fr das Plattensystem eines Servers drei Rume weiter sein. Alles
schon erlebt...)
:li.:font facename=Courier size=18x10.0 3 * * * deltree f&colon.\tmp &amp. mkdir f&colon.\tmp &amp. echo Das Verzeichnis wird morgens um drei gelscht! > f&colon.\tmp\Warnung.!!!:font
facename=default size=0x0.
:p.Um drei Uhr morgens wird zuerst der Befehl deltree mit dem Parameter
f&colon.\tmp aufgerufen, dann das Verzeichnis neu erzeugt und eine
Warnungsdatei in diesem Verzeichnis generiert. Alles geschieht ber einen
einzigen Befehlsinterpreter, so da die Ausgaben der Programme schn
hintereinander in der Ausgabedatei des Dmon stehen.
:li.:font facename=Courier size=18x10.Cronstart del c&colon.\cron\*.tmp >nul 2>&amp.1:font
facename=default size=0x0.
:p.Bei jedem Start des Dmons werden alle temporren Dateien aus dem
Cron-Verzeichnis auf Laufwerk C gelscht. Alle Ausgaben werden ignoriert.

:p.Dieser Befehl wird nur dann ausgefhrt, wenn auch die Freigabe in
der :link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink. erfolgt
ist.

:p.Dieser Befehl ist recht ntzlich, da erfahrungsgem immer ein paar
temporre Dateien vom Dmon nicht gelscht werden knnen. Das ist kein Fehler
des Dmons, sondern meistens eine fehlerhafte Crontabs-Zeile mit
:hp2.start:ehp2. aber ohne Ausgabeumlenkung. (Die temporre Ausgabedatei ist
dann fr den Dmon blockiert.)
:li.:font facename=Courier size=18x10.Cronstop echo Abgemeldet&colon. >> \Zeiten\florian &amp. time >> \Zeiten\florian:font
facename=default size=0x0.
:p.Beim jedem Beenden des Dmons werden wird eine Meldung und die aktuelle
Uhrzeit an eine Datei angehngt. Da der Befehl :hp2.time:ehp2. von der
Standardeingabe liest, diese aber vom Dmon standardgem auf :hp2.nul:ehp2.
gelegt wurde, entfllt eine Umstellung der Uhrzeit, sie wird nur angezeigt.

:p.Dieser Befehl wird nur dann ausgefhrt, wenn auch die Freigabe in
der :link reftype=hd refid=IDD_CRON_FILE.Crontabs-Bearbeitung:elink. erfolgt
ist.

:p.Zusammen mit einem hnlichen Befehl whrend des Hochfahrens lt sich so
ein rudimentres Abrechnungsprotokoll fahren. Als Voraussetzung dazu sollte man
aber auch den Cron Dmon schon beim Systemstart aktivieren. Das kann man z.B.
dadurch realisieren, indem man eine Referenz oder Kopie vom Dmon in den
Systemstart-Ordner bringt.

:p.:hp1.VORSICHT&colon. Es verbleibt nur eine sehr kurze Verzgerungsfrist,
bevor der Dmon sich dann beendet. Im Falle eines Systemabschlusses kann die
verbliebene Zeit bis zum Booten ggf. nicht ausreichen, um komplizierte
Befehlsfolgen auszufhren. Eventuell wird in spteren Versionen eine
benutzerdefinierbare maximale Verzgerungszeit angeboten, dazu sollten aber
Bedarfswnsche geuert werden.:ehp1.
:li.:font facename=Courier size=18x10.Daily VirusCheck:font
facename=default size=0x0.
:p.Tglich wird einmal zum frhestmglichen Zeitpunkt das Programm
VirusCheck gestartet.
Man beachte, da das Kommando :hp2.nicht:ehp2. beim Hinzufgen zur Liste
ausgefhrt wird, sondern erst ab dem nchsten Tag gestartet wird, falls der
Dmon am aktuellen Tag bereits gelaufen hat oder luft.
:li.:font facename=Courier size=18x10.0 8-12,14-18 * * 1-5 start PMBeep >nul 2>&amp.1:font
facename=default size=0x0.
:p.Von Montag bis Freitag wird zu jeder vollen Stunde zwischen 8 und 12 sowie
zwischen 14 und 18 Uhr das Programm PMBeep gestartet. Das Programm luft in
einer separaten Sitzung, Ausgaben werden ignoriert.
:eul.
.******************************************************************************
:h1 name=LAN_NETWORK.Benutzung im LAN und unter Netware
:i1.Netzwerk
:i1.Novell-Netware
:i1.LAN-Zugriff
:p.Die Kommunikation mit dem Cron Dmon funktioniert am besten durch den
LAN-Zugriff auf eine Named Pipe, da diese Kommunikationsart vom OS/2 direkt
untersttzt wird.

:p.Innerhalb eines Netzwerkes ist diese Kommunikationsart ebenfalls mglich.
Sowohl das LAN, als auch Novell-Netware bieten dabei Pipe-Komponenten an.
Beide bieten explizite Zugriffsschutzmechanismen, so da der Dmon darauf
verzichten kann.

:p.Um den Dmon innerhalb des Netzwerkes zur Verfgung zu stellen, mu man
mit den jeweiligen Zugriffsschutz-Programmen (z.B. :hp2.net access:ehp2. im
LAN) den Zugriff auf die Pipe
:xmp.
\pipe\Cron-Daemon-Request
:exmp.
:p.fr die gewnschten Benutzer(-gruppen) erlauben. Danach kann mit dem
Hilfsprogramm :hp2.crontab:ehp2. die Crontabs-Datei des Rechner fernbedient
werden.
.******************************************************************************
:h1.Neues zwischen den Versionen
:p.Dieses Kapitel enthlt alle greren nderungen zwischen den Versionen.
:ul.
:li.:link
reftype=hd refid=CHANG_120_112.nderungen zwischen der Version 1.20 und
Version 1.12:elink.
:eul.
.*=============================================================================
:h2 name=CHANG_120_112.nderungen zwischen der Version 1.20 und Version 1.12
:p.Folgende nderungen sind in Version 1.20 erfolgt&colon.
:ul compact.
:li.Kosmetische nderungen und diverse Fehlerbeseitigungen.
:li.Untersttzung fr franzsische Meldungen und Hilfe.
:li.In der PM-Version des Dmons kann ein Job verndert werden.
:li.In Kommandos knnen die Zeiten nun auch als Intervalle angegeben werden.
:hp2.0,4,5,6,9:ehp2. kann auch als :hp2.0,4-6,9:ehp2. angegeben werden.
:li.Die Spezialzeit :hp2.Daily:ehp2. erlaubt das Starten eines Kommandos zum
frhestmglichen Zeitpunkt an einem Tag, aber nur einmal pro Tag.
:li.Farben und Font des Hauptfensters knnen nun ber die Schriftartpalette
und die Farbpalette der Systemkonfiguration gendert werden, die Werte
berdauern einen Programmabschlu.
.br
Zum ndern der Vordergrundfarbe benutze man die Taste [Strg] mit der zweiten
Maustaste.
:li.Neben der Position wird nun auch die Darstellung des Fensters (minimiert,
maximiert oder normal) beim Programmabschlu gespeichert und bernommen.
:eul.
.******************************************************************************
:h1.Selbstbeweihrucherung
:p.Dieses Programm wurde unter OS/2 fr EMX als PM-Programm entwickelt.
Tips, Fehlermeldungen und Verbesserungsvorschlge (siehe Datei
:hp2.program!:ehp2.) werden dankend entgegengenommen.

:p.Bei Wnschen sollte man :hp2.vorher:ehp2. die Datei :hp2.wishlist:ehp2.
durchsehen, ob der Wunsch bereits registriert ist.

:p.Der Klau von Funktionen, Teilen von Programmen oder ganzen Dateien ist
explizit erlaubt. Bei ganzen Dateien oder kaum unterscheidbaren Dateien
greifen aber die allgemeinen Lizenzbestimmungen, damit andere Benutzer nicht
durch defekte Dateien irregeleitet werden. Spenden werden von jedem Sozialamt
gerne entgegengenommen, bei mir reicht 'ne mail mit 'nem simplen
"nicht schlecht".

:p.Vielen Dank an Leonard Hesker. Er hat die englische Version der Hilfe
durchgesehen.

:p.Ebenfalls vielen Dank an die Folgenden. Sie haben den Cron Dmon in die
anderen Sprachen bersetzt&colon.
:parml compact tsize=15 break=none.
:pt.Franzsisch
:pd.Raphal Vanney
:eparml.

:p.Florian Groe-Coosmann
.br
E-Mail im Internet&colon. :font facename=Courier size=18x10.coosman@uni-muenster.de:font
facename=default size=0x0.
:euserdoc.
.* RCS depending informations
.*
.* $Id: cronddeu.ipf 1.3 1995/10/18 11:13:21 Florian Rel $
.*
.* $Name: Version121 $
.*
.* $Log: cronddeu.ipf $
.* Revision 1.3  1995/10/18 11:13:21  Florian
.* Control pushbuttons added.
.*
.* Revision 1.2  1995/10/18 09:46:06  Florian
.* Some cosmetic changes.
.* Chapters Farben und Schriftart and Neues zwischen den Versionen added.
.* Crontabs Chapter rewritten.
.* Daily and intervals explained in XMP and SYNTAX.
.* Added support of the French language.
.*
.* Revision 1.1  1995/08/03 07:57:13  Florian
.* Initial revision
.* Copied from crond.ipf, res-numbers changed, some bugs corrected
.*
.*
