:userdoc.
:title.Weasel Pro documentation
:docprof toc=12.

.***********************************
.*   INTRODUCTION
.***********************************

:h1 res=2001 id=2001 global.Introduction to Weasel Pro

:artwork name='weasel.bmp' align=center.
:p.
This document is a supplement to the
:link reftype=hd database='WEASEL.INF' refid=1001.main Weasel manual:elink..
It describes the extra features in Weasel Pro that are not
present in Weasel Standard. It is assumed that you have already
read the main Weasel manual (WEASEL.INF).

:p.:hp2.Differences between Weasel Standard and Weasel Pro:ehp2.

:p.For ease of distribution, the two versions are contained in
the same set of files. However, the "Pro" features are not
activated until you have entered a valid registration code.
The essential differences between the two versions are&colon.
:ul.
:li.The standard version supports only one mail domain. With the
Pro version, a single server can host many mail domains.
:li.The Pro version will optionally support the IMAP4 protocol,
in addition to the POP3 and SMTP protocols supported by the
standard version. In the present release the IMAP4 server is
a separate executable which must be downloaded separately, but
the IMAP options are still controlled by the same Setup program.
:li.The standard version does not require any registration code;
that is, registration is optional. For the "Pro" version,
registration is compulsory. If you do not enter a valid
registration code, the server will remain in "Standard" mode.
:eul.

.***********************************
.*   REGISTRATION
.***********************************

:h1 id=register.Activating the registration

:hp2.Activating the registration:ehp2.

:p.The registration code for Weasel Pro has two components
:ul.
:li.your
name (or, if you prefer, some other identifying string such as a
company name)
:li.a registration number.
:eul.

:p.Once you have received
your registration code, run the Setup program that came with
Weasel, and go to the notebook page labelled "Register". Enter
the two parts of the registration code where indicated. Do not
include any leading or trailing spaces.

:p.Some test versions come with a time-limited demonstration mode
that allows the "Pro" mode to be activated even without a valid
registration code. These versions have a note on the "Register"
page about the time limit. After the time limit expires, the
"Pro" features will be available only if you have entered a
proper registration code.

.***********************************
.*   IMAP SUPPORT
.***********************************

:h1 id=imapsupport.IMAP support

:p.:hp2.IMAP Support:ehp2.

:p.IMAP is an extra mail access protocol that you might or might
not want to activate. Since not everyone will want it, you have
the option of leaving IMAP disabled. The next few pages explain
what IMAP is, and how to install and configure it.

.***********************************
.*   WHAT IS IMAP?
.***********************************

:h2 id=whatisimap.What is IMAP?

:p.:hp2.What is IMAP?:ehp2.

:p.There are three common protocols used for transporting e-mail:

:dl break=all.
:dt.   SMTP
:dd.the basic transport mechanism used for essentially
all transfers between mail servers. Normally you
also use SMTP to send all your outgoing mail.

:dt.   POP3
:dd.the most common method used by mail clients to fetch
incoming mail from the server. (There is also a
POP2, but it is obsolete.) POP3 remains popular
because it is simple and has low overhead.

:dt.   IMAP
:dd.a newer protocol that some mail clients can use
instead of POP3 to read and manipulate the mail
that is on the server. The version that this
package supports is known as IMAP4rev1.
:edl.

:p.IMAP is a lot more complicated than POP3 (so you might not want
it, because of the higher overheads). The essential difference
is that POP3 is designed for the case where the user downloads
all mail from the server and then processes it locally. (It
is possible for a POP3 user to leave a copy of the mail on the
server, but for various reasons that is not a good idea.)
With IMAP, the assumption is that the user is going to leave
the mail on the server. IMAP therefore has commands for
creating new mail folders on the server and for moving mail
between folders; commands for searching through mail without
downloading it; commands for downloading attachments without
downloading an entire message; status flags for keeping track
of things like which mail has already been read; and so on.

:p.The end result is that IMAP is attractive for the sort of user
who wants to access e-mail from several different locations.
This is possible because the user's mail store is on the server
rather than on the user's computer(s).

:p.A corollary of this is that IMAP is actually less attractive
from the viewpoint of the person running the server. You need
a more powerful server machine than with POP3, because most of
the workload has been transferred from the user's computer to
the server. In particular:

:ul.
:li.
The IMAP4 protocol is fairly complex, with many options, so
the server has to work harder to parse and respond to
commands.
:li.
While a typical POP3 session lasts only a few seconds or minutes
(download mail, delete mail, log off), an IMAP4 user is
more likely to remain logged on for days at a time. In
addition, some IMAP4 clients (e.g. Mozilla) are "greedy"
in that they open many parallel sessions for a single user,
and remain logged on in all of them until the user goes
off-line or closes all browser windows.
:li.
Keeping all past mail on the server can add up to a lot of
disk space. You might have to allow for several hundred
megabytes per user of storage space.
:eul.

:p.On the other hand, the big attraction of IMAP4 is that it makes
your service look more attractive to potential clients.

.***********************************
.*   INSTALLING IMAP
.***********************************

:h2 id=installimap.Installing IMAP

:p.:hp2.Installing IMAP:ehp2.

:p.Because the IMAP subsystem of Weasel is new and still under test,
it is not yet integrated into weasel.exe. Instead, it comes as a
separate executable called imapd.exe, which you have to run if you
want this feature. If you want to install it, you first need to
fetch the latest version of imapd - the file name is of the form
imapdnnn.zip - from http&colon.//www.pmoylan.org/ftp/Weasel/.
Next, unzip that file into the same directory as Weasel.exe.

.***********************************
.*   CONFIGURING IMAP
.***********************************

:h2 id=configureimap.Configuring IMAP

:p.:hp2.Configuring IMAP:ehp2.

:p.The IMAP configuration is done with Setup.exe (the same Setup as
you use for the main part of Weasel). After you have entered your
registration code into Setup, an extra notebook page "IMAP" appears.
This page is not visible in non-registered versions. Here you will
find the following entries.

:dl break=all.
:dt.     Port
:dd.The TCP/IP port on which the server listens for connections. Unless you are
doing something nonstandard, this should always be 143.
:dt.     Timeout (seconds)
:dd.The time that a session may remain idle before it is forcibly closed.
IMAP clients typically remain connected for long periods of time, and the IMAP
standard states that the timeout should be at least 30 minutes (1800 seconds).
Making this too short could create problems for dial-up users.
:dt.     Max users
:dd.This specifies how many client sessions will be allowed to use the server simultaneously.
It turns out that many IMAP clients - especially those based on web browsers - are
"greedy" in that they will hold open multiple parallel sessions. Furthermore, such
clients tend to stay logged in, unlike POP clients which generally log in for only
a few seconds at a time. This means that a user limit
of 10, which might sound adequate if you are used to POP, will in reality allow only about
two IMAP users.
:dt.     Enabled
:dd.This box must be checked in order to allow imapd.exe to run.
If you leave it unchecked, then IMAP support will be completely disabled.
:edl.

:p.In the lower half of this notebook page there is an option to enable
logging to a log file. We keep the IMAP log separate from the main Weasel
transaction log, on the grounds that IMAP creates many more log entries.
If you enable this you will find that the log file grows quickly. I
suggest that you leave IMAP logging turned off unless you are doing some
testing, because of the size of the generated file.

:p.:hp2.Enabling IMAP for your users:ehp2.

:p.Because IMAP is "expensive", we don't necessarily make it available
to all users. Weasel actually has a separate "IMAP enable" for each
user account, to allow the finest possible control.

:note.If you are upgrading from a version of Weasel prior to version
1.73, you will probably have to check your user accounts to ensure
that IMAP support is enabled/disabled according to your preferences,
because in those earlier versions there were no IMAP settings.

:p.In the Setup page for each user, there is an "Allow IMAP" checkbox.
(The checkbox is invisible if you haven't registered Weasel Pro.)
This is how you control IMAP access on a per-user basis.

:p.Naturally, you need a default so that you don't have to step through
all the users one by one. The default is the "Enable IMAP for new users"
checkbox on the "Users" page of Setup. In multidomain mode, there is
a separate default for each domain. This checkbox does not actually
enable or disable anything. Instead, it provides the initial state for
the "Allow IMAP" option each time you create a new user in this domain.

.***********************************
.*   TURNING ON MULTIDOMAIN MODE
.***********************************

:h1 id=turningmultion.Turning on the multidomain mode

:hp2.Turning on the multidomain mode:ehp2.

:p.The "Register" page of the Setup notebook also includes a
checkbox labelled "Enable multiple domain mode". Once you check
that checkbox, several things happen.

:ul.
:li.The "Users", "Aliases", and "Local" pages disappear from the
Setup notebook.
:li.Any existing information from those three pages is transferred
to what we call :link reftype=hd refid=originaldomain.the original
domain:elink..
:li.An extra option appears on the "Options 2" notebook page.
This will be explained when we discuss the topic of
:link reftype=hd refid=identifyusers.matching usernames with domains:elink..
:li.A new notebook page called "Domains" appears. If this is the
first time you have activated this feature, it will contain one entry
with a fictional domain name. (You should change this to a real domain name.)
If you have previously had multiple domain mode
enabled then it might list several domains.
:eul.

:p.These changes are reversible. See also the topic of
:link reftype=hd refid=turningmultioff.Turning off the multidomain mode:elink..

.***********************************
.*   THE ORIGINAL DOMAIN
.***********************************

:h2 id=originaldomain.The original domain

:hp2.The original domain:ehp2.

:p.When you first switch from single-domain mode to multidomain
mode, a single domain with a fictional name is created, and all of your
existing users are migrated to that domain.

:p.One of the first things you will want to do, almost certainly,
is to change that name to the name of a domain that
belongs to you. When you do that, the Setup program remembers the
name change, and the renamed domain is now considered to be the
original domain. As you add domains, the domain that was first
created continues to be called the original domain.

:p.The :hp1.only:ehp1. significance of the original domain is that
it will be the one used if you ever switch back to single-domain
mode. In all other respects, it is the same as any other domain.
If you never switch back to single-domain mode, then the concept
of the original domain has no importance.

.***********************************
.*   TURNING OFF MULTIDOMAIN MODE
.***********************************

:h2 id=turningmultioff.Turning off the multidomain mode

:hp2.Turning off the multidomain mode:ehp2.

:p.If you have a registered copy of Weasel Pro, then there is no
real motivation for going back to single-domain mode. Even if you
are hosting only one domain, you might as well stay in multidomain
mode permanently.

:p.If, however, you are using a time-limited demonstration version,
you will have to switch back to single-domain mode when the time
limit expires. To do this, you go to the "Register" page of the
Setup notebook, and uncheck the box labelled "Enable multiple domain mode".

:p.When you do this, the information in the original domain, including
the list of users, is moved back to the single-domain configuration.
If you have any other domains defined at that point, the users in those
domains are not migrated back. The information for those domains is
in subdirectories of the Mailroot directory, and if you want to migrate
any of that information you will have to do it manually.

:p.When you switch off the multidomain mode, you might get a warning
message that the original domain could not be fully deleted. There
are two likely reasons for this&colon.

:ul.
:li.Deleting a domain requires, among other things, deleting a file
called DOMAIN.INI. This deletion can fail because of the way that OS/2
keeps INI files cached in main memory. You can safely delete that
file manually.
:li.User directories will not be deleted if they still contain some
undelivered mail. If a user directory has not been deleted, you need
to check the files in that directory and make a decision about what
to do about the unfetched mail. Normally the most sensible decision is
to move the mail to that user's new directory.
:eul.

.***********************************
.*   ASSOCIATING DOMAINS WITH IP ADDRESSES
.***********************************

:h1 id=domainIP.Associating domains with IP addresses

:hp2.Associating domains with IP addresses:ehp2.

:p.A mail domain has three important attributes&colon.

:ul.
:li.The name of the domain, for example coyote.acme.net
:li.The alternative names that will also be accepted as destination
addresses for this domain. In particular, this includes the hostname
for the machine on which the mail server is running, for example
mail1.coyote.acme.net
:li.The numeric IP addresses belonging to the hostnames mentioned above.
:eul.

:p.The associations among these are defined when you
:link reftype=hd refid=editdomain.edit the domain properties:elink..
The name of the domain is given on the "Domains" page of the Setup
notebook, and the other names and IP addresses are given on the
"Local" page of the properties for that domain.

:p.Ideally the hostnames and IP addresses should not overlap.
That is, two domains should not be associated with the same hostname
or the same IP address. If you are using a single machine to host
multiple mail domains, however, some compromises are usually necessary.

:p.The most desirable situation is where your server has multiple
network interfaces, and therefore multiple IP addresses, and you
use a separate IP address for each mail domain that you are hosting.
In this case, the domains are separated from one another both
conceptually and physically. Weasel does not need to search through
the list of domains to identify a user, because the IP address
uniquely identifies a domain.

:p.More typically, you will have more domains than IP addresses.
For example, you might be hosting six domains but have only three
IP addresses. In that case, you have to decide how to partition
the address space. The most obvious decision is to allocate two
domains per IP address. On the other hand, you might decide that
you have two important customers and four less important ones; in
that case, you would probably give each important customer a
unique IP address, and let the other four share a single IP address.

:p.The extreme (but very common) case is where you have only one
IP address. In that case, you probably have no choice but to force
all users to specify their domain when logging in, by using a
POP3 login name of the form user@domain. Weasel Pro does have a feature
where they can simply log in as 'user', with the password used to
work out which domain they belong to, but some system managers
will want to disable this feature on the grounds that it weakens
security.

.***********************************
.*   MATCHING USERS WITH DOMAINS
.***********************************

:h1 id=identifyusers.Matching users with domains

:hp2.Matching users with domains:ehp2.

:p.When you are hosting multiple domains, there is a possibility that
a username occurs in two or more domains. (In fact, this is certain,
because the username 'postmaster' exists in every domain.) Thus, we
need a strategy for deciding which domain this user belongs to.

:p.There are three cases to consider&colon. incoming mail, outgoing
mail, and mail being fetched by a user. These three cases are
described below. Of these, the third case is the most complicated.

:p.:hp2.Incoming mail:ehp2.

:p.Incoming mail has a "To" address of the form user@domain. That is,
the domain is specified explicitly. Weasel Pro matches the domain by
checking whether 'domain' is the name of one of our domains, and
if not whether it is in the "Local" list for any domain. Normally this
should uniquely identify the domain.

:p.There are just two cases where an ambiguity might arise&colon.
:ul.
:li.If a name occurs in the "Local" list for more than one domain, the
first match is chosen. This is, in effect, a configuration error, and
you should not allow it to happen.
:li.If the domain name is unspecified or is an empty string, Weasel
Pro will check only the first domain in the domain list. If there is
a username match for that domain, the mail is accepted. Otherwise,
it is rejected with a 'no such user' error.
:eul.

:p.:hp2.Outgoing mail:ehp2.

:p.Outbound mail is normally mail that has come in from elsewhere
- for example, from one of your users - and is being relayed to
another server. Technically, the relay function is handled by a
'host' rather than by a 'mail domain'. In this case, therefore, the
question of 'what domain does this mail item belong to?' does not
arise.

:p.:hp2.Mail being fetched by a user:ehp2.

:p.The two preceding cases are handled by the SMTP component of
Weasel Pro. A 'fetch mail' operation by a user uses the POP3
or IMAP4 protocol rather than the SMTP protocol. The details of how we
match a user with a domain is a little more complicated.
This case is more fully described on the
:link reftype=hd refid=identifyPOPuser.following page:elink..

.***********************************
.*   MATCHING USERS WITH DOMAINS
.***********************************

:h2 id=identifyPOPuser.Identifying a mail user

:hp2.Identifying a mail user:ehp2.

:p.When a POP3 user or IMAP user logs in, he or she supplies a username and
a password. (In the IMAP case, or if the APOP or AUTH command is used, there is an additional
encryption operation on the password, but this does not change
the fact that just two pieces of information have been supplied.)
If your server has multiple interfaces then Weasel Pro is also
able to find out which IP address the client connected to. It
does not, however, know what domain is being addressed, because
there is nothing in the POP3 or IMAP4 protocols that supplies that information.

:p.There are basically two ways to resolve this problem&colon.

:ol.
:li.Require the user to log in with a username of the form
user@domain. That is, the login name includes a specification of
which domain that user is logging into.
:li.Allow the user to log in with a username in the usual way,
without specifying a domain, and let Weasel work out which domain
to use from the available clues&colon. the IP address that the
user has used to contact the POP or IMAP server, and the user's password.
:eol.

:p.It is up to you, as system manager, to decide which of these
two methods will be used. Method 1 gives an unambiguous
specification of the domain (provided that you haven't duplicated
a domain name), but is less convenient for the user. Method 2
gives the user the impression that the POP or IMAP server is entirely
dedicated to his or her domain, but it does create the risk that
the user will log into the wrong domain if the same username
occurs in more than one of the domains that your mail server
is hosting.

:p.The two methods are not mutually exclusive. You could, for example,
allow most users to log in using method 2, but require the
user@domain form of login for those users and/or domains for which
there is a risk of ambiguity.

:note.The presence of firewalls and proxies can, in some cases,
make it impossible for users to include the @ character in their
login name. To get around this, Weasel allows alternative
forms user'domain and user%domain. If the single quote (') character
or the percent character (%) is found, Weasel does not search
further for an @ character.

:p.The precise sequence of steps used by Weasel Pro to deduce
the domain is described below.

:p.:hp2.The identification process:ehp2.

:p.When a user logs in, by any of the several methods provided by
POP3 or IMAP4, Weasel Pro performs the following checks.

:ul.
:li.The login must have occurred with the user connecting to
a specific address. If your server has only one IP address then
this provides no useful information. If, however, it has several
IP addresses then this restricts the set of possible domains.
Only the domains that have this IP address (either explicitly, as
a numeric address, or implicitly, as the result of nameserver
lookup) on their "Local" Setup page are considered in the remainder of this
checking process.
:li.If the user has supplied an explicit domain name, by logging
in with the user@domain form of username, this further
restricts the set of possible domains. Normally this would mean
that there is only one domain that is a possible candidate.
:li.From the domains remaining after these checks, we keep the ones
for which there is a username match. Often, but not always,
there will be only one domain left to consider at this stage.
:eul.

:p.What happens next depends on whether you have specified
"Accept only the first user/domain match"
on the "Options 2" page of the Setup notebook. (This option is
visible only when you have activated multiple domain mode.)
If you have checked this option, and the search described above
has found multiple domains, only the first of these is used.
The login is successful if and only if we get a username and
password match for that domain.

:p.If, on the other hand, you leave that option unchecked, the
password is used to resolve any ambiguities. We select the
first domain for which the username matches :hp2.and:ehp2.
the password is correct. The probability that the same
username will occur in more than one domain is fairly high.
The probability that the same password is used for more
than one of those instances is extremely low. Thus, using
the password to resolve ambiguities will almost certainly
pick the correct domain. In the remotely possible case that
it gets the wrong domain, this will be detected the first
time that the user tries to log in, and the problem can be
fixed by changing the password for one of the affected users.

:p.The strategy of using passwords to resolve ambiguities does
slightly increase the chance that someone can break into
your system by guessing usernames and passwords.
Most people would consider the risk still to be acceptably
low. If you consider that risk to be unacceptable, you should
enable the "Accept only the first user/domain match" option.

.***********************************
.*   THE DOMAINS PAGE
.***********************************

:h1 id=domains.The list of domains

:hp2.The list of domains:ehp2.

:p.Once you have activated multidomain mode, your Setup notebook will
contain a page called "Domains". This lists all of the domains you
are hosting. The listbox on that page should, preferably, contain
precisely the names of your mail domains. That is, if you are hosting
a mail domain called coyote.acme.net, then one of the entries in that
listbox should be the name coyote.acme.net.

:p.The order of the domains in the listbox is significant, because it
defines the search order when a user logs in. For more detail on this,
see the section on
:link reftype=hd refid=identifyusers.matching users with domains:elink..

:p.There are five operations available to you on this page.

:p.:hp2.Adding a new domain:ehp2.

:p.If you select the "Add" button, you get a box inviting you
to type the domain name for the new domain. Finish this with
the <Enter> key, and then proceed as for
:link reftype=hd refid=editdomain.editing the properties of a domain:elink..

:p.:hp2.Renaming an existing domain:ehp2.

:p.The "Rename" button allows you to change the name of the selected domain.
Finish this operation with the <Enter> key.

:p.:hp2.Editing the properties of a domain:ehp2.

:p.The "Edit" button opens a new dialogue where you can
:link reftype=hd refid=editdomain.edit the properties:elink.
of the currently selected domain. You can also get the same
effect with a double-click of mouse button 1.

:p.:hp2.Changing the order of domains in the list:ehp2.

:p.The "Promote" button moves the currently selected domain one
place higher in the list of domains.

:p.:hp2.Deleting a domain:ehp2.

:p.The "Delete" button completely removes the currently selected domain.
This is a major change, so make sure that you really mean it.  If
some directories cannot be deleted - because, for example, some users
still have undelivered mail - you will get a message saying that
the remainder of the deletion must be done manually.


.***********************************
.*   EDITING THE PROPERTIES OF A DOMAIN
.***********************************

:h1 id=editdomain.Editing the properties of a domain

:hp2.Editing the properties of a domain:ehp2.

:p.When you choose to edit a domain, you get a new notebook with
three pages&colon.

:dl tsize=15 break=none.
:dt.    :link reftype=hd refid=pmconfiguser2.Users:elink.
:dd.The list of users for this domain.
:dt.    :link reftype=hd refid=pmaliases.Aliases:elink.
:dd.The aliases for this domain.
:dt.    :link reftype=hd refid=pmconfiguser3.Local:elink.
:dd.The hostnames and IP addresses that belong to this domain.
:edl.

:p.The 'Users' and 'Aliases' information are exactly the same as for
the single-domain case.
The 'Local' list has a slightly different meaning from what it
means in the single-domain case.


.***********************************
.*        USER EDITOR
.***********************************

:h2 id=pmconfiguser2 toc=123.Users
:hp2.Users:ehp2.
:p.
Adding a username on this page has two results&colon.

:ul compact.
:li.It tells the Weasel SMTP server to accept mail for that user on
this domain.
:li.It allows the user to log in to the Weasel POP server and collect any
mail that has arrived. (Users with IMAP enabled have a choice between
fetching mail via the POP server and getting it via the IMAP server.)
:eul.

:p.
:hp2.Adding a new user:ehp2.
:p.
Click on the "Add" button, and then proceed as for
:link reftype=hd database='WEASEL.INF' refid=pmedituser.Editing a user record:elink..
:p.
:hp2.Editing the details for an existing user:ehp2.
:p.
Click on the "Edit" button, and then follow the instructions in the section
:link reftype=hd database='WEASEL.INF' refid=pmedituser.Editing a user record:elink..
:p.
:hp2.Deleting a user:ehp2.
:p.
Click on the username to be deleted, and then click on the "Delete" button.

.***********************************
.*           ALIASES
.***********************************

:h2 id=pmaliases toc=123.Aliases
:hp2.Aliases:ehp2.
:p.
An alias looks like a username from the viewpoint of incoming mail,
but the name does not correspond to the name of any POP user.  Instead,
the alias refers to a list of e-mail addresses.  Whenever an e-mail
arrives addressed to that alias, a copy is sent to everyone on the
list.

:p.Each domain has its own set of aliases. (There are no 'global'
aliases that extend across domains; there would be no point in
having such a feature.) Apart from this detail, aliases in
multidomain mode work exactly like aliases in single-domain mode.
You can read about the details in the
:link reftype=hd refid=pmaliases database='WEASEL.INF'.main Weasel manual:elink..

.***********************************
.*   NAMES FOR THE LOCAL HOST
.***********************************

:h2 id=pmconfiguser3.Local
:hp2.Local:ehp2.

:p.
This notebook page contains a listbox and several pushbuttons. The
pushbuttons allow you to change the contents of the listbox, as
follows.

:dl break=all.
:dt.    Add
:dd.If you select this button, you are able to add a new entry
to the listbox. (Use the <Enter> key when you have finished
typing the new entry.)
:dt.    Promote
:dd.Allows you to change the order of the entries in the listbox.
The currently selected entry is moved one position higher.
:dt.    Delete
:dd.Removes the currently selected entry from the listbox.
:dt.    Add all local IP addresses
:dd.This is equivalent to a set of 'Add' operations, where the
IP addresses for interfaces on this host are added to the listbox.
Addresses that are already listed are not added again, so a
second press on this button will have no effect.
:edl.

:p.The 'Add all local IP addresses' option is simply a convenience
to save you some typing. Often the easiest way to define the
IP addresses for this domain is to add the addresses for all
interfaces on this machine, and then delete the ones that you
don't want to associate with this domain.

:p.Although this notebook page looks identical to the 'Local'
page in the single-domain mode, there is an important difference.
In single-domain mode, Weasel automatically binds itself to all
the local interfaces it can find, so very commonly you don't have
to enter anything at all on the 'Local' page. We cannot do this
in multidomain mode, because if you have multiple network interfaces you
will probably want to partition them such that each domain is bound
to only one (or perhaps more in rare cases) IP address. Because
of this, you must explicitly say which addresses belong to this
domain.

:p.Entries in the listbox can be either textual hostnames, such
as uvw.xyz.com, or numeric IP addresses, such as [10.0.1.5].
It is convenient to describe these two possibilities separately,
because they are used for different purposes.

:p.Note, however, that Weasel uses nameserver lookups to expand
the information you have entered. For each textual entry, the
corresponding numeric address is added to Weasel's internal
'Local' list, and vice versa. Thus, the internal list can be a
lot longer than the list you see on the 'Local' notebook page.

:p.:hp2.Numeric IP addresses:ehp2.

:p.A numeric entry is an IP address in the conventional dotted
notation, for example [192.168.3.7]. The brackets are optional,
but are usually preferred for neatness. In addition, there will
be 'implied' IP addresses determined at run-time, as the result
of nameserver translation of the textual hostnames.

:p.These addresses are used to construct internal tables showing
which domains belong with which IP addresses. When a POP3 user
logs into Weasel, he or she is connecting to a specific IP
address, so from this Weasel can deduce that this user belongs
to a subset of the possible domains.

:p.:hp2.Textual entries:ehp2.

:p.Every mail domain has a name, and the official name should
match the name on the 'Domains' page of the Weasel setup
notebook. Sometimes, however, you might give several names
to the same domain. In that case, the extra names should appear
on this 'Local' page.

:p.These entries are consulted whenever it is necessary to
resolve the 'domain' part of an e-mail address in the form user@domain,
in order to work out whether this is a local address and, if so, what
local domain it belongs to.
We consider that we have a match if we match the domain name itself,
or one of the entries in that domain's 'Local' list.

:p.Of course the numeric entries are also checked if the address
is specified numerically. That is, if mail arrives addressed to
user1@123.45.6.7 or user1@[123.45.6.7], we will accept a match if
one of this domain's IP addresses happens to be 123.45.6.7.

:p.:hp2.Wildcards in textual entries:ehp2.

:p.The Setup program allows you to put entries into the 'Local' list
that contain '?' and '*' wildcards. If you use such entries,
addresses will be checked using the usual rules for wildcard matches.
(The '?' matches any single character, and the '*' matches any
substring of zero or more characters.)

:p.In practice, however, there are not many situations where you
would be justified in using wildcards in this list. The wildcard
facility is really intended for use in the more global lists such
as the list of banned hosts.

.***********************************
.*   DUMPINI AND LOADINI
.***********************************

:h1 id=dumploaddomainini.Backing up the INI file data
:hp2.Backing up the INI file data:ehp2.

:p.The main Weasel manual explained how to use the utilities
called DUMPINI.EXE and LOADINI.EXE to store and reload the
configuration information for Weasel. In the single-domain mode,
this information is kept in a single file called WEASEL.INI.
The DumpINI program processes this to create a text file called
WEASEL.TNI. The LoadINI program takes the information from
WEASEL.TNI and puts it back into WEASEL.INI.

:p.:hp2.Backing up in the multidomain mode:ehp2.

:p.If you are running Weasel Pro in multidomain mode, the configuration
options are spread across several INI files. The 'global' options are kept in
WEASEL.INI, as in the single-domain case. Data specific to one domain,
such as the user data, are kept in a file called DOMAIN.INI.

:p.To find the DOMAIN.INI files, you must first look into the
'mail root' directory. In multidomain mode, this directory has one
subdirectory for each domain, and the name of the subdirectory is
the same as the name of the domain. If you look in these subdirectories,
you will find the DOMAIN.INI files.

:p.When multidomain mode is enabled, these DOMAIN.INI files are
automatically included in the LoadINI and DumpINI operations. That is,
DumpINI will create - in addition to the WEASEL.TNI file - a DOMAIN.TNI
file for each domain. Similarly, if LoadINI finds a {Domains} section
in WEASEL.TNI, then it will search for and process the DOMAIN.TNI
file for each of these domains.

:p.If you wish to back up or restore the data for a single domain, you can
use DumpINI and LoadINI directly on DOMAIN.INI or DOMAIN.TNI files, as
appropriate. For example, you can execute the command
:xmp.

       ..\..\dumpini domain.ini

:exmp.
to produce a text file called DOMAIN.TNI. This example assumes that
the domain.ini file is in a subdirectory two levels down from the
directory that contains DUMPINI.EXE, which is a common scenario.
The directories might be different in your case, because different
system managers have different ideas about the best place to locate
these files. One common scenario, for example, is to have one
directory entirely devoted to holding backup scripts and backup data
for a whole variety of software. In any case, it should be obvious
how to adjust the paths to make the above example work in your
preferred directory layout.

:euserdoc.

