/****************************************************************/
/* BUILDCSO.CMD : Build VX-REXX Client/Server Objects           */
/****************************************************************/

address CMD
"@echo off"

call RXFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

call setlocal

say "Creating VX-REXX Client/Server Objects..."

parse arg VXRexxDir szVideoMode
if (VXRexxDir = "/?") then do
   call Usage
end

if (szVideoMode \= "1024x768" & szVideoMode \= "800x600" & szVideoMode \= "640x480") then do
   szVideoMode = "640x480"
end

if (VXRexxDir = "") then do
   VXRexxDir = directory();
end
else do
   if (lastpos("\",VXRexxDir) = length(VXRexxDir)) then do
      VXRexxDir = left(VXRexxDir, length(VXRexxDir) -1)
   end
end

VXRexxDir = directory(VXRexxDir)

bldDemo = 0
if( FileExists( VXRexxDir || '\tutbook.inf' ) )then do
    bldDemo = 1
end

x = 5;
if (szVideoMode = "1024x768") then do
   y = 45;
   nDeltaY = -10;
   nDeltaX = 13;
end
if (szVideoMode = "640x480") then do
   y = 60;
   nDeltaY = -15;
   nDeltaX = 15;
end
if (szVideoMode = "800x600") then do
   y = 60
   nDeltaY = -15;
   nDeltaX = 15;
end

/* Create README program object */

x = 5;
y = y + 3 * nDeltaY;
className = "WPProgram"
title     = "Client/Server" || "0A"x || "Read Me First"
location  = "<VXREXX_FOLDER>"
setup     = "EXENAME=view.exe;" ||,
            "PROGTYPE=PM;" ||,
            "PARAMETERS=" || VXRexxDir || "\README2.INF;" ||,
            "ICONPOS=" x || "," || y || ";" ||,
            "STARTUPDIR=" || VXRexxDir || ";"

call SysCreateObject classname, title, location, setup, 'r'

/* Create "Database Object User's Guide" object in VX-REXX Folder */

x = x + nDeltaX;
className = "WPProgram"
title     = "Database Objects" || "0A"x || "Reference"
location  = "<VXREXX_FOLDER>"
params    = "EXENAME=view.exe;" ||,
            "PROGTYPE=PM;" ||,
            "PARAMETERS=" || VXRexxDir || "\VRDB.INF;" ||,
            "ICONPOS=" x || "," || y || ";" ||,
            "STARTUPDIR=" || VXRexxDir || ";"

call SysCreateObject className, title, location, params, "r"

/* Create "Chart Object User's Guide" object in VX-REXX Folder */

x = x + nDeltaX;
className = "WPProgram"
title     = "Chart Object" || "0A"x || "Reference"
location  = "<VXREXX_FOLDER>"
params    = "EXENAME=view.exe;" ||,
            "PROGTYPE=PM;" ||,
            "PARAMETERS=" || VXRexxDir || '\VRCHT.INF;' ||,
            "ICONPOS=" x || "," || y || ";" ||,
            "STARTUPDIR=" || VXRexxDir || ";"

call SysCreateObject className, title, location, params, "r"


/* Create "Database Administrator" object in VX-REXX Folder */

x = 5;
y = y + nDeltaY;
className = "WPProgram"
title     = "Database" || "0A"x || "Administrator"
location  = "<VXREXX_FOLDER>"
params    = "EXENAME=" || VXRexxDir || "\DBADMIN.EXE;" ||,
            "PROGTYPE=PM;" ||,
            "ICONPOS=" x || "," || y || ";" ||,
            "STARTUPDIR=" || VXRexxDir ";"

call SysCreateObject className, title, location, params, "r"

/* Create "Database Samples" folder in VX-REXX Folder */

x = x + nDeltaX;
className = "WPFolder"
title     = "Database Samples"
location  = "<VXREXX_FOLDER>"
params    = "ICONPOS=" x || "," || y || ";" ||,
            "OBJECTID=<DATABASE_SAMPLES>;"

call SysCreateObject className, title, location, params, "r"

/* Create Database Samples Source Folder */

className = "WPFolder"
title     = "Source"
location  = "<DATABASE_SAMPLES>"
params    = "OBJECTID=<DATABASE_SOURCE>;"

call SysCreateObject className, title, location, params, "r"

/* Create "Chart Samples" folder in VX-REXX Folder */

x = x + nDeltaX;
className = "WPFolder"
title     = "Chart Samples"
location  = "<VXREXX_FOLDER>"
params    = "ICONPOS=" x || "," || y || ";" ||,
            "OBJECTID=<CHART_SAMPLES>;"

call SysCreateObject className, title, location, params, "r"

/* Create Chart Samples Source Folder */

className = "WPFolder"
title     = "Source"
location  = "<CHART_SAMPLES>"
params    = "OBJECTID=<CHART_SOURCE>"

call SysCreateObject className, title, location, params, "r"

/* Create source folder under database samples*/

className = "WPFolder"
title     = "Source"
location  = "<DATABASE_SAMPLES>"
params    = "OBJECTID=<DATABASE_SOURCE>;"

call SysCreateObject className, title, location, params, "r"

/* Create source folder under chart samples*/

className = "WPFolder"
title     = "Source"
location  = "<CHART_SAMPLES>"
params    = "OBJECTID=<CHART_SOURCE>;"

call SysCreateObject className, title, location, params, "r"


if( bldDemo = 0 )then do

    /* Create IPFC book objects */
    
    x = 5;
    y = y + nDeltaY;
    
    className = "WPProgram"
    title     = "Information Presentation" || "0A"x || "Facility Help"
    location  = "<VXREXX_FOLDER>"
    params    = "EXENAME=view.exe;" ||,
                "PROGTYPE=PM;" ||,
                "PARAMETERS=" || VXRexxDir || "\IPFC20.INF;" ||,
                "ICONPOS=" || x || "," || y || ";" ||,
                "STARTUPDIR=" || VXRexxDir || ";"
                
    call SysCreateObject className, title, location, params, "r"
    
    x = x + nDeltaX;
    
    className = "WPProgram"
    title     = "IPFC Compiled" || "0A"x || "Examples Help"
    location  = "<VXREXX_FOLDER>"
    params    = "EXENAME=view.exe;" ||,
                "PROGTYPE=PM;" ||,
                "PARAMETERS=" || VXRexxDir || "\IPFCEXMP.INF;" ||,
                "ICONPOS=" || x || "," || y || ";" ||,
                "STARTUPDIR=" || VXRexxDir || ";"
                
    call SysCreateObject className, title, location, params, "r"            
end

/* if (szVideoMode = "1024x768") then do
   y = 40 + 3 * nDeltaY;
end
if (szVideoMode = "640x480") then do
   y = 50 + 3 * nDeltaY;
end
if (szVideoMode = "800x600") then do
   y = 50 + 3 * nDeltaY;
end */


call AddSample "Titles", "Chart Titles"      , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Rowcol", "Row and Column"    , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Rmouse", "Mouse Example"     , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Printcht","Print Chart"      , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Miniclik","Simple Click"     , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Groups","Group Options"      , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Drill","Drill Down"          , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Data","Data"                 , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Click","Click"               , "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Bound1","Database Charting 1", "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"
call AddSample "Bound2","Database Charting 2", "<CHART_SAMPLES>", "CHTSAMP", "<CHART_SOURCE>"

call AddSample "master","Master/Detail","<DATABASE_SAMPLES>", "DBSAMPLE", "<DATABASE_SOURCE>"
call AddSample "starter","Getting Started","<DATABASE_SAMPLES>","DBSAMPLE", "<DATABASE_SOURCE>"
call AddSample "wsample","Sample Database"||"0A"x||"Generator","<DATABASE_SAMPLES>","DBSAMPLE", "<DATABASE_SOURCE>"
call AddSample "orderapp","Order Entry Application","<DATABASE_SAMPLES>","DBSAMPLE", "<DATABASE_SOURCE>"

exit;


/* AddSample: Arguments - 1) Directory Name
                          2) Long Name
                          3) Location
                          4) Sample Directory
                          5) Source Folder Location */

AddSample: procedure expose VXRexxDir
/*********
    Parms:  1   directory name
            2   long name
            3   location
            4   sample directory

*/

   target_dir = VXRexxDir


   szDirName = arg(1)
   szLongName = arg(2)
   szLocation = arg(3)
   szSampleDir = arg(4)
   szSourceLocation = arg(5)

   szStartUp = target_dir || "\" || szSampleDir || "\" || szDirName;

   szExeName = szDirName || ".EXE";
   szIcoName = szDirName || ".ICO";
   szVRPName = szDirName || ".VRP";

/* Create shadow of the sample directory under the source folder */

   classname = "WPShadow"
   title     = szLongName
   location  = szSourceLocation
   setup     = "SHADOWID=" || szStartUp || ";"
   call SysCreateObject classname, title, location, setup, 'r'

/* Do not create a program reference to chart edit sample */

   if (szDirName = "Chtedit") then do
      return
   end

/* Create the executable icon */

   classname = "WPProgram"
   title = szLongName
   location = szLocation
   setup = "EXENAME=" || szStartUp || "\" || szExeName || ";PROGTYPE=PM;ICONFILE=" || szStartUp || "\" || szIcoName || ";STARTUPDIR=" || szStartUp || ";"
   call SysCreateObject classname, title, location, setup, 'r'

return

/*
 * FileExists
 */
    
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )
    
    
Usage:
say 'BUILDCSK.CMD : Builds VX-REXX Client/Server objects'
say ''
say 'USAGE:  BUILDVRX [path] [resolution]'
say 'Where [path]       = VX-REXX Directory'
say '      [resolution] = 640x480, 800x600, 1024x768 (default=640x480)'
say''
exit
