/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRSet "LChartType", "Value", "BarLineChart"
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         LChartType_Change
*/
LChartType_Change:
    /* Change the chart typed (probably triggered by the DDCB
    */

    type = VRGet( "LChartType", "Value" )
    call VRMethod "WC_1", "SetOption", "ChartType", type  

    /* Change the 'Last Selected' text to "Chart Type"
    */
  
    call VRSet "DT_LastSel", "Caption", "Chart Type"
return

/*:VRX         M1_Project_Copy_Click
*/
M1_Project_Copy_Click:
    /* Copy the chart into the clipboard.
    */

    call VRMethod "WC_1", "PutClipboard"
return

/*:VRX         MI_Help_ProdInfo_Click
*/
MI_Help_ProdInfo_Click:
    /* The product information is displayed as a multi-line
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 6
    message.1 = "Chart Click Sample"
    message.2 = ""
    message.3 = "This demo application shows the power"
    message.4 = "of the chart's click event which can"
    message.5 = "be used to create fully featured, easy"
    message.6 = "to use applications."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1
return

/*:VRX         MI_Project_Load_Click
*/
MI_Project_Load_Click:
    /* Load a chart from a file.
    */
    
    filename = VRFileDialog( VRWindow(), "Loading a Chart.", "Open", "*.CHT", , ,  )
    
    if( LENGTH(filename) > 0 ) then do
        if( VRFileExists(filename) ) then do
            /* The load routine
            */

            call VRMethod "WC_1", "LoadFromFile", filename
            call VRMethod "WC_1", "Redraw"
        end
        else do             
            id = VRMessage( VRWindow(), "Can't load chart.", "Chart Load Error.", "Error", , ,  )           
        end
    end
return

/*:VRX         MI_Project_LoadData_Click
*/
MI_Project_LoadData_Click:
    /* Load a chart from a file with the data.
    */
    
    filename = VRFileDialog( VRWindow(), "Loading a Chart.", "Open", "*.CHT", , ,  )
    
    if( LENGTH(filename) > 0 ) then do
        if( VRFileExists(filename) ) then do
            /* The load routine
            */

            call VRMethod "WC_1", "LoadFromFile", filename, 1
            call VRMethod "WC_1", "Redraw"
        end
        else do             
            id = VRMessage( VRWindow(), "Can't load chart.", "Chart Load Error.", "Error", , ,  )           
        end
    end

return

/*:VRX         MI_Project_Paste_Click
*/
MI_Project_Paste_Click:
    /* Paste a chart from the clipboard.
    */

    call VRMethod "WC_1", "GetClipboard"
return

/*:VRX         MI_Project_PasteData_Click
*/
MI_Project_PasteData_Click:
    /* Get the data with the chart from the clipboard.
    */

    call VRMethod "WC_1", "GetClipboard", 1
return

/*:VRX         MI_Project_Save_Click
*/
MI_Project_Save_Click:
    /* Save a chart to a file
    */
    
    filename = VRFileDialog( VRWindow(), "Saving a Chart.", "Save", "*.CHT", , ,  )
    
    if( LENGTH(filename) > 0 ) then do
        call VRMethod "WC_1", "SaveToFile", filename
    end
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         WC_1_Click
*/
WC_1_Click:
    /* Find out which chart item was selected
    */

    item = VRInfo( "Item" )
    call VRSet "DT_LastSel", "Caption", item

    if( ( item == "ChartTitle" ) | ( item == "ChartSubtitle" ) | ( item == "ChartFootnote" ) ) then do
        /* User selected one of the chart titles
        */

        if( item == "ChartTitle" ) then do
            string = "New title:"
        end
        else if( item == "ChartSubtitle" ) then do
            string = "New subtitle:"
        end
        else do
            string = "New footnote:"
        end

        /* Bring up a modal window to change the value of the appropriate chart title
        */
        values = Window1( VRWindow(), string, "" )
        if( values \= "" ) then do
            parse var values title
            option = substr( item, 6 )
            /* Set the value of the appropriate chart title
            */

            call VRMethod "WC_1", "SetOption", option, title
        end
    end
    else if( substr( item, 1, 10 ) == "ChartGroup" ) then do
        /* User selected a data element
        */

        parse var item str'.'group'.'row'.'col
        if( row > 0 & col > 0 ) then do
            /* Bring up a modal window to change the value of the data element
            */

            oldvalue = VRMethod( "WC_1", "GetDataValue", row, col )
            values = Window1( VRWindow(), "Change the data value:", oldvalue )
            if( values \= "" ) then do
                parse var values dataval
                /* Set the value of the appropriate data element
                */

                call VRMethod "WC_1", "SetDataValue", row, col, dataval
            end
        end
    end
    else if( substr( item, 1, 11 ) == "ChartXScale" ) then do
        /* User selected a row name
        */

        parse var item str'.'row
        if( row > 0 ) then do
            /* Bring up a modal window to change the value of the appropriate row name
            */

            oldvalue = VRMethod( "WC_1", "GetRowName", row )
            values = Window1( VRWindow(), "Change the row name:", oldvalue )
            if( values \= "" ) then do
                parse var values name
                /* Set the value of the appropriate row name
                */

                call VRMethod "WC_1", "SetRowName", row, name
            end
        end
    end
    else if( substr( item, 1, 16 ) == "ChartSliceLabels" ) then do
        /* User selected a row name
        */

        parse var item str'.'row
        if( row > 0 ) then do
            /* Bring up a modal window to change the value of the appropriate row name
            */

            oldvalue = VRMethod( "WC_1", "GetRowName", row )
            values = Window1( VRWindow(), "Change the row name:", oldvalue )
            if( values \= "" ) then do
                parse var values name
                /* Set the value of the appropriate row name
                */

                call VRMethod "WC_1", "SetRowName", row, name
            end
        end
    end
    else if( substr( item, 1, 11 ) == "ChartZScale" ) then do
        /* User selected a column name
        */

        parse var item str'.'col
        if( col > 0 ) then do
            /* Bring up a modal window to change the value of the appropriate column name
            */

            oldvalue = VRMethod( "WC_1", "GetColName", col )
            values = Window1( VRWindow(), "Change the column name:", oldvalue )
            if( values \= "" )then do
                parse var values name

                /* Set the value of the appropriate column name
                */
                call VRMethod "WC_1", "SetColName", col, name
            end
        end
    end
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

