/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The product information is displayed with a multi-line
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 6
    message.1 = "Chart Data Sample"
    message.2 = ""
    message.3 = "This sample application shows how data"
    message.4 = "can be added to the chart at run-time,"
    message.5 = "as well as how the row and column names"
    message.6 = "can be changed."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1
return

/*:VRX         PB_CopyToChart_Click
*/
PB_CopyToChart_Click:
    call VRSet "WC_SampleChart", "painting", 0
    
    /* Get all the values from the entry fields.
    */

    row = VRGet( "EF_row", "Value" )
    col = VRGet( "EF_col", "Value" )
    row_name = VRGet( "EF_row_name", "Value" )
    col_name = VRGet( "EF_col_name", "Value" )
    data_value = VRGet( "EF_data_value", "Value" )

    /* Update the chart from the given previous values
    */

    call VRMethod "WC_SampleChart", "SetRowName", row, row_name
    call VRMethod "WC_SampleChart", "SetColName", col, col_name
    call VRMethod "WC_SampleChart", "SetDataValue", row, col, data_value
    drop row col row_name col_name data_value

    /* Reset Painting
    */

    call VRSet "WC_SampleChart", "painting", 1
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

