/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GenData
*/
GenData:
    /* The following two stem arrays are used to generate names
    */

    FNames.0 = 14
    FNames.1 = "Bob"
    FNames.2 = "Abigail"
    FNames.3 = "Dave"
    FNames.4 = "Emily"
    FNames.5 = "Joe"
    FNames.6 = "Rachel"
    FNames.7 = "Shawn"
    FNames.8 = "Adrienne"
    FNames.9 = "Debra"
    FNames.10 = "Al"
    FNames.11 = "Mike"
    FNames.12 = "Michelle"
    FNames.13 = "Todd"
    FNames.14 = "Tracy"

    SNames.0 = 18
    SNames.1 = "Smith"
    SNames.2 = "Clarke"
    SNames.3 = "Okabe"
    SNames.4 = "Swaine"
    SNames.5 = "McDonald"
    SNames.6 = "Jardim"
    SNames.7 = "McGinn"
    SNames.8 = "Myers"
    SNames.9 = "Namocatcat"
    SNames.10 = "Cook"
    SNames.11 = "Atwood"
    SNames.12 = "Elison"
    SNames.13 = "Lucas"
    SNames.14 = "Herbert"
    SNames.15 = "Dandy"
    SNames.16 = "Vincent"
    SNames.17 = "Haba"
    SNames.18 = "Parsons"

    /* The following array is our list of regions 
    */
    RName.0 = 8
    RName.1 = "Waterloo"
    RName.2 = "L.A."
    RName.3 = "Toronto"
    RName.4 = "Tokyo"
    RName.5 = "Cairo"
    RName.6 = "New York"
    RName.7 = "Paris"
    RName.8 = "London"

    /* This is just the number of employees per region 
    */
    Names = 4
    
    /* The array of products 
    */
    Prod.0 = 3
    Prod.1 = "Apples"
    Prod.2 = "Oranges"
    Prod.3 = "Bananas"

    /* Make sure our charts are set up nice 
    */
    call VRMethod "WC_Regions", "SetDataSize", RName.0, 1
    call VRMethod "WC_People", "SetDataSize", Names, 1
    call VRMethod "WC_Products", "SetDataSize", Prod.0, 1

    /* Generate the data, and fill up the regions chart 
    */
    do i = 1 to RName.0
        sum = 0
        MaxR = Random( 8000, 20000 )
        do j = 1 to Names
            MaxS = MaxR + Random( 0, 8000 ) - 4000
            do k = 1 to Prod.0
                Data.i.j.k = Random( 3, MaxS )
                sum = sum + Data.i.j.k
            end
            fr = Random( 1, FNames.0 )
            sr = Random( 1, SNames.0 )
            Name.i.j = FNames.fr SNames.sr
        end
        call VRMethod "WC_Regions", "SetRowName", i, RName.i
        call VRMethod "WC_Regions", "SetDataValue", i, 1, sum
    end

    /* Set up the products chart */
    do i = 1 to Prod.0
        call VRMethod "WC_Products", "SetRowName", i, Prod.i
    end

    /* Mode is used to tell us how deep we are - helps when zooming out 
    */

    Mode = 0

    call VRSet "WC_Regions", "Visible", 1
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    /* Create the chart data
    */

    call GenData
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The product information is displayed with a multi-line
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 6
    message.1 = "Chart Drill-down Sample"
    message.2 = ""
    message.3 = "This sample application shows an"
    message.4 = "example of how a chart may be used"
    message.5 = "to generate an effective presentation"
    message.6 = "of related information."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         PB_ZoomOut_Click
*/
PB_ZoomOut_Click:
    /* Mode is used to keep track of the 3 zoom levels,
    */

    if( \Mode )then do
        call VRSet "WC_People", "Visible", 0
        call VRSet "WC_Regions", "Visible", 1
        call VRSet "PB_ZoomOut", "Enabled", 0
    end
    else do
        call VRSet "WC_Products", "Visible", 0
        call VRSet "WC_People", "Visible", 1  
        Mode = 0  
    end
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         WC_People_DoubleClick
*/
WC_People_DoubleClick:
    /* Zoom into the next chart
    */

    item = VRInfo( "Item" )
    parse var item regn'.'group'.'row'.'col

    if( regn = "ChartGroup" )then do
        /* Set the chart options according the selected chart.
        */

        call VRMethod "WC_Products", "SetOption", "Title", Name.CurrRegion.row
        call VRSet "WC_Products", "HintText", "Chart of sales by product for " || Name.CurrRegion.row

        /* Fill in all the data
        */

        do i = 1 to Prod.0
            sum = Data.CurrRegion.row.i
            call VRMethod "WC_Products", "SetDataValue", i, 1, sum
            call VRMethod "WC_Products", "SetRowName", i, Prod.i
        end

        /* Make the appropriate charts visible
        */

        call VRSet "WC_People", "Visible", 0
        call VRSet "WC_Products", "Visible", 1
        Mode = 1
    end
return

/*:VRX         WC_Regions_DoubleClick
*/
WC_Regions_DoubleClick:
    /* Zoom into the next chart
    */

    item = VRInfo( "Item" )
    parse var item regn'.'group'.'CurrRegion'.'col

    if( regn = "ChartGroup" )then do
        /* Set the chart options according to the selected bar.
        */

        call VRMethod "WC_People", "SetOption", "Title", RName.CurrRegion

        /* Fill in all the chart data.
        */

        do i = 1 to Names
            sum = 0
            do j = 1 to Prod.0
                sum = sum + Data.CurrRegion.i.j
            end
            call VRMethod "WC_People", "SetDataValue", i, 1, sum
            call VRMethod "WC_People", "SetRowName", i, Name.CurrRegion.i
        end

        /* Make the appropriate charts visible
        */

        call VRSet "WC_Regions", "Visible", 0
        call VRSet "WC_People", "Visible", 1
        call VRSet "PB_ZoomOut", "Enabled", 1
    end
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

