/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The product information is displayed with a multi-line 
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Chart Mini Click Sample"
    message.2 = ""
    message.3 = "This sample application shows a simple"
    message.4 = "way to handle chart events."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         ParseEvent
*/
ParseEvent:
    /* Update the event information
    */

    event = VRInfo( "E" )
    item = VRInfo( "Item" )

    parse var item region'.'group'.'row'.'col
    call VRSet "DT_Event", "Caption", event
    call VRSet "DT_Region", "Caption", region
    call VRSet "DT_Group", "Caption", group
    call VRSet "DT_Row", "Caption", row
    call VRSet "DT_Column", "Caption", col
return

/*:VRX         Quit
*/
Quit:
    /* Close the application    
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         WC_1_Click
*/
WC_1_Click:
    /* Update the event information
    */

    call ParseEvent
return

/*:VRX         WC_1_ContextMenu
*/
WC_1_ContextMenu:
    /* Update the event information
    */

    call ParseEvent
return

/*:VRX         WC_1_DoubleClick
*/
WC_1_DoubleClick:
    /* Update the event information
    */

    call ParseEvent
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

