/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the Window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the Window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_Area_Click
*/
MI_Area_Click:
    /* Change the graph type and checked menu item to
       an Area Graph.
    */

    call VRMethod "WC_1", "SetOption", "ChartType", "AreaChart"

    call VRSet "MI_Area", "Checked", 1
    call VRSet "MI_Bar", "Checked", 0
    call VRSet "MI_Pie", "Checked", 0
    call VRSet "MI_Line", "Checked", 0
    call VRSet "MI_Gantt", "Checked", 0
return

/*:VRX         MI_Bar_Click
*/
MI_Bar_Click:
    /* Change the graph type and checked menu item to 
       a Bar Chart.
    */

    call VRMethod "WC_1", "SetOption", "ChartType", "BarChart"

    call VRSet "MI_Area", "Checked", 0
    call VRSet "MI_Bar", "Checked", 1
    call VRSet "MI_Pie", "Checked", 0
    call VRSet "MI_Line", "Checked", 0
    call VRSet "MI_Gantt", "Checked", 0
return

/*:VRX         MI_Gantt_Click
*/
MI_Gantt_Click:
    /* Change the graph type and the checked menu item to
       a Gantt graph.
    */

    call VRMethod "WC_1", "SetOption", "ChartType", "GanttChart"

    call VRSet "MI_Area", "Checked", 0
    call VRSet "MI_Bar", "Checked", 0
    call VRSet "MI_Pie", "Checked", 0
    call VRSet "MI_Line", "Checked", 0
    call VRSet "MI_Gantt", "Checked", 1
return

/*:VRX         MI_Line_Click
*/
MI_Line_Click:
    /* Change the graph type and checked menu item to
       Line Chart.
    */

    call VRMethod "WC_1", "SetOption", "ChartType", "LineChart"

    call VRSet "MI_Area", "Checked", 0
    call VRSet "MI_Bar", "Checked", 0
    call VRSet "MI_Pie", "Checked", 0
    call VRSet "MI_Line", "Checked", 1
    call VRSet "MI_Gantt", "Checked", 0
return

/*:VRX         MI_Pie_Click
*/
MI_Pie_Click:
    /* Change the chart type to PieChart
    */

    call VRMethod "WC_1", "SetOption", "ChartType", "PieChart"

    /* Set the current checked menu item
    */

    call VRSet "MI_Area", "Checked", 0
    call VRSet "MI_Bar", "Checked", 0
    call VRSet "MI_Pie", "Checked", 1
    call VRSet "MI_Line", "Checked", 0
    call VRSet "MI_Gantt", "Checked", 0

return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The Product Information is displayed by a multi-line
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Chart Copy and Paste Example"
    message.2 = ""
    message.3 = "Click on the chart with the right mouse"
    message.4 = "button to bring up a pop-up menu."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1    
return

/*:VRX         Quit
*/
Quit:
    /* Close the application    
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         WC_1_ContextMenu
*/
WC_1_ContextMenu:
    /* Call the popup menu
    */

    left = VRInfo( "Left" )
    top = VRInfo( "Top" )
    source = VRInfo( "Source" )
    call VRMethod "PopupMenu", "Popup", left, top
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

