/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         CommonRet
*/
CommonRet: procedure expose Globals.
    parse arg Refresh

    column.0 = 0
    value.0 = 0
    call VRMethod "Application", "PutVar", "column."
    call VRMethod "Application", "PutVar", "value."
    call VRMethod "Application", "PutVar", "Refresh"
return

/*:VRX         DDCB_SearchField_Change
*/
DDCB_SearchField_Change:
    field = VRGet( "DDCB_SearchField", "Value" )
    value = VRGet( "EF_SearchValue", "Value" )
    if( ( field \= "" ) & ( value \= "" ) ) then
        ok = VRSet( "PB_SI_Add", "Enabled", 1 )
return

/*:VRX         EF_SearchValue_Change
*/
EF_SearchValue_Change: 
    field = VRGet( "DDCB_SearchField", "Value" )
    value = VRGet( "EF_SearchValue", "Value" )
    if( ( field \= "" ) & ( value \= "" ) ) then
        ok = VRSet( "PB_SI_Add", "Enabled", 1 )
    else
        ok = VRSet( "PB_SI_Add", "Enabled", 0 )
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    ok = VRMethod( "Application", "GetVar", "Titles." )

    ok = VRSet( "DT_3", "Caption", "Search " || InitArgs.1 )
    ok = VRMethod( "DDCB_SearchField", "AddStringList", "Titles."  )
    fieldHandle = VRMethod( "CN_Conditions", "AddField", "String", "Field", "Field" )
    fieldHandle = VRMethod( "CN_Conditions", "AddField", "String", "Value", "Value" )

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         PB_SI_Add_Click
*/
PB_SI_Add_Click:
    field = VRGet( "DDCB_SearchField", "Value" )
    value = VRGet( "EF_SearchValue", "Value" )

    ok = VRMethod( "DDCB_SearchField", "DeleteString", field )

    newrec = VRMethod( "CN_Conditions", "AddRecord", , "Last", field, "", ,  )
    ok = VRMethod( "CN_Conditions", "SetFieldData", newrec, "Field", field, "Value", value )

    ok = VRSet( "PB_SI_Remove", "Enabled", 1 )
    ok = VRSet( "PB_SI_Ok", "Enabled", 1 )

    ok = VRSet( "DDCB_SearchField", "Value", "" )
    ok = VRSet( "EF_SearchValue", "Value", "" )
return

/*:VRX         PB_SI_ALL_Click_Click
*/
PB_SI_ALL_Click_Click: 
    Call CommonRet 1
    Call Quit
return

/*:VRX         PB_SI_Cancel_Click
*/
PB_SI_Cancel_Click:
    call CommonRet 0
    call Quit
return

/*:VRX         PB_SI_Ok_Click
*/
PB_SI_Ok_Click:
    ok = VRMethod( "CN_Conditions", "GetRecordList", "All", "reclist." )
    column.0 = reclist.0
    value.0 = reclist.0    
    do i = 1 to reclist.0
        column.i = VRMethod( "CN_Conditions", "GetFieldData", reclist.i, "Field" )
        value.i  = VRMethod( "CN_Conditions", "GetFieldData", reclist.i, "Value" )
    end

    Refresh = 1
    call VRMethod "Application", "PutVar", "column."
    call VRMethod "Application", "PutVar", "value."
    call VRMethod "Application", "PutVar", "Refresh"
    call Quit
return

/*:VRX         PB_SI_Remove_Click
*/
PB_SI_Remove_Click:
    ok = VRMethod( "CN_Conditions", "GetRecordList", "Selected", "reclist." )
    if( reclist.0 > 0 ) then do
        field = VRMethod( "CN_Conditions", "GetFieldData", reclist.1, "Field" )
        ok = VRMethod( "CN_Conditions", "RemoveRecord", reclist.1 )
        position = VRMethod( "DDCB_SearchField", "AddString", field,  )
    end
    ok = VRMethod( "CN_Conditions", "GetRecordList", "All", "reclist." )
    if( reclist.0 <= 0 ) then do
        ok = VRSet( "PB_SI_Ok", "Enabled", 0 )
        ok = VRSet( "PB_SI_Remove", "Enabled", 0 )
    end
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Search_Close
*/
Search_Close:
    call CommonRet 0
    call Quit
return

