/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GameButton
*/
GameButton: procedure expose Colors. Picked. CurrRow
    parse arg row, column

    /* If the button is not in the current row, then copy the color up
        to the current row.
    */

    if( row < CurrRow ) then do
        color = VRGet( "PB_R" || row || "C" || column, "BackColor" )
    end
    else do
        color = Colors.!curr
    end
    call VRSet "PB_R" || CurrRow || "C" || column, "BackColor", color

    /* Enable guess only if all all 4 colors were selected.
    */

    Picked.column = 1
    do i = 1 to 4
        if( \Picked.i ) then do
            signal GBDone
        end
    end
    call VRSet "PB_Guess", "Enabled", 1

GBDone:
return

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: procedure expose Colors. Soln. Picked. CurrRow
    /* Define all the colors.
    */

    Colors.1 = "Blue"
    Colors.2 = "Red"
    Colors.3 = "Green"
    Colors.4 = "Pink"
    Colors.5 = "Cyan"
    Colors.6 = "Yellow"
    Colors.0 = 6
    do i = 1 to Colors.0
        call VRSet "PB_Color" || i, "BackColor", Colors.i
    end

    /* Initialize the global variables for a new game.
    */

    CurrRow = 1
    Colors.!curr = Colors.1
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
    call NewGame

    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return

/*:VRX         MN_New_Click
*/
MN_New_Click:
    call NewGame
return

/*  Reset the game board.
*/

NewGame: procedure expose Colors. Soln. Picked. CurrRow
    if CurrRow > 10 then CurrRow = 10
    do i = 2 to CurrRow
        call VRSet "DT_Row" || i, "Caption", ""
        do j = 1 to 4
            call VRSet "PB_R" || i || "C" || j, "Visible", 0
            call VRSet "PB_R" || i || "C" || j, "BackColor", "<default>"
        end
    end

    do i = 1 to 4
        call VRSet "PB_R0C" || i, "BackColor", "<default>"
        call VRSet "PB_R1C" || i, "BackColor", "<default>"
        Picked.i = 0
    end

    do i = 1 to 4
        j = Random( 1, Colors.0 )
        Soln.i = Colors.j
    end

    call VRSet "DT_Row1", "Caption", "<==="
    call VRSet "PB_Guess", "Enabled", 0
    CurrRow = 1
return

/*:VRX         MN_Peek_Click
*/
MN_Peek_Click:
    call ShowSoln
    call VRMessage VRWindow(), "Game over. You peeked!", "Mind Game", "I"
    call NewGame
return

/*:VRX         MN_ProdInfo_Click
*/
MN_ProdInfo_Click:
    call About VRWindow()
return

/*:VRX         PB_Color1_Click
*/
PB_Color1_Click:
    Colors.!curr = Colors.1
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Color2_Click
*/
PB_Color2_Click:
    Colors.!curr = Colors.2
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Color3_Click
*/
PB_Color3_Click:
    Colors.!curr = Colors.3
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Color4_Click
*/
PB_Color4_Click:
    Colors.!curr = Colors.4
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Color5_Click
*/
PB_Color5_Click:
    Colors.!curr = Colors.5
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Color6_Click
*/
PB_Color6_Click:
    Colors.!curr = Colors.6
    call VRSet "PB_CurrColor", "BackColor", Colors.!curr
return

/*:VRX         PB_Guess_Click
*/
PB_Guess_Click:
    /* Check to see if the correct solution was entered.
    */

    correct = 0
    do i = 1 to 4
        Picked.i = 0
        if( VRGet( "PB_R" || CurrRow || "C" || i, "BackColor" ) = Soln.i ) then do
            correct = correct + 1
        end
    end

    /* Add the hints beside the solutino
    */

    almost = 0
    do i = 1 to Colors.0
        userCount = 0
        do j = 1 to 4
            if( VRGet( "PB_R" || CurrRow || "C" || j, "BackColor" ) = Colors.i ) then do
                userCount = userCount + 1
            end
        end
        solCount = 0
        do j = 1 to 4
            if( Soln.j = Colors.i ) then do
                solCount = solCount + 1
            end
        end
        almost = almost + Min( userCount, solCount )
    end
    almost = almost - correct

    call VRSet "DT_Row" || CurrRow, "Caption", Copies( "X", correct ) || Copies( "O", almost )
    if( correct = 4 ) then do
        call ShowSoln
        call VRMessage VRWindow(), "Congratulations! You guessed the right combination in" CurrRow "turns.", "YOU WIN!", "I"
        call NewGame
        signal GuessDone
    end

    /* Advance to the next row.
    */

    CurrRow = CurrRow + 1
    if( CurrRow > 10 ) then do
        call ShowSoln
        call VRMessage VRWindow(), "Sorry, but you have run out of turns.", "You Lose.", "I"
        call NewGame
        signal GuessDone
    end

    /* Make the next row visible
    */

    do i = 1 to 4
        call VRSet "PB_R" || CurrRow || "C" || i, "Visible", 1
    end
    call VRSet "DT_Row" || CurrRow, "Caption", "<==="

GuessDone:
    call VRSet "PB_Guess", "Enabled", 0
    call VRSet "PB_R" || (CurrRow - 1) || "C1", "TabStop", 0
    call VRSet "PB_R" || (CurrRow - 1) || "C2", "TabStop", 0
    call VRSet "PB_R" || (CurrRow - 1) || "C3", "TabStop", 0
    call VRSet "PB_R" || (CurrRow - 1) || "C4", "TabStop", 0
    drop correct almost i j userCount solCount
return

/*:VRX         PB_R10C1_Click
*/
PB_R10C1_Click:
    call GameButton 10, 1
return

/*:VRX         PB_R10C2_Click
*/
PB_R10C2_Click:
    call GameButton 10, 2    
return

/*:VRX         PB_R10C3_Click
*/
PB_R10C3_Click:
    call GameButton 10, 3
return
/*:VRX         PB_R10C4_Click
*/
PB_R10C4_Click:
    call GameButton 10, 4
return
/*:VRX         PB_R1C1_Click
*/
PB_R1C1_Click:
    call GameButton 1, 1
return
/*:VRX         PB_R1C2_Click
*/
PB_R1C2_Click:
    call GameButton 1, 2
return
/*:VRX         PB_R1C3_Click
*/
PB_R1C3_Click:
    call GameButton 1, 3
return
/*:VRX         PB_R1C4_Click
*/
PB_R1C4_Click:
    call GameButton 1, 4
return
/*:VRX         PB_R2C1_Click
*/
PB_R2C1_Click:
    call GameButton 2, 1
return
/*:VRX         PB_R2C2_Click
*/
PB_R2C2_Click:
    call GameButton 2, 2
return
/*:VRX         PB_R2C3_Click
*/
PB_R2C3_Click:
    call GameButton 2, 3
return
/*:VRX         PB_R2C4_Click
*/
PB_R2C4_Click:
    call GameButton 2, 4
return
/*:VRX         PB_R3C1_Click
*/
PB_R3C1_Click:
    call GameButton 3, 1
return
/*:VRX         PB_R3C2_Click
*/
PB_R3C2_Click:
    call GameButton 3, 2
return
/*:VRX         PB_R3C3_Click
*/
PB_R3C3_Click:
    call GameButton 3, 3
return
/*:VRX         PB_R3C4_Click
*/
PB_R3C4_Click:
    call GameButton 3, 4
return
/*:VRX         PB_R4C1_Click
*/
PB_R4C1_Click:
    call GameButton 4, 1
return
/*:VRX         PB_R4C2_Click
*/
PB_R4C2_Click:
    call GameButton 4, 2
return
/*:VRX         PB_R4C3_Click
*/
PB_R4C3_Click:
    call GameButton 4, 3
return
/*:VRX         PB_R4C4_Click
*/
PB_R4C4_Click:
    call GameButton 4, 4
return
/*:VRX         PB_R5C1_Click
*/
PB_R5C1_Click:
    call GameButton 5, 1
return
/*:VRX         PB_R5C2_Click
*/
PB_R5C2_Click:
    call GameButton 5, 2
return
/*:VRX         PB_R5C3_Click
*/
PB_R5C3_Click:
    call GameButton 5, 3
return
/*:VRX         PB_R5C4_Click
*/
PB_R5C4_Click:
    call GameButton 5, 4
return
/*:VRX         PB_R6C1_Click
*/
PB_R6C1_Click:
    call GameButton 6, 1
return
/*:VRX         PB_R6C2_Click
*/
PB_R6C2_Click:
    call GameButton 6, 2
return
/*:VRX         PB_R6C3_Click
*/
PB_R6C3_Click:
    call GameButton 6, 3
return
/*:VRX         PB_R6C4_Click
*/
PB_R6C4_Click:
    call GameButton 6, 4
return
/*:VRX         PB_R7C1_Click
*/
PB_R7C1_Click:
    call GameButton 7, 1
return
/*:VRX         PB_R7C2_Click
*/
PB_R7C2_Click:
    call GameButton 7, 2
return
/*:VRX         PB_R7C3_Click
*/
PB_R7C3_Click:
    call GameButton 7, 3
return
/*:VRX         PB_R7C4_Click
*/
PB_R7C4_Click:
    call GameButton 7, 4
return
/*:VRX         PB_R8C1_Click
*/
PB_R8C1_Click:
    call GameButton 8, 1
return
/*:VRX         PB_R8C2_Click
*/
PB_R8C2_Click:
    call GameButton 8, 2
return
/*:VRX         PB_R8C3_Click
*/
PB_R8C3_Click:
    call GameButton 8, 3
return
/*:VRX         PB_R8C4_Click
*/
PB_R8C4_Click:
    call GameButton 8, 4
return
/*:VRX         PB_R9C1_Click
*/
PB_R9C1_Click:
    call GameButton 9, 1
return
/*:VRX         PB_R9C2_Click
*/
PB_R9C2_Click:
    call GameButton 9, 2
return
/*:VRX         PB_R9C3_Click
*/
PB_R9C3_Click:
    call GameButton 9, 3
return
/*:VRX         PB_R9C4_Click
*/
PB_R9C4_Click:
    call GameButton 9, 4
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ShowSoln
*/
ShowSoln:
    /* Change all the colors of the solution buttons
    */

    call VRSet "PB_Guess", "Enabled", 0
    do i = 1 to 4
        call VRSet "PB_R0C" || i, "BackColor", Soln.i
    end
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return
