/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MainWin_Close
*/
MainWin_Close:
    call Quit
return

/*:VRX         MLWin1_Close
*/
MLWin1_Close:
    /* Close the secondary window
    */

    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         MLWin2_Close
*/
MLWin2_Close:
    /* Close the secondary window
    */

    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         PB_Modal_Click
*/
PB_Modal_Click:
    call ModalWin VRWindow()
return

/*:VRX         PB_Modeless1_Click
*/
PB_Modeless1_Click:
    /* Note that a modeless window can not be in a seperate file.
    */

    call VRLoadSecondary "MLWin1"
return

/*:VRX         PB_Modeless2_Click
*/
PB_Modeless2_Click:
    /* Note that a modeless window can not be in a seperate file.
    */

    call VRLoadSecondary "MLWin2"
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

