/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini: procedure
    signal on SYNTAX name FiniDone

    call VRSet VRWindow(), "Visible", 0
    call mciRxExit

FiniDone:
return 0

/*:VRX         Halt
*/
Halt:
    call Quit
return
/*:VRX         Init
*/
Init: procedure
    signal on FAILURE name InitError
    signal on SYNTAX name InitError

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    if( RxFuncQuery( "mciRxInit" ) = 0 ) then do
        signal InitDone
    end
    call RxFuncAdd "mciRxInit", "MCIAPI", "mciRxInit"
    if( mciRxInit() <> 0 ) then do
        call VRMessage window, "Unable to initialize multimedia functions.", "Movies", "E"
        call Quit
    end

InitDone: 
return

InitError:
    call VRMessage VRWindow(), "Couldn't load MMOS/2 REXX interface!", "Error", "Error"
    call Quit
return
/*:VRX         PB_NoWait_Click
*/
PB_NoWait_Click:
    listName = VRGet( "LB_Playing", "Self" )
    call VRMethod "Application", "StartThread", "Play", "", listName
    drop listName
return

/*:VRX         PB_Wait_Click
*/
PB_Wait_Click:
    window = VRWindow()
    call VRSet window, "Enabled", 0
    listName = VRGet( "LB_Playing", "Self" )
    call Play window, listName
    call VRSet window, "Enabled", 1
    drop window listName
return

/*:VRX         Quit
*/
Quit: procedure
    call VRSet VRWindow(), "ShutDown", 1
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

