/*:VRX         Main
*/
Main:
    parse arg window, listbox
    movie = VRFileDialog( window, "Select a movie", "O", "*.AVI" )
    if( movie = "" ) then do
        signal MainDone
    end
    if( \VRFileExists( movie ) ) then do
        call VRMessage window, "File '" || movie || "' not found.", "Movies", "E"
        signal MainDone
    end

    tid = VRMethod( "Application", "GetThreadID" )
    title = "Thread" tid || ":" movie     
    call VRMethod listbox, "AddString", "Thread" tid || ":" movie
    call PlayMovie movie, tid
    call VRMethod listbox, "DeleteString", title

MainDone:
exit

PlayMovie: procedure
    parse arg movie, tid
    alias = "dv" || tid

    if( \Send( "open digitalvideo alias" alias "shareable wait" ) ) then do
        signal PlayDone
    end
    if( \Send( "load" alias movie "wait" ) ) then do
        signal PlayDone
    end
    if( \Send( "set" alias "time format ms wait" ) ) then do
        signal PlayDone
    end
    if( \Send( "setpositionadvise" alias "on every 500 wait" ) ) then do
        signal PlayDone
    end

    do i = 1 to 8
        if( \Send( "play" alias "wait" ) ) then do
            signal PlayDone
        end
        if( \Send( "seek" alias "to 0 wait" ) ) then do
            signal PlayDone
        end
    end

    call Send( "close" alias "wait" )

PlayDone:
return

Send: procedure
    parse arg command
    rc = mciRxSendString( command, "text", 0, 0 )
    if( rc = 0 ) then do
        ok = 1
        signal SendDone
    end

    call mciRxGetErrorString rc, "errtext"
    msg.1 = "Unable to execute a multimedia command."
    msg.2 = ""
    msg.3 = "Command:     '" || command || "'"
    msg.4 = ""
    msg.5 = "Return code: '" || rc || "'"
    msg.6 = "Return text: '" || text || "'"
    msg.7 = "Error text:  '" || errtext || "'"
    msg.0 = 7

    call VRMessageStem "", "msg."
    ok = 0

SendDone:    
return ok
