/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         ColorWin_Close
*/
ColorWin_Close:
    /* ColorWin is a notebook page.
    */

    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         ColorWin_Create
*/
ColorWin_Create:
    /* Get the color and size values of the button
    */

    call VRSet "DDCB_BackColor", "Value", VRGet( "PB_PressMe", "BackColor" )
    call VRSet "DDCB_ForeColor", "Value", VRGet( "PB_PressMe", "ForeColor" )
    call VRMethod "DDCB_BackColor", "SetFocus" 
return

/*:VRX         DDCB_BackColor_Change
*/
DDCB_BackColor_Change:
    call VRSet "PB_PressMe", "BackColor", VRGet( "DDCB_BackColor", "Value" )
return

/*:VRX         DDCB_ForeColor_Change
*/
DDCB_ForeColor_Change:
    call VRSet "PB_PressMe", "ForeColor", VRGet( "DDCB_ForeColor", "Value" )
return

/*:VRX         EF_Height_Change
*/
EF_Height_Change:
    call VRSet "PB_PressMe", "Height", VRGet( "EF_Height", "Value" )
return

/*:VRX         EF_Width_Change
*/
EF_Width_Change:
    call VRSet "PB_PressMe", "Width", VRGet( "EF_Width", "Value" )
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MainWin_Close
*/
MainWin_Close:
    call Quit
return

/*:VRX         MN_ProductInfo_Click
*/
MN_ProductInfo_Click:
    call About VRWindow()
return

/*:VRX         NBWin_Close
*/
NBWin_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         PB_PressMe_Click
*/
PB_PressMe_Click:
    if( \VRIsValidObject( "NBWin" ) ) then do
        call VRLoadSecondary "NBWin"
    end
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SizeWin_Close
*/
SizeWin_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         SizeWin_Create
*/
SizeWin_Create:
    /* SizeWin is a notebook page.
    */

    call VRSet "EF_Height", "Value", VRGet( "PB_PressMe", "Height" )
    call VRSet "EF_Width", "Value", VRGet( "PB_PressMe", "Width" )
    call VRMethod "EF_Height", "SetFocus"
return

