/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init: 
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    /* Change the focus to the value set
    */
    
    IgnoreChange = 0
    call VRSet "VALUE_RGB", "Selected", 1
    call SetSliders
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SetColor
*/
SetColor: procedure expose IgnoreChange
    parse arg color, value

    /*  Get the color of the selected item
    */
    selected = VRGet( "VALUE_RGB", "Selected" )
    call VRMethod "VALUE_RGB", "GetAttributes", "Values", "attrs."
    parse var attrs.selected "("red","green","blue")"

    /*  Set the color of the slider ribbon strip
    */
    value = Trunc( 255 * ( value / 100 ) )
    if( color = "Red" ) then do
        red = value
        call VRSet "SL_Red", "RibbonColor", "(" || red || ",0,0)"
    end
    else if( color = "Green" ) then do
        green = value
        call VRSet "SL_Green", "RibbonColor", "(0," || green || ",0)"
    end
    else do
        blue = value
        call VRSet "SL_Blue", "RibbonColor", "(0,0," || blue || ")"
    end

    if( IgnoreChange \= 0 ) then do
        IgnoreChange = IgnoreChange - 1
        signal endSetColor
    end

    /*  Set the color of the value set item
    */
    attrs.selected = "(" || red || "," || green || "," || blue || ")"
    call VRMethod "VALUE_RGB", "SetAttributes", "Values", "attrs."
    call VRSet "DT_Settings", "Caption", attrs.selected

endSetColor:
return

/*:VRX         SetSliders
*/
SetSliders: procedure
    /* Change the sliders to show the RGB content of the selected
        color.
    */

    /* Get the selected color information   
    */
    selected = VRGet( "VALUE_RGB", "Selected" )
    call VRMethod "VALUE_RGB", "GetAttributes", "Values", "attrs."
    call VRSet "DT_Settings", "Caption", attrs.selected
    parse var attrs.selected "("red","green","blue")"

    /* Change the sliders.
    */
    call VRSet "SL_Red", "Percentile", Trunc( red * 100 / 255 )
    call VRSet "SL_Green", "Percentile", Trunc( green * 100 / 255 )
    call VRSet "SL_Blue", "Percentile", Trunc( blue * 100 / 255 )
return

/*:VRX         SL_Blue_Change
*/
SL_Blue_Change:
    /* Change the blue content of the selected color
    */
    
    call SetColor "Blue", VRGet( "SL_Blue", "Percentile" )
return

/*:VRX         SL_Blue_Track
*/
SL_Blue_Track:
    /* Change the color of the blue slider
    */

    call SetColor "Blue", VRGet( "SL_Blue", "Percentile" )
return

/*:VRX         SL_Green_Change
*/
SL_Green_Change:
    /* Change the green content of the selected color
    */

    call SetColor "Green", VRGet( "SL_Green", "Percentile" )
return

/*:VRX         SL_Green_Track
*/
SL_Green_Track:
    /* Change the color of the green slider.
    */

    call SetColor "Green", VRGet( "SL_Green", "Percentile" )
return

/*:VRX         SL_Red_Change
*/
SL_Red_Change:    
    /* Change the red content of the selected color 
    */

    call SetColor "Red", VRGet( "SL_Red", "Percentile" )
return

/*:VRX         SL_Red_Track
*/
SL_Red_Track:
    /* Change the color of the red slider.
    */
    
    call SetColor "Red", VRGet( "SL_Red", "Percentile" )
return

/*:VRX         VALUE_RGB_Click
*/
VALUE_RGB_Click:
    /* The currently selected color has just changed.
    */

    IgnoreChange = 3        /* Ignore the next three changes to the sliders. */
    call SetSliders
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

