/**/

call rxfuncadd "ZxAdmin","ZXMAILRX","ZxAdmin"
call rxfuncadd "ZxUser","ZXMAILRX","ZxUser"

/***************************************************************************
* Function:  ZxmMailLogin                                                  *
*                                                                          *
* Syntax:    rc=ZxmMailLogin(username,password,sessionid,                  *
*                            userdata,msglist,[server])                    *
*                                                                          *
*                                                                          *
* Parameter:                                                               *
*            username  input                                               *
*            password  input                                               *
*            sessionid output                                              *
*            userdata  output Stem variable struct is:                     *
*                      userdata.0   -number of items allways 1 in this case*
*                      userdata.1.!uid  -unique user id                    *
*                      userdata.1.!type  -type 1 = Admin 2 = User          *
*                      userdata.1.!tbytes -total bytes for messages        *
*                      userdata.1.!nbmsg  -number of message               *
*                      userdata.1.!mboxpath -path where the mail is stored *
*                                          for specified user, only valid  *
*                                          for local server                *
*                                                                          *
*            msglist   output Stem variable struct is index 1->n:          *
*                      msglist.0 -total number of message                  *
*                      msglist.x.!id   -database message id                *
*                      msglist.x.!uidl -unique message id                  *
*                      msglist.x.!usid -user id (duplication of            *
*                                     userdata.!uid)                       *
*                      msglist.x.!size -size of message                    *
*                      msglist.x.!file -message file name                  *
*                                      (no path 8.3 format                 *
*                                       ex: 00001234.MSG)                  *
*                                                                          *
*            server optional network server to connect to                  *
*                                                                          *
* Return:                                                                  *
*            RESPONSE_SUCCESS               0                              *
*            ERROR_SERVER_NOT_RUNNING       1                              *
*            ERROR_SERVER_NOT_FOUND         2                              *
*            RESPONSE_FAILED                3                              *
*            ERROR_DBERROR                  4                              *
*            ERROR_LOGIN_INVALID_USER       5                              *
*            ERROR_LOGIN_INVALID_PASSWORD   6                              *
*            ERROR_INVALID_ARGUMENTS        7                              *
*            ERROR_INVALID_NB_ARGUMENTS     8                              *
*                                                                          *
***************************************************************************/
/* fill in a user name with admin rights */
user = ""
pwd = ""

rc = ZxAdmin('LOGIN',user,pwd,'sessionid')
say 'rc mail login='rc
if(rc<>0) then return 0
say 'sessionid='sessionid

rc = cleanup()
return 0

/*
rc = ZxUser('LOGIN',user,pwd,'sessionid','userdata','msglist')
say 'rc mail login='rc
if(rc<>0) then return 0
say 'sessionid='sessionid


say 'userdata.!uid     ='userdata.!uid
say 'userdata.!type    ='userdata.!type
if(userdata.!type == 2) then
  say 'user type is "USER"'
else if (userdata.!type == 1) then
  say 'user type is "ADMIN"'
else
  say 'user type is "UNKNOWN"'
say 'userdata.!tbytes  ='userdata.!tbytes' bytes'
say 'userdata.!nbmsg   ='userdata.!nbmsg
say 'userdata.!mboxpath='userdata.!mboxpath

say 'msglist.0='msglist.0
do i = 1 while i<=msglist.0
say 'msglist.'i'.!id  ='msglist.i.!id
say 'msglist.'i'.!uidl='msglist.i.!uidl
say 'msglist.'i'.!usid='msglist.i.!usid
say 'msglist.'i'.!size='msglist.i.!size
say 'msglist.'i'.!file='msglist.i.!file
end*/

/* this clears up userdata stem so we are sure we have new data */
drop userdata.

/*rc=zxuser('INFO',sessionid,'userdata')
say 'rc info='rc
if(rc<>0) then
  do
  rc = cleanup()
  return 0
  end

say 'userdata.!username     ='userdata.!username
say 'userdata.!uid     ='userdata.!uid
say 'userdata.!type    ='userdata.!type
if(userdata.!type == 2) then
  say 'user type is "USER"'
else if (userdata.!type == 1) then
  say 'user type is "ADMIN"'
else
  say 'user type is "UNKNOWN"'
say 'userdata.!tbytes  ='userdata.!tbytes' bytes'
say 'userdata.!nbmsg   ='userdata.!nbmsg
say 'userdata.!mboxpath='userdata.!mboxpath*/

/* this clears up msglist stem so we are sure we have new data */
drop msglist.

/*rc = ZxUser('MSG', 'LIST', sessionid, 'msglist')
say 'rc msg list='rc
if(rc<>0) then
  do
  rc = cleanup()
  return 0
  end

say 'msglist.0='msglist.0
if(rc==0) then
do i = 1 while i<=msglist.0
say 'msglist.'i'.!id  ='msglist.i.!id
say 'msglist.'i'.!uidl='msglist.i.!uidl
say 'msglist.'i'.!usid='msglist.i.!usid
say 'msglist.'i'.!size='msglist.i.!size
say 'msglist.'i'.!file='msglist.i.!file
end*/

/* test of zxadmin functions */
sid = sessionid
/* on these they should all return ERROR_ZXMAIL_ACCESS_DENIED 21 */

stem.!aliasid = 0
stem.!domainid = 0


stem.!domain = "bidon.com"

/*rc = ZxAdmin('DOMAIN', 'ADD', sid, 'stem')
say 'rc DOMAIN ADD='rc*/

/*domid = 3
mailboxid = 1
rc = ZxAdmin('DOMAIN', 'SETDEFAULTMBOX', sid, domid, mailboxid)
say 'rc DOMAIN SETDEFMBOX='rc*/

/*rc = ZxAdmin('DOMAIN', 'DEL', sid, domid)
say 'rc DOMAIN DEL='rc*/

/*rc = ZxAdmin('DOMAIN', 'MODIFY', sid, domid, "bcbg.com")
say 'rc DOMAIN MODIFY='rc*/

domid = 3
drop stem.

/*rc = ZxAdmin('DOMAIN', 'LIST', sid, 'stem')
say 'rc DOMAIN LIST='rc
say "stem.0  ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "domain  ="i
say "domainid="stem.i.!domainid
say "domain  ="stem.i.!domain
say "defmbox ="stem.i.!defaultmailbox
end


stem.!domainid = domid
rc = ZxAdmin('DOMAIN', 'GETINFO', sid, 'stem')
say 'rc DOMAIN GETINFO    ='rc
say 'stem.!domainid       ='stem.!domainid
say 'stem.!defaultmailbox ='stem.!defaultmailbox
say 'stem.!domain         ='stem.!domain

mailboxid = 1
rc = ZxAdmin('DOMAIN','ADDMBOX', sid, domid, mailboxid)
say 'rc DOMAIN ADDMBOX='rc*/

/*mailboxid = 1
rc = ZxAdmin('DOMAIN', 'DELMBOX', sid, domid, mailboxid)
say 'rc DOMAIN REMMBOX='rc*/

/*drop stem.
stem.!domainid = domid
rc = ZxAdmin('DOMAIN','LISTMBOX', sid, 'stem')
say 'rc DOMAIN LISTMBOX='rc
say "stem.0    ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "mailboxid  ="stem.i.!mailboxid
say "domuserid  ="stem.i.!domuserid
say "mailbox    ="stem.i.!mailbox
end

drop stem.

stem.!domainid = 3
stem.!mailboxid = 1
stem.!alias = "GWBush"
rc = ZxAdmin('ALIAS', 'ADD', sid, 'stem')
say 'rc ALIAS ADD='rc


drop stem.
stem.!domainid = domid
rc = ZxAdmin('ALIAS', 'LIST', sid, 'stem')
say 'rc DOMAIN LISTALIAS='rc
say "stem.0    ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "mailboxid  ="stem.i.!mailboxid
say "aliasid    ="stem.i.!aliasid
say "alias      ="stem.i.!alias
end

stem.!aliasid = 3
stem.!domainid = 3*/
/*stem.!alias = "Georges.Bush"*/
/*stem.!mailboxid = 2
rc = ZxAdmin('ALIAS', 'MODIFY', sid, 'stem')
say 'rc ALIAS MODIFY='rc


drop stem.
stem.!domainid = 3
rc = ZxAdmin('ALIAS', 'LIST', sid, 'stem')
say 'rc DOMAIN LISTALIAS='rc
say "stem.0     ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "mailboxid  ="stem.i.!mailboxid
say "aliasid    ="stem.i.!aliasid
say "alias      ="stem.i.!alias
end

domid = 3
aliasid = 3
rc = ZxAdmin('ALIAS', 'DEL', sid, domid, aliasid)
say 'rc ALIAS DEL='rc

drop stem.
stem.!domainid = 3
stem.!aliasid = 3
rc = ZxAdmin('ALIAS', 'GETINFO', sid, 'stem')
say 'rc ALIAS GETINFO='rc
say "mailboxid  ="stem.!mailboxid
say "aliasid    ="stem.!aliasid
say "alias      ="stem.!alias*/


stem.!mailbox = "bidon"
stem.!password = "bidon"
stem.!desc = "bidon"
stem.!type = 2
rc = ZxAdmin('MBOX', 'ADD', sid, 'stem')
say 'rc MBOX ADD='rc

/*drop stem.
mailboxid = 6
rc = ZxAdmin('MBOX', 'DEL', sid, mailboxid)
say 'rc MBOX DEL='rc*/

drop stem.
rc = ZxAdmin('MBOX', 'LIST', sid, 'stem')
say 'rc MBOX LIST='rc
say "stem.0     ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "---------------------------"
say "mailbox no "i
say "mailboxid  ="stem.i.!mailboxid
say "mailbox    ="stem.i.!mailbox
say "desc       ="stem.i.!desc
say "type       ="stem.i.!type
if(stem.i.!type == 2) then
say 'user type  = "USER"'
else if (stem.i.!type == 1) then
say 'user type  = "ADMIN"'
else
say 'user type  = "UNKNOWN"'
say "nbmsg      ="stem.i.!nbmsg
say "tbytes     ="stem.i.!tbytes
say "---------------------------"
say ""
end

drop stem.
stem.!mailboxid = 6
stem.!desc = "bidon"
stem.!type = 2
stem.!password = "bidon"
rc = ZxAdmin('MBOX', 'MODIFY', sid, 'stem')
say 'rc MBOX MODIFY='rc

drop stem.
stem.!mailboxid = 6
rc = ZxAdmin('MBOX', 'INFO', sid, 'stem')
say 'rc MBOX INFO='rc
if(rc==0) then
 do
 say "---------------------------"
 say "mailbox no "i
 say "mailboxid  ="stem.!mailboxid
 say "mailbox    ="stem.!mailbox
 say "desc       ="stem.!desc
 say "type       ="stem.!type
 if(stem.!type == 2) then
 say 'user type  = "USER"'
 else if (stem.!type == 1) then
 say 'user type  = "ADMIN"'
 else
 say 'user type  = "UNKNOWN"'
 say "nbmsg      ="stem.!nbmsg
 say "tbytes     ="stem.!tbytes
 say 'mboxpath   ='stem.!mboxpath

 say "---------------------------"
 say ""
 end

drop stem.
stem.!mailboxid = 1
rc = ZxAdmin('MBOX', 'LISTMSG', sid, 'stem')
say 'rc MBOX LISTMSG='rc
say "stem.0        ="stem.0
if(rc==0) then
do i =1 while i<=stem.0
say "---------------------------"
say "message no "i
say "message id    ="stem.i.!id
say "uidl number   ="stem.i.!uidl
say "message size  ="stem.i.!size
say "file          ="stem.i.!file
say "mailbox id    ="stem.i.!mailboxid
say "---------------------------"
say ""
end




/* we will test only once */
/*say "mid "msglist.2.!id
rc = ZxUser('MSG', 'DEL', sessionid, msglist.2.!id)
say 'rc DEL MSG='rc
if(rc<>0) then
  do
  rc = cleanup()
  return 0
  end
*/
rc = cleanup()
return 0;

cleanup:
rc=zxadmin('LOGOFF',sessionid)
say 'rc logoff='rc
return 0

