/*
 PB-GNU COOKIE ProBoard PEX Version
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of the PB-GNU COOKIE.

 PB-GNU COOKIE is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 PB-GNU COOKIE is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with PB-GNU COOKIE; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <pb_sdk.h>

#if !defined( MAXINT )
#define MAXINT 0x7fff
#endif

#if !defined( MAXPATH )
#define MAXPATH 80
#endif

#define randomize() srand( unsigned(time(NULL)) )
#define header \
"\f%cFortune Cookie %cv1.0 %cCopyright (C) 1995 by Silicon Creations Inc.\n"\
"%c%c\n\n"

#pragma warn -ofp
void
main( argc, argv )
    int  argc;
   char *argv[];
{
   char buf[0x1000], *p, *ptr, fname[MAXPATH];
   long ofs;
    int len, logoff = 0;
   FILE *dat;

   if( --argc ){
      if( !stricmp( *(argv + 1), "/LOGOFF" ) )
         logoff = 1;
   }

   strcpy( fname, *argv );
   *strrchr( fname, '.' ) = '\0';
   strcat( fname, ".DAT" );
   dat = fopen( fname, "r" );
   if( NULL == dat ){
      printf( "%cCouldn't open data file: '%c%s%c'. Please, notify your Sysop!\n"
              "%cPress [%cEnter%c] to continue...\t",
              RED, YELLOW, fname, RED,
              WHITE, YELLOW, WHITE );
      return;
   }

   randomize();
   ofs = l_mul( long(rand()), long(MAXINT) ) + rand();
   fseek( dat, 0, SEEK_END );
   ofs = l_mod( ofs, ftell( dat ) );

   fseek( dat, ofs, SEEK_SET );
   len = fread( buf, sizeof(char), 0x1000, dat );
   if( len < 0x1000 ){
      rewind( dat );
      len = fread( buf, sizeof(char), 0x1000, dat );
   }
   fclose( dat );

   buf[len - 1] = '\0';

   p = strchr( buf, '%' );
   if( NULL == p ) return;
   p++;

   ptr = strchr( p, '%' );
   if( NULL == ptr ) return;
   *ptr = '\0';

   CurUser->uFlags |= UFLAG_CLEAR;
   printf( header, YELLOW, RED, WHITE, RED, YELLOW );
   while( '\0' != *p ){
      if( '\t' == *p ) printf( "        " );
      else putchar( *p );
      p++;
   }

   if( logoff ){
      printf( "\n\n%cHanging up...", RED | BLINK );
      sleep( 2 );
      HangUp();
   }
   else{
      printf( "\n\n%cPress [%cEnter%c] to continue...\t",
              WHITE, YELLOW, WHITE );
   }
}
