/***********************************************************************
*                                                                      *
*  Definition file for QUOTE.HPP                                       *
*                                                                      *
*  Purpose : Definition of different colors for quote lines            *
*                                                                      *
*  Author  : Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*  eMail   : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*                                                                      *
* $Log: quote.hpv $
// Revision 1.1  1994/08/27  11:21:41  BRAINBOX
// Initial revision
//
//                                                                *
*                                                                      *
************************************************************************
*/



class QuoteEdit : public AbbreviationEdit
{
   private:

      unsigned char quoteColor ;
      void display(void) ;

   public:
      QuoteEdit(int x1, int y1, int x2, int y2, unsigned char *s) :
         AbbreviationEdit(x1, y1, x2, y2, s)
         {
            quoteColor = ( C_LIGHTGRAY << 4) | C_LIGHTRED ;
         } ;

      void redraw(void) ;
      void setQuoteColor(unsigned char col) ;
      unsigned char getQuoteColor(void) ;
} ;
