/***********************************************************************
*                                                                      *
*   Program  INTRUDE                                                   *
*   Author   Peter Bloemendaal                                         *
*            Brainbox systems +31-70-3523661                           *
*   eMail  : internet -> bloemendaal@rullf2.LeidenUniv.nl              *
*            fidonet  -> 2:281/908                                     *
*                                                                      *
*   Purpose  Place a message on the users screen (Proboard)            *
*                                                                      *
*----------------------------------------------------------------------*
*                                                                      *
*   This source is copyrighted and distributed under the GNU license   *
*                                                                      *
*   If you use parts of this source and distribute compiled versions   *
*   of it, you have to make your source available!!!                   *
*                                                                      *
*                                                                      *
*----------------------------------------------------------------------*
*  $Log: fulledit.cpv $
*/

// Disable the include below, to compile an EXE!!!
#include "PB_MBH.H"


#include "abbrev.cpp"
#include "border.hpp"

#define VERSION "Intrude 0.1"


class IntEdit : public AbbreviationEdit
{
   public:

      IntEdit(int x1, int y1, int x2, int y2, unsigned char *s)
         : AbbreviationEdit(x1, y1, x2, y2, s){ ; } ;
      int processKey(unsigned int)  ;
} ;

IntEdit::processKey(unsigned int key)
{
   return key ;
}



// The editor part itself
void intrude(void)
{

   IntEdit edit(10,5,70,15,(unsigned char*) "") ;
   Border  border(10, 5, 70, 15);


   edit.redraw() ;
   border.setTopColor((C_LIGHTGRAY << 4) | C_DARKGRAY) ;
   border.setBotColor((C_LIGHTGRAY << 4) | C_WHITE) ;
   border.open() ;
   edit.change() ;
   edit.saveFile("INTRUDE.SEM") ;

}


#ifdef _PB_SDK_H
int keyhandler(KEY k)
{
   if (k == KEY_ALTW)
   {
      LocalDisplay(FALSE) ;
      printf("\nPlease wait a moment...\n") ;
      RemoteDisplay(FALSE) ;
      LocalDisplay(TRUE) ;

      intrude() ;

      RemoteDisplay(TRUE) ;
      LocalDisplay(FALSE) ;
      printf("\nThanks for waiting!\n") ;
      LocalDisplay(TRUE) ;

      return HANDLED ;
   } else
      return NOT_HANDLED ;
}
#endif


void main(void)
{
#ifdef _PB_SDK_H
   InstallHandler(HANDLER_SYSOPKEY,keyhandler) ;
   ExitTSR() ;
#else
   intrude() ;
#endif
}
