/*
 * This file is part of LZSETUP (Configuration program for Listerz)
 *
 * Copyright (c) 1997 Branislav L. Slantchev (gargoyle)
 * A fine product of Silicon Creations, Inc.
 *
 * This file is released under the terms and conditions of the GNU
 * General Public License Version 2. The full text of the license is
 * supplied in the Copying.Doc file included with this archive. This
 * free software comes with absolutely no warranty, as outlined in the
 * licensing text. You are not allowed to remove this copyright notice.
 *
 * Contact: Branislav L. Slantchev at 73023.262@compuserve.com
*/
#include <stdlib.h>
#include <opdefine.h>
#include <opcrt.h>
#include <opstring.h>
#include <opcolor.h>
#include <opmenu.h>
#include "lzs_cmds.h"

extern FrameArray lz_FrameType;

word InitMenu(Menu &M, ColorSet &Colors)
  //-Initialize menu system generated by MAKEMENU
{
	//Frame #defines
	if( !M.InitCustom(6, 5, 29, 13, Colors,
					  wBordered+wClear+wUserContents+wCoversOnDemand,
					  Vertical))
	  return M.InitStatus;

	M.mnOptionsOn(mnAlphaMatch+mnSelectOnMatch+mnAllowPending+mnAllHotSpots+
				  mnUseItemForTopic);
	M.mnOptionsOff(mnArrowSelect+mnPopOnSelect+mnSelectOnClick+mnAltMatch);
	M.wFrame.SetFrameType(lz_FrameType);
	M.EnableExplosions(20);
	M.AddShadow(shBR, shSeeThru);
	M.AddHeader(" Main ", heTR);
	M.SetSelectMarker(" ", " ");
	M.AddItemHelp("Screen Layout", 2, 0, miScreen1, "Choose positions for output against the background file");
	  M.AddFramedSubMenu(23, 8, 41, 11, Vertical, lz_FrameType);
	  M.EnableExplosions(20);
	  M.AddShadow(shBR, shSeeThru);
	  M.AddHeader(" Screens ", heTR);
	  M.SetSelectMarker(" ", " ");
	  M.AddItemHelp("Area Selection", 2, 0, miMainScreen, "Layout control for the main selection screen");
	  M.AddItemHelp("Progress Report", 3, 0, miProcScreen, "Layout control for the progress report screen");
	  M.ItemsDone();
	M.AddItemHelp("Options and Colors", 3, 0, miOptions4, "Choose display characters and colors for the output");
	  M.AddFramedSubMenu(21, 9, 41, 15, Vertical, lz_FrameType);
	  M.EnableExplosions(20);
	  M.AddShadow(shBR, shSeeThru);
	  M.AddHeader(" Settings ", heTR);
	  M.SetSelectMarker(" ", " ");
	  M.AddItemHelp("Character Symbols", 2, 0, miCharacter5, "Select various status character symbols");
		M.AddFramedSubMenu(31, 12, 52, 18, Vertical, lz_FrameType);
		M.EnableExplosions(20);
		M.AddShadow(shBR, shSeeThru);
		M.AddHeader(" Symbols ", heTR);
		M.SetSelectMarker(" ", " ");
		M.AddItemHelp("Tag Character", 2, 0, miTagSymbol, "Select symbol to use to mark a tagged item");
		M.AddItemHelp("Progbar Foreground", 3, 9, miPbarFgChar, "Symbol used by the progress bar to show current status (Current Area)");
		M.AddItemHelp("Progbar Background", 4, 9, miPbarBgChar, "Symbol used by the progress bar to fill the area (Current Area)");
		M.AddItemHelp("Totals Progbar Fg",  5, 15, miPbarTotalFgChar, "Symbol used by the progress bar to show current status (Total Areas)");
		M.AddItemHelp("Totals Progbar Bg",  6, 15, miPbarTotalBgChar, "Symbol used by the progress bar to fill the area (Total Areas)");
		M.ItemsDone();
	  M.AddItemHelp("Selection List", 3, 0, miSelection6, "Select colors for the main screen area list");
		M.AddFramedSubMenu(34, 13, 53, 18, Vertical, lz_FrameType);
		M.EnableExplosions(20);
		M.AddShadow(shBR, shSeeThru);
		M.AddHeader(" Selection List ", heTR);
		M.SetSelectMarker(" ", " ");
		M.AddItemHelp("Area Name List", 2, 0, miListAreaName, "Color for the area name in the list");
		M.AddItemHelp("Selection Bar", 3, 0, miListSelectBar, "Color for the highlight selection bar");
		M.AddItemHelp("Tag Symbol Color", 4, 0, miListTag, "Color for the tag symbol in the list");
		M.AddItemHelp("Tag Hilite Color", 5, 4, miListTagHilite, "Color for the tag symbol when the selection bar is over the item");
		M.ItemsDone();
	  M.AddItemHelp("Command Bar", 4, 1, miCommand11, "Select colors for the command bar area");
		M.AddFramedSubMenu(31, 14, 53, 21, Vertical, lz_FrameType);
		M.EnableExplosions(20);
		M.AddShadow(shBR, shSeeThru);
		M.AddHeader(" Command Bar ", heTR);
		M.SetSelectMarker(" ", " ");
		M.AddItemHelp("Active Foreground", 2, 7, miCbarActiveFg, "Item text color when the command bar is active");
		M.AddItemHelp("Active Background", 3, 7, miCbarActiveBg, "Color between items when the command bar is active");
		M.AddItemHelp("Hotkey Highlight", 4, 0, miCbarHotkey, "Color for the hotkey in the command bar");
		M.AddItemHelp("Selection Bar", 5, 0, miCbarHilite, "Color for the selected item in the command bar");
		M.AddItemHelp("Disabled Foreground", 6, 10, miCbarOffFg, "Item text color when the command bar is disabled");
		M.AddItemHelp("Disabled Background", 7, 10, miCbarOffBg, "Color between items when the command bar is disabled");
		M.ItemsDone();
	  M.AddItemHelp("Progress Screen", 5, 0, miProgress18, "Select colors for the process report screen");
		M.AddFramedSubMenu(34, 15, 49, 19, Vertical, lz_FrameType);
		M.EnableExplosions(20);
		M.AddShadow(shBR, shSeeThru);
		M.AddHeader(" Progress ", heTR);
		M.SetSelectMarker(" ", " ");
		M.AddItemHelp("Text Color", 2, 0, miProcText, "Color for the area names displayed in the progress list");
		M.AddItemHelp("Digits Color", 3, 0, miProcDigits, "Color for all numeric information in the progress reports");
		M.AddItemHelp("Active Area", 4, 0, miProcAreaName, "Color for the name of area currently being processed");
		M.ItemsDone();
	  M.AddItemHelp("Progress Bars", 6, 9, miProgress22, "Select colors for the progress bars");
		M.AddFramedSubMenu(32, 16, 53, 21, Vertical, lz_FrameType);
		M.EnableExplosions(20);
		M.AddShadow(shBR, shSeeThru);
		M.AddHeader(" Progress Bars ", heTR);
		M.SetSelectMarker(" ", " ");
		M.AddItemHelp("Current Foreground", 2, 8, miPbarFg, "Color for the progress already being completed (Current Area)");
		M.AddItemHelp("Current Background", 3, 8, miPbarBg, "Color for the area signifying the total job amount (Current Area)");
		M.AddItemHelp("Total Foreground", 4, 7, miPbarTotalFg, "Color for the progress already being completed (All Areas)");
		M.AddItemHelp("Total Background", 5, 7, miPbarTotalBg, "Color for the area signifying the total job amount (All Areas)");
		M.ItemsDone();
	  M.ItemsDone();
	M.AddItemHelp("Compression Programs", 4, 0, miCompression, "Options for the compressions programs to use");
	  M.AddFramedSubMenu(22, 10, 50, 16, Vertical, lz_FrameType);
	  M.EnableExplosions(20);
	  M.AddShadow(shBR, shSeeThru);
	  M.AddHeader(" Compressors ", heTR);
	  M.SetSelectMarker(" ", " ");
	  M.AddItemHelp("ZIP (PKWARE, Inc.)", 2, 0, miZIP, "Set the options for the ZIP format");
	  M.AddItemHelp("RAR (Eugene Roshal)", 3, 0, miRAR, "Set the options for the RAR format");
	  M.AddItemHelp("ARJ (Robert Jung)", 4, 0, miARJ, "Set the options for the ARJ format");
	  M.AddItemHelp("LHA (Haruyashu Yoshizaki)", 5, 0, miLHA, "Set the options for the LHA format");
	  M.AddItemHelp("ZOO (Rahul Dhesi)", 6, 1, miZOO, "Set the options for the ZOO format");
	  M.ItemsDone();
	M.AddItemHelp("File Locations", 5, 0, miFileLocations, "The system path and various file names");
	M.AddItemHelp("Useron Support", 6, 0, miUseron, "Options for the online user support (multinode systems)");
	M.AddItemHelp("Information", 7, 0, miInformation, "Information about this program");
	M.AddItemHelp("Exit Program", 8, 1, miExit, "Exit the program (prompts if data needs to be saved)");
	M.ItemsDone();

	if (M.RawError())      M.Done();
	return M.RawError();
}

