
/* ------------------------------------------------------------
 * Filename ............... Handler.Cpp
 *
 * General Purpose ........ The local key handler
 * ------------------------------------------------------------
 * First date ............. 12-28-94 02:06pm
 *
 * First in version ....... 2.00
 *
 * Written by ............. Alain Schellinck
 *
 * Copyright .............. Nephilim software development
 * ------------------------------------------------------------
 * Revisions:
 * ----------
 *
 *   Date   | By |                  Purpose                   |
 * ---------+----+--------------------------------------------+
 *          |    |                                            |
 *          |    |                                            |
 *          |    |                                            |
 */

/*-------------------------------------------------------------------------*/

#include <main.hpp>
#pragma  hdrstop

/*-------------------------------------------------------------------------*/

#include <keyboard.hpp>

/*--] Code [-----------------> Local Keyboard handling [-------------------*/

/*
 * Routine   : LocalKeyHandler()
 * Purpose   : The local keyboard handler
 * ------------------------------------------------------------------------
 * Parameters: the local key
 * Return    : True if handled, False if NOT
 *
 */

IntT LocalKeyHandler(WrdT key)
{
   IntT ret_val = False;

   switch(key)
   {
      case KEY_UP    :
      case KEY_DN    :
      case KEY_LT    :
      case KEY_RT    :
      {
         TKeyboard->poke(key, True);
         ret_val = True;
      }
      break;
   }

   return (ret_val);
}

/*---------------------------] END OF THE CODE [---------------------------*/
