/*
**      ctl.h (InterMail)
**
**      Copyright 1989-1994 Peter Stewart & InterZone Software, inc. 
**      All rights reserved. The information may be freely used by
**      authors of InterMail utilities.
**
**      FD.SYS definitions for InterMail 2.2x
**
*/

/* Mailer --------------------------------------------------- */

/* --- Loglevels */

#define LOGFATAL        0x0001       /* !  Fatal errors                  */
#define LOGERROR        0x0002       /* ?  Errors                        */
#define LOGBRIEF        0x0004       /* +  Major changes in action       */
#define LOGACCT         0x0008       /* $  Accounting information        */
#define LOGXFER         0x0010       /* *  Sent/Received files           */
#define LOGTRIVIAL      0x0020       /* -  Minor changes in action       */
#define LOGEFF          0x0040       /* %  Transfer efficiencies         */
#define LOGMODEM        0x0080       /* =  Modem activities / resp.      */
#define LOGROUTING      0x0100       /* :  Rerouting of messages etc.    */
#define LOGSESSION      0x0200       /* ~  Session stuff, SysOp, etc.    */
#define LOGDEBUG        0x8000       /*    All loglevels enabled         */

/* --- Miscellaneous MAILER flags */

#define NOUNLISTED      0x00000001L  /* Don't allow unlisted systems     */
#define CREATE_BATCH    0x00000002L  /* Create batchfile when BBS caller */
#define TERMONLY        0x00000004L  /* Running as Terminal-Only         */
#define DTR_HANGUP      0x00000008L  /* Use DTR to hangup                */
#define DTR_DIAL        0x00000010L  /* Toggle DTR prior to dialing      */
#define DTR_BUSY        0x00000020L  /* Use DTR to signal BUSY           */
#define MANUAL_ANSWER   0x00000040L  /* Use manual answer                */
#define CONNECT_RESET   0x00000080L  /* Reset modem to connect speed     */
#define MODEM_FIXED     0x00000100L  /* Use constant speed against modem */
#define NOMAIL_NOPWD    0x00000200L  /* No mail from unsecured systems   */
#define DELAYFIRST      0x00000400L  /* Delay before first call          */
#define CLOCK           0x00000800L  /* Display clock                    */
#define KILLNULL        0x00001000L  /* Remove messages with no text     */
#define MAILONLY        0x00002000L  /* Don't allow human callers        */
#define LIMITED_ANSWER  0x00004000L  /* Limited hours to answer          */
#define EXIT_NETMAIL    0x00008000L  /* Exit when netmail received       */
#define ZONE_ADAPTION   0x00010000L  /* Adopt called/calling zone        */
#define PRINTNEWMSGS    0x00020000L  /* Print received messages          */
#define NOUNKNOWNPOINTS 0x00040000L  /* Don't accept unlisted points     */
#define FORCEDCARRIER   0x00080000L  /* Carrier is forced. Ring required */
#define NULLMODEM       0x00100000L  /* Initiate session when CD high    */
#define MAILER43LINES   0x00200000L  /* Use 43/50 line mode in mailer    */
#define SWAPTOEMSDISK   0x00400000L  /* Swap file to LIM/EMS/DISK w/shell*/
#define MAILEREMSOK     0x00800000L  /* If EMS can be used for swapping  */
#define PRESENTAKAS     0x01000000L  /* Present AKAs during EMSI sessions*/
#define NOBLINKMAIL     0x02000000L  /* Don't flash the waiting mail sign*/
#define EXITONANYFILE   0x04000000L  /* Exit after ANY data has been rcvd*/

/* --- Audio flags */

#define CLOCKNOISE      0x0001       /* Tic-tac-tic-tac-tic-tac          */
#define INMAILNOISE     0x0002       /* Unpacked any mail                */
#define INCRASHNOISE    0x0004       /* Unpacked crash or immediate mail */
#define INCONNECTNOISE  0x0008       /* Incoming MAIL call (connect)     */
#define INCALLERNOISE   0x0010       /* Incoming human caller passed >BBS*/
#define MAILWAITING     0x0020       /* Mail is waiting                  */
#define OUTMAILNOISE    0x0040       /* Sent mail (after session)        */
#define OUTCONNECTNOISE 0x0080       /* Outgoing MAIL call (connect)     */
#define ERRORNOISE      0x0100       /* S.O.S.                           */


/* --- Request types */

#define REQALL          0x01         /* Anybody can request              */
#define REQNONE         0x02         /* No one can request               */
#define REQLISTED       0x04         /* Only listed systems and their pts*/
#define REQPWD          0x10         /* Only secure systems can request  */
#define REQLIMITED      0x08         /* Limited hours                    */


typedef struct
 {
   /* The logfile */

   char     log[71];
   word     loglevel;                /* See --- Loglevels */

   /* Number manipulation */

   char     prefix[31];              /* Always added */
   char     hidden[10][31];          /* Strip these if they are in # */
   char     postfix[31];             /* Always appended */

   /* Miscellaneous flags */

   long     flags;                   /* See --- Miscellaneous flags */
   long     flags_reserved;          /* Reserved flags */
   word     audio;                   /* See --- Audio flags */
   byte     synchtimer;              /* Number of seconds for sync */

   /* Errorlevels */

   byte     crashexit;               /* Mail exit */
   byte     bbs300;
   byte     bbs1200;
   byte     bbs1275;
   byte     bbs2400;
   byte     bbs4800;
   byte     bbs9600;
   byte     bbs19200;
   byte     bbs38400;

   /* Modem */

   word     modembaud;               /* 30=300, 24=2400, etc. */
   byte     modemport;               /* 1-255 (COM1=1, COM2=2, etc.) */
   byte     modemdelay;              /* 1/10 seconds delay / line sent */

   /* --- Messages */

   char     b300msg[16];
   char     b1200msg[16];
   char     b1275msg[16];
   char     b2400msg[16];
   char     b4800msg[16];
   char     b9600msg[16];
   char     b19200msg[16];
   char     b38400msg[16];
   char     errormsg[16];
   char     busymsg[16];
   char     carriermsg[16];
   char     okmsg[16];
   char     ringmsg[16];
   char     nodialmsg[16];
   char     noanswmsg[16];
   char     voicemsg[16];

   /* --- Commands */

   char     escapestr[11];
   char     offhookstr[11];
   char     reconnectstr[11];
   char     init1[50];
   char     init2[50];
   char     init3[50];
   char     resetstr[50];
   char     downstr[50];
   char     hangupstr[11];
   char     dialstr[11];

   /* --- Manual answer stuff */

   char     modemanswer[11];
   byte     answerdelay;

   /* ------ Limited answer start and end times */

   byte     begin_hour;
   byte     begin_minute;
   byte     end_hour;
   byte     end_minute;

   /* Calling control */

   byte     retrybusy;
   byte     retryresend;
   byte     retrydelay;

   /* File request control */

   char     reqlist[71];             /* List to scan for reqable dirs    */
   char     reqalias[71];            /* Magic filenames                  */
   char     reqmessage[71];          /* Appended to FAILED REQUEST message */
   byte     reqtype;                 /* Bit field                        */
   byte     reqmaxfiles;             /* Max number of files to send on 1 req*/
   word     reqmaxtime;              /* Maximum number of minutes for req*/
   word     reqmaxsize;              /* Maximum size (in KB) for req     */
   word     reqminbaud;              /* Minimum baudrate for req         */
   byte     reqstarthr;              /* Start time for file requests, can be*/
   byte     reqstartmin;             /* combined with the reqdays field. */
   byte     reqendhr;
   byte     reqendmin;
   byte     reqdays;                 /* 7 6 5 4 3 2 1    0x80==All days
                                        - - - - - - -
                                              
                                               Saturday
                                              Friday
                                             Thursday
                                            Wednesday
                                           Tuesday
                                          Monday
                                         Sunday          */

   /* File to send when human callers are let thru */

   char     bbsname[11];
   char     beforebbsbanner[71];

   /* Function keys from mailer menu */
   /* --- F1-F12, Shift F1-F12       */

   struct
	 {
      char     cmd[61];
      char     title[26];
      byte     behavior;             /* 1-Pause, 2-Process msg base */
    }
    key[24];

   /* Mailer colors

   header
   highlight
   clock
   data_entry
   error
   normal_text
   frame
   window_text
   window_frame
   window_select
   window_highlight */

   byte     color[11];

   /* Number of days to keep entries in history files */

   byte     keep_history;

   /* FDServer password, if none given, server is INactive */

   char     slavepwd[21];

   /* File displayed to users when system is in event for no callers */

   char     ineventfile[71];

   /* File displayed when human callers are seen on mail-only system */

   char     mailonlyfile[71];

   /* External programs to run on certain "wake-up" strings */

   struct
    {
      char     wakeupstr[40];
      byte     errorlevel;
    }
    externmail[10];

   /* RESERVED FIELD */

   /* --- Limited audio start and end times. If the below four bytes
          are all zero (0), audio is enabled all the time */

   byte     audio_begin_hour;
   byte     audio_begin_minute;
   byte     audio_end_hour;
   byte     audio_end_minute;

   /* ---	Minimum cost to process undialable */

   word     min_undial_cost;

   char     RESERVERAT[886];
   char     extrnreq  [71];
   char     modem_name[61];            /* modem name, for 'modem selection' */
 }
 _mailer;


/* Editor ----------------------------------------------------------------- */

#define EDITOR43LINES   0x00000001L
#define SHOWHARDCRS     0x00000002L
#define EDITORSWAP      0x00000004L  /* Swap file to LIM/EMS/DISK w/shell*/
#define EDITOREMSOK     0x00000008L  /* Whether or not EMS should be used*/

/* Netmail folder behavior */

#define RESTRICTED      0x00000001L
#define EXPORTOK        0x00000004L
#define USEXLATTABLES   0x00000008L
#define EDREADONLY      0x00000020L

/* Echomail flags */
#define SAVEBAD         0x00000001L

typedef struct
    {
    char    path[65];      /* Path if "board==0", otherwise empty (65) */
    byte    ftype;         /* Folder type                              */
    char    areatag[39];   /* Echomail area tag                        */
    byte    origin;        /* Default origin line, 0-19                */
    char    title[41];     /* Title to appear on screen                */
    byte    useaka;        /* AKA to use, 0==primary                   */
    word    board;         /* QuickBBS/RemoteAccess/WC board number    */
    word    upzone;        /* Uplink zone                              */
    word    upnet;         /* Uplink net                               */
    word    upnode;        /* Uplink node                              */
    word    uppoint;       /* Uplink point                             */
    long    behave;        /* Behavior, see above                      */
    long    hiwater;       /* Highwater mark for echomail              */
    long    pwdcrc;        /* CRC32 of password or -1L if unprotected  */
    long    userok;        /* Users with initial access                */
    long    accflags;      /* access flags, for network environment    */
    char    reserved[8];   /* for future expansion                     */
    }
    _eFOLDER;

typedef struct
 {
   /* Macro keys */

   char     macrokey[24][61];        /* F1-F12, Shift F1-F12 */

   /* Margin, default==60 */

   byte     margin;

   /* Default message status */

   word     msgbits;

   /* Miscellaneous settings */

   long     flags;

   /* Origin lines */

   char     origin[20][61];

   /* Editor colors
      top_line
      status_line
      error
      text
      text_quotes
      text_reverse
      text_hardCRs
      header
      header_data
      header_data_highlight
      data_entry
      window_frame
      window_text
      window_select
      window_highlight  */

   byte     color[15];

   /* Netmail folder flags */

   long     netfolderflags;

   /* Translation tables IN/OUT */

   byte     translate_in[256];
   byte     translate_out[256];

   /* Where RemoteAccess/QuickBBS message base files are */

   char     qbase[71];
   char     WCmain[71];

   /* RESERVED */

   char     RESERVERAT[255];
   long     echoflags;
   _eFOLDER BBSnet;
   _eFOLDER dupes;
   _eFOLDER badecho;
   char     echolog[65];
   char     IMEWork[71];

 }
 _editor;


/* Shared data ----------------------------------------------------------- */

#define FASTKEY      0x00000001L
#define FLICKER      0x00000002L
#define BLACKOUT     0x00000004L
#define HAVEEXTKBD   0x00000008L    /* Use extended INT 16H calls */
#define FORCE24HOUR  0x00000010L    /* Force 24-hour time format */

#define SUPERUSER    0x00000001L    /* User flags */
#define ADMINUSER    0x00000002L
#define USER         0x00000004L
#define BYPASSRO     0x00010000L
#define BYPASSEXP    0x00020000L

#define PROTECT_MEXIT   0x00000001L    /* Protect Alt-Q          Mailer */
#define PROTECT_MSHELL  0x00000002L    /* Protect Alt-Z          Mailer */
#define PROTECT_MKEYS   0x00000004L    /* Protect function keys  Mailer */
#define PROTECT_MFREQ   0x00000008L    /* Protect file requests  Mailer */
#define PROTECT_MXMIT   0x00000010L    /* Protect transmit       Mailer */
#define PROTECT_MSEND   0x00000020L    /* Protect send mail      Mailer */
#define PROTECT_MPOLL   0x00000040L    /* Protect poll           Mailer */
#define PROTECT_MNCOMP  0x00000080L    /* Protect IMNC           Mailer */
#define PROTECT_MQUEUE  0x00000100L    /* Protect mail queue     Mailer */
#define PROTECT_MPRN    0x00000200L    /* Protect printer toggle Mailer */


typedef struct
 {
   char     systempath[71];
   char     mailpath[71];
   char     swap_path[71];
   char     semaphore[71];
   char     secfilespath[71];
   char     infilepath[71];
   char     packetpath[71];
   char     nodelistpath[71];

   word     countrycode;

   struct
	 {
      word     zone;
      word     net;
      word     node;
      word     point;
    }
    aka[11];

   /* Timeout value for screen blanker in SECONDS (0-255) */

   long     flags;
   byte     blackout_time;

   /* User record */

   struct
    {
      char     name[37];
      long     pwdcrc;           /* Crc-32 of user password, -1L No pwd */
      dword    flags;
    }
    user[10];

   /* Protection of exits */

   dword    exitpwdcrc;          /* Password for DOS shell, exits, etc. */
   dword    exitflags;           /* Which flags should be protected */
   char     filler[760];         /* contains domain stuff */
   char     systemname[50];      /* site_info - system name */
   char     systemloc[40];       /* site_info - location */
   char     systemphone[24];     /* site_info - phone */
   char     fill[6];             /* 6 loose bytes :) */
   char     systemflags[20];     /* site_info - nodelist flags */
   char     systemcountry[26];   /* site_info - country */
   char     serial[14];          /* serial number */
   char     outecho[66];         /* outbound echomail packets */
   char     reserved[10];        /* reserved space */


 }
 _shared;


/* Terminal --------------------------------------------------------------- */

#define CONNECT_NOISE   0x00000001L
#define TRANSFER_NOISE  0x00000002L
#define USE_TRANSLATE   0x00000004L
#define USE_43LINES     0x00000008L
#define AUTOZMODEM      0x00000010L
#define NOWRAPAROUND    0x00000020L
#define LOCALECHO       0x00000040L
#define NOAVATAR        0x00000080L


typedef struct
 {
   char     initstring[41];      /* Init string                         */
   word     scrollsize;          /* Max memory to use for buffer (in K) */
   byte     emulation;           /* 0=TTY, 1=ANSI, 2=VT52, 3=VT100      */
   byte     protocol;            /* Index in protocol list              */
   char     shiftkey[12][31];    /* Shift F1-F12 macro settings         */
   char     ctrlkey[12][31];     /* Ctrl  F1-F12 macro settings         */
   char     downloadpath[60];    /* Default download path               */
   char     uploadpath[60];      /* Default upload path                 */
   byte     translate_in[256];   /* Translation table - modem->screen   */
   byte     translate_out[256];  /* Translation table - screen->modem   */
   byte     retrywait;           /* Seconds to wait before next dial..  */
   dword    flags;               /* Behavior, sounds, flashes.. etc.    */
   dword    directorypwd;        /* CRC-32 of password to enter phoneDir*/
   char     editor[60];          /* Invoked with Alt-I                  */
   char     RESERVERAT[796];     /* Reserved space                      */
   struct
     {
	word     zone;
	word     net;
	word     node;
	word     point;
      }
      newaka[21];
 }
 _terminal;
/* Printer ---------------------------------------------------------------- */

#define PAGE_FORMAT   0x00000001L
#define PAGE_FFEED    0x00000002L
#define EJECT         0x00000004L
#define MANUAL_PAPER  0x00000008L
#define HIDE_KLUDGE   0x00000010L
#define CONTINOUS     0x00000020L

typedef struct
 {
   char     port;       /* 0 LPT1, 1 LPT2, 2 LPT3, 3 COM1, 4 COM2 */
   char     baud;       /* 0 9600, 1 4800, 2 2400, 3 1200 */
   byte     stopbits;   /* 0x00 - 1, 0x01 - 2 */
   byte     wordlength; /* 0x00 - 7, 0x01 - 8 */
   byte     parity;     /* 0x00 - Even, 0x01 - Odd, 0x02 - None */
   byte     pagelen;
   long     behavior;
   char     init[71];
   char     reset[71];
   char     bold_on[31];
   char     bold_off[31];
   char     pr1RESERVED[62];
   char     italic_on[31];
   char     italic_off[31];
   byte     pagewidth;           /* Width in columns of a page */
   byte     leftmargin;          /* Left margin, ie. start printing at column*/
   byte     footer;              /* Footer margin, ie. leave nn lines */
   byte     header;              /* Header margin, ie. skip nn lines */
   byte     translate_out[256];  /* Translation table - disk->printer */
   char     pr2RESERVED[100];
 }
 _printer;


/* Global control file ------------------------------------------------**
**
*************************************************************************/
#define IM_THISREV 0x0100

struct _ctl
 {
   char      fingerprint[5];  /* Must contain "JoHo" */
   word      sysrev;          /* Must contain THISREV above */
   dword     ctlcrc;          /* CRC-32 of struct excluding the 1st 11 bytes */
   _mailer   m;
   _editor   e;
   _shared   s;
   _terminal t;
/*   _common   c;   */
   _printer  p;
   dword     ctlcrc2;            /* CRC-32 of all the above */
 };

/* end of file "ctl.h" */
