
PB-GNU PASSWD				User's Manual				PB-GNU PASSWD
					Last revision date: April 20, 1995


NAME
	PB-GNU PASSWD - enforces regular password change

SYNOPSIS
	PASSWD or WELCOMEx

VERSION
	PB-GNU PASSWD version 1.0

DESCRIPTION
	PB-GNU PASSWD	modelled after AIX passwd command. Forces users
		to change passwords every x number of days. Supports super
		user mode. Sends warning messages to users x days before
		expiration of their password. Define minimum number of alpha-
		numeric and special characters, maximum number of repeats,
		minimum number of differences. Register with a random number
		in the configuration file. Fully transparent mode available.
		Force password change for everybody (optional).


EXAMPLES
	There are two ways to set PASSWD up: as an autoexec WELCOMEx.PEX
	and as a menu entry for Change Password function. The latter is
	necessary if you want your users to change password because the
	internal ProBoard Change Password function does not support the
	advanced features of PASSWD and does not update the Last Password
	Change field in the User Profile correctly.

	First, copy PASSWD.PEX to WELCOMEx.PEX and put it in your PEX
	directory ('x' is a number from 0 to 9). Edit PASSWD.INI to set
	your preferences. This file is heavily commented, so it will not
	be discussed here. Place it in the same directory. The name must
	remain PASSWD.INI, you may not change it. This will ensure the
	autoexec mode when a user logs on.

	In a menu, replacing the internal Change Password function, create
	an entry with Function 60, Run ProBoard SDK File and data:
	PASSWD C:\PB\CFG\PASSWD2.INI. Next, create a PASSWD2.INI and place
	it in the directory specified on the data line (C:\PB\CFG in this
	example). This name must have an .INI extension. Make sure you have
	set the 'Force' parameter correctly. That's all.

FILES
	PASSWD.PEX		ProBoard executable (can be renamed to WELCOMEx.PEX)
	PASSWD.INI		configuration file
	<other>.INI		(optional): additional configuration file(s)

DIAGNOSTICS
	Logging is preformed to PROBOARD.LOG. All messages are in the form
	PASSWD: message. Here are the messages:

	'username' - password changed!

		appears when the user 'username' successfully changed password.

	error in INI file for entry 'entryname'

		appears if an entry with 'entryname' has an illegal value.
		Check your configuration file.

	'username' warned ('numdays' days to password expiration)

		appears when PASSWD warns the user 'username' that his/her
		password will expire in 'numdays' days.

	config error - password length exceeded!
	forced values: AlphaNum = 6, Symbols = 2

		if the sum of alphanumeric and special characters, as defined
		in the configuration file, exceeds 15. This is a limitation of
		ProBoard, not of PASSWD. New values will be forced. This is not
		an abortive error.


ERRORS
	All error messages are in the form: Error: message. Here's a list
	of all error messages.

	password mismatch! Please, try again.

		User typed a different password when asked to re-type the new
		one for security reasons.

	at least 'numchar' alphanumeric characters are required!

		User entered less than 'numchar' alphanumerics for password.
		Another password must be chosen.

	at least 'numchar' special symbols are required!

		User entered less than 'numchar' special symbols.

	new password must have at least 'numchar' symbols not duplicated in old!

		New password has too few symbols that do not appear in the
		old password. New password must contain at least 'numchar'
		symbols that do not appear in the old password.

	not more than 'numchar' symbols from old password can be used!

		New password contains too many characters that appear in the old
		one. Reduce to less or equal to 'numchar'.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.0
	Release Date: April 20, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LIMITS
	Since ProBoard doesn't set the date field for password modification,
	upon installing PASSWD, you'll find out that all user have to change
	their passwords. Also, PASSWD will not let a user go until he/she
	submits a valid password for a new one. The CRC value in the User
	Profile is not used. The settings in the configuration file will
	override ProBoard's password length setting.

BUGS
	I am not aware of any.

LEGALITIES
	PB-GNU PASSWD is Copyright 1995 by Branislav L. Slantchev.

	Written with the Borland C++ 3.1 compiler and ProBoard SDK 2.01.

	PB-GNU PASSWD (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.


SEE ALSO
	README		quick installations
	PASSWD.INI	annotated sample configuration file
