// AFinder version 1.1
// Written by Gregory Gulick
// Copyright 1994 - All Rights Reserved

#include <pb_sdk.h>

#define CTRUE 			0
#define CFALSE 			-1

#define CITY_SEARCH 	0
#define ACCESS_SEARCH 	1
#define ALIAS_SEARCH 	2
#define NAME_SEARCH 	3
#define GENDER_SEARCH 	4
#define PHONE_SEARCH 	5
#define AGE_SEARCH		6

#define AT 				0
#define ABOVE 			1
#define BELOW 			2

#define REAL 			1
#define ALIAS 			2

// Prototypes

void no_memory(void);							// Out of memory?  Abort.
void main_menu(void);  		                    // Short header.
void header(void);                              // Program information
void press_enter(void);                         // Press Enter to Continue
void main(int argc, char **argv);               // Read Command Line Args
void search_city(void);                         // Search for City Info
void search_access(void);						// Search access levels
void search_alias(void);						// Search for alias
void search_name(void);							// Search for real name
void search_gender(void);                       // SysOp gender search
void search_phone(void);						// Search by phone number
void search_age(void);                          // Search by age
void init_ln(void);                             // Init line number
bool ln_counter(void);                          // Count lines on screen
void s_header(int search_type);                 // Search City Header

// Global Variables

	int search_rate;							// FuzzySearch Rate
	int email_board;							// Msg base num for e-mail
	int sysop_level;							// For user editor
	int alias_mail_name;						// Alias or real name?
	int save_x;									// For restoring screen

	int ln;                                     // Line number
	bool ln_reset;                              // Safe to clear screen?
	bool restore_screen;						// Restore screen
	bool search_completed;						// Done searching?
	bool want_access_search;					// Search access levels?
	bool want_alias_search;						// Search by aliases?
	bool doing_alias_search;					// Are we doing an al srch?
	char ch;									// Multipurpose character
	char dataline[100];							// String for shell command

void init_ln(void) { ln = 1; }

bool ln_counter(void)
{
	USER_REC *rec, *recs;						// User Record pointers
	char user_num_s[10];						// For reading user number
	int usernum;								// Int version of above

	// This function tests to see if we've reached the end of the user's
	// screen.  If we have, then querry the user if he/she wishes to
	// continue.  If not, return the value false to the calling function.

	// Also note the variable ln_reset.  This variable indicates whether
	// or not it is safe to clear the screen (i.e., if the person
	// querried specifically requested to continue).

	// Also note the variable restore_screen.  This is a boolean variable
	// which tells ASearch to restore the screen that the user was on when
	// they initiated an e-mail or the user editor.  When set to true,
	// the calling function will restore the screen.

	if ((ln == CurUser->screenLength-3) || (search_completed == TRUE)) {
		SetColor(WHITE);
		if (search_completed == FALSE)			// If we are not done,
			printf("\nMore? ");					// print "More?"
		else                                    // If we are done,
			printf("\nDone. ");					// print "Done."

		// This begins the actual routine that builds the prompt.  Prompt
		// construction is variant on sysop level, local mode, and search
		// completion.

		SetColor(MAGENTA);
		printf("(");
		if (search_completed == FALSE) {		// If search is still going,
			SetColor(CYAN);						// Place Y/N in prompt
			printf("Y");
			SetColor(MAGENTA);
			printf(",");
			SetColor(CYAN);
			printf(" n");
			SetColor(MAGENTA);
			printf(", [");
		}
		else {									// If search is completed,
			SetColor(MAGENTA);					// No Y/N in prompt
			printf("[");
			SetColor(CYAN);
			printf("Enter");
			SetColor(MAGENTA);
			printf("], ");
			SetColor(MAGENTA);
			printf("[");
		}
		SetColor(CYAN);
		printf("E");
		SetColor(MAGENTA);
		printf("]");
		SetColor(CYAN);
		printf("mail User");
		if ((CurUser->level >= sysop_level) && (BaudRate == 0)) { // See below
			SetColor(MAGENTA);					// If this is the sysop
			printf(", [");						// in local mode, print
			SetColor(CYAN);						// user editor in the
			printf("U");						// prompt.
			SetColor(MAGENTA);
			printf("]");
			SetColor(CYAN);
			printf("ser Editor");
		}
		SetColor(MAGENTA);
		printf(") ");							// End of prompt construction

		// This small procedure controls what keys this entire function will
		// accept:
		//
		// if sysop in local mode and search not complete, accepts : Y,N,E,U
		// if sysop in local mode and search is completed, accepts : E,U
		// if not sysop and search is not completed, accepts       : Y,N,E
		// if not sysop and search is completed, accepts           : E

		if ((CurUser->level >= sysop_level) && (BaudRate == 0) && (search_completed == FALSE))
			ch = WaitKeys("YNEU\r");
		else if ((CurUser->level >= sysop_level) && (BaudRate == 0) && (search_completed == TRUE))
			ch = WaitKeys("EU\r");
		else if (search_completed == TRUE)
			ch = WaitKeys("E\r");
		else
			ch = WaitKeys("YNE\r");

		// This small procedure returns false if the user has selected
		// NO to the more prompt.  It then returns to the calling function
		// which aborts the search.

		if (toupper(ch) == 'N')
			return(FALSE);

		// This rather large procedure is the send email procedure.  It
		// allocates memory, and reads the user number requested by the
		// user.  If there is insufficient memory, the program displays
		// a message that there is not enough memory to send e-mail, and
		// the program continues.  If the user number does not exist, the
		// program displays a message and returns to the calling function.

		if (toupper(ch) == 'E') {
			if ((rec = (USER_REC *) calloc(1,1500)) == NULL) {
				SetColor(RED);
				printf("\n\nNot enough memory to E-Mail.\n");
				press_enter();
				ln_reset=TRUE;
				restore_screen = TRUE;
				return(TRUE);
			}
			recs = rec;
			SetColor(WHITE);
			printf("Email User.  User Number : ");
			Input(user_num_s,4,INPUT_DIGITS);
			usernum = atoi(user_num_s);
			if (usernum == 0) {
				free(recs);
				ln_reset = TRUE;
				restore_screen = TRUE;
				return(TRUE);
			}
			if (ReadUser(rec, usernum) == TRUE) {
				if (doing_alias_search == TRUE) {
					switch (alias_mail_name) {
						case REAL : sprintf(dataline,"%d /T=\"%s\"",email_board, rec->name);break;
						case ALIAS: sprintf(dataline,"%d /T=\"%s\"",email_board, rec->alias);break;
					}
				}
				else
					sprintf(dataline,"%d /T=\"%s\"",email_board,rec->name);
				free(recs);
				MenuFunction(27, dataline);
				restore_screen = TRUE;
				ln_reset=TRUE;
				return(TRUE);
			}
			else {
				SetColor(RED);
				printf("\n\nInvalid user number.\n");
				press_enter();
				free(recs);
				ln_reset=TRUE;
				restore_screen = TRUE;
				return(TRUE);
			}
		}

		// This procedure controls the user editor.  It called the ProConfig
		// editor via : PROCFG UE <rec> -- where <rec> is the record number
		// of the user to be edited.  Notice that 1 is added to the requested
		// user number.  This is because the user log begins at record
		// number 1, whereas the actual C USER_REC array starts at element
		// 0.  The +1 compensates for this difference.

		if (toupper(ch) == 'U') {
			SetColor(WHITE);
			printf("User Editor.  User Number : ");
			Input(user_num_s,4,INPUT_DIGITS);
			if (strlen(user_num_s) == 0) {
				ln_reset=TRUE;
				restore_screen = TRUE;
				return(TRUE);
			}
			usernum = atoi(user_num_s);
			sprintf(dataline,"*Q *Z PROCFG UE %d",usernum+1);
			MenuFunction(7,dataline);
			ln_reset=TRUE;
			restore_screen = TRUE;
			return(TRUE);
		}

		// This small procedure is run if the user press enter.

		else {
			restore_screen = FALSE;
			ln_reset = TRUE;
			return(TRUE);
		}
	}

	// The remainder of this function is executed if it is not time to
	// ask for "More?".  It increments the line number, sets the reset
	// boolean to false, and the restore_screen boolean to false.

	++ln;
	ln_reset = FALSE;
	restore_screen = FALSE;
	return(TRUE);
}

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
	printf("Insufficient memory to run PowerPEX!\n");
	press_enter();
	exit();										// Abort program
}

void press_enter(void)
{
	SetColor(WHITE);
	printf("\nPress [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.");
	ch=WaitKeys("\r");
}

void header(void)
{
    printf("\f");
	SetColor(MAGENTA);
	printf("\n");
	printf(" ");
	SetColor(WHITE);
    printf("AFinder 1.1 ");
	SetColor(MAGENTA);
	printf("\n");
    printf("\n");

}

void main_menu(void)
{
	char menu_choice;

	do {
	printf("\f");
	SetColor(MAGENTA);
	printf("\n");
	printf(" ");
	SetColor(WHITE);
    printf("AFinder 1.1 ");
	SetColor(MAGENTA);
	printf("\n");
	printf("\n");
	SetColor(WHITE);
	printf("          ");
	SetColor(CYAN);
	printf("A PowerPEX Developed by Gregory Gulick and Gil Gulick ");
	SetColor(WHITE);
	printf("\n");
	SetColor(MAGENTA);
	printf("\n\n");
	SetColor(WHITE);
	if ((want_alias_search == TRUE) || (CurUser->level >= sysop_level))
		printf("                           [A] Search by Alias\n");
	printf("                           [C] Search by City\n");
	if ((want_access_search == TRUE) || (CurUser->level >= sysop_level))
		printf("                           [L] Search by Access Level\n");
	printf("                           [N] Search by Real Name\n");
	printf("                           [Q] Quit AFinder\n");
	if (CurUser->level >= sysop_level) {
		printf("\n                             SysOp Options \n\n");
		printf("                           [1] Search by User's Age\n");
		printf("                           [2] Search by User's Phone Number\n");
		printf("                           [3] Search by User's Gender\n");
	}
	SetColor(MAGENTA);
	printf("\n\n");
	printf(" ");
	SetColor(WHITE);
	printf("Written by Gregory Gulick - (C) Copyright 1994 ");
	SetColor(MAGENTA);
	printf("\n");
	printf("\n");
	SetColor(WHITE);
	printf("\nCommand : ");
	menu_choice = WaitKey();
	switch (toupper(menu_choice)) {
		case 'A' : { if (want_alias_search == TRUE)
						search_alias();
						break;
				   }
		case 'C' : search_city();break;
		case 'L' : { if (want_access_search == TRUE)
						search_access();
						break;
				   }
		case 'N' : search_name();break;
		case '1' : { if (CurUser->level >= sysop_level)
						search_age();
					 break;
				   }
		case '2' : { if (CurUser->level >= sysop_level)
						search_phone();
					 break;
				   }
		case '3' : { if (CurUser->level >= sysop_level)
						search_gender();
					 break;
				   }
	}
	} while (toupper(menu_choice) != 'Q');
}

void s_header(int search_type)
{

	// This header is specific to the type of search being done.
	// It is passed constants relative to the type of search being done.

	printf("\f");
	SetColor(WHITE);
	init_ln();
    printf("AFinder 1.1 ");
	SetColor(CYAN);
	printf("- ");
	SetColor(BLUE);
	printf("A PowerPEX by Gregory Gulick                   ");
	SetColor(CYAN);
	printf("(C) Copyright 1994\n");
	SetColor(MAGENTA);
	printf("\n");
	SetColor(WHITE);
	switch (search_type) {
		case ALIAS_SEARCH  : printf("Number Alias                                         Last Called    Total Calls\n");break;
		case CITY_SEARCH   : printf("Number Username                 City                 Last Called    Total Calls\n");break;
		case GENDER_SEARCH :
		case NAME_SEARCH   : printf("Number Username                                      Last Called    Total Calls\n");break;
		case AGE_SEARCH    : printf("Number Username                          Last Called    Date of Birth    Age   \n");break;
		case PHONE_SEARCH  : printf("Number Username              Voice Phone     Data Phone      Fax Phone\n");break;
		case ACCESS_SEARCH : printf("Number Username                 Access Level         Last Called    Total Calls\n");break;
	}
	SetColor(MAGENTA);
	printf("\n");
	SetColor(WHITE);
	ln=4;
}

void search_city(void)
{
	char buf[40];
	int x;
	USER_REC *ur, *urs;

	if ( (ur = (USER_REC *) calloc (1,1500)) == NULL)
		no_memory();

	urs = ur;

	header();
	SetColor(WHITE);
    printf("\nEnter city to search for (\003*\007 for all): ");
	Input(buf,36,INPUT_UPALL);

	if (strlen(buf) == 0) {                     // If enter is pressed,
		free(urs);
		return;									// abort.
	}

	s_header(CITY_SEARCH);

	// This procedure begins a loop that ends when the total number of users
	// has been reached.  Inde the loop, the string buf, which was entered
	// by the user is compared to the city of the user who's record is being
	// read.  If buf is found inside the city or if a fuzzysearch (search
	// rate specified by command line parameter) is successful, the user
	// information is displayed.

	search_completed = FALSE;					// Starting the search

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)                            // If the first line,
			save_x = x-1;						// Save the position for restore
        if (ReadUser(ur,x) == TRUE) {
            if ((strstr(strupr(ur->city),buf) != NULL) ||
             (FuzzySearch(strupr(ur->city),buf,search_rate) >= search_rate) ||
             (strcmp(buf,"*") == 0)) {
				SetColor(CYAN);
				printf("[");
				SetColor(MAGENTA);
				printf("%4d", ur->record);
				SetColor(CYAN);
				printf("] ");
				SetColor(WHITE);
				printf("%-24.24s ",ur->name);
				SetColor(CYAN);
				printf("%-20.20s  ",ur->city);
				SetColor(WHITE);
				printf("%1.2d/%1.2d/%1.2d        ", ur->lastDate[1], ur->lastDate[0], ur->lastDate[2]);
				SetColor(CYAN);
				printf("%5u\n",ur->timesCalled);

				// Test if we've reached the end of the user's screen.

				if (ln_counter() == FALSE) {	// If false,
					free(urs);					// Free memory first, then
					return;						// return to calling function
				}
				else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
					x = save_x;					// If restoring screen
					s_header(CITY_SEARCH);		// Re-display header
				}
				else if (ln_reset == TRUE)		// If user wishes to continue
					s_header(CITY_SEARCH);		// Re-display header

			} // End of strstr/fuzzysearch test
		} // End of test for user existance
	} // End of loop to maximum number of users
	 free (urs);    							// Free memory
	 search_completed = TRUE;					// End of search
	 ln_counter();  							// Excute end of search prompt
} // End of function

void search_access(void)
{
	char buf[40];
	int x;
	USER_REC *rec, *recs;
	long r_access;								// Request search level
	int search_pref;

	if ((rec = (USER_REC *) calloc (1,1500)) == NULL)
		no_memory();

	recs = rec;

	header();
	SetColor(WHITE);
	MenuFunction(5,"ACCLEVEL");
	printf("\nSearch Examples : ");
	printf("\n\n     40  - Search for all users with access level 40.\n");
	  printf("     40+ - Search for all users with access level 40 and higher.\n");
	  printf("     40- - Search for all users with access level 40 and lower.\n");
    printf("\nEnter access level to search for: ");
	Input(buf,5,INPUT_ALL);
	r_access = atol(buf);

	if (r_access == 0) {						// Return if invalid input
		free(recs);
		return;
	}

	if (strstr(buf,"+") != NULL)				// What type of search is
		search_pref = ABOVE;					// is being done?  At,
	else if (strstr(buf,"-") != NULL)			// Above, or Below requested
		search_pref = BELOW;					// access level?
	else
		search_pref = AT;

	s_header(ACCESS_SEARCH);

	search_completed = FALSE;					// Starting the search

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
			if ((search_pref == ABOVE) && (rec->level < r_access))
				continue;
			if ((search_pref == BELOW) && (rec->level > r_access))
				continue;
			if ((search_pref == AT) && (rec->level != r_access))
				continue;
			SetColor(CYAN);
			printf("[");
			SetColor(MAGENTA);
			printf("%4d", rec->record);
			SetColor(CYAN);
			printf("] ");
			SetColor(WHITE);
			printf("%-24.24s ", rec->name);
			SetColor(CYAN);
			printf("     %5d             ", rec->level);
			SetColor(WHITE);
			printf("%1.2d/%1.2d/%1.2d       ", rec->lastDate[1], rec->lastDate[0], rec->lastDate[2]);
			SetColor(CYAN);
			printf("%5u\n",rec->timesCalled);

			// Test if we've reached the end of the user's screen

			if (ln_counter() == FALSE) {
				free(recs);
				return;
			}
			else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
				x = save_x;
				s_header(ACCESS_SEARCH);
			}
			else if (ln_reset == TRUE)
				s_header(ACCESS_SEARCH);
		} // End of test for user existance
	} // End of for loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
} // End of function

void search_alias(void)
{
	char buf[40], test[40];
	int x;
	USER_REC *rec, *recs;

	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
		no_memory();

	recs = rec;

	header();
	SetColor(WHITE);
    printf("\nEnter alias to search for (\003*\007 for all): ");
	Input(buf,36,INPUT_UPALL);

	if (strlen(buf) == 0) {
		free(recs);
		return;
	}

	s_header(ALIAS_SEARCH);

	doing_alias_search = TRUE;
	search_completed = FALSE;

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
            strcpy(test,rec->alias);
            if ((strstr(strupr(test),buf) != NULL) ||
             (FuzzySearch(strupr(test),buf,search_rate) >= search_rate) ||
             (strcmp(buf,"*") == 0) &&
             (strcmp(test,"") != 0)) {
				SetColor(CYAN);
				printf("[");
				SetColor(MAGENTA);
				printf("%4d", rec->record);
				SetColor(CYAN);
				printf("] ");
				SetColor(WHITE);
				printf("%-24.24s                        ", rec->alias);
				SetColor(CYAN);
				printf("%1.2d/%1.2d/%1.2d      ", rec->lastDate[1], rec->lastDate[0], rec->lastDate[2]);
				SetColor(WHITE);
				printf("%5u\n",rec->timesCalled);

				// Test if we've reached the end of the user's screen.

				if (ln_counter() == FALSE) {
					doing_alias_search = FALSE;
					free(recs);
					return;
				}
				else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
					x = save_x;
					s_header(ALIAS_SEARCH);
				}
				else if (ln_reset == TRUE)
					s_header(ALIAS_SEARCH);

			} // End of fuzzy search test
		} // End of existance test
	} // End of loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
	doing_alias_search = FALSE;
} // End of function

void search_gender(void)
{
	char buf[40];
	byte r_sex;
	int x;
	USER_REC *rec, *recs;

	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
		no_memory();

	recs = rec;
	r_sex = 1;

	header();
	SetColor(WHITE);
    printf("\nEnter gender to search for ([U]nknown, [M]ale, [F]emale): ");
	Input(buf,1,INPUT_UPALL);

	if (strlen(buf) == 0) {
		free(recs);
		return;
	}

	s_header(GENDER_SEARCH);
	search_completed = FALSE;

	if (strstr(buf,"U") != NULL)
		r_sex = 0;
	if (strstr(buf,"M") != NULL)
		r_sex = 1;
	if (strstr(buf,"F") != NULL)
		r_sex = 2;

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
			if (r_sex == rec->sex) {
				SetColor(CYAN);
				printf("[");
				SetColor(MAGENTA);
				printf("%4d", rec->record);
				SetColor(CYAN);
				printf("] ");
				SetColor(WHITE);
				printf("%-24.24s                        ", rec->name);
				SetColor(CYAN);
				printf("%1.2d/%1.2d/%1.2d      ", rec->lastDate[1], rec->lastDate[0], rec->lastDate[2]);
				SetColor(WHITE);
				printf("%5u\n",rec->timesCalled);

				// Test if we've reached the end of the user's screen.

				if (ln_counter() == FALSE) {
					free(recs);
					return;
				}
				else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
					x = save_x;
					s_header(GENDER_SEARCH);
				}
				else if (ln_reset == TRUE)
					s_header(GENDER_SEARCH);

			} // End of fuzzy search test
		} // End of existance test
	} // End of loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
} // End of function


void search_name(void)
{
    char buf[40], test[40];
	int x;
	USER_REC *rec, *recs;

	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
		no_memory();

	recs = rec;

	header();
	SetColor(WHITE);
    printf("\nEnter name to search for (\003*\007 for all): ");
	Input(buf,36,INPUT_UPALL);

	if (strlen(buf) == 0) {
		free(recs);
		return;
	}

	s_header(NAME_SEARCH);
	search_completed = FALSE;

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
            strcpy(test,rec->name);
            if ((strstr(strupr(test),buf) != NULL) ||
             (FuzzySearch(strupr(test),buf,search_rate) >= search_rate) ||
             (strcmp(buf,"*") == 0)) {
				SetColor(CYAN);
				printf("[");
				SetColor(MAGENTA);
				printf("%4d", rec->record);
				SetColor(CYAN);
				printf("] ");
				SetColor(WHITE);
                printf("%-24.24s                        ", rec->name);
				SetColor(CYAN);
				printf("%1.2d/%1.2d/%1.2d      ", rec->lastDate[1], rec->lastDate[0], rec->lastDate[2]);
				SetColor(WHITE);
				printf("%5u\n",rec->timesCalled);

				// Test if we've reached the end of the user's screen.

				if (ln_counter() == FALSE) {
					free(recs);
					return;
				}
				else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
					x = save_x;
                    s_header(NAME_SEARCH);
				}
				else if (ln_reset == TRUE)
                    s_header(NAME_SEARCH);

			} // End of fuzzy search test
		} // End of existance test
	} // End of loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
} // End of function

void search_phone(void)
{
    char buf[40], test[40];
	int x;
	USER_REC *rec, *recs;

	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
		no_memory();

	recs = rec;

	header();
	SetColor(WHITE);
    printf("\nEnter numbers to search for (\003*\007 for all): ");
	Input(buf,20,INPUT_ALL);

	if (strlen(buf) == 0) {
		free(recs);
		return;
	}

	s_header(PHONE_SEARCH);
	search_completed = FALSE;

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
			strcpy(test,rec->name);
            if ((strstr(rec->voicePhone,buf) != NULL) ||
             (strstr(rec->dataPhone,buf) != NULL) ||
             (strstr(rec->faxPhone,buf) != NULL) ||
             (strcmp(buf,"*") == 0)) {
				SetColor(CYAN);
				printf("[");
				SetColor(MAGENTA);
				printf("%4d", rec->record);
				SetColor(CYAN);
				printf("] ");
				SetColor(WHITE);
				printf("%-20.20s  ", rec->name);
				SetColor(CYAN);
				printf("%-16.16s",rec->voicePhone);
				SetColor(WHITE);
				printf("%-16.16s", rec->dataPhone);
				SetColor(CYAN);
				printf("%-16.16s\n", rec->faxPhone);

				// Test if we've reached the end of the user's screen.

				if (ln_counter() == FALSE) {
					free(recs);
					return;
				}
				else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
					x = save_x;
					s_header(PHONE_SEARCH);
				}
				else if (ln_reset == TRUE)
					s_header(PHONE_SEARCH);

			} // End of fuzzy search test
		} // End of existance test
	} // End of loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
} // End of function

void search_age(void)
{
	char buf[40], *day, *days;
	int x, user_age, search_pref;
	USER_REC *rec, *recs;
	long r_age;

	char current_date[100], *year, *years;
	int cy, cm, cd;	// Current year, Current month, Current day
	int um, ud; // User month, day
	time_t ct;

	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
		no_memory();

	if ((year = (char *) calloc(1,30)) == NULL)
		no_memory();

	if ((day = (char *) calloc(1,30)) == NULL)
		no_memory();

	years = year;
	recs = rec;
	days = day;

	time(&ct);   								// Format time
	sprintf(current_date,"%s",ctime(&ct));		// Put formatted time in str

	// This next procedure calculates the month.  Returns an integer.

	if (strstr(current_date,"Jan") != NULL)
		cm = 1;
	if (strstr(current_date,"Feb") != NULL)
		cm = 2;
	if (strstr(current_date,"Mar") != NULL)
		cm = 3;
	if (strstr(current_date,"Apr") != NULL)
		cm = 4;
	if (strstr(current_date,"May") != NULL)
		cm = 5;
	if (strstr(current_date,"Jun") != NULL)
		cm = 6;
	if (strstr(current_date,"Jul") != NULL)
		cm = 7;
	if (strstr(current_date,"Aug") != NULL)
		cm = 8;
	if (strstr(current_date,"Sep") != NULL)
		cm = 9;
	if (strstr(current_date,"Oct") != NULL)
		cm = 10;
	if (strstr(current_date,"Nov") != NULL)
		cm = 11;
	if (strstr(current_date,"Dec") != NULL)
		cm = 12;

	strcpy(day,current_date);
	day = day + 8;
	cd = atoi(day);
	free(days);

	strrev(current_date);
	strncpy(year,current_date,3);
	strrev(year);
	cy = atoi(year);
	free(years);

	header();
	SetColor(WHITE);

/*    printf("\nCurrent Month >> %d, Current Day >> %d\n",cm,cd);
 *
 *  Debug routine
 *                                                                      */

    printf("\nSearch Examples : ");
	printf("\n\n     40  - Search for all users 40 years old.\n");
	  printf("     40+ - Search for all users 40 and older.\n");
	  printf("     40- - Search for all users 40 and younger.\n");
	printf("\nEnter age to search for : ");
	Input(buf,5,INPUT_ALL);
	r_age = atol(buf);

	if (r_age == 0) {							// Return if invalid input
		free(recs);
		return;
	}

	if (strstr(buf,"+") != NULL)				// What type of search is
		search_pref = ABOVE;					// is being done?  At,
	else if (strstr(buf,"-") != NULL)			// Above, or Below requested
		search_pref = BELOW;					// access level?
	else
		search_pref = AT;

	s_header(AGE_SEARCH);

	search_completed = FALSE;					// Starting the search

	for (x=1; x<=NumUsers; ++x) {
		if (ln == 4)
			save_x = x-1;
		if (ReadUser(rec,x) == TRUE) {
			user_age = cy - rec->birthDate[2];

			um = rec->birthDate[1];
			ud = rec->birthDate[0];

			if (cm < um)
				--user_age;
			if ((cm == um) && (cd < ud))
				--user_age;

			if ((search_pref == ABOVE) && (user_age < r_age))
				continue;
			if ((search_pref == BELOW) && (user_age > r_age))
				continue;
			if ((search_pref == AT) && (user_age != r_age))
				continue;
			SetColor(CYAN);
			printf("[");
			SetColor(MAGENTA);
			printf("%4d", rec->record);
			SetColor(CYAN);
			printf("] ");
			SetColor(WHITE);
			printf("%-24.24s ", rec->name);
			SetColor(CYAN);
			printf("           %1.2d/%1.2d/%1.2d       ", rec->lastDate[1], rec->lastDate[0], rec->lastDate[2]);
			SetColor(WHITE);
			printf("%1.2d/%1.2d/%1.2d       ", rec->birthDate[1], rec->birthDate[0], rec->birthDate[2]);
			SetColor(CYAN);
			printf("%3d\n",user_age);

			// Test if we've reached the end of the user's screen

			if (ln_counter() == FALSE) {
				free(recs);
				return;
			}
			else if ((ln_reset == TRUE) && (restore_screen == TRUE)) {
				x = save_x;
				s_header(AGE_SEARCH);
			}
			else if (ln_reset == TRUE)
				s_header(AGE_SEARCH);
		} // End of test for user existance
	} // End of for loop
	free(recs);
	search_completed = TRUE;
	ln_counter();
} // End of function

void main(int argc, char **argv)
{
	char *hack, *hacks;
	int test;

	if ((hack = (char *) calloc(1,30)) == NULL)	// Allocate memory
		no_memory();							// No memory?  Abort.

	hacks = hack;

	if (argc < 2) {								// No command line parameters?
		printf("\f");
		SetColor(RED);
		printf("Not enough command line parameters.  See documentation.\n");
		press_enter();
		free(hacks);
		exit();
	}
	else {     									// Read command line params
		hack = strstr(argv[1],":");             // Read fuzzy search rate
		++hack;                                 // Skip the colon
		search_rate = atoi(hack);               // Convert to integer
		hack = strstr(argv[2],":");             // Read email board
		++hack;                                 // Skip the colon
		email_board = atoi(hack);               // Conver to integer
		hack = strstr(argv[3],":");				// Read sysop level
		++hack;									// Skip the colon
		sysop_level = atoi(hack);				// Convert to integer
		if (strstr(argv[4],"OFF") != NULL)		// Read access search
			want_access_search = FALSE;			// Don't want access search
		else
			want_access_search = TRUE;          // Do want access search
		hack = strstr(argv[4],":");
		++hack;
		test = atoi(hack);
		if (test == 1) {
			want_alias_search = TRUE;
			alias_mail_name = REAL;
		}
		else if (test == 2) {
			want_alias_search = TRUE;
			alias_mail_name = ALIAS;
		}
		else if ((want_alias_search == FALSE) && (CurUser->level >=sysop_level))
			want_alias_search = TRUE;
		else
			want_alias_search = FALSE;

		free(hacks);							// Free memory
	}
	main_menu();
}
