// PB/Help! version 1.0
// Written by Gregory Gulick
// Copyright 1994 - All Rights Reserved

#include <pb_sdk.h>

#define CTRUE 			0
#define CFALSE 			-1

// Prototypes

void no_memory(void);							// Out of memory?  Abort.
void header(void);                              // Program information
void press_enter(void);                         // Press Enter to Continue
void main(void);				                // Read Command Line Args
void init_ln(void);                             // Init line number
bool ln_counter(void);                          // Count lines on screen

// Global Variables

	int ln;                                     // Line number
	bool ln_reset;                              // Safe to clear screen?
	char ch;									// Multipurpose character

void init_ln(void) { ln = 1; }

bool ln_counter(void)
{
	// This function tests to see if we've reached the end of the user's
	// screen.  If we have, then querry the user if he/she wishes to
	// continue.  If not, return the value false to the calling function.

	// Also note the variable ln_reset.  This variable indicates whether
	// or not it is safe to clear the screen (i.e., if the person
	// querried specifically requested to continue).

	if(ln == CurUser->screenLength-2) {
		SetColor(WHITE);
		printf("\nMore? ");

		// This begins the actual routine that builds the prompt.  Prompt
		// construction is variant on sysop level, local mode, and search
		// completion.

		SetColor(MAGENTA);
		printf("(");
		SetColor(CYAN);						// Place Y/N in prompt
		printf("Y");
		SetColor(MAGENTA);
		printf(",");
		SetColor(CYAN);
		printf("n");
		SetColor(MAGENTA);
		printf(") ");							// End of prompt construction

		// This small procedure controls what keys this entire function will
		// accept:

		ch = WaitKeys("YN\r");

		// This small procedure returns false if the user has selected
		// NO to the more prompt.  It then returns to the calling function
		// which aborts the search.

		if (toupper(ch) == 'N')
			return(FALSE);

		// This small procedure is run if the user press enter.

		else {
			ln_reset = TRUE;
			return(TRUE);
		}

		// The remainder of this function is executed if it is not time to
		// ask for "More?".  It increments the line number, sets the reset
		// boolean to false, and the restore_screen boolean to false.
	}
	++ln;
	ln_reset = FALSE;
	return(TRUE);
}

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
	printf("Insufficient memory to run PowerPEX!\n");
	press_enter();
	exit();										// Abort program
}

void press_enter(void)
{
	SetColor(WHITE);
	printf("\nPress [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.");
	ch=WaitKeys("\r");
}

void header(void)
{

	// This header is specific to the type of search being done.
	// It is passed constants relative to the type of search being done.

	printf("\f");
	SetColor(WHITE);
	init_ln();
	printf("PB/Help! 1.0 ");
	SetColor(CYAN);
	printf("- ");
	SetColor(BLUE);
	printf("A PowerPEX by Gregory Gulick                  ");
	SetColor(CYAN);
	printf("(C) Copyright 1994\n");
	SetColor(MAGENTA);
	printf("\n\n");
	ln=4;
}

void main(void)
{
	char help_dir[100], dir_exist[100], data;
	FILE *fp;

	ln=0;
	header();

	strcpy(help_dir,SysPath);
	strcat(help_dir,"PBHELP\\");
	strcpy(dir_exist,help_dir);
	strcat(dir_exist,".");
	strcat(help_dir,CurMenu);
	strcat(help_dir,".HLP");

	if (access(dir_exist,00) == CFALSE) {
		SetColor(RED);
		printf("\nPB/Help! directory not found.  Consult documentation.\n");
		press_enter();
		exit();
	}

	if (access(help_dir,00) == CTRUE) {
		fp = fopen(help_dir,"r");
		data = fgetc(fp);
		while (feof(fp) == 0) {
			SetColor(WHITE);
			if (data == '\n') {
				if (ln_counter() == FALSE) {
					fclose(fp);
					exit();
				}
				else if (ln_reset == TRUE)
					header();
				else
					printf("\n");
			}
			else
				printf("%c",data);
			data = fgetc(fp);
		}
		fclose(fp);
		press_enter();
	}
	else {
		SetColor(CYAN);
		printf("Sorry, No help available for this menu.\n");
		press_enter();
	}
	exit();
}
