/*
 * This file is part of VizPak (PEX)
 *
 * Copyright (C) 1995-1997 by Branislav L. Slantchev
 * A Product of Silicon Creations, Inc.
 *
 * This file is distributed under the terms and conditions of the GNU
 * General Public License. For more information, refer to the file
 * Copying.Doc which is included in the archive.
*/
#include "vizpak.h"
#include "pblsdk.h"

#ifndef PB_SDK
	#include <stdio.h>
	#include <string.h>
	#include "_pbinit.h"
#else
	#include "pblibc.h"
#endif

AbstractViz*
SelectEffect(int argc, char *argv[])
{
	AbstractViz *viz = 0;

	if( argc > 1 )
	{
		if( !stricmp("marquee", argv[1]) )
			viz = new Marquee(argc-1, &argv[1], argv[0]);
		else if( !stricmp("strobe", argv[1]) )
			viz = new Strobe(argc-1, &argv[1], argv[0]);
		else if ( !stricmp("glisten", argv[1]) )
			viz = new Glisten(argc-1, &argv[1], argv[0]);
		else if ( !stricmp("bounce", argv[1]) )
			viz = new Bounce(argc-1, &argv[1], argv[0]);
	}

	return viz;
}

void
main(int argc, char *argv[])
{
#ifndef PB_SDK
	proboard_emulator_init();
#endif

	if( (CurUser->uFlags & UFLAG_ANSI)
		|| (CurUser->uFlags & UFLAG_AVATAR)
		|| (CurUser->uFlags & UFLAG_AVTPLUS) )
	{
		AbstractViz *vizpak = SelectEffect(argc, argv);

		if( !vizpak )
		{
			char *msg = "vizPak: first argument must be an effect name";
			printf("%s\t\n", msg);
			Log(LOG_FRIEND, msg);
		}
		else
		{
			vizpak->effect();
			delete vizpak;
		}
	}

#ifndef PB_SDK
	proboard_emulator_term();
#endif
}
