/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __DATE_H )
	#include "date.h"
#endif

/*
 * returns 0 if year is not leap and 1 otherwise
*/
	bool
date_isleap( int year )
{
	return BOOL( !(year % 4) && ((year % 100) || !(year % 400)) );
}

/*
 * converts date to julian format
*/
	int
date_julian( int day, int mon, int year )
{
	static int mdays[12] = { 0, 31, 59, 90, 120, 151, 181,
		   			 		 212, 243, 273, 304, 334 };
	int julian;

	julian = mdays[mon - 1] + day;
	if( 2 < mon ) julian += date_isleap( year );
	return julian;
}


/*
 * returns difference (in days) between two dates,
 * result is > 0, means that y2 is more recent than y1
 * result is < 0, means that y1 is more recent than y2
*/
	int
date_diff( int d1, int m1, int y1, int d2, int m2, int y2 )
{
	int days;
	int j1 = date_julian( d1, m1, y1 );
	int j2 = date_julian( d2, m2, y2 );

	/* same year, return difference */
	if( y1 == y2 ) return j2 - j1;

	if( y1 > y2 ){
		days = j1 + date_julian( 31, 12, y2 ) - j2;
		SWAP( y1, y2, int );
	}
	else days = j2 + date_julian( 31, 12, y1 ) - j1;

	/* adjust for years in between */
	for( y1++; y1 < y2; ++y1 )
		days += 365 + date_isleap( y1 );

	return days;
}

#if 0
#include <stdlib.h>
#include <stdio.h>
void
main( void )
{
	int d1, m1, y1, d2, m2, y2;
	char buf[10];

	for( ;; ){
		printf( "d1: " ); gets(buf); if('\0' == *buf) return; d1 = atoi(buf);
		printf( "m1: " ); gets(buf); if('\0' == *buf) return; m1 = atoi(buf);
		printf( "y1: " ); gets(buf); if('\0' == *buf) return; y1 = atoi(buf);
		printf( "d2: " ); gets(buf); if('\0' == *buf) return; d2 = atoi(buf);
		printf( "m2: " ); gets(buf); if('\0' == *buf) return; m2 = atoi(buf);
		printf( "y2: " ); gets(buf); if('\0' == *buf) return; y2 = atoi(buf);
		printf( "\nLeap: %d = %d, %d = %d\n",
			y1, date_isleap(y1), y2, date_isleap(y2) );
		printf( "\nDifference: %d\n", date_diff(d1,m1,y1,d2,m2,y2) );
	}
}
#endif
