/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "llistadt.h"

#if !defined( PB_SDK )
	#if !defined( __MEM_H )
		#include <mem.h>
	#endif
	#if !defined( __ALLOC_H )
		#include <alloc.h>
	#endif
	#if !defined( __STDARG_H )
		#include <stdarg.h>
	#endif
#endif

#define __ATOMDATA(p)   ( (llatom *)(p) + 1 )
#define __ATOMHEAD(p)   ( (llatom *)(p) - 1 )

typedef int  (*__compFunct)(const void *, const void *);
typedef void (*__procFunct)(void *);
typedef __procFunct __freeFunct;

static __compFunct  _ffCompare;
static        void *_ffKey;

static llatom *_llput( llatom *node, const void *data, size_t width );

/*
 * creates a new list
*/
	llist*
llnew( void )
{
	llist *list = (llist *)malloc( sizeof(llist) );
	if( NULL != list ){
		list->count = 0;
		list->head = &list->_dummy[0];
		list->tail = &list->_dummy[1];
		list->head->next = list->tail->next = NULL;
	}
	return list;
}

/*
 * adds an entry to the list, uses where to choose head, tail or sort
*/
	void*
lladd( llist *list, const void *data, size_t width, int where, ... )
{
	llatom *p;
	va_list arg;
	__compFunct compare;

	if( LLPUT_START == where ){
		p = _llput( list->head, data, width );
	}
	else if( LLPUT_SORT == where ){
		va_start( arg, where );
		compare = va_arg( arg, __compFunct );
		va_end( arg );
		for( p = list->head; p->next; p = p->next ){
			if( 0 > compare(data, __ATOMDATA(p->next)) ){
				p = _llput( p, data, width );
				break;
			}
		}
		if( !p->next ) goto _putAtEnd;
	}
	else{
_putAtEnd:
		if( list->tail->next ) p = _llput( list->tail->next, data, width );
		else p = _llput( list->tail, data, width );
		if( p ) list->tail->next = p;
	}

	if( NULL == list->head->next ) list->head->next = p;
	if( NULL == list->tail->next ) list->tail->next = p;

	if( p ){
		list->count++;
		return __ATOMDATA(p);
	}
	else return NULL;
}

/*
 * frees an entry allocated by lladd()
*/
	void
llfree( void *node )
{
	free( __ATOMHEAD(node) );
}

/*
 * frees the whole list
*/
	void
lldelete( llist *list, __freeFunct freeData )
{
	llatom *p;

	for( p = list->head->next; NULL != p; ){
		llatom *tmp = p->next;
		freeData( __ATOMDATA(p) );
		p = tmp;
	}
	free( list );
}

/*
 * returns first element of list
*/
	void*
llfirst( llist *list )
{
	return list->head->next ? __ATOMDATA(list->head->next) : NULL;
}

/*
 * returns element after node
*/
	void*
llnext( const void *node )
{
	llatom *p = __ATOMHEAD( node );

	if( p->next ) return __ATOMDATA( p->next );
	else return NULL;
}

/*
 * executes a function for each entry that matches key
*/
	void
llfeach( llist *list, const void *key, __compFunct cmp, __procFunct proc )
{
	llatom *p;

	for( p = list->head->next; p; p = p->next ){
		if( 0 == cmp(key, __ATOMDATA(p)) )
			proc( __ATOMDATA(p) );
	}
}

/*
 * locates first element in a list
*/
	void*
llfindfirst( llist *list, const void *key, __compFunct cmp )
{
	if( list->head->next ){
		_ffCompare = cmp;
		_ffKey = key;
		return llfindnext( __ATOMDATA(list->head) );
	}
	else return NULL;
}

/*
 * locates next element in list
*/
	void*
llfindnext( void *node )
{
	llatom *p;

	for( p = __ATOMHEAD(node)->next; p; p = p->next ){
		if( 0 == _ffCompare(_ffKey, __ATOMDATA(p)) ) return __ATOMDATA(p);
	}
	return NULL;
}

/*
 * removes node from the list
*/
	void
llkill( llist *list, void *node, __freeFunct freeData )
{
	llatom *p, *tmp, *nodePtr = __ATOMHEAD(node);

	for( p = list->head; p->next; p = p->next ){
		if( p->next == nodePtr ){
			tmp = nodePtr;
			p->next = nodePtr->next;
			if( list->tail->next == nodePtr ) list->tail->next = p;
			freeData( __ATOMDATA(tmp) );
			list->count--;
			break;
		}
	}
}

/*
 * copies node data to a buffer and removes the node
*/
	void*
llget( llist *list, void *node, void *data, size_t width, __freeFunct freeData )
{
	if( NULL == node ) return NULL;
	memcpy( data, node, width );
	llkill( list, node, freeData );
	return data;
}

/*
 * adds an entry to the list after node
*/
	llatom*
_llput( llatom *node, const void *data, size_t width )
{
	llatom *newNode = (llatom *)malloc( sizeof(llatom) + width );
	if( NULL != newNode ){
		memcpy( __ATOMDATA(newNode), data, width );
		newNode->next = node->next;
		node->next = newNode;
	}
	return newNode;
}
