/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __USERSBBS_H )
	#include "usersbbs.h"
#endif

#if !defined( PB_SDK ) && !defined( __PBCONFIG_H )
	#include "pbconfig.h"
#endif

FILE *_openUsersBBS(const char *mode);

/*
 * Returns total number of users in USERS.BBS
*/
	int
NumUsersBBS( void )
{
	FILE *fp;
	long ofs;
	 int num;

	fp = _openUsersBBS( "rb" );
	if( !fp ) return -1;

	fseek( fp, 0L, SEEK_END );
	ofs = ftell(fp);
	fclose(fp);

	num = (int)l_div( ofs, (long)sizeof(RA_USERSBBS) );
	return num;
}

/*
 * Reads a record from USERS.BBS into the USERS_BBS structure.
*/
	int
ReadUsersBBS( int num, RA_USERSBBS *ra )
{
	FILE *fp;
	 int retval = 0;

	fp = _openUsersBBS( "rb" );
	if( !fp ) return -1;

	fseek( fp, l_mul((long)(num - 1), (long)sizeof(RA_USERSBBS)), SEEK_SET );
	if( 1 != fread( ra, sizeof(RA_USERSBBS), 1, fp ) ) retval = -1;

	fclose(fp);
	return retval;
}

/*
 * Writes a record to the USERS.BBS file
*/
	int
WriteUsersBBS( int num, RA_USERSBBS *ra )
{
	FILE *fp;
	 int retval = 0;

	fp = _openUsersBBS( "r+b" );
	if( !fp ) return -1;

	fseek( fp, l_mul((long)(num - 1), (long)sizeof(RA_USERSBBS)), SEEK_SET );
	if( 1 != fwrite(ra, sizeof(RA_USERSBBS), 1, fp) ) retval = -1;

	fclose( fp );
	return retval;
}

/*
 * Opens the USERS.BBS file in desired mode.
*/
	FILE*
_openUsersBBS( const char *mode )
{
	char path[MAXPATH];

#if !defined( PB_SDK )
	CONFIG cfg;
	CONFIG *Config = &cfg;
	if( -1 == ReadConfig( &cfg ) ) return NULL;
#endif
	sprintf( path, "%s\\USERS.BBS", Config->msgpath );

	return fopen( path, mode );
}
